/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

///////////////////////////////////////////////////////////////////////////////
//
// Class:			UserNotificationThread
// Description:		This class is the thread that does the actual User Notification
//                  work, i.e. it subscribing AMT for recieving events and waiting
//                  for events to come.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _USER_NOTIFICATION_THREAD_H
#define _USER_NOTIFICATION_THREAD_H

#include <string>
#include "PeriodicActionThread.h"
#include "UNSWSManClient.h"
#include "UNSSoapServer.h"
#include "soapStub.h"

class UserNotificationThread :	public PeriodicActionThread
{
public:
	UserNotificationThread(UNSEventLogger *pLogger = NULL);
	virtual ~UserNotificationThread(void);

	// Initialize this thread with a given action interval time.
	void init();

	// Set the cresentials to be used to connect to AMT.
	void SetCredentials(const Credentials &cred);

	void SetClientIP(const string &clientIP); // For debug only
	void SetServerIP(const string &serverIP); // For debug only

	// Set a pointer to the Logger.
	void SetLogger(UNSEventLogger *pLogger);

protected:
	virtual void action();
	virtual void cleanup();

private:
	enum State {
		SERVER_BIND_STATE,
		SUBSCRIBE_FOR_ALERT_STATE,
		SUBSCRIBE_FOR_ALERT_FAILURE_STATE,
		SERVER_RUN_STATE};


	void Cleanup();

	/*These functions return the next state into which we should go.*/
	State BindServer();
	State SubscribeForAlert(bool bLogFailure = true);
	State SubscribeForAlertFailure();
	State RunServer();

	// Data members.
	State			m_State;
	string			m_clientIP;
	string			m_serverIP;
	UNSWSManClient	m_client;	// Wsman client for subscription.
	UNSSoapServer	m_server;	// Soap server.
	UNSEventLogger *m_pLogger;

	// Static constants.
	static const unsigned long DEFAULT_CLIENT_INTERVAL;
	static const unsigned long DEFAULT_BIND_INTERVAL;
	static const unsigned long HECI_DOWNTIME_ON_RESUME;
	static const char * IP_LOCALHOST;
	static const unsigned long UNS_PROV_WAIT_TIME;
};
#endif // _USER_NOTIFICATION_THREAD_H
