
import math 
from dolfin import *
dolfin_set("form compiler", "sfc")



class Solution(Function): 
    def eval(self, values, xx): 
        r = math.sqrt((xx[0]-0.5)**2 + (xx[1]-0.5)**2) 

        values[0] = (xx[0]-0.5)/r 
        values[1] = (xx[1]-0.5)/r 

class DirichletBoundary(SubDomain): 
    def inside(self, x, on_boundary): 
        return bool(on_boundary)

# Geometry
N = 3  
if N%2==0: 
    print "The solution will have a singularity in a nodal point."
    #sys.exit(0)

mesh = UnitSquare(N,N)

# Function spaces
X = VectorFunctionSpace(mesh, 'CG', 1)
Y = FunctionSpace(mesh, 'CG', 1)
XY = X + Y

# Solution function (in mixed space)
u = Function(XY)

# Basis functions (in mixed space)
vv = TestFunction(XY)
uu = TrialFunction(XY)

# Form coefficients
do_split = False 
if do_split:
    x, y = split(u)
else:
    x = Function(X)
    y = Function(Y)

# Forms
L = dot(x,x)*dx + inner(grad(x),grad(x))*dx + dot(x,x)*y*dx
if do_split:
    F = derivative(L, u, vv)
    J = derivative(F, u, uu)
else:
    F = derivative(L, (x,y), vv)
    J = derivative(F, (x,y), uu)

# start vector 
dirichlet_function = Solution(X)
x0 = project(dirichlet_function,X)

y0 = Function(Y)
y0.vector().zero()

#Some ugly code related to Function <-> SubFunction stuff
#--------------------------------------------------------
uvec = u.vector()
uarr = uvec.array()
xn = x0.vector().size()
x0a, y0a = uarr[:xn], uarr[xn:]
x0a[:] = x0.vector().array()
#y0a[:] = y0.vector().array()
y0a[:] = 1 
#x0a[:] = 1/sqrt(2) 
#y0a[:] = 0 
u.vector().set(uarr)
plot(u.sub(0))
#Done ugly code 
#--------------------------------------------------------

x.vector().norm()
y.vector().norm()


# Solve nonlinear variational problem
dirichlet_boundary = DirichletBoundary()
#plot(dirichlet_function)
bc = DirichletBC(X, dirichlet_function, dirichlet_boundary)
#problem = VariationalProblem(J, F, bc, nonlinear=True)

b = assemble(F)
A = assemble(J)
file = File("A.m"); file << A;  
file = File("b.m"); file << b;  
print "norm of b ", b.norm()
problem = VariationalProblem(J, F, bc, nonlinear=True)
print "before ", u.vector().disp()
problem.solve(u)

print "after ", u.vector().disp()

# Plot both fields TODO: Having problems with showing both
#x0.assign(u.sub(0))
#y0.assign(u.sub(1))
figure(0)
#plot(x0, title="x")
plot(u.sub(0), title="x")
figure(1)
#plot(y0, title="y")
plot(u.sub(1), title="y")
interactive()

# Write solution to file
vtk = File("x.pvd")
vtk << x0 
vtk = File("y.pvd")
vtk << y0

