/* Copyright (c) 2010, 2014. The SimGrid Team.
 * All rights reserved.                                                     */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

#include <stdio.h>
#include <stdarg.h>

int my_vsnprintf(char *buf, const char *tmpl, ...)
{
  int i;
  va_list args;
  va_start(args, tmpl);
  i = vsnprintf(buf, 2, tmpl, args);
  va_end(args);
  return i;
}

int main(void)
{
  char bufs[5] = { 'x', 'x', 'x', '\0', '\0' };
  char bufd[5] = { 'x', 'x', 'x', '\0', '\0' };
  int i;
  i = my_vsnprintf(bufs, "%s", "111");
  if (strcmp(bufs, "1"))
    exit(1);
  if (i != 3)
    exit(1);
  i = my_vsnprintf(bufd, "%d", 111);
  if (strcmp(bufd, "1"))
    exit(1);
  if (i != 3)
    exit(1);
  exit(0);
}
