 ###############################################################################
 #  Copyright 2008 Ian McIntosh <ian@openanswers.org>
 #
 #  This program is free software; you can redistribute it and/or modify
 #  it under the terms of the GNU General Public License as published by
 #  the Free Software Foundation; either version 2 of the License, or
 #  (at your option) any later version.
 #
 #  This program is distributed in the hope that it will be useful,
 #  but WITHOUT ANY WARRANTY; without even the implied warranty of
 #  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 #  GNU Library General Public License for more details.
 #
 #  You should have received a copy of the GNU General Public License
 #  along with this program; if not, write to the Free Software
 #  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 ###############################################################################

require 'pathname'
require 'cairo'
require 'delegate'

class Canvas < Cairo::ImageSurface
	attr_reader :widget, :height, :width

	def initialize (window, width = 100, height = 100)
    super(Cairo::Format::RGB24, height, width)
    @cr = Cairo::Context.new(self)
    @parent = window
    @width = width
    @height= height

		# GTK Signal Handlers
	  window.signal_connect('configure-event') { |obj, event|		# Widget changed size
			@width, @height = event.width, event.height		# save it
      puts("===debug in event configure-event====", window)
		}
    
		window.signal_connect('draw') { |obj, event|				# Widget changed visibility
      puts("===debug in event draw====", window)
			@redraw_needed = false
		}
	end

end

# Local Variables:
# tab-width: 2
# End:
