#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:36:55 
# _test-auth.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi
MYUSER="$1"
MYPWD="$2"
MYDOMAIN="$3"
MYREALM="$4"

### I N C L U D E

. ./_include.sh

### S T A R T
sep=`testparm -sv 2> /dev/null | grep 'winbind separator' | awk '{print $4}'`

function auth()
{
	if wbinfo -a "$1" > /dev/null 2> /dev/null; then
		wbinfo -a "$1" | grep 'succeeded$'
		return 0
	fi
	wbinfo -a "$1" | grep 'failed$'
	return 1
}

function impersonate()
{
	#su - "$1" -c "id" 2> /dev/null
	expect session.expect "$2" su "$1" -c id 2> /dev/null
	return $?
}

function getSid()
{
	if wbinfo -n "$1" > /dev/null 2> /dev/null; then
		wbinfo -n "$1" | awk '{print $1}'
		return 0
	fi
	return 1
}

function getLogin()
{
	if wbinfo -s "$1" > /dev/null 2> /dev/null; then
		wbinfo -s "$1" | awk '{print $1}'
		return 0
	fi
	return 1
}

echo "--------------------------------------------------------------------------------"
echo "AUTHENTICATION TEST"
echo "--------------------------------------------------------------------------------"

if [ "${MYUSER}" == "" ]; then
	echo "No user selected (see Credentials)"
	exit 1
fi
echo "+AUTHENTICATION"
echo "+authenticating ${MYUSER}"
if ! auth "${MYUSER}%${MYPWD}"; then
	echo "authenticating ${MYUSER} failed" >&2
fi

echo "+authenticating ${MYDOMAIN}${sep}${MYUSER}"
if ! auth "${MYDOMAIN}${sep}${MYUSER}%${MYPWD}"; then
	echo "authenticating ${MYDOMAIN}${sep}${MYUSER} failed" >&2
fi
echo "+authenticating ${MYREALM}${sep}${MYUSER}"
if ! auth "${MYREALM}${sep}${MYUSER}%${MYPWD}"; then
	echo "authenticating ${MYREALM}${sep}${MYUSER} failed" >&2
fi

echo "+impersonating ${MYUSER}"
if impersonate "${MYUSER}" "${MYPWD}"; then
	echo "ok"
else
	echo "impersonating ${MYUSER} failed" >&2
fi
echo "+impersonating ${MYDOMAIN}${sep}${MYUSER}"
if impersonate "${MYDOMAIN}${sep}${MYUSER}" "${MYPWD}"; then
	echo "ok"
else
	echo "impersonating ${MYDOMAIN}${sep}${MYUSER} failed" >&2
fi

echo "+SID"
echo "+getting security id (sid) for ${MYDOMAIN}${sep}${MYUSER}"
if ! getSid "${MYDOMAIN}${sep}${MYUSER}"; then
	echo "getting sid for ${MYDOMAIN}${sep}${MYUSER} failed" >&2
else
	echo "+getting login from ${MYDOMAIN}${sep}${MYUSER} sid"
	sid=`getSid "${MYUSER}"`
	if ! getLogin "${sid}"; then
		echo "getting login from ${MYUSER} sid failed" >&2
	fi
fi
