/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef MESSAGETREEITEM_H
#define MESSAGETREEITEM_H

#include "treeitem.h"

class SingleMessage;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class MessageTreeItem : public TreeItem
{
  private:
    SingleMessage* m_message;

  public:
    MessageTreeItem(const QList<QVariant> &data, TreeItem *parent = 0, QString = "");
    ~MessageTreeItem();

    QVariant data(int column, int role = Qt::DisplayRole, bool = 0) const;

    void setMessage(SingleMessage* theValue){m_message = theValue;}
    SingleMessage* message() const {return m_message;}

    void sortChildren(int column, Qt::SortOrder order);

    static bool LessThan(TreeItem* i1, TreeItem* i2);
};

#endif
