(defun gr ()
  (show-graphics)
  (showpen)
  (moveto 0 0)
  (lineto 20 20))

(setf graph-width 600)
(setf graph-height 220)

(defun array-max-abs (points)
  (let ((m 0.0))
        (dotimes (i (length points))
          (setf m (max m (abs (aref points i)))))
        m))

(defun s-plot (snd &optional (n 1000))
  (prog ((points (snd-samples snd n))
                   maxpoint y-offset horizontal-scale vertical-scale)
    (show-graphics)
    (clear-graphics)
    (setf maxpoint (array-max-abs points))
    (setf y-offset (/ graph-height 2))
    (moveto 0 y-offset)
    (lineto graph-width y-offset)
    (moveto 0 y-offset)
    (setf horizontal-scale (/ (float graph-width) (length points)))
    (setf vertical-scale (- (/ (float y-offset) maxpoint)))
    (dotimes (i (length points))
      (lineto (truncate (* horizontal-scale i))
              (+ y-offset (truncate (* vertical-scale (aref points i))))))
    (format t "X Axis: ~A to ~A (seconds)\n" (snd-t0 snd) (/ (length points) (snd-srate snd)))
    (format t "Y Axis: ~A to ~A\n" (- maxpoint) maxpoint)
    (format t "~A samples plotted.\n" (length points))
    ))
    
