/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.PIGrabber;
import net.sf.saxon.event.ParseOptions;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetStripper;
import net.sf.saxon.style.UseWhenFilter;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class PreparedStylesheet
implements Templates,
Serializable {
    private Executable executable;
    private CompilerInfo compilerInfo;
    private transient Configuration config;
    private NamePool targetNamePool;
    private transient StyleNodeFactory nodeFactory;
    private int errorCount = 0;
    private HashMap<URI, PreparedStylesheet> nextStylesheetCache;
    private DecimalFormatManager decimalFormatManager;

    protected PreparedStylesheet(Configuration config, CompilerInfo info) {
        this.config = config;
        this.executable = new Executable(config);
        RuleManager rm = new RuleManager();
        rm.setRecoveryPolicy(info.getRecoveryPolicy());
        this.executable.setRuleManager(rm);
        this.executable.setHostLanguage(50);
        this.executable.setCollationTable(new CollationMap(config.getCollationMap()));
        this.executable.setSchemaAware(info.isSchemaAware());
        this.compilerInfo = info;
        if (this.compilerInfo.getErrorListener() == null) {
            this.compilerInfo.setErrorListener(config.getErrorListener());
        }
    }

    public static PreparedStylesheet compile(Source source, Configuration config, CompilerInfo info) throws TransformerConfigurationException {
        PreparedStylesheet pss = new PreparedStylesheet(config, info);
        pss.prepare(source);
        return pss;
    }

    public Transformer newTransformer() {
        Controller c = new Controller(this.config, this.executable);
        c.setPreparedStylesheet(this);
        return c;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setTargetNamePool(NamePool pool) {
        this.targetNamePool = pool;
    }

    public NamePool getTargetNamePool() {
        if (this.targetNamePool == null) {
            return this.config.getNamePool();
        }
        return this.targetNamePool;
    }

    public StyleNodeFactory getStyleNodeFactory() {
        return this.nodeFactory;
    }

    public void setDecimalFormatManager(DecimalFormatManager dfm) {
        this.decimalFormatManager = dfm;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    protected void prepare(Source styleSource) throws TransformerConfigurationException {
        block5: {
            this.nodeFactory = this.config.getStyleNodeFactory();
            try {
                DocumentImpl doc = this.loadStylesheetModule(styleSource, this.nodeFactory);
                this.setStylesheetDocument(doc, this.nodeFactory);
            }
            catch (XPathException e) {
                try {
                    this.compilerInfo.getErrorListener().fatalError(e);
                }
                catch (TransformerException e2) {
                    // empty catch block
                }
                if (this.errorCount != 0) break block5;
                ++this.errorCount;
            }
        }
        if (this.errorCount > 0) {
            throw new TransformerConfigurationException("Failed to compile stylesheet. " + this.errorCount + (this.errorCount == 1 ? " error " : " errors ") + "detected.");
        }
    }

    public DocumentImpl loadStylesheetModule(Source styleSource, StyleNodeFactory nodeFactory) throws XPathException {
        TreeBuilder styleBuilder = new TreeBuilder();
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.setURIResolver(this.compilerInfo.getURIResolver());
        styleBuilder.setPipelineConfiguration(pipe);
        styleBuilder.setSystemId(styleSource.getSystemId());
        styleBuilder.setNodeFactory(nodeFactory);
        styleBuilder.setLineNumbering(true);
        StartTagBuffer startTagBuffer = new StartTagBuffer();
        UseWhenFilter useWhenFilter = new UseWhenFilter(startTagBuffer);
        useWhenFilter.setUnderlyingReceiver(styleBuilder);
        startTagBuffer.setUnderlyingReceiver(useWhenFilter);
        StylesheetStripper styleStripper = new StylesheetStripper();
        styleStripper.setUnderlyingReceiver(startTagBuffer);
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(styleStripper);
        Sender sender = new Sender(pipe);
        AugmentedSource aug = AugmentedSource.makeAugmentedSource(styleSource);
        aug.setSchemaValidationMode(4);
        aug.setDTDValidationMode(4);
        aug.setLineNumbering(true);
        if (aug.getXMLReader() == null && Configuration.getPlatform().isJava()) {
            XMLReader styleParser = this.config.getStyleParser();
            aug.setXMLReader(styleParser);
            sender.send(aug, commentStripper, new ParseOptions());
            this.config.reuseStyleParser(styleParser);
        } else {
            sender.send(aug, commentStripper, new ParseOptions());
        }
        DocumentImpl doc = (DocumentImpl)styleBuilder.getCurrentRoot();
        styleBuilder.reset();
        if (aug.isPleaseCloseAfterUse()) {
            aug.close();
        }
        return doc;
    }

    protected void setStylesheetDocument(DocumentImpl doc, StyleNodeFactory snFactory) throws XPathException {
        DocumentImpl styleDoc = doc;
        this.nodeFactory = snFactory;
        StyleElement topnode = (StyleElement)styleDoc.getDocumentElement();
        if (topnode instanceof LiteralResultElement) {
            styleDoc = ((LiteralResultElement)topnode).makeStylesheet(this, snFactory);
        }
        if (!(styleDoc.getDocumentElement() instanceof XSLStylesheet)) {
            throw new XPathException("Outermost element of stylesheet is not xsl:stylesheet or xsl:transform or literal result element");
        }
        XSLStylesheet top = (XSLStylesheet)styleDoc.getDocumentElement();
        if (this.compilerInfo.isVersionWarning() && top.getVersion().equals(BigDecimal.valueOf(1L))) {
            try {
                TransformerException w = new TransformerException("Running an XSLT 1.0 stylesheet with an XSLT 2.0 processor");
                w.setLocator(topnode);
                this.config.getErrorListener().warning(w);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        this.executable.setLocationMap(top.getLocationMap());
        top.setPreparedStylesheet(this);
        try {
            top.preprocess();
        }
        catch (XPathException e) {
            Throwable e2 = e.getException();
            if (e2 instanceof XPathException) {
                try {
                    this.compilerInfo.getErrorListener().fatalError((XPathException)e2);
                }
                catch (TransformerException e3) {
                    // empty catch block
                }
            }
            throw e;
        }
        top.compileStylesheet();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public boolean isCompileWithTracing() {
        return this.compilerInfo.isCompileWithTracing();
    }

    public Properties getOutputProperties() {
        Properties details = this.executable.getDefaultOutputProperties();
        return new Properties(details);
    }

    public void reportError(TransformerException err) throws TransformerException {
        ++this.errorCount;
        if (err instanceof XPathException) {
            if (!((XPathException)err).hasBeenReported()) {
                try {
                    this.compilerInfo.getErrorListener().fatalError(err);
                    ((XPathException)err).setHasBeenReported(true);
                }
                catch (Exception exception) {}
            }
        } else {
            this.compilerInfo.getErrorListener().fatalError(err);
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void reportWarning(TransformerException err) {
        try {
            this.compilerInfo.getErrorListener().warning(err);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public PreparedStylesheet getCachedStylesheet(String href, String baseURI) {
        URI abs = null;
        try {
            abs = new URI(baseURI).resolve(href);
        }
        catch (URISyntaxException err) {
            // empty catch block
        }
        PreparedStylesheet result = null;
        if (abs != null && this.nextStylesheetCache != null) {
            result = this.nextStylesheetCache.get(abs);
        }
        return result;
    }

    public void putCachedStylesheet(String href, String baseURI, PreparedStylesheet pss) {
        URI abs = null;
        try {
            abs = new URI(baseURI).resolve(href);
        }
        catch (URISyntaxException err) {
            // empty catch block
        }
        if (abs != null) {
            if (this.nextStylesheetCache == null) {
                this.nextStylesheetCache = new HashMap(4);
            }
            this.nextStylesheetCache.put(abs, pss);
        }
    }

    public CompilerInfo getCompilerInfo() {
        return this.compilerInfo;
    }

    public void explain(ExpressionPresenter presenter) {
        presenter.startElement("stylesheet");
        this.getExecutable().getKeyManager().explainKeys(presenter);
        this.getExecutable().explainGlobalVariables(presenter);
        this.getExecutable().getRuleManager().explainTemplateRules(presenter);
        this.getExecutable().explainNamedTemplates(presenter);
        FunctionLibraryList libList = (FunctionLibraryList)this.getExecutable().getFunctionLibrary();
        List libraryList = libList.getLibraryList();
        presenter.startElement("functions");
        for (int i = 0; i < libraryList.size(); ++i) {
            FunctionLibrary lib = (FunctionLibrary)libraryList.get(i);
            if (!(lib instanceof ExecutableFunctionLibrary)) continue;
            Iterator<UserFunction> f = ((ExecutableFunctionLibrary)lib).iterateFunctions();
            while (f.hasNext()) {
                UserFunction func = f.next();
                presenter.startElement("function");
                presenter.emitAttribute("name", func.getFunctionName().getDisplayName());
                presenter.emitAttribute("line", func.getLineNumber() + "");
                presenter.emitAttribute("module", func.getSystemId());
                func.getBody().explain(presenter);
                presenter.endElement();
            }
        }
        presenter.endElement();
        presenter.endElement();
    }

    public static Source getAssociatedStylesheet(Configuration config, Source source, String media, String title, String charset) throws TransformerConfigurationException {
        PIGrabber grabber;
        block6: {
            grabber = new PIGrabber();
            grabber.setFactory(config);
            grabber.setCriteria(media, title, charset);
            grabber.setBaseURI(source.getSystemId());
            grabber.setURIResolver(config.getURIResolver());
            try {
                new Sender(config.makePipelineConfiguration()).send(source, grabber, new ParseOptions());
            }
            catch (XPathException err) {
                if (grabber.isTerminated()) break block6;
                throw new TransformerConfigurationException("Failed while looking for xml-stylesheet PI", err);
            }
        }
        try {
            Source[] sources = grabber.getAssociatedStylesheets();
            if (sources == null) {
                throw new TransformerConfigurationException("No matching <?xml-stylesheet?> processing instruction found");
            }
            return PreparedStylesheet.compositeStylesheet(config, source.getSystemId(), sources);
        }
        catch (TransformerException err) {
            if (err instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)err;
            }
            throw new TransformerConfigurationException(err);
        }
    }

    private static Source compositeStylesheet(Configuration config, String baseURI, Source[] sources) throws TransformerConfigurationException {
        if (sources.length == 1) {
            return sources[0];
        }
        if (sources.length == 0) {
            throw new TransformerConfigurationException("No stylesheets were supplied");
        }
        StringBuffer sb = new StringBuffer(250);
        sb.append("<xsl:stylesheet version='1.0' ");
        sb.append(" xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>");
        for (int i = 0; i < sources.length; ++i) {
            sb.append("<xsl:import href='").append(sources[i].getSystemId()).append("'/>");
        }
        sb.append("</xsl:stylesheet>");
        InputSource composite = new InputSource();
        composite.setSystemId(baseURI);
        composite.setCharacterStream(new StringReader(sb.toString()));
        return new SAXSource(config.getSourceParser(), composite);
    }
}

