/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.php.project.ui.customizer;

import java.awt.BorderLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.spi.project.ui.support.ProjectCustomizer.Category;
import org.openide.util.HelpCtx;

public final class CustomizerFramework extends JPanel implements ChangeListener, HelpCtx.Provider {
    private static final long serialVersionUID = 19349854609829890L;

    private static final Logger LOGGER = Logger.getLogger(CustomizerFramework.class.getName());

    private final Category category;
    private final PhpModuleCustomizerExtender extender;

    public CustomizerFramework(Category category, PhpModuleCustomizerExtender extender, PhpProjectProperties uiProps) {
        assert category != null;
        assert extender != null;
        assert uiProps != null;

        this.category = category;
        this.extender = extender;

        uiProps.addCustomizerExtender(extender);

        initComponents();

        add(extender.getComponent(), BorderLayout.CENTER);

        validateData();
    }

    @Override
    public void addNotify() {
        extender.addChangeListener(this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        extender.removeChangeListener(this);
        super.removeNotify();
    }

    void validateData() {
        String error = extender.getErrorMessage();
        if (!extender.isValid()) {
            assert error != null : "Customizer extender " + category.getDisplayName() + " returns no error even if it is not valid";
            category.setErrorMessage(error);
            category.setValid(false);
            return;
        }

        // is valid
        if (error != null) {
            LOGGER.log(Level.INFO, "Customizer extender {0} returns error even if it is valid.", category.getDisplayName());
        }

        category.setErrorMessage(extender.getWarningMessage());
        category.setValid(true);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new BorderLayout());
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    @Override
    public void stateChanged(ChangeEvent e) {
        validateData();
    }

    @Override
    public HelpCtx getHelpCtx() {
        HelpCtx help = extender.getHelp();
        return help != null ? help : HelpCtx.DEFAULT_HELP;
    }
}
