/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QRegExp>
#include <QStringList>

#include <iostream>
#include <fstream>
#include <sstream>
#include "MvQHighlighter.h"

using namespace std;

MvQHighlighter::MvQHighlighter(QTextDocument* parent) :
    QSyntaxHighlighter(parent)
{
    HighlightingRule rule;

    //Keywords
    QTextCharFormat keywordFormat;

    keywordFormat.setForeground(Qt::darkBlue);
    keywordFormat.setFontWeight(QFont::Bold);

    QStringList keywordPatterns;
    keywordPatterns << "DATE"
                    << "TIME"
                    << "STOP INDEX"
                    << "# OF POINTS";

    foreach (QString pattern, keywordPatterns) {
        //rule.pattern = QRegExp(pattern,Qt::CaseInsensitive);
        //QString s=pattern + "(?==)";
        QString s    = pattern + "(?=:)";
        rule.pattern = QRegExp(s, Qt::CaseInsensitive);
        rule.format  = keywordFormat;
        highlightingRules.append(rule);
    }

    //Data keywords
    QTextCharFormat dataKeyFormat;

    dataKeyFormat.setForeground(QColor(224, 138, 33));
    //dataKeyFormat.setForeground(QColor(255,119,119));
    dataKeyFormat.setFontWeight(QFont::Bold);

    QStringList dataKeyPatterns;
    dataKeyPatterns << " SECS "
                    << " LONGIT "
                    << " LATIT "
                    << " ETA "
                    << " PRESS "
                    << "  Z "
                    << " Z-ORO "
                    << " PV "
                    << " THETA "
                    << " Q";

    foreach (QString pattern, dataKeyPatterns) {
        //rule.pattern = QRegExp(pattern,Qt::CaseInsensitive);
        //QString s=pattern + "(?==)";
        QString s    = pattern;
        rule.pattern = QRegExp(s, Qt::CaseInsensitive);
        rule.format  = dataKeyFormat;
        highlightingRules.append(rule);
    }

    //Comments
    QTextCharFormat singleLineCommentFormat;

    singleLineCommentFormat.setFontItalic(true);
    singleLineCommentFormat.setForeground(Qt::darkGreen);
    QRegExp rx("\\*[^\n]*");
    rx.setPatternSyntax(QRegExp::WildcardUnix);
    rule.pattern = rx;
    rule.format  = singleLineCommentFormat;
    highlightingRules.append(rule);

    //Server (URL)
    /*QTextCharFormat serverFormat;

	serverFormat.setForeground(Qt::red);
     	serverFormat.setFontWeight(QFont::Bold);
 
	rule.pattern = QRegExp("\\*\?\\b");
        rule.format = serverFormat;
        highlightingRules.append(rule);*/
}

void MvQHighlighter::highlightBlock(const QString& text)
{
    foreach (HighlightingRule rule, highlightingRules) {
        QRegExp expression(rule.pattern);
        int index = text.indexOf(expression);
        while (index >= 0) {
            int length = expression.matchedLength();
            setFormat(index, length, rule.format);
            index = text.indexOf(expression, index + length);
        }
    }
    setCurrentBlockState(0);

    /* int startIndex = 0;
     if (previousBlockState() != 1)
         startIndex = text.indexOf(commentStartExpression);

     while (startIndex >= 0) 
	{
         int endIndex = text.indexOf(commentEndExpression, startIndex);
         int commentLength;
         if (endIndex == -1) 
	{
             setCurrentBlockState(1);
             commentLength = text.length() - startIndex;
         } 
	else 
	{
             commentLength = endIndex - startIndex
                             + commentEndExpression.matchedLength();
         }
         setFormat(startIndex, commentLength, multiLineCommentFormat);
         startIndex = text.indexOf(commentStartExpression,
                                                 startIndex + commentLength);
     }*/
}
