#!/usr/bin/env python
#-*- coding: utf-8 -*-
# memaker.py - A gtk based avatar creation program.
# Copyright 2008 The MeMaker Project
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. See the file LICENSE.
# If not, see <http://www.gnu.org/licenses/>.

import os
import webbrowser

from launchpadlib.launchpad import Launchpad
from launchpadlib.credentials import Credentials

credentials = 0
doneAuth = False

def load_auth(authfile):
    global credentials
    credentials = Credentials()
    credentials.load(open(authfile))

def get_auth1():
    global credentials
    credentials = Credentials(consumer_name="memaker")
    token = credentials.get_request_token(web_root='https://launchpad.net/')
    webbrowser.open(token)
    
def get_auth2(authfile):
    global credentials
    credentials.exchange_request_token_for_access_token(web_root='https://launchpad.net/')
    credentials.save(file(authfile, "w"))

def get_old_mugshot(cachedir):
    launchpad = Launchpad(credentials, cache=cachedir, service_root='https://api.launchpad.net/beta/')
    mugshot = launchpad.me.mugshot
    return mugshot.open("r").read()
    
def set_new_mugshot(new_mugshot_data, cachedir):
    launchpad = Launchpad(credentials, cache=cachedir, service_root='https://api.launchpad.net/beta/')
    mugshot = launchpad.me.mugshot
    mugshot_handle = mugshot.open("w", "image/png", "mugshot.png")
    mugshot_handle.write(new_mugshot_data)
    mugshot_handle.close()
