# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.higher_order_tetra import HigherOrderTetra


class BezierTetra(HigherOrderTetra):
    r"""
    BezierTetra - A 3D cell that represents an arbitrary order Bezier
    tetrahedron
    
    Superclass: HigherOrderTetra
    
    BezierTetra is a concrete implementation of Cell to represent a
    3D tetrahedron using Bezier shape functions of user specified order.
    
    The number of points in a Bezier cell determines the order over which
    they are iterated relative to the parametric coordinate system of the
    cell. The first points that are reported are vertices. They appear in
    the same order in which they would appear in linear cells. Mid-edge
    points are reported next. They are reported in sequence. For two- and
    three-dimensional (3D) cells, the following set of points to be
    reported are face points. Finally, 3D cells report points interior to
    their volume.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBezierTetra, obj, update, **traits)
    
    def _get_rational_weights(self):
        return wrap_vtk(self._vtk_obj.GetRationalWeights())
    rational_weights = traits.Property(_get_rational_weights, desc=\
        r"""
        
        """
    )

    def evaluate_location_projected_node(self, *args):
        """
        evaluate_location_projected_node(self, subId:int, point_id:int,
            x:[float, float, float], weights:[float, ...]) -> None
        C++: void evaluate_location_projected_node(int &subId,
            const IdType point_id, double x[3], double *weights)"""
        ret = self._wrap_call(self._vtk_obj.EvaluateLocationProjectedNode, *args)
        return ret

    def set_rational_weights_from_point_data(self, *args):
        """
        set_rational_weights_from_point_data(self, point_data:PointData,
            numPts:int) -> None
        C++: void set_rational_weights_from_point_data(
            PointData *point_data, const IdType numPts)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetRationalWeightsFromPointData, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BezierTetra, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BezierTetra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit BezierTetra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BezierTetra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

