//------------------------------------------------------------------------------
//$Author: saulius $
//$Date: 2018-03-01 08:14:33 -0500 (Thu, 01 Mar 2018) $
//$Revision: 96 $
//$URL: svn://saulius-grazulis.lt/libraries/trunk/java/SOptions/toptdefaults.java $
//------------------------------------------------------------------------------

import java.io.*;

class toptdefaults {

    static Option options[];

    public static void main( String [] args )
    {
        OptionValue boolval = new OptionValue(true);
        OptionValue svalue = new OptionValue("Default 'svalue'");
        OptionValue ivalue = new OptionValue(1234);
        OptionValue fvalue = new OptionValue(12.23);
        OptionValue dvalue = new OptionValue(6.02e+23);

        topt.options = new Option[] {
            new Option( "-b-", "--false",    OptionType.OT_BOOLEAN_FALSE, boolval ),
            new Option( "-b",  "--true",     OptionType.OT_BOOLEAN_TRUE,  boolval ),
            new Option( "-s", "--strval",    OptionType.OT_STRING, svalue ),
            new Option( "-i", "--intval",    OptionType.OT_INT,    ivalue ),
            new Option( "-f", "--floatval",  OptionType.OT_FLOAT,  fvalue ),
            new Option( "-d", "--doubleval", OptionType.OT_FLOAT,  dvalue ),
        };

        String files[] = null;
        try {
            files = SOptions.get_options( args, topt.options );
        }
        catch (SOptionsException e) {
            System.err.println( "topt: " + e.getMessage() );
        }

        System.out.println( "option '-b' value = " +  boolval.bool );
        System.out.println( "option '-s' value = " +  svalue.s );
        System.out.println( "option '-i' value = " +  ivalue.i );
        System.out.println( "option '-f' value = " +  fvalue.f );
        System.out.println( "option '-d' value = " +  dvalue.f );

        if( files != null ) {
            for( int i = 0; i < files.length; i++ ) {
                System.out.println( "file: '" + files[i] + "'" );
            }
        }
    }
}
