/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.mapping.WrappedException;
import java.util.Hashtable;

public class ModuleContext {
    static ModuleContext global = new ModuleContext(ModuleManager.instance);
    ModuleManager manager;
    Hashtable table = new Hashtable();

    public ModuleContext(ModuleManager manager) {
        this.manager = manager;
    }

    public static ModuleContext getContext() {
        return global;
    }

    public ModuleManager getManager() {
        return this.manager;
    }

    public Object checkInstance(ModuleInfo info) {
        return this.table.get(info.className);
    }

    public Object makeInstance(ModuleInfo info) {
        Object inst;
        Class clas;
        String cname = info.className;
        try {
            clas = info.getModuleClass();
        }
        catch (ClassNotFoundException ex) {
            throw new WrappedException("cannot find module " + cname, ex);
        }
        try {
            try {
                inst = clas.getDeclaredField("$instance").get(null);
            }
            catch (NoSuchFieldException ex) {
                inst = clas.newInstance();
            }
        }
        catch (Throwable ex) {
            throw new WrappedException("exception while initializing module " + cname, ex);
        }
        this.setInstance(info, inst);
        return inst;
    }

    public Object findInstance(ModuleInfo info) {
        Object inst = this.table.get(info.className);
        if (inst == null || info.moduleClass == null || !info.moduleClass.isInstance(inst)) {
            inst = this.makeInstance(info);
        }
        return inst;
    }

    public void setInstance(ModuleInfo info, Object instance) {
        this.table.put(info.className, instance);
    }

    public ModuleInfo findFromInstance(Object instance) {
        Class<?> instanceClass = instance.getClass();
        String className = instanceClass.getName();
        ModuleInfo info = this.manager.findWithClassName(className);
        info.moduleClass = instanceClass;
        this.setInstance(info, instance);
        return info;
    }
}

