package tests::EmailConcatenaterTest;

use base qw/Lire::Test::DlfAnalyserTestCase/;

use Lire::DlfAnalysers::EmailConcatenater;
use File::Basename;

sub schemasdir {
    return dirname( __FILE__ ) . "/../..";
}

sub create_analyser {
    return new Lire::DlfAnalysers::EmailConcatenater();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../../email_concat_init";
}

sub test_categorise {
    my $self = $_[0];

    my $analyser = $self->create_analyser();

    my $dlf = { 'from_user' => undef,
                'from_domain' => undef,
                'to_user' => undef,
                'to_domain' => undef,
            };
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'from_email'} );
    $self->assert_null( $dlf->{'to_email'} );

    $dlf->{'from_user'} = 'francis';
    $dlf->{'to_user'} = 'wolfgang';
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'from_email'} );
    $self->assert_null( $dlf->{'to_email'} );

    $dlf->{'from_domain'} = 'logreport.com';
    $dlf->{'to_domain'} = 'logreport.org';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'francis@logreport.com', $dlf->{'from_email'} );
    $self->assert_str_equals( 'wolfgang@logreport.org', $dlf->{'to_email'} );

    $dlf->{'from_user'} = $dlf->{'to_user'} = 
        $dlf->{'from_email'} = $dlf->{'to_email'} = undef;
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'from_email'} );
    $self->assert_null( $dlf->{'to_email'} );

    return;
}


1;
