package latexDraw.ui.components;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import latexDraw.ui.dialog.ExceptionFrameDialog;


/** 
 * This class allows the change the renderer of JComboBox. it allows to display a icon in the list<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class LabelListCellRenderer extends JLabel implements ListCellRenderer
{
	private static final long serialVersionUID = 1L;

	/** The colour displayed when a item is selected in the list */
	public static final Color selectcolor = new Color(120, 160, 195);
	
	
	/**
	 * The constructor by default
	 */
	public LabelListCellRenderer() 
	{
        setOpaque(true);
    }
	
	
	
	public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) 
	{
		try
		{
			setBackground(isSelected ? selectcolor : Color.white);
			if(value instanceof JLabel)
				setIcon(((JLabel)value).getIcon());
			
			setEnabled(list.isEnabled());
			setFont(list.getFont());
		}
		catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
		
		return this;
	}
}
