package latexDraw.ui.components;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;


/**
 * Allows to display a given image in a panel(canvas).<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class DisplayCanvas extends Canvas
{
	private static final long serialVersionUID = 1L;
	
	/** The image to display */
	protected transient Image image;
	
	
	/**
	 * The constructor by default
	 * @param i The image to display
	 */
	public DisplayCanvas(Image i)
	{
		image = i;
		prepareImage(image, this);
		setPreferredSize(new Dimension(image.getWidth(this), image.getHeight(this)));
	}
	
	
	
	@Override
	public void paint(Graphics g)
	{
		if(image!=null)
			g.drawImage(image, 0, 0, this);
	}
}
