/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "setupcodec.h"
#include "ui_setupcodec.h"

#include "global/global.h"
#include <QDebug>
#include <QIntValidator>

using namespace Global;

SetupCodec::SetupCodec(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::SetupCodec)
{
    ui->setupUi(this);

    QFont f("Noto Sans CJK SC Regular");
    f.setPixelSize(14);
    ui->cb_VideoOutput->setFont(f);
    ui->cb_VDecoder->setFont(f);
    ui->lineEdit->setFont(f);

    f.setPixelSize(16);
    ui->label->setFont(f);
    ui->label_2->setFont(f);
    ui->label_3->setFont(f);

    QIntValidator *ivd = new QIntValidator;
    ivd->setRange(1, 32);
    ui->lineEdit->setValidator(ivd);
    ui->lineEdit->setFixedHeight(30);

    initData();
    initConnect();
}

SetupCodec::~SetupCodec()
{
    if (ui->lineEdit->validator()) {
        delete ui->lineEdit->validator();
    }
    delete ui;
}

void SetupCodec::initData()
{
    ui->cb_VDecoder->addItem(tr("default"));
    ui->cb_VDecoder->addItem(tr("no"));
    ui->cb_VDecoder->addItem("vdpau");
    ui->cb_VDecoder->addItem("vdpau-copy");
    ui->cb_VDecoder->addItem("vaapi");
    ui->cb_VDecoder->addItem("vaapi-copy");
    ui->cb_VDecoder->setCurrentText(g_settings->value("General/video_decoder").toString());

    ui->label->setText(tr("Video output"));
    ui->cb_VideoOutput->addItem(tr("auto"));
    ui->cb_VideoOutput->addItem("x11");
    ui->cb_VideoOutput->addItem("xv");
    ui->cb_VideoOutput->addItem("vdpau");
    ui->cb_VideoOutput->addItem("vaapi");
    ui->cb_VideoOutput->addItem("gpu");
    ui->cb_VideoOutput->setCurrentText(g_settings->value("General/video_output").toString());

    ui->label_3->setText(tr("Decode threads"));
    int threads = g_settings->value("General/video_decode_threads").toInt();
    ui->lineEdit->setText(QString::number(threads > 0 ? threads : 4));
//    ui->label_3->hide();
//    ui->cb_ADecoder->hide();
}

void SetupCodec::initConnect()
{
    connect(ui->cb_VDecoder, &QComboBox::currentTextChanged, this, [this](QString decoder) {
        gsetup->videoDecoder.second = decoder;
    });
    connect(ui->cb_VideoOutput, &QComboBox::currentTextChanged, this, [this](QString decoder) {
        gsetup->videoOutput.second = decoder;
    });
    connect(ui->lineEdit, &QLineEdit::textChanged, this, [this](QString text){
        gsetup->videoDecodeThreads.second = text.toInt();
    });
}

void SetupCodec::setBlackTheme()
{
    ui->label->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->label_2->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->label_3->setStyleSheet(QString("color:rgb(249,249,249);"));

    ui->cb_VideoOutput->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->cb_VDecoder->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->lineEdit->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
//    ui->cb_ADecoder->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
}

void SetupCodec::setLightTheme()
{
    ui->label->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label_2->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label_3->setStyleSheet(QString("color:rgb(38,38,38);"));

    ui->cb_VideoOutput->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->cb_VDecoder->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->lineEdit->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    //    ui->cb_ADecoder->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
}

void SetupCodec::setWidgetFont(QString family, int size)
{
    QFont f(family);
    f.setPointSize(size + 2);
    ui->label->setFont(f);
    ui->label_2->setFont(f);
    ui->label_3->setFont(f);

    f.setPointSize(size);
    ui->cb_VDecoder->setFont(f);
    ui->cb_VideoOutput->setFont(f);
    ui->lineEdit->setFont(f);
}
