
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraFeedbackControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraFeedbackControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraFeedbackControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraFeedbackControl::staticMetaObject);
}


// bool QCameraFeedbackControl::isEventFeedbackEnabled(QCameraFeedbackControl::EventType)


static void _init_f_isEventFeedbackEnabled_c3660 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isEventFeedbackEnabled_c3660 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl *)cls)->isEventFeedbackEnabled (qt_gsi::QtToCppAdaptor<QCameraFeedbackControl::EventType>(arg1).cref()));
}


// bool QCameraFeedbackControl::isEventFeedbackLocked(QCameraFeedbackControl::EventType)


static void _init_f_isEventFeedbackLocked_c3660 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isEventFeedbackLocked_c3660 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl *)cls)->isEventFeedbackLocked (qt_gsi::QtToCppAdaptor<QCameraFeedbackControl::EventType>(arg1).cref()));
}


// void QCameraFeedbackControl::resetEventFeedback(QCameraFeedbackControl::EventType)


static void _init_f_resetEventFeedback_3660 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resetEventFeedback_3660 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFeedbackControl *)cls)->resetEventFeedback (qt_gsi::QtToCppAdaptor<QCameraFeedbackControl::EventType>(arg1).cref());
}


// bool QCameraFeedbackControl::setEventFeedbackEnabled(QCameraFeedbackControl::EventType, bool)


static void _init_f_setEventFeedbackEnabled_4416 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setEventFeedbackEnabled_4416 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl *)cls)->setEventFeedbackEnabled (qt_gsi::QtToCppAdaptor<QCameraFeedbackControl::EventType>(arg1).cref(), arg2));
}


// bool QCameraFeedbackControl::setEventFeedbackSound(QCameraFeedbackControl::EventType, const QString &filePath)


static void _init_f_setEventFeedbackSound_5577 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filePath");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setEventFeedbackSound_5577 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl *)cls)->setEventFeedbackSound (qt_gsi::QtToCppAdaptor<QCameraFeedbackControl::EventType>(arg1).cref(), arg2));
}


// static QString QCameraFeedbackControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraFeedbackControl::tr (arg1, arg2, arg3));
}


// static QString QCameraFeedbackControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraFeedbackControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCameraFeedbackControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("isEventFeedbackEnabled?", "@brief Method bool QCameraFeedbackControl::isEventFeedbackEnabled(QCameraFeedbackControl::EventType)\n", true, &_init_f_isEventFeedbackEnabled_c3660, &_call_f_isEventFeedbackEnabled_c3660);
  methods += new qt_gsi::GenericMethod ("isEventFeedbackLocked?", "@brief Method bool QCameraFeedbackControl::isEventFeedbackLocked(QCameraFeedbackControl::EventType)\n", true, &_init_f_isEventFeedbackLocked_c3660, &_call_f_isEventFeedbackLocked_c3660);
  methods += new qt_gsi::GenericMethod ("resetEventFeedback", "@brief Method void QCameraFeedbackControl::resetEventFeedback(QCameraFeedbackControl::EventType)\n", false, &_init_f_resetEventFeedback_3660, &_call_f_resetEventFeedback_3660);
  methods += new qt_gsi::GenericMethod ("setEventFeedbackEnabled", "@brief Method bool QCameraFeedbackControl::setEventFeedbackEnabled(QCameraFeedbackControl::EventType, bool)\n", false, &_init_f_setEventFeedbackEnabled_4416, &_call_f_setEventFeedbackEnabled_4416);
  methods += new qt_gsi::GenericMethod ("setEventFeedbackSound", "@brief Method bool QCameraFeedbackControl::setEventFeedbackSound(QCameraFeedbackControl::EventType, const QString &filePath)\n", false, &_init_f_setEventFeedbackSound_5577, &_call_f_setEventFeedbackSound_5577);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraFeedbackControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraFeedbackControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QCameraFeedbackControl> decl_QCameraFeedbackControl (qtdecl_QMediaControl (), "QtMultimedia", "QCameraFeedbackControl_Native",
  methods_QCameraFeedbackControl (),
  "@hide\n@alias QCameraFeedbackControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraFeedbackControl> &qtdecl_QCameraFeedbackControl () { return decl_QCameraFeedbackControl; }

}


class QCameraFeedbackControl_Adaptor : public QCameraFeedbackControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraFeedbackControl_Adaptor();

  //  [adaptor ctor] QCameraFeedbackControl::QCameraFeedbackControl()
  QCameraFeedbackControl_Adaptor() : QCameraFeedbackControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraFeedbackControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraFeedbackControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraFeedbackControl::isSignalConnected(signal);
  }

  //  [expose] int QCameraFeedbackControl::receivers(const char *signal)
  int fp_QCameraFeedbackControl_receivers_c1731 (const char *signal) const {
    return QCameraFeedbackControl::receivers(signal);
  }

  //  [expose] QObject *QCameraFeedbackControl::sender()
  QObject * fp_QCameraFeedbackControl_sender_c0 () const {
    return QCameraFeedbackControl::sender();
  }

  //  [expose] int QCameraFeedbackControl::senderSignalIndex()
  int fp_QCameraFeedbackControl_senderSignalIndex_c0 () const {
    return QCameraFeedbackControl::senderSignalIndex();
  }

  //  [adaptor impl] bool QCameraFeedbackControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCameraFeedbackControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraFeedbackControl_Adaptor, bool, QEvent *>(&QCameraFeedbackControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCameraFeedbackControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QCameraFeedbackControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCameraFeedbackControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraFeedbackControl_Adaptor, bool, QObject *, QEvent *>(&QCameraFeedbackControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCameraFeedbackControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QCameraFeedbackControl::isEventFeedbackEnabled(QCameraFeedbackControl::EventType)
  bool cbs_isEventFeedbackEnabled_c3660_0(const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1) const
  {
    __SUPPRESS_UNUSED_WARNING (arg1);
    throw qt_gsi::AbstractMethodCalledException("isEventFeedbackEnabled");
  }

  virtual bool isEventFeedbackEnabled(QCameraFeedbackControl::EventType arg1) const
  {
    if (cb_isEventFeedbackEnabled_c3660_0.can_issue()) {
      return cb_isEventFeedbackEnabled_c3660_0.issue<QCameraFeedbackControl_Adaptor, bool, const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type &>(&QCameraFeedbackControl_Adaptor::cbs_isEventFeedbackEnabled_c3660_0, qt_gsi::CppToQtAdaptor<QCameraFeedbackControl::EventType>(arg1));
    } else {
      throw qt_gsi::AbstractMethodCalledException("isEventFeedbackEnabled");
    }
  }

  //  [adaptor impl] bool QCameraFeedbackControl::isEventFeedbackLocked(QCameraFeedbackControl::EventType)
  bool cbs_isEventFeedbackLocked_c3660_0(const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1) const
  {
    __SUPPRESS_UNUSED_WARNING (arg1);
    throw qt_gsi::AbstractMethodCalledException("isEventFeedbackLocked");
  }

  virtual bool isEventFeedbackLocked(QCameraFeedbackControl::EventType arg1) const
  {
    if (cb_isEventFeedbackLocked_c3660_0.can_issue()) {
      return cb_isEventFeedbackLocked_c3660_0.issue<QCameraFeedbackControl_Adaptor, bool, const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type &>(&QCameraFeedbackControl_Adaptor::cbs_isEventFeedbackLocked_c3660_0, qt_gsi::CppToQtAdaptor<QCameraFeedbackControl::EventType>(arg1));
    } else {
      throw qt_gsi::AbstractMethodCalledException("isEventFeedbackLocked");
    }
  }

  //  [adaptor impl] void QCameraFeedbackControl::resetEventFeedback(QCameraFeedbackControl::EventType)
  void cbs_resetEventFeedback_3660_0(const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1)
  {
    __SUPPRESS_UNUSED_WARNING (arg1);
    throw qt_gsi::AbstractMethodCalledException("resetEventFeedback");
  }

  virtual void resetEventFeedback(QCameraFeedbackControl::EventType arg1)
  {
    if (cb_resetEventFeedback_3660_0.can_issue()) {
      cb_resetEventFeedback_3660_0.issue<QCameraFeedbackControl_Adaptor, const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type &>(&QCameraFeedbackControl_Adaptor::cbs_resetEventFeedback_3660_0, qt_gsi::CppToQtAdaptor<QCameraFeedbackControl::EventType>(arg1));
    } else {
      throw qt_gsi::AbstractMethodCalledException("resetEventFeedback");
    }
  }

  //  [adaptor impl] bool QCameraFeedbackControl::setEventFeedbackEnabled(QCameraFeedbackControl::EventType, bool)
  bool cbs_setEventFeedbackEnabled_4416_0(const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1, bool arg2)
  {
    __SUPPRESS_UNUSED_WARNING (arg1);
    __SUPPRESS_UNUSED_WARNING (arg2);
    throw qt_gsi::AbstractMethodCalledException("setEventFeedbackEnabled");
  }

  virtual bool setEventFeedbackEnabled(QCameraFeedbackControl::EventType arg1, bool arg2)
  {
    if (cb_setEventFeedbackEnabled_4416_0.can_issue()) {
      return cb_setEventFeedbackEnabled_4416_0.issue<QCameraFeedbackControl_Adaptor, bool, const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type &, bool>(&QCameraFeedbackControl_Adaptor::cbs_setEventFeedbackEnabled_4416_0, qt_gsi::CppToQtAdaptor<QCameraFeedbackControl::EventType>(arg1), arg2);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setEventFeedbackEnabled");
    }
  }

  //  [adaptor impl] bool QCameraFeedbackControl::setEventFeedbackSound(QCameraFeedbackControl::EventType, const QString &filePath)
  bool cbs_setEventFeedbackSound_5577_0(const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1, const QString &filePath)
  {
    __SUPPRESS_UNUSED_WARNING (arg1);
    __SUPPRESS_UNUSED_WARNING (filePath);
    throw qt_gsi::AbstractMethodCalledException("setEventFeedbackSound");
  }

  virtual bool setEventFeedbackSound(QCameraFeedbackControl::EventType arg1, const QString &filePath)
  {
    if (cb_setEventFeedbackSound_5577_0.can_issue()) {
      return cb_setEventFeedbackSound_5577_0.issue<QCameraFeedbackControl_Adaptor, bool, const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type &, const QString &>(&QCameraFeedbackControl_Adaptor::cbs_setEventFeedbackSound_5577_0, qt_gsi::CppToQtAdaptor<QCameraFeedbackControl::EventType>(arg1), filePath);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setEventFeedbackSound");
    }
  }

  //  [adaptor impl] void QCameraFeedbackControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCameraFeedbackControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraFeedbackControl_Adaptor, QChildEvent *>(&QCameraFeedbackControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCameraFeedbackControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraFeedbackControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCameraFeedbackControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraFeedbackControl_Adaptor, QEvent *>(&QCameraFeedbackControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCameraFeedbackControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraFeedbackControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraFeedbackControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraFeedbackControl_Adaptor, const QMetaMethod &>(&QCameraFeedbackControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraFeedbackControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCameraFeedbackControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCameraFeedbackControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraFeedbackControl_Adaptor, QTimerEvent *>(&QCameraFeedbackControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCameraFeedbackControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isEventFeedbackEnabled_c3660_0;
  gsi::Callback cb_isEventFeedbackLocked_c3660_0;
  gsi::Callback cb_resetEventFeedback_3660_0;
  gsi::Callback cb_setEventFeedbackEnabled_4416_0;
  gsi::Callback cb_setEventFeedbackSound_5577_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraFeedbackControl_Adaptor::~QCameraFeedbackControl_Adaptor() { }

//  Constructor QCameraFeedbackControl::QCameraFeedbackControl() (adaptor class)

static void _init_ctor_QCameraFeedbackControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCameraFeedbackControl_Adaptor> ();
}

static void _call_ctor_QCameraFeedbackControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraFeedbackControl_Adaptor *> (new QCameraFeedbackControl_Adaptor ());
}


// void QCameraFeedbackControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFeedbackControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCameraFeedbackControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFeedbackControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QCameraFeedbackControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFeedbackControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QCameraFeedbackControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraFeedbackControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QCameraFeedbackControl::isEventFeedbackEnabled(QCameraFeedbackControl::EventType)

static void _init_cbs_isEventFeedbackEnabled_c3660_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isEventFeedbackEnabled_c3660_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl_Adaptor *)cls)->cbs_isEventFeedbackEnabled_c3660_0 (arg1));
}

static void _set_callback_cbs_isEventFeedbackEnabled_c3660_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_isEventFeedbackEnabled_c3660_0 = cb;
}


// bool QCameraFeedbackControl::isEventFeedbackLocked(QCameraFeedbackControl::EventType)

static void _init_cbs_isEventFeedbackLocked_c3660_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isEventFeedbackLocked_c3660_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl_Adaptor *)cls)->cbs_isEventFeedbackLocked_c3660_0 (arg1));
}

static void _set_callback_cbs_isEventFeedbackLocked_c3660_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_isEventFeedbackLocked_c3660_0 = cb;
}


// exposed bool QCameraFeedbackControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl_Adaptor *)cls)->fp_QCameraFeedbackControl_isSignalConnected_c2394 (arg1));
}


// exposed int QCameraFeedbackControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraFeedbackControl_Adaptor *)cls)->fp_QCameraFeedbackControl_receivers_c1731 (arg1));
}


// void QCameraFeedbackControl::resetEventFeedback(QCameraFeedbackControl::EventType)

static void _init_cbs_resetEventFeedback_3660_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resetEventFeedback_3660_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFeedbackControl_Adaptor *)cls)->cbs_resetEventFeedback_3660_0 (arg1);
}

static void _set_callback_cbs_resetEventFeedback_3660_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_resetEventFeedback_3660_0 = cb;
}


// exposed QObject *QCameraFeedbackControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraFeedbackControl_Adaptor *)cls)->fp_QCameraFeedbackControl_sender_c0 ());
}


// exposed int QCameraFeedbackControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraFeedbackControl_Adaptor *)cls)->fp_QCameraFeedbackControl_senderSignalIndex_c0 ());
}


// bool QCameraFeedbackControl::setEventFeedbackEnabled(QCameraFeedbackControl::EventType, bool)

static void _init_cbs_setEventFeedbackEnabled_4416_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setEventFeedbackEnabled_4416_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (heap);
  bool arg2 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl_Adaptor *)cls)->cbs_setEventFeedbackEnabled_4416_0 (arg1, arg2));
}

static void _set_callback_cbs_setEventFeedbackEnabled_4416_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_setEventFeedbackEnabled_4416_0 = cb;
}


// bool QCameraFeedbackControl::setEventFeedbackSound(QCameraFeedbackControl::EventType, const QString &filePath)

static void _init_cbs_setEventFeedbackSound_5577_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filePath");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setEventFeedbackSound_5577_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraFeedbackControl::EventType>::target_type & > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QCameraFeedbackControl_Adaptor *)cls)->cbs_setEventFeedbackSound_5577_0 (arg1, arg2));
}

static void _set_callback_cbs_setEventFeedbackSound_5577_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_setEventFeedbackSound_5577_0 = cb;
}


// void QCameraFeedbackControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFeedbackControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFeedbackControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraFeedbackControl> &qtdecl_QCameraFeedbackControl ();

static gsi::Methods methods_QCameraFeedbackControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraFeedbackControl::QCameraFeedbackControl()\nThis method creates an object of class QCameraFeedbackControl.", &_init_ctor_QCameraFeedbackControl_Adaptor_0, &_call_ctor_QCameraFeedbackControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraFeedbackControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraFeedbackControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraFeedbackControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraFeedbackControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraFeedbackControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isEventFeedbackEnabled", "@brief Virtual method bool QCameraFeedbackControl::isEventFeedbackEnabled(QCameraFeedbackControl::EventType)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEventFeedbackEnabled_c3660_0, &_call_cbs_isEventFeedbackEnabled_c3660_0);
  methods += new qt_gsi::GenericMethod ("isEventFeedbackEnabled", "@hide", true, &_init_cbs_isEventFeedbackEnabled_c3660_0, &_call_cbs_isEventFeedbackEnabled_c3660_0, &_set_callback_cbs_isEventFeedbackEnabled_c3660_0);
  methods += new qt_gsi::GenericMethod ("isEventFeedbackLocked", "@brief Virtual method bool QCameraFeedbackControl::isEventFeedbackLocked(QCameraFeedbackControl::EventType)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEventFeedbackLocked_c3660_0, &_call_cbs_isEventFeedbackLocked_c3660_0);
  methods += new qt_gsi::GenericMethod ("isEventFeedbackLocked", "@hide", true, &_init_cbs_isEventFeedbackLocked_c3660_0, &_call_cbs_isEventFeedbackLocked_c3660_0, &_set_callback_cbs_isEventFeedbackLocked_c3660_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraFeedbackControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraFeedbackControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("resetEventFeedback", "@brief Virtual method void QCameraFeedbackControl::resetEventFeedback(QCameraFeedbackControl::EventType)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resetEventFeedback_3660_0, &_call_cbs_resetEventFeedback_3660_0);
  methods += new qt_gsi::GenericMethod ("resetEventFeedback", "@hide", false, &_init_cbs_resetEventFeedback_3660_0, &_call_cbs_resetEventFeedback_3660_0, &_set_callback_cbs_resetEventFeedback_3660_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraFeedbackControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraFeedbackControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setEventFeedbackEnabled", "@brief Virtual method bool QCameraFeedbackControl::setEventFeedbackEnabled(QCameraFeedbackControl::EventType, bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setEventFeedbackEnabled_4416_0, &_call_cbs_setEventFeedbackEnabled_4416_0);
  methods += new qt_gsi::GenericMethod ("setEventFeedbackEnabled", "@hide", false, &_init_cbs_setEventFeedbackEnabled_4416_0, &_call_cbs_setEventFeedbackEnabled_4416_0, &_set_callback_cbs_setEventFeedbackEnabled_4416_0);
  methods += new qt_gsi::GenericMethod ("setEventFeedbackSound", "@brief Virtual method bool QCameraFeedbackControl::setEventFeedbackSound(QCameraFeedbackControl::EventType, const QString &filePath)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setEventFeedbackSound_5577_0, &_call_cbs_setEventFeedbackSound_5577_0);
  methods += new qt_gsi::GenericMethod ("setEventFeedbackSound", "@hide", false, &_init_cbs_setEventFeedbackSound_5577_0, &_call_cbs_setEventFeedbackSound_5577_0, &_set_callback_cbs_setEventFeedbackSound_5577_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraFeedbackControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCameraFeedbackControl_Adaptor> decl_QCameraFeedbackControl_Adaptor (qtdecl_QCameraFeedbackControl (), "QtMultimedia", "QCameraFeedbackControl",
  methods_QCameraFeedbackControl_Adaptor (),
  "@qt\n@brief Binding of QCameraFeedbackControl");

}


//  Implementation of the enum wrapper class for QCameraFeedbackControl::EventType
namespace qt_gsi
{

static gsi::Enum<QCameraFeedbackControl::EventType> decl_QCameraFeedbackControl_EventType_Enum ("QtMultimedia", "QCameraFeedbackControl_EventType",
    gsi::enum_const ("ViewfinderStarted", QCameraFeedbackControl::ViewfinderStarted, "@brief Enum constant QCameraFeedbackControl::ViewfinderStarted") +
    gsi::enum_const ("ViewfinderStopped", QCameraFeedbackControl::ViewfinderStopped, "@brief Enum constant QCameraFeedbackControl::ViewfinderStopped") +
    gsi::enum_const ("ImageCaptured", QCameraFeedbackControl::ImageCaptured, "@brief Enum constant QCameraFeedbackControl::ImageCaptured") +
    gsi::enum_const ("ImageSaved", QCameraFeedbackControl::ImageSaved, "@brief Enum constant QCameraFeedbackControl::ImageSaved") +
    gsi::enum_const ("ImageError", QCameraFeedbackControl::ImageError, "@brief Enum constant QCameraFeedbackControl::ImageError") +
    gsi::enum_const ("RecordingStarted", QCameraFeedbackControl::RecordingStarted, "@brief Enum constant QCameraFeedbackControl::RecordingStarted") +
    gsi::enum_const ("RecordingInProgress", QCameraFeedbackControl::RecordingInProgress, "@brief Enum constant QCameraFeedbackControl::RecordingInProgress") +
    gsi::enum_const ("RecordingStopped", QCameraFeedbackControl::RecordingStopped, "@brief Enum constant QCameraFeedbackControl::RecordingStopped") +
    gsi::enum_const ("AutoFocusInProgress", QCameraFeedbackControl::AutoFocusInProgress, "@brief Enum constant QCameraFeedbackControl::AutoFocusInProgress") +
    gsi::enum_const ("AutoFocusLocked", QCameraFeedbackControl::AutoFocusLocked, "@brief Enum constant QCameraFeedbackControl::AutoFocusLocked") +
    gsi::enum_const ("AutoFocusFailed", QCameraFeedbackControl::AutoFocusFailed, "@brief Enum constant QCameraFeedbackControl::AutoFocusFailed"),
  "@qt\n@brief This class represents the QCameraFeedbackControl::EventType enum");

static gsi::QFlagsClass<QCameraFeedbackControl::EventType > decl_QCameraFeedbackControl_EventType_Enums ("QtMultimedia", "QCameraFeedbackControl_QFlags_EventType",
  "@qt\n@brief This class represents the QFlags<QCameraFeedbackControl::EventType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraFeedbackControl> inject_QCameraFeedbackControl_EventType_Enum_in_parent (decl_QCameraFeedbackControl_EventType_Enum.defs ());
static gsi::ClassExt<QCameraFeedbackControl> decl_QCameraFeedbackControl_EventType_Enum_as_child (decl_QCameraFeedbackControl_EventType_Enum, "EventType");
static gsi::ClassExt<QCameraFeedbackControl> decl_QCameraFeedbackControl_EventType_Enums_as_child (decl_QCameraFeedbackControl_EventType_Enums, "QFlags_EventType");

}

