
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRegExp.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRegExp>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRegExp

//  Constructor QRegExp::QRegExp()


static void _init_ctor_QRegExp_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QRegExp> ();
}

static void _call_ctor_QRegExp_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRegExp *> (new QRegExp ());
}


//  Constructor QRegExp::QRegExp(const QString &pattern, Qt::CaseSensitivity cs, QRegExp::PatternSyntax syntax)


static void _init_ctor_QRegExp_6734 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pattern");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cs", true, "Qt::CaseSensitive");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("syntax", true, "QRegExp::RegExp");
  decl->add_arg<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > (argspec_2);
  decl->set_return_new<QRegExp> ();
}

static void _call_ctor_QRegExp_6734 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::CaseSensitivity>(heap, Qt::CaseSensitive), heap);
  const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QRegExp::PatternSyntax>(heap, QRegExp::RegExp), heap);
  ret.write<QRegExp *> (new QRegExp (arg1, qt_gsi::QtToCppAdaptor<Qt::CaseSensitivity>(arg2).cref(), qt_gsi::QtToCppAdaptor<QRegExp::PatternSyntax>(arg3).cref()));
}


//  Constructor QRegExp::QRegExp(const QRegExp &rx)


static void _init_ctor_QRegExp_1981 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return_new<QRegExp> ();
}

static void _call_ctor_QRegExp_1981 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = gsi::arg_reader<const QRegExp & >() (args, heap);
  ret.write<QRegExp *> (new QRegExp (arg1));
}


// QString QRegExp::cap(int nth)


static void _init_f_cap_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nth", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_cap_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QString > ((QString)((QRegExp *)cls)->cap (arg1));
}


// QString QRegExp::cap(int nth)


static void _init_f_cap_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nth", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_cap_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QString > ((QString)((QRegExp *)cls)->cap (arg1));
}


// int QRegExp::captureCount()


static void _init_f_captureCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_captureCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRegExp *)cls)->captureCount ());
}


// QStringList QRegExp::capturedTexts()


static void _init_f_capturedTexts_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_capturedTexts_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QRegExp *)cls)->capturedTexts ());
}


// QStringList QRegExp::capturedTexts()


static void _init_f_capturedTexts_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_capturedTexts_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QRegExp *)cls)->capturedTexts ());
}


// Qt::CaseSensitivity QRegExp::caseSensitivity()


static void _init_f_caseSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ();
}

static void _call_f_caseSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ((qt_gsi::Converter<Qt::CaseSensitivity>::target_type)qt_gsi::CppToQtAdaptor<Qt::CaseSensitivity>(((QRegExp *)cls)->caseSensitivity ()));
}


// QString QRegExp::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRegExp *)cls)->errorString ());
}


// QString QRegExp::errorString()


static void _init_f_errorString_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRegExp *)cls)->errorString ());
}


// bool QRegExp::exactMatch(const QString &str)


static void _init_f_exactMatch_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_exactMatch_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QRegExp *)cls)->exactMatch (arg1));
}


// int QRegExp::indexIn(const QString &str, int offset, QRegExp::CaretMode caretMode)


static void _init_f_indexIn_c4680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("caretMode", true, "QRegExp::CaretAtZero");
  decl->add_arg<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_indexIn_c4680 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  const qt_gsi::Converter<QRegExp::CaretMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QRegExp::CaretMode>(heap, QRegExp::CaretAtZero), heap);
  ret.write<int > ((int)((QRegExp *)cls)->indexIn (arg1, arg2, qt_gsi::QtToCppAdaptor<QRegExp::CaretMode>(arg3).cref()));
}


// bool QRegExp::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRegExp *)cls)->isEmpty ());
}


// bool QRegExp::isMinimal()


static void _init_f_isMinimal_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMinimal_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRegExp *)cls)->isMinimal ());
}


// bool QRegExp::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRegExp *)cls)->isValid ());
}


// int QRegExp::lastIndexIn(const QString &str, int offset, QRegExp::CaretMode caretMode)


static void _init_f_lastIndexIn_c4680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "-1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("caretMode", true, "QRegExp::CaretAtZero");
  decl->add_arg<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_lastIndexIn_c4680 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  const qt_gsi::Converter<QRegExp::CaretMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QRegExp::CaretMode>(heap, QRegExp::CaretAtZero), heap);
  ret.write<int > ((int)((QRegExp *)cls)->lastIndexIn (arg1, arg2, qt_gsi::QtToCppAdaptor<QRegExp::CaretMode>(arg3).cref()));
}


// int QRegExp::matchedLength()


static void _init_f_matchedLength_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_matchedLength_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRegExp *)cls)->matchedLength ());
}


// int QRegExp::numCaptures()


static void _init_f_numCaptures_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_numCaptures_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRegExp *)cls)->numCaptures ());
}


// bool QRegExp::operator!=(const QRegExp &rx)


static void _init_f_operator_excl__eq__c1981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1981 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = gsi::arg_reader<const QRegExp & >() (args, heap);
  ret.write<bool > ((bool)((QRegExp *)cls)->operator!= (arg1));
}


// QRegExp &QRegExp::operator=(const QRegExp &rx)


static void _init_f_operator_eq__1981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return<QRegExp & > ();
}

static void _call_f_operator_eq__1981 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = gsi::arg_reader<const QRegExp & >() (args, heap);
  ret.write<QRegExp & > ((QRegExp &)((QRegExp *)cls)->operator= (arg1));
}


// bool QRegExp::operator==(const QRegExp &rx)


static void _init_f_operator_eq__eq__c1981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1981 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = gsi::arg_reader<const QRegExp & >() (args, heap);
  ret.write<bool > ((bool)((QRegExp *)cls)->operator== (arg1));
}


// QString QRegExp::pattern()


static void _init_f_pattern_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_pattern_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRegExp *)cls)->pattern ());
}


// QRegExp::PatternSyntax QRegExp::patternSyntax()


static void _init_f_patternSyntax_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRegExp::PatternSyntax>::target_type > ();
}

static void _call_f_patternSyntax_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRegExp::PatternSyntax>::target_type > ((qt_gsi::Converter<QRegExp::PatternSyntax>::target_type)qt_gsi::CppToQtAdaptor<QRegExp::PatternSyntax>(((QRegExp *)cls)->patternSyntax ()));
}


// int QRegExp::pos(int nth)


static void _init_f_pos_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nth", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_pos_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<int > ((int)((QRegExp *)cls)->pos (arg1));
}


// int QRegExp::pos(int nth)


static void _init_f_pos_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nth", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_pos_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<int > ((int)((QRegExp *)cls)->pos (arg1));
}


// void QRegExp::setCaseSensitivity(Qt::CaseSensitivity cs)


static void _init_f_setCaseSensitivity_2324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cs");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaseSensitivity_2324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExp *)cls)->setCaseSensitivity (qt_gsi::QtToCppAdaptor<Qt::CaseSensitivity>(arg1).cref());
}


// void QRegExp::setMinimal(bool minimal)


static void _init_f_setMinimal_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minimal");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimal_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExp *)cls)->setMinimal (arg1);
}


// void QRegExp::setPattern(const QString &pattern)


static void _init_f_setPattern_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pattern");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPattern_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExp *)cls)->setPattern (arg1);
}


// void QRegExp::setPatternSyntax(QRegExp::PatternSyntax syntax)


static void _init_f_setPatternSyntax_2601 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("syntax");
  decl->add_arg<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPatternSyntax_2601 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExp *)cls)->setPatternSyntax (qt_gsi::QtToCppAdaptor<QRegExp::PatternSyntax>(arg1).cref());
}


// static QString QRegExp::escape(const QString &str)


static void _init_f_escape_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_escape_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)QRegExp::escape (arg1));
}



namespace gsi
{

static gsi::Methods methods_QRegExp () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRegExp::QRegExp()\nThis method creates an object of class QRegExp.", &_init_ctor_QRegExp_0, &_call_ctor_QRegExp_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRegExp::QRegExp(const QString &pattern, Qt::CaseSensitivity cs, QRegExp::PatternSyntax syntax)\nThis method creates an object of class QRegExp.", &_init_ctor_QRegExp_6734, &_call_ctor_QRegExp_6734);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRegExp::QRegExp(const QRegExp &rx)\nThis method creates an object of class QRegExp.", &_init_ctor_QRegExp_1981, &_call_ctor_QRegExp_1981);
  methods += new qt_gsi::GenericMethod ("cap", "@brief Method QString QRegExp::cap(int nth)\n", true, &_init_f_cap_c767, &_call_f_cap_c767);
  methods += new qt_gsi::GenericMethod ("cap", "@brief Method QString QRegExp::cap(int nth)\n", false, &_init_f_cap_767, &_call_f_cap_767);
  methods += new qt_gsi::GenericMethod ("captureCount", "@brief Method int QRegExp::captureCount()\n", true, &_init_f_captureCount_c0, &_call_f_captureCount_c0);
  methods += new qt_gsi::GenericMethod ("capturedTexts", "@brief Method QStringList QRegExp::capturedTexts()\n", true, &_init_f_capturedTexts_c0, &_call_f_capturedTexts_c0);
  methods += new qt_gsi::GenericMethod ("capturedTexts", "@brief Method QStringList QRegExp::capturedTexts()\n", false, &_init_f_capturedTexts_0, &_call_f_capturedTexts_0);
  methods += new qt_gsi::GenericMethod (":caseSensitivity", "@brief Method Qt::CaseSensitivity QRegExp::caseSensitivity()\n", true, &_init_f_caseSensitivity_c0, &_call_f_caseSensitivity_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QRegExp::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QRegExp::errorString()\n", false, &_init_f_errorString_0, &_call_f_errorString_0);
  methods += new qt_gsi::GenericMethod ("exactMatch", "@brief Method bool QRegExp::exactMatch(const QString &str)\n", true, &_init_f_exactMatch_c2025, &_call_f_exactMatch_c2025);
  methods += new qt_gsi::GenericMethod ("indexIn", "@brief Method int QRegExp::indexIn(const QString &str, int offset, QRegExp::CaretMode caretMode)\n", true, &_init_f_indexIn_c4680, &_call_f_indexIn_c4680);
  methods += new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QRegExp::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
  methods += new qt_gsi::GenericMethod ("isMinimal?|:minimal", "@brief Method bool QRegExp::isMinimal()\n", true, &_init_f_isMinimal_c0, &_call_f_isMinimal_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QRegExp::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("lastIndexIn", "@brief Method int QRegExp::lastIndexIn(const QString &str, int offset, QRegExp::CaretMode caretMode)\n", true, &_init_f_lastIndexIn_c4680, &_call_f_lastIndexIn_c4680);
  methods += new qt_gsi::GenericMethod ("matchedLength", "@brief Method int QRegExp::matchedLength()\n", true, &_init_f_matchedLength_c0, &_call_f_matchedLength_c0);
  methods += new qt_gsi::GenericMethod ("numCaptures", "@brief Method int QRegExp::numCaptures()\n", true, &_init_f_numCaptures_c0, &_call_f_numCaptures_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QRegExp::operator!=(const QRegExp &rx)\n", true, &_init_f_operator_excl__eq__c1981, &_call_f_operator_excl__eq__c1981);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QRegExp &QRegExp::operator=(const QRegExp &rx)\n", false, &_init_f_operator_eq__1981, &_call_f_operator_eq__1981);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QRegExp::operator==(const QRegExp &rx)\n", true, &_init_f_operator_eq__eq__c1981, &_call_f_operator_eq__eq__c1981);
  methods += new qt_gsi::GenericMethod (":pattern", "@brief Method QString QRegExp::pattern()\n", true, &_init_f_pattern_c0, &_call_f_pattern_c0);
  methods += new qt_gsi::GenericMethod (":patternSyntax", "@brief Method QRegExp::PatternSyntax QRegExp::patternSyntax()\n", true, &_init_f_patternSyntax_c0, &_call_f_patternSyntax_c0);
  methods += new qt_gsi::GenericMethod ("pos", "@brief Method int QRegExp::pos(int nth)\n", true, &_init_f_pos_c767, &_call_f_pos_c767);
  methods += new qt_gsi::GenericMethod ("pos", "@brief Method int QRegExp::pos(int nth)\n", false, &_init_f_pos_767, &_call_f_pos_767);
  methods += new qt_gsi::GenericMethod ("setCaseSensitivity|caseSensitivity=", "@brief Method void QRegExp::setCaseSensitivity(Qt::CaseSensitivity cs)\n", false, &_init_f_setCaseSensitivity_2324, &_call_f_setCaseSensitivity_2324);
  methods += new qt_gsi::GenericMethod ("setMinimal|minimal=", "@brief Method void QRegExp::setMinimal(bool minimal)\n", false, &_init_f_setMinimal_864, &_call_f_setMinimal_864);
  methods += new qt_gsi::GenericMethod ("setPattern|pattern=", "@brief Method void QRegExp::setPattern(const QString &pattern)\n", false, &_init_f_setPattern_2025, &_call_f_setPattern_2025);
  methods += new qt_gsi::GenericMethod ("setPatternSyntax|patternSyntax=", "@brief Method void QRegExp::setPatternSyntax(QRegExp::PatternSyntax syntax)\n", false, &_init_f_setPatternSyntax_2601, &_call_f_setPatternSyntax_2601);
  methods += new qt_gsi::GenericStaticMethod ("escape", "@brief Static method QString QRegExp::escape(const QString &str)\nThis method is static and can be called without an instance.", &_init_f_escape_2025, &_call_f_escape_2025);
  return methods;
}

gsi::Class<QRegExp> decl_QRegExp ("QtCore", "QRegExp",
  methods_QRegExp (),
  "@qt\n@brief Binding of QRegExp");


GSI_QTCORE_PUBLIC gsi::Class<QRegExp> &qtdecl_QRegExp () { return decl_QRegExp; }

}


//  Implementation of the enum wrapper class for QRegExp::CaretMode
namespace qt_gsi
{

static gsi::Enum<QRegExp::CaretMode> decl_QRegExp_CaretMode_Enum ("QtCore", "QRegExp_CaretMode",
    gsi::enum_const ("CaretAtZero", QRegExp::CaretAtZero, "@brief Enum constant QRegExp::CaretAtZero") +
    gsi::enum_const ("CaretAtOffset", QRegExp::CaretAtOffset, "@brief Enum constant QRegExp::CaretAtOffset") +
    gsi::enum_const ("CaretWontMatch", QRegExp::CaretWontMatch, "@brief Enum constant QRegExp::CaretWontMatch"),
  "@qt\n@brief This class represents the QRegExp::CaretMode enum");

static gsi::QFlagsClass<QRegExp::CaretMode > decl_QRegExp_CaretMode_Enums ("QtCore", "QRegExp_QFlags_CaretMode",
  "@qt\n@brief This class represents the QFlags<QRegExp::CaretMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRegExp> inject_QRegExp_CaretMode_Enum_in_parent (decl_QRegExp_CaretMode_Enum.defs ());
static gsi::ClassExt<QRegExp> decl_QRegExp_CaretMode_Enum_as_child (decl_QRegExp_CaretMode_Enum, "CaretMode");
static gsi::ClassExt<QRegExp> decl_QRegExp_CaretMode_Enums_as_child (decl_QRegExp_CaretMode_Enums, "QFlags_CaretMode");

}


//  Implementation of the enum wrapper class for QRegExp::PatternSyntax
namespace qt_gsi
{

static gsi::Enum<QRegExp::PatternSyntax> decl_QRegExp_PatternSyntax_Enum ("QtCore", "QRegExp_PatternSyntax",
    gsi::enum_const ("RegExp", QRegExp::RegExp, "@brief Enum constant QRegExp::RegExp") +
    gsi::enum_const ("Wildcard", QRegExp::Wildcard, "@brief Enum constant QRegExp::Wildcard") +
    gsi::enum_const ("FixedString", QRegExp::FixedString, "@brief Enum constant QRegExp::FixedString") +
    gsi::enum_const ("RegExp2", QRegExp::RegExp2, "@brief Enum constant QRegExp::RegExp2") +
    gsi::enum_const ("WildcardUnix", QRegExp::WildcardUnix, "@brief Enum constant QRegExp::WildcardUnix") +
    gsi::enum_const ("W3CXmlSchema11", QRegExp::W3CXmlSchema11, "@brief Enum constant QRegExp::W3CXmlSchema11"),
  "@qt\n@brief This class represents the QRegExp::PatternSyntax enum");

static gsi::QFlagsClass<QRegExp::PatternSyntax > decl_QRegExp_PatternSyntax_Enums ("QtCore", "QRegExp_QFlags_PatternSyntax",
  "@qt\n@brief This class represents the QFlags<QRegExp::PatternSyntax> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRegExp> inject_QRegExp_PatternSyntax_Enum_in_parent (decl_QRegExp_PatternSyntax_Enum.defs ());
static gsi::ClassExt<QRegExp> decl_QRegExp_PatternSyntax_Enum_as_child (decl_QRegExp_PatternSyntax_Enum, "PatternSyntax");
static gsi::ClassExt<QRegExp> decl_QRegExp_PatternSyntax_Enums_as_child (decl_QRegExp_PatternSyntax_Enums, "QFlags_PatternSyntax");

}

