/*
    Copyright (C) 2021 Fredrik Johansson

    This file is part of FLINT.

    FLINT is free software: you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License (LGPL) as published
    by the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.  See <https://www.gnu.org/licenses/>.
*/

#include "fexpr.h"
#include "fexpr_builtin.h"

const fexpr_symbol_info fexpr_builtin_table[FEXPR_BUILTIN_LENGTH] = {
    { FEXPR_AGM, "AGM", "\\operatorname{agm}", NULL, },
    { FEXPR_AGMSequence, "AGMSequence", "\\operatorname{agm}", fexpr_write_latex_subscript_call, },
    { FEXPR_Abs, "Abs", "", fexpr_write_latex_simple, },
    { FEXPR_Acos, "Acos", "\\operatorname{acos}", NULL, },
    { FEXPR_Acosh, "Acosh", "\\operatorname{acosh}", NULL, },
    { FEXPR_Acot, "Acot", "\\operatorname{acot}", NULL, },
    { FEXPR_Acoth, "Acoth", "\\operatorname{acoth}", NULL, },
    { FEXPR_Acsc, "Acsc", "\\operatorname{acsc}", NULL, },
    { FEXPR_Acsch, "Acsch", "\\operatorname{acsch}", NULL, },
    { FEXPR_Add, "Add", "", fexpr_write_latex_add, },
    { FEXPR_AiryAi, "AiryAi", "\\operatorname{Ai}", fexpr_write_latex_call1_optional_derivative, },
    { FEXPR_AiryAiZero, "AiryAiZero", "a", fexpr_write_latex_subscript, },
    { FEXPR_AiryBi, "AiryBi", "\\operatorname{Bi}", fexpr_write_latex_call1_optional_derivative, },
    { FEXPR_AiryBiZero, "AiryBiZero", "b", fexpr_write_latex_subscript, },
    { FEXPR_AlgebraicNumberSerialized, "AlgebraicNumberSerialized", "", fexpr_write_latex_misc_special, },
    { FEXPR_AlgebraicNumbers, "AlgebraicNumbers", "\\overline{\\mathbb{Q}}", NULL, },
    { FEXPR_All, "All", "", fexpr_write_latex_logic, },
    { FEXPR_AnalyticContinuation, "AnalyticContinuation", "", fexpr_write_latex_misc_special, },
    { FEXPR_And, "And", "", fexpr_write_latex_logic, },
    { FEXPR_AngleBrackets, "AngleBrackets", "", fexpr_write_latex_simple, },
    { FEXPR_Approximation, "Approximation", "", fexpr_write_latex_simple },
    { FEXPR_Arg, "Arg", "\\arg", NULL, },
    { FEXPR_ArgMax, "ArgMax", "", fexpr_write_latex_setop, },
    { FEXPR_ArgMaxUnique, "ArgMaxUnique", "", fexpr_write_latex_setop, },
    { FEXPR_ArgMin, "ArgMin", "", fexpr_write_latex_setop, },
    { FEXPR_ArgMinUnique, "ArgMinUnique", "", fexpr_write_latex_setop, },
    { FEXPR_Asec, "Asec", "\\operatorname{asec}", NULL, },
    { FEXPR_Asech, "Asech", "\\operatorname{asech}", NULL, },
    { FEXPR_Asin, "Asin", "\\operatorname{asin}", NULL, },
    { FEXPR_Asinh, "Asinh", "\\operatorname{asinh}", NULL, },
    { FEXPR_AsymptoticTo, "AsymptoticTo", "", fexpr_write_latex_misc_special, },
    { FEXPR_Atan, "Atan", "\\operatorname{atan}", NULL, },
    { FEXPR_Atan2, "Atan2", "\\operatorname{atan2}", NULL, },
    { FEXPR_Atanh, "Atanh", "\\operatorname{atanh}", NULL, },
    { FEXPR_BarnesG, "BarnesG", "G", NULL, },
    { FEXPR_BellNumber, "BellNumber", "\\operatorname{B}", fexpr_write_latex_subscript, },
    { FEXPR_BernoulliB, "BernoulliB", "B", fexpr_write_latex_subscript, },
    { FEXPR_BernoulliPolynomial, "BernoulliPolynomial", "B", fexpr_write_latex_subscript_call, },
    { FEXPR_BernsteinEllipse, "BernsteinEllipse", "\\mathcal{E}", fexpr_write_latex_subscript, },
    { FEXPR_BesselI, "BesselI", "I", fexpr_write_latex_sub1_call1_optional_derivative, },
    { FEXPR_BesselJ, "BesselJ", "J", fexpr_write_latex_sub1_call1_optional_derivative, },
    { FEXPR_BesselJZero, "BesselJZero", "j", fexpr_write_latex_subscript, },
    { FEXPR_BesselK, "BesselK", "K", fexpr_write_latex_sub1_call1_optional_derivative, },
    { FEXPR_BesselY, "BesselY", "Y", fexpr_write_latex_sub1_call1_optional_derivative, },
    { FEXPR_BesselYZero, "BesselYZero", "y", fexpr_write_latex_subscript, },
    { FEXPR_BetaFunction, "BetaFunction", "\\mathrm{B}", NULL, },
    { FEXPR_Binomial, "Binomial", "", fexpr_write_latex_simple2, },
    { FEXPR_Braces, "Braces", "", fexpr_write_latex_simple, },
    { FEXPR_Brackets, "Brackets", "", fexpr_write_latex_simple, },
    { FEXPR_CC, "CC", "\\mathbb{C}", NULL, },
    { FEXPR_Call, "Call", "", fexpr_write_latex_misc_special, },
    { FEXPR_CallIndeterminate, "CallIndeterminate", "", fexpr_write_latex_misc_special, },
    { FEXPR_Cardinality, "Cardinality", "", fexpr_write_latex_simple, },
    { FEXPR_CarlsonHypergeometricR, "CarlsonHypergeometricR", "R", fexpr_write_latex_subscript_call, },
    { FEXPR_CarlsonHypergeometricT, "CarlsonHypergeometricT", "T", fexpr_write_latex_subscript_call, },
    { FEXPR_CarlsonRC, "CarlsonRC", "R_C", NULL, },
    { FEXPR_CarlsonRD, "CarlsonRD", "R_D", NULL, },
    { FEXPR_CarlsonRF, "CarlsonRF", "R_F", NULL, },
    { FEXPR_CarlsonRG, "CarlsonRG", "R_G", NULL, },
    { FEXPR_CarlsonRJ, "CarlsonRJ", "R_J", NULL, },
    { FEXPR_CartesianPower, "CartesianPower", "", fexpr_write_latex_pow, },
    { FEXPR_CartesianProduct, "CartesianProduct", "\\times", fexpr_write_latex_infix, },
    { FEXPR_Case, "Case", "", NULL, },
    { FEXPR_Cases, "Cases", "", fexpr_write_latex_cases, },
    { FEXPR_CatalanConstant, "CatalanConstant", "G", NULL, },
    { FEXPR_Ceil, "Ceil", "", fexpr_write_latex_simple, },
    { FEXPR_Characteristic, "Characteristic", "\\operatorname{char}", NULL, },
    { FEXPR_ChebyshevT, "ChebyshevT", "T", fexpr_write_latex_subscript_call, },
    { FEXPR_ChebyshevU, "ChebyshevU", "U", fexpr_write_latex_subscript_call, },
    { FEXPR_ClosedComplexDisk, "ClosedComplexDisk", "\\overline{D}", NULL, },
    { FEXPR_ClosedOpenInterval, "ClosedOpenInterval", "", fexpr_write_latex_simple2_small, },
    { FEXPR_Coefficient, "Coefficient", "", fexpr_write_latex_misc_special, },
    { FEXPR_Column, "Column", "", NULL, },
    { FEXPR_ColumnMatrix, "ColumnMatrix", "", fexpr_write_latex_matrix, },
    { FEXPR_CommutativeRings, "CommutativeRings", "", NULL, },
    { FEXPR_ComplexBranchDerivative, "ComplexBranchDerivative", "", fexpr_write_latex_derivative, },
    { FEXPR_ComplexDerivative, "ComplexDerivative", "", fexpr_write_latex_derivative, },
    { FEXPR_ComplexInfinities, "ComplexInfinities", "\\{\\hat{\\infty}, [e^{i \\theta}] \\infty\\}", NULL, },
    { FEXPR_ComplexLimit, "ComplexLimit", "", fexpr_write_latex_limit, },
    { FEXPR_ComplexSignedInfinities, "ComplexSignedInfinities", "\\{[e^{i \\theta}] \\infty\\}", NULL, },
    { FEXPR_ComplexSingularityClosure, "ComplexSingularityClosure", "\\overline{\\mathbb{C}}_{\\text{Sing}}", NULL, },
    { FEXPR_ComplexZeroMultiplicity, "ComplexZeroMultiplicity", "", fexpr_write_latex_residue, },
    { FEXPR_Concatenation, "Concatenation", " \\,^\\frown ", fexpr_write_latex_infix, },
    { FEXPR_CongruentMod, "CongruentMod", "", fexpr_write_latex_logic, },
    { FEXPR_Conjugate, "Conjugate", "", fexpr_write_latex_simple, },
    { FEXPR_ConreyGenerator, "ConreyGenerator", "g", fexpr_write_latex_subscript, },
    { FEXPR_Cos, "Cos", "\\cos", NULL, },
    { FEXPR_CosIntegral, "CosIntegral", "\\operatorname{Ci}", NULL, },
    { FEXPR_Cosh, "Cosh", "\\cosh", NULL, },
    { FEXPR_CoshIntegral, "CoshIntegral", "\\operatorname{Chi}", NULL, },
    { FEXPR_Cot, "Cot", "\\cot", NULL, },
    { FEXPR_Coth, "Coth", "\\coth", NULL, },
    { FEXPR_CoulombC, "CoulombC", "C", fexpr_write_latex_subscript_call, },
    { FEXPR_CoulombF, "CoulombF", "", fexpr_write_latex_misc_special, },
    { FEXPR_CoulombG, "CoulombG", "", fexpr_write_latex_misc_special, },
    { FEXPR_CoulombH, "CoulombH", "", fexpr_write_latex_misc_special, },
    { FEXPR_CoulombSigma, "CoulombSigma", "\\sigma", fexpr_write_latex_subscript_call, },
    { FEXPR_Csc, "Csc", "\\csc", NULL, },
    { FEXPR_Csch, "Csch", "\\operatorname{csch}", NULL, },
    { FEXPR_Csgn, "Csgn", "\\operatorname{csgn}", NULL, },
    { FEXPR_CurvePath, "CurvePath", "", fexpr_write_latex_misc_special, },
    { FEXPR_Cyclotomic, "Cyclotomic", "\\Phi", fexpr_write_latex_subscript_call, },
    { FEXPR_Decimal, "Decimal", "", fexpr_write_latex_decimal, },
    { FEXPR_DedekindEta, "DedekindEta", "\\eta", NULL, },
    { FEXPR_DedekindEtaEpsilon, "DedekindEtaEpsilon", "\\varepsilon", NULL, },
    { FEXPR_DedekindSum, "DedekindSum", "s", NULL, },
    { FEXPR_Def, "Def", "", NULL, },
    { FEXPR_Delta, "Delta", "\\Delta", NULL },
    { FEXPR_Delta_, "Delta_", "\\Delta", fexpr_write_latex_subscript },
    { FEXPR_Derivative, "Derivative", "", fexpr_write_latex_derivative, },
    { FEXPR_Det, "Det", "\\operatorname{det}", NULL, },
    { FEXPR_DiagonalMatrix, "DiagonalMatrix", "", fexpr_write_latex_matrix, },
    { FEXPR_DigammaFunction, "DigammaFunction", "\\psi", fexpr_write_latex_call1_optional_derivative, },
    { FEXPR_DigammaFunctionZero, "DigammaFunctionZero", "x", fexpr_write_latex_subscript, },
    { FEXPR_DirichletCharacter, "DirichletCharacter", "", fexpr_write_latex_misc_special, },
    { FEXPR_DirichletGroup, "DirichletGroup", "G", fexpr_write_latex_subscript, },
    { FEXPR_DirichletL, "DirichletL", "L", NULL, },
    { FEXPR_DirichletLZero, "DirichletLZero", "\\rho", fexpr_write_latex_subscript, },
    { FEXPR_DirichletLambda, "DirichletLambda", "\\Lambda", NULL, },
    { FEXPR_DiscreteLog, "DiscreteLog", "", fexpr_write_latex_misc_special, },
    { FEXPR_Div, "Div", "", fexpr_write_latex_div, },
    { FEXPR_Divides, "Divides", "\\mid", fexpr_write_latex_infix, },
    { FEXPR_DivisorProduct, "DivisorProduct", "", fexpr_write_latex_divsum, },
    { FEXPR_DivisorSigma, "DivisorSigma", "\\sigma", fexpr_write_latex_subscript_call, },
    { FEXPR_DivisorSum, "DivisorSum", "", fexpr_write_latex_divsum, },
    { FEXPR_DoubleFactorial, "DoubleFactorial", "", fexpr_write_latex_factorial, },
    { FEXPR_EisensteinE, "EisensteinE", "E", fexpr_write_latex_subscript_call, },
    { FEXPR_EisensteinG, "EisensteinG", "G", fexpr_write_latex_subscript_call, },
    { FEXPR_Element, "Element", "\\in", fexpr_write_latex_infix, },
    { FEXPR_Ellipsis, "Ellipsis", "\\ldots", NULL, },
    { FEXPR_EllipticE, "EllipticE", "E", NULL, },
    { FEXPR_EllipticK, "EllipticK", "K", NULL, },
    { FEXPR_EllipticPi, "EllipticPi", "\\Pi", NULL, },
    { FEXPR_EllipticRootE, "EllipticRootE", "e", fexpr_write_latex_subscript_call, },
    { FEXPR_Enclosure, "Enclosure", "", fexpr_write_latex_simple },
    { FEXPR_Equal, "Equal", "=", fexpr_write_latex_infix, },
    { FEXPR_EqualAndElement, "EqualAndElement", "", fexpr_write_latex_misc_special, },
    { FEXPR_EqualNearestDecimal, "EqualNearestDecimal", "", fexpr_write_latex_misc_special, },
    { FEXPR_EqualQSeriesEllipsis, "EqualQSeriesEllipsis", "", fexpr_write_latex_misc_special, },
    { FEXPR_Equivalent, "Equivalent", "", fexpr_write_latex_logic, },
    { FEXPR_Erf, "Erf", "\\operatorname{erf}", NULL, },
    { FEXPR_Erfc, "Erfc", "\\operatorname{erfc}", NULL, },
    { FEXPR_Erfi, "Erfi", "\\operatorname{erfi}", NULL, },
    { FEXPR_Euler, "Euler", "\\gamma", NULL, },
    { FEXPR_EulerE, "EulerE", "E", fexpr_write_latex_subscript, },
    { FEXPR_EulerPhi, "EulerPhi", "\\varphi", NULL, },
    { FEXPR_EulerPolynomial, "EulerPolynomial", "E", fexpr_write_latex_subscript_call, },
    { FEXPR_EulerQSeries, "EulerQSeries", "\\phi", NULL, },
    { FEXPR_Exists, "Exists", "", fexpr_write_latex_logic, },
    { FEXPR_Exp, "Exp", "\\exp", fexpr_write_latex_exp, },
    { FEXPR_ExpIntegralE, "ExpIntegralE", "E", fexpr_write_latex_subscript_call, },
    { FEXPR_ExpIntegralEi, "ExpIntegralEi", "\\operatorname{Ei}", NULL, },
    { FEXPR_ExtendedRealNumbers, "ExtendedRealNumbers", "\\overline{\\mathbb{R}}", NULL, },
    { FEXPR_Factorial, "Factorial", "", fexpr_write_latex_factorial, },
    { FEXPR_FallingFactorial, "FallingFactorial", "", fexpr_write_latex_simple2, },
    { FEXPR_False, "False", "\\operatorname{False}", NULL, },
    { FEXPR_Fibonacci, "Fibonacci", "F", fexpr_write_latex_subscript, },
    { FEXPR_Fields, "Fields", "", NULL, },
    { FEXPR_FiniteField, "FiniteField", "", NULL, },
    { FEXPR_Floor, "Floor", "", fexpr_write_latex_simple, },
    { FEXPR_For, "For", "", NULL, },
    { FEXPR_FormalLaurentSeries, "FormalLaurentSeries", "", fexpr_write_latex_alg_structure, },
    { FEXPR_FormalPowerSeries, "FormalPowerSeries", "", fexpr_write_latex_alg_structure, },
    { FEXPR_FormalPuiseuxSeries, "FormalPuiseuxSeries", "", fexpr_write_latex_alg_structure, },
    { FEXPR_FresnelC, "FresnelC", "C", NULL, },
    { FEXPR_FresnelS, "FresnelS", "S", NULL, },
    { FEXPR_Fun, "Fun", "\\mapsto", fexpr_write_latex_infix, },
    { FEXPR_GCD, "GCD", "\\gcd", NULL, },
    { FEXPR_Gamma, "Gamma", "\\Gamma", NULL, },
    { FEXPR_GaussLegendreWeight, "GaussLegendreWeight", "w", fexpr_write_latex_subscript, },
    { FEXPR_GaussSum, "GaussSum", "G", fexpr_write_latex_subscript_call, },
    { FEXPR_GegenbauerC, "GegenbauerC", "", NULL, },
    { FEXPR_GeneralLinearGroup, "GeneralLinearGroup", "\\operatorname{GL}", fexpr_write_latex_subscript_call, },
    { FEXPR_GeneralizedBernoulliB, "GeneralizedBernoulliB", "B", fexpr_write_latex_subscript, },
    { FEXPR_GeneralizedRiemannHypothesis, "GeneralizedRiemannHypothesis", "\\operatorname{GRH}", NULL, },
    { FEXPR_GlaisherConstant, "GlaisherConstant", "A", NULL, },
    { FEXPR_GoldenRatio, "GoldenRatio", "\\varphi", NULL, },
    { FEXPR_Greater, "Greater", ">", fexpr_write_latex_infix, },
    { FEXPR_GreaterEqual, "GreaterEqual", "\\ge", fexpr_write_latex_infix, },
    { FEXPR_GreekGamma, "GreekGamma", "\\Gamma", NULL },
    { FEXPR_GreekGamma_, "GreekGamma_", "\\Gamma", fexpr_write_latex_subscript },
    { FEXPR_GreekPi, "GreekPi", "\\Pi", NULL },
    { FEXPR_GreekPi_, "GreekPi_", "\\Pi", fexpr_write_latex_subscript },
    { FEXPR_Guess, "Guess", "", fexpr_write_latex_simple },
    { FEXPR_HankelH1, "HankelH1", "H^{(1)}", fexpr_write_latex_subscript_call, },
    { FEXPR_HankelH2, "HankelH2", "H^{(2)}", fexpr_write_latex_subscript_call, },
    { FEXPR_HarmonicNumber, "HarmonicNumber", "H", fexpr_write_latex_subscript, },
    { FEXPR_HermiteH, "HermiteH", "H", fexpr_write_latex_subscript_call, },
    { FEXPR_HilbertClassPolynomial, "HilbertClassPolynomial", "H", fexpr_write_latex_subscript_call, },
    { FEXPR_HilbertMatrix, "HilbertMatrix", "H", fexpr_write_latex_subscript, },
    { FEXPR_HurwitzZeta, "HurwitzZeta", "\\zeta", fexpr_write_latex_call2_optional_derivative, },
    { FEXPR_Hypergeometric0F1, "Hypergeometric0F1", "\\,{}_0F_1", NULL, },
    { FEXPR_Hypergeometric0F1Regularized, "Hypergeometric0F1Regularized", "\\,{}_0{\\textbf F}_1", NULL, },
    { FEXPR_Hypergeometric1F1, "Hypergeometric1F1", "\\,{}_1F_1", NULL, },
    { FEXPR_Hypergeometric1F1Regularized, "Hypergeometric1F1Regularized", "\\,{}_1{\\textbf F}_1", NULL, },
    { FEXPR_Hypergeometric1F2, "Hypergeometric1F2", "\\,{}_1F_2", NULL, },
    { FEXPR_Hypergeometric1F2Regularized, "Hypergeometric1F2Regularized", "\\,{}_1{\\textbf F}_2", NULL, },
    { FEXPR_Hypergeometric2F0, "Hypergeometric2F0", "\\,{}_2F_0", NULL, },
    { FEXPR_Hypergeometric2F1, "Hypergeometric2F1", "\\,{}_2F_1", NULL, },
    { FEXPR_Hypergeometric2F1Regularized, "Hypergeometric2F1Regularized", "\\,{}_2{\\textbf F}_1", NULL, },
    { FEXPR_Hypergeometric2F2, "Hypergeometric2F2", "\\,{}_2F_2", NULL, },
    { FEXPR_Hypergeometric2F2Regularized, "Hypergeometric2F2Regularized", "\\,{}_2{\\textbf F}_2", NULL, },
    { FEXPR_Hypergeometric3F2, "Hypergeometric3F2", "\\,{}_3F_2", NULL, },
    { FEXPR_Hypergeometric3F2Regularized, "Hypergeometric3F2Regularized", "\\,{}_3{\\textbf F}_2", NULL, },
    { FEXPR_HypergeometricU, "HypergeometricU", "U", NULL, },
    { FEXPR_HypergeometricUStar, "HypergeometricUStar", "U^{*}", NULL, },
    { FEXPR_HypergeometricUStarRemainder, "HypergeometricUStarRemainder", "R", fexpr_write_latex_subscript_call, },
    { FEXPR_IdentityMatrix, "IdentityMatrix", "I", fexpr_write_latex_subscript, },
    { FEXPR_Im, "Im", "\\operatorname{Im}", NULL, },
    { FEXPR_Implies, "Implies", "", fexpr_write_latex_logic, },
    { FEXPR_IncompleteBeta, "IncompleteBeta", "\\mathrm{B}", fexpr_write_latex_subscript_call, },
    { FEXPR_IncompleteBetaRegularized, "IncompleteBetaRegularized", "I", fexpr_write_latex_subscript_call, },
    { FEXPR_IncompleteEllipticE, "IncompleteEllipticE", "E", NULL, },
    { FEXPR_IncompleteEllipticF, "IncompleteEllipticF", "F", NULL, },
    { FEXPR_IncompleteEllipticPi, "IncompleteEllipticPi", "\\Pi", NULL, },
    { FEXPR_IndefiniteIntegralEqual, "IndefiniteIntegralEqual", "", fexpr_write_latex_misc_special, },
    { FEXPR_Infimum, "Infimum", "", fexpr_write_latex_setop, },
    { FEXPR_Infinity, "Infinity", "\\infty", NULL, },
    { FEXPR_IntegersGreaterEqual, "IntegersGreaterEqual", "", fexpr_write_latex_range, },
    { FEXPR_IntegersLessEqual, "IntegersLessEqual", "", fexpr_write_latex_range, },
    { FEXPR_Integral, "Integral", "", fexpr_write_latex_integral, },
    { FEXPR_Intersection, "Intersection", "\\cap", fexpr_write_latex_infix, },
    { FEXPR_Interval, "Interval", "", fexpr_write_latex_simple2_small, },
    { FEXPR_IsEven, "IsEven", "", fexpr_write_latex_simple, },
    { FEXPR_IsHolomorphicOn, "IsHolomorphicOn", "", fexpr_write_latex_misc_special, },
    { FEXPR_IsMeromorphicOn, "IsMeromorphicOn", "", fexpr_write_latex_misc_special, },
    { FEXPR_IsOdd, "IsOdd", "", fexpr_write_latex_simple, },
    { FEXPR_IsPrime, "IsPrime", "", fexpr_write_latex_simple, },
    { FEXPR_Item, "Item", "", fexpr_write_latex_simple2, },
    { FEXPR_JacobiP, "JacobiP", "", NULL, },
    { FEXPR_JacobiSymbol, "JacobiSymbol", "", fexpr_write_latex_simple2, },
    { FEXPR_JacobiTheta, "JacobiTheta", "\\theta", fexpr_write_latex_sub1_call2_optional_derivative, },
    { FEXPR_JacobiThetaEpsilon, "JacobiThetaEpsilon", "\\varepsilon", fexpr_write_latex_subscript_call, },
    { FEXPR_JacobiThetaPermutation, "JacobiThetaPermutation", "S", fexpr_write_latex_subscript_call, },
    { FEXPR_JacobiThetaQ, "JacobiThetaQ", "\\theta", fexpr_write_latex_sub1_call2_optional_derivative, },
    { FEXPR_KeiperLiLambda, "KeiperLiLambda", "\\lambda", fexpr_write_latex_subscript, },
    { FEXPR_KhinchinConstant, "KhinchinConstant", "K", NULL, },
    { FEXPR_KroneckerDelta, "KroneckerDelta", "", fexpr_write_latex_simple2_small, },
    { FEXPR_KroneckerSymbol, "KroneckerSymbol", "", fexpr_write_latex_simple2, },
    { FEXPR_LCM, "LCM", "\\operatorname{lcm}", NULL, },
    { FEXPR_LaguerreL, "LaguerreL", "", NULL, },
    { FEXPR_LambertW, "LambertW", "W", fexpr_write_latex_misc_special, },
    { FEXPR_Lamda, "Lamda", "\\Lambda", NULL },
    { FEXPR_Lamda_, "Lamda_", "\\Lambda", fexpr_write_latex_subscript },
    { FEXPR_LandauG, "LandauG", "g", NULL, },
    { FEXPR_Lattice, "Lattice", "", fexpr_write_latex_collection },
    { FEXPR_LeftLimit, "LeftLimit", "", fexpr_write_latex_limit, },
    { FEXPR_LegendreP, "LegendreP", "P", fexpr_write_latex_subscript_call, },
    { FEXPR_LegendrePolynomialZero, "LegendrePolynomialZero", "x", fexpr_write_latex_subscript, },
    { FEXPR_LegendreSymbol, "LegendreSymbol", "", fexpr_write_latex_simple2, },
    { FEXPR_Length, "Length", "", fexpr_write_latex_simple, },
    { FEXPR_LerchPhi, "LerchPhi", "\\Phi", NULL, },
    { FEXPR_Less, "Less", "<", fexpr_write_latex_infix, },
    { FEXPR_LessEqual, "LessEqual", "\\le", fexpr_write_latex_infix, },
    { FEXPR_Limit, "Limit", "", fexpr_write_latex_limit, },
    { FEXPR_LiouvilleLambda, "LiouvilleLambda", "\\lambda", NULL, },
    { FEXPR_List, "List", "", fexpr_write_latex_collection, },
    { FEXPR_Log, "Log", "\\log", NULL, },
    { FEXPR_LogBarnesG, "LogBarnesG", "\\log G", NULL, },
    { FEXPR_LogBarnesGRemainder, "LogBarnesGRemainder", "R", fexpr_write_latex_subscript_call, },
    { FEXPR_LogGamma, "LogGamma", "\\log \\Gamma", NULL, },
    { FEXPR_LogIntegral, "LogIntegral", "\\operatorname{li}", NULL, },
    { FEXPR_Logic, "Logic", "", fexpr_write_latex_logic },
    { FEXPR_LowerGamma, "LowerGamma", "\\gamma", NULL, },
    { FEXPR_Matrices, "Matrices", "", fexpr_write_latex_misc_special, },
    { FEXPR_Matrix, "Matrix", "", fexpr_write_latex_matrix, },
    { FEXPR_Matrix2x2, "Matrix2x2", "", fexpr_write_latex_matrix, },
    { FEXPR_Max, "Max", "\\max", NULL, },
    { FEXPR_Maximum, "Maximum", "", fexpr_write_latex_setop, },
    { FEXPR_MeromorphicDerivative, "MeromorphicDerivative", "", fexpr_write_latex_derivative, },
    { FEXPR_MeromorphicLimit, "MeromorphicLimit", "", fexpr_write_latex_limit, },
    { FEXPR_Min, "Min", "\\min", NULL, },
    { FEXPR_Minimum, "Minimum", "", fexpr_write_latex_setop, },
    { FEXPR_Mod, "Mod", "\\bmod", fexpr_write_latex_infix, },
    { FEXPR_ModularGroupAction, "ModularGroupAction", "\\circ", fexpr_write_latex_infix, },
    { FEXPR_ModularGroupFundamentalDomain, "ModularGroupFundamentalDomain", "\\mathcal{F}", NULL, },
    { FEXPR_ModularJ, "ModularJ", "j", NULL, },
    { FEXPR_ModularLambda, "ModularLambda", "\\lambda", NULL, },
    { FEXPR_ModularLambdaFundamentalDomain, "ModularLambdaFundamentalDomain", "\\mathcal{F}_{\\lambda}", NULL, },
    { FEXPR_MoebiusMu, "MoebiusMu", "\\mu", NULL, },
    { FEXPR_Mul, "Mul", "", fexpr_write_latex_mul, },
    { FEXPR_MultiZetaValue, "MultiZetaValue", "\\zeta", NULL, },
    { FEXPR_NN, "NN", "\\mathbb{N}", NULL, },
    { FEXPR_Neg, "Neg", "", fexpr_write_latex_neg_pos, },
    { FEXPR_Not, "Not", "", fexpr_write_latex_logic, },
    { FEXPR_NotElement, "NotElement", "\\notin", fexpr_write_latex_infix, },
    { FEXPR_NotEqual, "NotEqual", "\\ne", fexpr_write_latex_infix, },
    { FEXPR_NumberE, "NumberE", "e", NULL, },
    { FEXPR_NumberI, "NumberI", "i", NULL, },
    { FEXPR_Omega, "Omega", "\\Omega", NULL },
    { FEXPR_Omega_, "Omega_", "\\Omega", fexpr_write_latex_subscript },
    { FEXPR_One, "One", "1", fexpr_write_latex_subscript, },
    { FEXPR_OpenClosedInterval, "OpenClosedInterval", "", fexpr_write_latex_simple2_small, },
    { FEXPR_OpenComplexDisk, "OpenComplexDisk", "D", NULL, },
    { FEXPR_OpenInterval, "OpenInterval", "", fexpr_write_latex_simple2_small, },
    { FEXPR_OpenRealBall, "OpenRealBall", "", fexpr_write_latex_simple2_small, },
    { FEXPR_Or, "Or", "", fexpr_write_latex_logic, },
    { FEXPR_Otherwise, "Otherwise", "", NULL, },
    { FEXPR_PSL2Z, "PSL2Z", "\\operatorname{PSL}_2(\\mathbb{Z})", NULL, },
    { FEXPR_Parentheses, "Parentheses", "", fexpr_write_latex_simple, },
    { FEXPR_PartitionsP, "PartitionsP", "p", NULL, },
    { FEXPR_Path, "Path", "\\rightsquigarrow", fexpr_write_latex_infix, },
    { FEXPR_Phi, "Phi", "\\Phi", NULL },
    { FEXPR_Phi_, "Phi_", "\\Phi", fexpr_write_latex_subscript },
    { FEXPR_Pi, "Pi", "\\pi", NULL, },
    { FEXPR_Pol, "Pol", "", NULL, },
    { FEXPR_Poles, "Poles", "", fexpr_write_latex_setop, },
    { FEXPR_PolyLog, "PolyLog", "\\operatorname{Li}", fexpr_write_latex_subscript_call, },
    { FEXPR_Polynomial, "Polynomial", "", fexpr_write_latex_misc_special, },
    { FEXPR_PolynomialDegree, "PolynomialDegree", "\\deg", NULL, },
    { FEXPR_PolynomialFractions, "PolynomialFractions", "", fexpr_write_latex_alg_structure, },
    { FEXPR_PolynomialRootIndexed, "PolynomialRootIndexed", "", fexpr_write_latex_misc_special, },
    { FEXPR_PolynomialRootNearest, "PolynomialRootNearest", "", fexpr_write_latex_misc_special, },
    { FEXPR_Polynomials, "Polynomials", "", fexpr_write_latex_alg_structure, },
    { FEXPR_Pos, "Pos", "", fexpr_write_latex_neg_pos, },
    { FEXPR_Pow, "Pow", "", fexpr_write_latex_pow, },
    { FEXPR_Prime, "Prime", "p", fexpr_write_latex_subscript, },
    { FEXPR_PrimePi, "PrimePi", "\\pi", NULL, },
    { FEXPR_PrimeProduct, "PrimeProduct", "", fexpr_write_latex_divsum, },
    { FEXPR_PrimeSum, "PrimeSum", "", fexpr_write_latex_divsum, },
    { FEXPR_Primes, "Primes", "\\mathbb{P}", NULL, },
    { FEXPR_PrimitiveDirichletCharacters, "PrimitiveDirichletCharacters", "G^{\\text{Primitive}}", fexpr_write_latex_subscript, },
    { FEXPR_PrimitiveReducedPositiveIntegralBinaryQuadraticForms, "PrimitiveReducedPositiveIntegralBinaryQuadraticForms", "\\mathcal{Q}^{*}", fexpr_write_latex_subscript_call, },
    { FEXPR_Product, "Product", "", fexpr_write_latex_sum_product, },
    { FEXPR_ProjectiveComplexNumbers, "ProjectiveComplexNumbers", "\\hat{\\mathbb{C}}_{\\infty}", NULL, },
    { FEXPR_ProjectiveRealNumbers, "ProjectiveRealNumbers", "\\hat{\\mathbb{R}}_{\\infty}", NULL, },
    { FEXPR_Psi, "Psi", "\\Psi", NULL },
    { FEXPR_Psi_, "Psi_", "\\Psi", fexpr_write_latex_subscript },
    { FEXPR_QQ, "QQ", "\\mathbb{Q}", NULL, },
    { FEXPR_QSeriesCoefficient, "QSeriesCoefficient", "", fexpr_write_latex_misc_special, },
    { FEXPR_QuotientRing, "QuotientRing", "", NULL, },
    { FEXPR_RR, "RR", "\\mathbb{R}", NULL, },
    { FEXPR_Range, "Range", "", fexpr_write_latex_range, },
    { FEXPR_Re, "Re", "\\operatorname{Re}", NULL, },
    { FEXPR_RealAbs, "RealAbs", "", fexpr_write_latex_simple, },
    { FEXPR_RealAlgebraicNumbers, "RealAlgebraicNumbers", "\\overline{\\mathbb{Q}}_{\\mathbb{R}}", NULL, },
    { FEXPR_RealBall, "RealBall", "", fexpr_write_latex_simple2_small, },
    { FEXPR_RealDerivative, "RealDerivative", "", fexpr_write_latex_derivative, },
    { FEXPR_RealInfinities, "RealInfinities", "\\{\\hat{\\infty}, \\pm \\infty\\}", NULL, },
    { FEXPR_RealLimit, "RealLimit", "", fexpr_write_latex_limit, },
    { FEXPR_RealSignedInfinities, "RealSignedInfinities", "\\{\\pm \\infty\\}", NULL, },
    { FEXPR_RealSingularityClosure, "RealSingularityClosure", "\\overline{\\mathbb{R}}_{\\text{Sing}}", NULL, },
    { FEXPR_Repeat, "Repeat", "", fexpr_write_latex_misc_special, },
    { FEXPR_Residue, "Residue", "", fexpr_write_latex_residue, },
    { FEXPR_RiemannHypothesis, "RiemannHypothesis", "\\operatorname{RH}", NULL, },
    { FEXPR_RiemannXi, "RiemannXi", "\\xi", NULL, },
    { FEXPR_RiemannZeta, "RiemannZeta", "\\zeta", fexpr_write_latex_call1_optional_derivative, },
    { FEXPR_RiemannZetaZero, "RiemannZetaZero", "\\rho", fexpr_write_latex_subscript, },
    { FEXPR_RightLimit, "RightLimit", "", fexpr_write_latex_limit, },
    { FEXPR_Rings, "Rings", "", NULL, },
    { FEXPR_RisingFactorial, "RisingFactorial", "", fexpr_write_latex_simple2, },
    { FEXPR_Root, "Root", "", NULL, },
    { FEXPR_RootOfUnity, "RootOfUnity", "\\zeta", fexpr_write_latex_subscript, },
    { FEXPR_Row, "Row", "", NULL, },
    { FEXPR_RowMatrix, "RowMatrix", "", fexpr_write_latex_matrix, },
    { FEXPR_SL2Z, "SL2Z", "\\operatorname{SL}_2(\\mathbb{Z})", NULL, },
    { FEXPR_Same, "Same", "=", fexpr_write_latex_infix, },
    { FEXPR_Sec, "Sec", "\\sec", NULL, },
    { FEXPR_Sech, "Sech", "\\operatorname{sech}", NULL, },
    { FEXPR_SequenceLimit, "SequenceLimit", "", fexpr_write_latex_limit, },
    { FEXPR_SequenceLimitInferior, "SequenceLimitInferior", "", fexpr_write_latex_limit, },
    { FEXPR_SequenceLimitSuperior, "SequenceLimitSuperior", "", fexpr_write_latex_limit, },
    { FEXPR_Ser, "Ser", "", NULL, },
    { FEXPR_Set, "Set", "", fexpr_write_latex_collection, },
    { FEXPR_SetMinus, "SetMinus", "\\setminus", fexpr_write_latex_infix, },
    { FEXPR_Sets, "Sets", "", NULL, },
    { FEXPR_ShowExpandedNormalForm, "ShowExpandedNormalForm", "", fexpr_write_latex_show_form, },
    { FEXPR_Sigma, "Sigma", "\\Sigma", NULL },
    { FEXPR_Sigma_, "Sigma_", "\\Sigma", fexpr_write_latex_subscript },
    { FEXPR_Sign, "Sign", "\\operatorname{sgn}", NULL, },
    { FEXPR_SignExtendedComplexNumbers, "SignExtendedComplexNumbers", "\\overline{\\mathbb{C}}_{[e^{i \\theta}] \\infty}", NULL, },
    { FEXPR_Sin, "Sin", "\\sin", NULL, },
    { FEXPR_SinIntegral, "SinIntegral", "\\operatorname{Si}", NULL, },
    { FEXPR_Sinc, "Sinc", "\\operatorname{sinc}", NULL, },
    { FEXPR_SingularValues, "SingularValues", "\\sigma", NULL, },
    { FEXPR_Sinh, "Sinh", "\\sinh", NULL, },
    { FEXPR_SinhIntegral, "SinhIntegral", "\\operatorname{Shi}", NULL, },
    { FEXPR_SloaneA, "SloaneA", "", fexpr_write_latex_misc_special, },
    { FEXPR_Solutions, "Solutions", "", fexpr_write_latex_setop, },
    { FEXPR_SpecialLinearGroup, "SpecialLinearGroup", "\\operatorname{SL}", fexpr_write_latex_subscript_call, },
    { FEXPR_Spectrum, "Spectrum", "\\operatorname{spec}", NULL, },
    { FEXPR_SphericalHarmonicY, "SphericalHarmonicY", "", NULL, },
    { FEXPR_Sqrt, "Sqrt", "", fexpr_write_latex_simple, },
    { FEXPR_SquaresR, "SquaresR", "r", fexpr_write_latex_subscript_call, },
    { FEXPR_Step, "Step", "", fexpr_write_latex_collection, },
    { FEXPR_StieltjesGamma, "StieltjesGamma", "\\gamma", fexpr_write_latex_subscript_call, },
    { FEXPR_StirlingCycle, "StirlingCycle", "", fexpr_write_latex_simple2, },
    { FEXPR_StirlingS1, "StirlingS1", "", fexpr_write_latex_simple2, },
    { FEXPR_StirlingS2, "StirlingS2", "", fexpr_write_latex_simple2, },
    { FEXPR_StirlingSeriesRemainder, "StirlingSeriesRemainder", "R", fexpr_write_latex_subscript_call, },
    { FEXPR_Sub, "Sub", "", fexpr_write_latex_sub, },
    { FEXPR_Subscript, "Subscript", "", fexpr_write_latex_simple2, },
    { FEXPR_Subset, "Subset", "\\subset", fexpr_write_latex_infix, },
    { FEXPR_SubsetEqual, "SubsetEqual", "\\subseteq", fexpr_write_latex_infix, },
    { FEXPR_Subsets, "Subsets", "\\mathscr{P}", NULL, },
    { FEXPR_Sum, "Sum", "", fexpr_write_latex_sum_product, },
    { FEXPR_Supremum, "Supremum", "", fexpr_write_latex_setop, },
    { FEXPR_SymmetricPolynomial, "SymmetricPolynomial", "e", fexpr_write_latex_subscript_call, },
    { FEXPR_Tan, "Tan", "\\tan", NULL, },
    { FEXPR_Tanh, "Tanh", "\\tanh", NULL, },
    { FEXPR_Theta, "Theta", "\\Theta", NULL },
    { FEXPR_Theta_, "Theta_", "\\Theta", fexpr_write_latex_subscript },
    { FEXPR_True, "True", "\\operatorname{True}", NULL, },
    { FEXPR_Tuple, "Tuple", "", fexpr_write_latex_collection, },
    { FEXPR_Tuples, "Tuples", "", NULL, },
    { FEXPR_Undefined, "Undefined", "\\mathfrak{u}", NULL, },
    { FEXPR_Union, "Union", "\\cup", fexpr_write_latex_infix, },
    { FEXPR_UniqueSolution, "UniqueSolution", "", fexpr_write_latex_setop, },
    { FEXPR_UniqueZero, "UniqueZero", "", fexpr_write_latex_setop, },
    { FEXPR_UnitCircle, "UnitCircle", "\\mathbb{T}", NULL, },
    { FEXPR_Unknown, "Unknown", "\\operatorname{Unknown}", NULL, },
    { FEXPR_UnsignedInfinity, "UnsignedInfinity", "\\hat{\\infty}", NULL, },
    { FEXPR_UpperGamma, "UpperGamma", "\\Gamma", NULL, },
    { FEXPR_UpperHalfPlane, "UpperHalfPlane", "\\mathbb{H}", NULL, },
    { FEXPR_WeierstrassP, "WeierstrassP", "\\wp", NULL, },
    { FEXPR_WeierstrassSigma, "WeierstrassSigma", "\\sigma", NULL, },
    { FEXPR_WeierstrassZeta, "WeierstrassZeta", "\\zeta", NULL, },
    { FEXPR_Where, "Where", "", fexpr_write_latex_where, },
    { FEXPR_XGCD, "XGCD", "\\operatorname{xgcd}", NULL, },
    { FEXPR_XX, "XX", "\\text{x}", fexpr_write_latex_subscript, },
    { FEXPR_Xi, "Xi", "\\Xi", NULL },
    { FEXPR_Xi_, "Xi_", "\\Xi", fexpr_write_latex_subscript },
    { FEXPR_ZZ, "ZZ", "\\mathbb{Z}", NULL, },
    { FEXPR_Zero, "Zero", "0", fexpr_write_latex_subscript, },
    { FEXPR_ZeroMatrix, "ZeroMatrix", "0", fexpr_write_latex_subscript, },
    { FEXPR_Zeros, "Zeros", "", fexpr_write_latex_setop, },
    { FEXPR_alpha, "alpha", "\\alpha", NULL },
    { FEXPR_alpha_, "alpha_", "\\alpha", fexpr_write_latex_subscript },
    { FEXPR_beta, "beta", "\\beta", NULL },
    { FEXPR_beta_, "beta_", "\\beta", fexpr_write_latex_subscript },
    { FEXPR_chi, "chi", "\\chi", NULL },
    { FEXPR_chi_, "chi_", "\\chi", fexpr_write_latex_subscript },
    { FEXPR_delta, "delta", "\\delta", NULL },
    { FEXPR_delta_, "delta_", "\\delta", fexpr_write_latex_subscript },
    { FEXPR_ell, "ell", "\\ell", NULL },
    { FEXPR_ell_, "ell_", "\\ell", fexpr_write_latex_subscript },
    { FEXPR_epsilon, "epsilon", "\\varepsilon", NULL },
    { FEXPR_epsilon_, "epsilon_", "\\varepsilon", fexpr_write_latex_subscript },
    { FEXPR_eta, "eta", "\\eta", NULL },
    { FEXPR_eta_, "eta_", "\\eta", fexpr_write_latex_subscript },
    { FEXPR_gamma, "gamma", "\\gamma", NULL },
    { FEXPR_gamma_, "gamma_", "\\gamma", fexpr_write_latex_subscript },
    { FEXPR_iota, "iota", "\\iota", NULL },
    { FEXPR_iota_, "iota_", "\\iota", fexpr_write_latex_subscript },
    { FEXPR_kappa, "kappa", "\\kappa", NULL },
    { FEXPR_kappa_, "kappa_", "\\kappa", fexpr_write_latex_subscript },
    { FEXPR_lamda, "lamda", "\\lambda", NULL },
    { FEXPR_lamda_, "lamda_", "\\lambda", fexpr_write_latex_subscript },
    { FEXPR_mu, "mu", "\\mu", NULL },
    { FEXPR_mu_, "mu_", "\\mu", fexpr_write_latex_subscript },
    { FEXPR_nu, "nu", "\\nu", NULL },
    { FEXPR_nu_, "nu_", "\\nu", fexpr_write_latex_subscript },
    { FEXPR_omega, "omega", "\\omega", NULL },
    { FEXPR_omega_, "omega_", "\\omega", fexpr_write_latex_subscript },
    { FEXPR_phi, "phi", "\\phi", NULL },
    { FEXPR_phi_, "phi_", "\\phi", fexpr_write_latex_subscript },
    { FEXPR_pi, "pi", "\\pi", NULL },
    { FEXPR_pi_, "pi_", "\\pi", fexpr_write_latex_subscript },
    { FEXPR_rho, "rho", "\\rho", NULL },
    { FEXPR_rho_, "rho_", "\\rho", fexpr_write_latex_subscript },
    { FEXPR_sigma, "sigma", "\\sigma", NULL },
    { FEXPR_sigma_, "sigma_", "\\sigma", fexpr_write_latex_subscript },
    { FEXPR_tau, "tau", "\\tau", NULL },
    { FEXPR_tau_, "tau_", "\\tau", fexpr_write_latex_subscript },
    { FEXPR_theta, "theta", "\\theta", NULL },
    { FEXPR_theta_, "theta_", "\\theta", fexpr_write_latex_subscript },
    { FEXPR_varphi, "varphi", "\\varphi", NULL },
    { FEXPR_varphi_, "varphi_", "\\varphi", fexpr_write_latex_subscript },
    { FEXPR_vartheta, "vartheta", "\\vartheta", NULL },
    { FEXPR_vartheta_, "vartheta_", "\\vartheta", fexpr_write_latex_subscript },
    { FEXPR_xi, "xi", "\\xi", NULL },
    { FEXPR_xi_, "xi_", "\\xi", fexpr_write_latex_subscript },
    { FEXPR_zeta, "zeta", "\\zeta", NULL },
    { FEXPR_zeta_, "zeta_", "\\zeta", fexpr_write_latex_subscript },
};
