package org.basex.qt3ts.app;

import org.basex.tests.bxapi.*;
import org.basex.tests.qt3ts.*;

/**
 * Tests derived from the functx library .
 *
 * @author BaseX Team 2005-15, BSD License
 * @author Leo Woerteler
 */
@SuppressWarnings("all")
public class AppFunctxFunctx extends QT3TestSet {

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddAttributes1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "            declare namespace new = \"http://new\";\n" +
      "            (:~ \n" +
      "               : Adds attributes to XML elements : \n" +
      "               : @author Priscilla Walmsley, Datypic \n" +
      "               : @version 1.0 \n" +
      "               : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html \n" +
      "               : @param $elements the element(s) to which you wish to add the attribute \n" +
      "               : @param $attrNames the name(s) of the attribute(s) to add \n" +
      "               : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "            declare function functx:add-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { \n" +
      "               for $element in $elements return element { node-name($element)} { \n" +
      "                  for $attrName at $seq in $attrNames return                     \n" +
      "                    if ($element/@*[node-name(.) = $attrName]) then () else attribute {$attrName} {$attrValues[$seq]}, $element/@*, $element/node() } \n" +
      "            } ;\n" +
      "            let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> \n" +
      "            return (functx:add-attributes( $in-xml/a, xs:QName('att1'), 1))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a att1=\"1\">x</a>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddAttributes2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "         (:~ \n" +
      "            : Adds attributes to XML elements : \n" +
      "            : @author Priscilla Walmsley, Datypic \n" +
      "            : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html \n" +
      "            : @param $elements the element(s) to which you wish to add the attribute \n" +
      "            : @param $attrNames the name(s) of the attribute(s) to add \n" +
      "            : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { \n" +
      "            for $element in $elements \n" +
      "            return element { node-name($element)} { \n" +
      "               for $attrName at $seq in $attrNames \n" +
      "               return if ($element/@*[node-name(.) = $attrName]) then () else attribute {$attrName} {$attrValues[$seq]}, $element/@*, $element/node() } \n" +
      "         } ;\n" +
      "         let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> \n" +
      "         return (functx:add-attributes( $in-xml/a, (xs:QName('att1'),xs:QName('att2')), (1,2)))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a att1=\"1\" att2=\"2\">x</a>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddAttributes3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "         (:~ \n" +
      "            : Adds attributes to XML elements : \n" +
      "            : @author Priscilla Walmsley, Datypic \n" +
      "            : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html \n" +
      "            : @param $elements the element(s) to which you wish to add the attribute \n" +
      "            : @param $attrNames the name(s) of the attribute(s) to add \n" +
      "            : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { \n" +
      "            for $element in $elements \n" +
      "            return element { node-name($element)} { \n" +
      "               for $attrName at $seq in $attrNames \n" +
      "               return if ($element/@*[node-name(.) = $attrName]) then () else attribute {$attrName} {$attrValues[$seq]}, $element/@*, $element/node() } \n" +
      "         } ;\n" +
      "         let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> \n" +
      "         return (functx:add-attributes( $in-xml/b, (xs:QName('att1'),xs:QName('att2')), (1,2)))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<b att2=\"2\" att1=\"x\">x</b>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddAttributes4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "                    (:~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { \n" +
      "            for $element in $elements return element { node-name($element)} { \n" +
      "               for $attrName at $seq in $attrNames \n" +
      "               return if ($element/@*[node-name(.) = $attrName]) then () else attribute {$attrName} {$attrValues[$seq]}, $element/@*, $element/node() } \n" +
      "         } ;\n" +
      "         let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> \n" +
      "         return (functx:add-attributes( $in-xml/a, xs:QName('new:att1'), 1))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a xmlns:new=\"http://new\" new:att1=\"1\">x</a>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddAttributes5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "                    (:~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { \n" +
      "            for $element in $elements \n" +
      "            return element { node-name($element)} { \n" +
      "               for $attrName at $seq in $attrNames \n" +
      "               return if ($element/@*[node-name(.) = $attrName]) then () else attribute {$attrName} {$attrValues[$seq]}, $element/@*, $element/node() } \n" +
      "            } ;\n" +
      "         let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> \n" +
      "         return (functx:add-attributes( $in-xml/a, QName('http://new','new:att1'), 1))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a xmlns:new=\"http://new\" new:att1=\"1\">x</a>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddAttributesAll() {
    final XQuery query = new XQuery(
      "\n" +
      "         declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "         (:~ \n" +
      "            : Adds attributes to XML elements : \n" +
      "            : @author Priscilla Walmsley, Datypic \n" +
      "            : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-attributes.html \n" +
      "            : @param $elements the element(s) to which you wish to add the attribute \n" +
      "            : @param $attrNames the name(s) of the attribute(s) to add \n" +
      "            : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { \n" +
      "            for $element in $elements \n" +
      "            return element { node-name($element)} { \n" +
      "               for $attrName at $seq in $attrNames \n" +
      "               return if ($element/@*[node-name(.) = $attrName]) then () else attribute {$attrName} {$attrValues[$seq]}, $element/@*, $element/node() } \n" +
      "         } ;\n" +
      "         let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> \n" +
      "         return (functx:add-attributes( $in-xml/a, xs:QName('att1'), 1), \n" +
      "                  functx:add-attributes( $in-xml/a, (xs:QName('att1'),xs:QName('att2')), (1,2)), \n" +
      "                  functx:add-attributes( $in-xml/b, (xs:QName('att1'),xs:QName('att2')), (1,2)), \n" +
      "                  functx:add-attributes( $in-xml/a, xs:QName('new:att1'), 1), \n" +
      "                  functx:add-attributes( $in-xml/a, QName('http://new','new:att1'), 1))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a att1=\"1\">x</a><a att1=\"1\" att2=\"2\">x</a><b att2=\"2\" att1=\"x\">x</b><a xmlns:new=\"http://new\" new:att1=\"1\">x</a><a xmlns:new=\"http://new\" new:att1=\"1\">x</a>", false)
    );
  }

  /**
   * ~ : Adds months to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-months.html : @param $date the date : @param $months the number of months to add ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty ~ : Construct a yearMonthDuration from a number of years and months : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_yearmonthduration.html : @param $years the number of years : @param $months the number of months .
   */
  @org.junit.Test
  public void functxFunctxAddMonths1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Adds months to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-months.html : @param $date the date : @param $months the number of months to add :)\n" +
      "         declare function functx:add-months ( $date as xs:anyAtomicType? , $months as xs:integer ) as xs:date? { xs:date($date) + functx:yearMonthDuration(0,$months) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (:~ : Construct a yearMonthDuration from a number of years and months : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_yearmonthduration.html : @param $years the number of years : @param $months the number of months :)\n" +
      "         declare function functx:yearMonthDuration ( $years as xs:decimal? , $months as xs:integer? ) as xs:yearMonthDuration { (xs:yearMonthDuration('P1M') * functx:if-empty($months,0)) + (xs:yearMonthDuration('P1Y') * functx:if-empty($years,0)) } ;\n" +
      "                    (functx:add-months(xs:date('2004-01-23'),1))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-02-23")
    );
  }

  /**
   * ~ : Adds months to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-months.html : @param $date the date : @param $months the number of months to add ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty ~ : Construct a yearMonthDuration from a number of years and months : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_yearmonthduration.html : @param $years the number of years : @param $months the number of months .
   */
  @org.junit.Test
  public void functxFunctxAddMonths2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Adds months to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-months.html : @param $date the date : @param $months the number of months to add :)\n" +
      "         declare function functx:add-months ( $date as xs:anyAtomicType? , $months as xs:integer ) as xs:date? { xs:date($date) + functx:yearMonthDuration(0,$months) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (:~ : Construct a yearMonthDuration from a number of years and months : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_yearmonthduration.html : @param $years the number of years : @param $months the number of months :)\n" +
      "         declare function functx:yearMonthDuration ( $years as xs:decimal? , $months as xs:integer? ) as xs:yearMonthDuration { (xs:yearMonthDuration('P1M') * functx:if-empty($months,0)) + (xs:yearMonthDuration('P1Y') * functx:if-empty($years,0)) } ;\n" +
      "                    (functx:add-months( xs:dateTime('2005-15-31T12:00:13'),2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2006-02-28")
    );
  }

  /**
   * ~ : Adds months to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-months.html : @param $date the date : @param $months the number of months to add ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty ~ : Construct a yearMonthDuration from a number of years and months : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_yearmonthduration.html : @param $years the number of years : @param $months the number of months .
   */
  @org.junit.Test
  public void functxFunctxAddMonths3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Adds months to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-months.html : @param $date the date : @param $months the number of months to add :)\n" +
      "         declare function functx:add-months ( $date as xs:anyAtomicType? , $months as xs:integer ) as xs:date? { xs:date($date) + functx:yearMonthDuration(0,$months) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (:~ : Construct a yearMonthDuration from a number of years and months : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_yearmonthduration.html : @param $years the number of years : @param $months the number of months :)\n" +
      "         declare function functx:yearMonthDuration ( $years as xs:decimal? , $months as xs:integer? ) as xs:yearMonthDuration { (xs:yearMonthDuration('P1M') * functx:if-empty($months,0)) + (xs:yearMonthDuration('P1Y') * functx:if-empty($years,0)) } ;\n" +
      "                    (functx:add-months('2005-15-31',-3))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2005-09-30")
    );
  }

  /**
   * ~ : Adds months to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-months.html : @param $date the date : @param $months the number of months to add ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty ~ : Construct a yearMonthDuration from a number of years and months : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_yearmonthduration.html : @param $years the number of years : @param $months the number of months .
   */
  @org.junit.Test
  public void functxFunctxAddMonthsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Adds months to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-months.html : @param $date the date : @param $months the number of months to add :)\n" +
      "         declare function functx:add-months ( $date as xs:anyAtomicType? , $months as xs:integer ) as xs:date? { xs:date($date) + functx:yearMonthDuration(0,$months) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (:~ : Construct a yearMonthDuration from a number of years and months : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_yearmonthduration.html : @param $years the number of years : @param $months the number of months :)\n" +
      "         declare function functx:yearMonthDuration ( $years as xs:decimal? , $months as xs:integer? ) as xs:yearMonthDuration { (xs:yearMonthDuration('P1M') * functx:if-empty($months,0)) + (xs:yearMonthDuration('P1Y') * functx:if-empty($years,0)) } ;\n" +
      "                    (functx:add-months(xs:date('2004-01-23'),1), functx:add-months( xs:dateTime('2005-15-31T12:00:13'),2), functx:add-months('2005-15-31',-3))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-02-23 2006-02-28 2005-09-30")
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddOrUpdateAttributes1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "                    (:~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-or-update-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { for $element in $elements return element { node-name($element)} { for $attrName at $seq in $attrNames return attribute {$attrName} {$attrValues[$seq]}, $element/@*[not(node-name(.) = $attrNames)], $element/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> return (functx:add-or-update-attributes( $in-xml/a, xs:QName('att1'), 1))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a att1=\"1\">x</a>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddOrUpdateAttributes2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "                    (:~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-or-update-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { for $element in $elements return element { node-name($element)} { for $attrName at $seq in $attrNames return attribute {$attrName} {$attrValues[$seq]}, $element/@*[not(node-name(.) = $attrNames)], $element/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> return (functx:add-or-update-attributes( $in-xml/a, (xs:QName('att1'),xs:QName('att2')), (1,2)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a att1=\"1\" att2=\"2\">x</a>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddOrUpdateAttributes3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "                    (:~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-or-update-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { for $element in $elements return element { node-name($element)} { for $attrName at $seq in $attrNames return attribute {$attrName} {$attrValues[$seq]}, $element/@*[not(node-name(.) = $attrNames)], $element/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> return (functx:add-or-update-attributes( $in-xml/b, (xs:QName('att1'),xs:QName('att2')), (1,2)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<b att1=\"1\" att2=\"2\">x</b>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddOrUpdateAttributes4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "                    (:~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-or-update-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { for $element in $elements return element { node-name($element)} { for $attrName at $seq in $attrNames return attribute {$attrName} {$attrValues[$seq]}, $element/@*[not(node-name(.) = $attrNames)], $element/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> return (functx:add-or-update-attributes( $in-xml/a, xs:QName('new:att1'), 1))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a xmlns:new=\"http://new\" new:att1=\"1\">x</a>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddOrUpdateAttributes5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "                    (:~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-or-update-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { for $element in $elements return element { node-name($element)} { for $attrName at $seq in $attrNames return attribute {$attrName} {$attrValues[$seq]}, $element/@*[not(node-name(.) = $attrNames)], $element/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> return (functx:add-or-update-attributes( $in-xml/a, QName('http://new','new:att1'), 1))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a xmlns:new=\"http://new\" new:att1=\"1\">x</a>", false)
    );
  }

  /**
   * ~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add .
   */
  @org.junit.Test
  public void functxFunctxAddOrUpdateAttributesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace new = \"http://new\";\n" +
      "                    (:~ : Adds attributes to XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_add-or-update-attributes.html : @param $elements the element(s) to which you wish to add the attribute : @param $attrNames the name(s) of the attribute(s) to add : @param $attrValues the value(s) of the attribute(s) to add :)\n" +
      "         declare function functx:add-or-update-attributes ( $elements as element()* , $attrNames as xs:QName* , $attrValues as xs:anyAtomicType* ) as element()? { for $element in $elements return element { node-name($element)} { for $attrName at $seq in $attrNames return attribute {$attrName} {$attrValues[$seq]}, $element/@*[not(node-name(.) = $attrNames)], $element/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>x</a> <b att1=\"x\">x</b> </in-xml> return (functx:add-or-update-attributes( $in-xml/a, xs:QName('att1'), 1), functx:add-or-update-attributes( $in-xml/a, (xs:QName('att1'),xs:QName('att2')), (1,2)), functx:add-or-update-attributes( $in-xml/b, (xs:QName('att1'),xs:QName('att2')), (1,2)), functx:add-or-update-attributes( $in-xml/a, xs:QName('new:att1'), 1), functx:add-or-update-attributes( $in-xml/a, QName('http://new','new:att1'), 1))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a att1=\"1\">x</a><a att1=\"1\" att2=\"2\">x</a><b att1=\"1\" att2=\"2\">x</b><a xmlns:new=\"http://new\" new:att1=\"1\">x</a><a xmlns:new=\"http://new\" new:att1=\"1\">x</a>", false)
    );
  }

  /**
   * ~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test .
   */
  @org.junit.Test
  public void functxFunctxAllWhitespace1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test :)\n" +
      "         declare function functx:all-whitespace ( $arg as xs:string? ) as xs:boolean { normalize-space($arg) = '' } ;\n" +
      "                    let $in-xml := <in-xml> <a> </a> <b>x </b> <c> <x>x</x> </c> </in-xml> return (functx:all-whitespace(' '))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test .
   */
  @org.junit.Test
  public void functxFunctxAllWhitespace2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test :)\n" +
      "         declare function functx:all-whitespace ( $arg as xs:string? ) as xs:boolean { normalize-space($arg) = '' } ;\n" +
      "                    let $in-xml := <in-xml> <a> </a> <b>x </b> <c> <x>x</x> </c> </in-xml> return (functx:all-whitespace(' x '))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test .
   */
  @org.junit.Test
  public void functxFunctxAllWhitespace3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test :)\n" +
      "         declare function functx:all-whitespace ( $arg as xs:string? ) as xs:boolean { normalize-space($arg) = '' } ;\n" +
      "                    let $in-xml := <in-xml> <a> </a> <b>x </b> <c> <x>x</x> </c> </in-xml> return (functx:all-whitespace($in-xml/a))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test .
   */
  @org.junit.Test
  public void functxFunctxAllWhitespace4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test :)\n" +
      "         declare function functx:all-whitespace ( $arg as xs:string? ) as xs:boolean { normalize-space($arg) = '' } ;\n" +
      "                    let $in-xml := <in-xml> <a> </a> <b>x </b> <c> <x>x</x> </c> </in-xml> return (functx:all-whitespace($in-xml/b))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test .
   */
  @org.junit.Test
  public void functxFunctxAllWhitespace5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test :)\n" +
      "         declare function functx:all-whitespace ( $arg as xs:string? ) as xs:boolean { normalize-space($arg) = '' } ;\n" +
      "                    let $in-xml := <in-xml> <a> </a> <b>x </b> <c> <x>x</x> </c> </in-xml> return (functx:all-whitespace($in-xml/c))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test .
   */
  @org.junit.Test
  public void functxFunctxAllWhitespace6() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test :)\n" +
      "         declare function functx:all-whitespace ( $arg as xs:string? ) as xs:boolean { normalize-space($arg) = '' } ;\n" +
      "                    let $in-xml := <in-xml> <a> </a> <b>x </b> <c> <x>x</x> </c> </in-xml> return (functx:all-whitespace($in-xml/c/text()[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test .
   */
  @org.junit.Test
  public void functxFunctxAllWhitespaceAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is all whitespace or a zero-length string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_all-whitespace.html : @param $arg the string (or node) to test :)\n" +
      "         declare function functx:all-whitespace ( $arg as xs:string? ) as xs:boolean { normalize-space($arg) = '' } ;\n" +
      "                    let $in-xml := <in-xml> <a> </a> <b>x </b> <c> <x>x</x> </c> </in-xml> return (functx:all-whitespace(' '), functx:all-whitespace(' x '), functx:all-whitespace($in-xml/a), functx:all-whitespace($in-xml/b), functx:all-whitespace($in-xml/c), functx:all-whitespace($in-xml/c/text()[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false true false false true")
    );
  }

  /**
   * ~ : Whether all the values in a sequence are distinct : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_are-distinct-values.html : @param $seq the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxAreDistinctValues1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether all the values in a sequence are distinct : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_are-distinct-values.html : @param $seq the sequence of values :)\n" +
      "         declare function functx:are-distinct-values ( $seq as xs:anyAtomicType* ) as xs:boolean { count(distinct-values($seq)) = count($seq) } ;\n" +
      "                    (functx:are-distinct-values( (1,2,1,3)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether all the values in a sequence are distinct : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_are-distinct-values.html : @param $seq the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxAreDistinctValues2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether all the values in a sequence are distinct : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_are-distinct-values.html : @param $seq the sequence of values :)\n" +
      "         declare function functx:are-distinct-values ( $seq as xs:anyAtomicType* ) as xs:boolean { count(distinct-values($seq)) = count($seq) } ;\n" +
      "                    (functx:are-distinct-values( (1,2,1,3,2.0)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether all the values in a sequence are distinct : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_are-distinct-values.html : @param $seq the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxAreDistinctValues3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether all the values in a sequence are distinct : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_are-distinct-values.html : @param $seq the sequence of values :)\n" +
      "         declare function functx:are-distinct-values ( $seq as xs:anyAtomicType* ) as xs:boolean { count(distinct-values($seq)) = count($seq) } ;\n" +
      "                    (functx:are-distinct-values( (1,2,3) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether all the values in a sequence are distinct : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_are-distinct-values.html : @param $seq the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxAreDistinctValuesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether all the values in a sequence are distinct : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_are-distinct-values.html : @param $seq the sequence of values :)\n" +
      "         declare function functx:are-distinct-values ( $seq as xs:anyAtomicType* ) as xs:boolean { count(distinct-values($seq)) = count($seq) } ;\n" +
      "                    (functx:are-distinct-values( (1,2,1,3)), functx:are-distinct-values( (1,2,1,3,2.0)), functx:are-distinct-values( (1,2,3) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "false false true")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxAtomicType1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (functx:atomic-type(2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xs:integer")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxAtomicType2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (functx:atomic-type('abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xs:string")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxAtomicType3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (functx:atomic-type(xs:date('2005-15-15')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xs:date")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxAtomicType4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (functx:atomic-type( (2,'abc',xs:date('2005-15-15'))))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xs:integer xs:string xs:date")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxAtomicTypeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (functx:atomic-type(2), functx:atomic-type('abc'), functx:atomic-type(xs:date('2005-15-15')), functx:atomic-type( (2,'abc',xs:date('2005-15-15'))))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xs:integer xs:string xs:date xs:integer xs:string xs:date")
    );
  }

  /**
   * ~ : The average, counting "empty" values as zero : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_avg-empty-is-zero.html : @param $values the values to be averaged : @param $allNodes the sequence of all nodes to find the average over .
   */
  @org.junit.Test
  public void functxFunctxAvgEmptyIsZero1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The average, counting \"empty\" values as zero : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_avg-empty-is-zero.html : @param $values the values to be averaged : @param $allNodes the sequence of all nodes to find the average over :)\n" +
      "         declare function functx:avg-empty-is-zero ( $values as xs:anyAtomicType* , $allNodes as node()* ) as xs:double { if (empty($allNodes)) then 0 else sum($values[string(.) != '']) div count($allNodes) } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"69.99\"/> <price value=\"49.99\" discount=\"\"/> </prices> return (functx:avg-empty-is-zero( $in-xml//price/@discount, $in-xml//price))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("4")
    );
  }

  /**
   * ~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenExclusive1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-exclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value > $minValue and $value < $maxValue } ;\n" +
      "                    (functx:between-exclusive(55, 1, 1000))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenExclusive2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-exclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value > $minValue and $value < $maxValue } ;\n" +
      "                    (functx:between-exclusive(1, 1, 1000))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenExclusive3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-exclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value > $minValue and $value < $maxValue } ;\n" +
      "                    (functx:between-exclusive(1200, 1, 1000))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenExclusive4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-exclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value > $minValue and $value < $maxValue } ;\n" +
      "                    (functx:between-exclusive('b', 'a', 'c'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenExclusive5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-exclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value > $minValue and $value < $maxValue } ;\n" +
      "                    (functx:between-exclusive(xs:date('2004-10-31'), xs:date('2004-10-15'), xs:date('2004-11-01')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenExclusiveAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-exclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-exclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value > $minValue and $value < $maxValue } ;\n" +
      "                    (functx:between-exclusive(55, 1, 1000), functx:between-exclusive(1, 1, 1000), functx:between-exclusive(1200, 1, 1000), functx:between-exclusive('b', 'a', 'c'), functx:between-exclusive(xs:date('2004-10-31'), xs:date('2004-10-15'), xs:date('2004-11-01')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false false true true")
    );
  }

  /**
   * ~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenInclusive1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-inclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value >= $minValue and $value <= $maxValue } ;\n" +
      "                    (functx:between-inclusive(55, 1, 1000))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenInclusive2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-inclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value >= $minValue and $value <= $maxValue } ;\n" +
      "                    (functx:between-inclusive(1, 1, 1000))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenInclusive3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-inclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value >= $minValue and $value <= $maxValue } ;\n" +
      "                    (functx:between-inclusive(1200, 1, 1000))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenInclusive4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-inclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value >= $minValue and $value <= $maxValue } ;\n" +
      "                    (functx:between-inclusive('b', 'b', 'd'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenInclusive5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-inclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value >= $minValue and $value <= $maxValue } ;\n" +
      "                    (functx:between-inclusive(xs:date('2004-10-31'), xs:date('2004-10-15'), xs:date('2004-11-01')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value .
   */
  @org.junit.Test
  public void functxFunctxBetweenInclusiveAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is between two provided values, or equal to one of them : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_between-inclusive.html : @param $value the value to be tested : @param $minValue the minimum value : @param $maxValue the maximum value :)\n" +
      "         declare function functx:between-inclusive ( $value as xs:anyAtomicType? , $minValue as xs:anyAtomicType , $maxValue as xs:anyAtomicType ) as xs:boolean { $value >= $minValue and $value <= $maxValue } ;\n" +
      "                    (functx:between-inclusive(55, 1, 1000), functx:between-inclusive(1, 1, 1000), functx:between-inclusive(1200, 1, 1000), functx:between-inclusive('b', 'b', 'd'), functx:between-inclusive(xs:date('2004-10-31'), xs:date('2004-10-15'), xs:date('2004-11-01')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true false true true")
    );
  }

  /**
   * ~ : Turns a camelCase string into space-separated words : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_camel-case-to-words.html : @param $arg the string to modify : @param $delim the delimiter for the words (e.g. a space) .
   */
  @org.junit.Test
  public void functxFunctxCamelCaseToWords1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Turns a camelCase string into space-separated words : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_camel-case-to-words.html : @param $arg the string to modify : @param $delim the delimiter for the words (e.g. a space) :)\n" +
      "         declare function functx:camel-case-to-words ( $arg as xs:string? , $delim as xs:string ) as xs:string { concat(substring($arg,1,1), replace(substring($arg,2),'(\\p{Lu})', concat($delim, '$1'))) } ;\n" +
      "                    (functx:camel-case-to-words( 'thisIsACamelCaseTerm',' '))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "this Is A Camel Case Term")
    );
  }

  /**
   * ~ : Turns a camelCase string into space-separated words : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_camel-case-to-words.html : @param $arg the string to modify : @param $delim the delimiter for the words (e.g. a space) .
   */
  @org.junit.Test
  public void functxFunctxCamelCaseToWords2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Turns a camelCase string into space-separated words : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_camel-case-to-words.html : @param $arg the string to modify : @param $delim the delimiter for the words (e.g. a space) :)\n" +
      "         declare function functx:camel-case-to-words ( $arg as xs:string? , $delim as xs:string ) as xs:string { concat(substring($arg,1,1), replace(substring($arg,2),'(\\p{Lu})', concat($delim, '$1'))) } ;\n" +
      "                    (functx:camel-case-to-words( 'thisIsACamelCaseTerm',','))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "this,Is,A,Camel,Case,Term")
    );
  }

  /**
   * ~ : Turns a camelCase string into space-separated words : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_camel-case-to-words.html : @param $arg the string to modify : @param $delim the delimiter for the words (e.g. a space) .
   */
  @org.junit.Test
  public void functxFunctxCamelCaseToWordsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Turns a camelCase string into space-separated words : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_camel-case-to-words.html : @param $arg the string to modify : @param $delim the delimiter for the words (e.g. a space) :)\n" +
      "         declare function functx:camel-case-to-words ( $arg as xs:string? , $delim as xs:string ) as xs:string { concat(substring($arg,1,1), replace(substring($arg,2),'(\\p{Lu})', concat($delim, '$1'))) } ;\n" +
      "                    (functx:camel-case-to-words( 'thisIsACamelCaseTerm',' '), functx:camel-case-to-words( 'thisIsACamelCaseTerm',','))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "this Is A Camel Case Term this,Is,A,Camel,Case,Term")
    );
  }

  /**
   * ~ : Capitalizes the first character of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_capitalize-first.html : @param $arg the word or phrase to capitalize .
   */
  @org.junit.Test
  public void functxFunctxCapitalizeFirst1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Capitalizes the first character of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_capitalize-first.html : @param $arg the word or phrase to capitalize :)\n" +
      "         declare function functx:capitalize-first ( $arg as xs:string? ) as xs:string? { concat(upper-case(substring($arg,1,1)), substring($arg,2)) } ;\n" +
      "                    (functx:capitalize-first('hello'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Hello")
    );
  }

  /**
   * ~ : Capitalizes the first character of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_capitalize-first.html : @param $arg the word or phrase to capitalize .
   */
  @org.junit.Test
  public void functxFunctxCapitalizeFirst2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Capitalizes the first character of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_capitalize-first.html : @param $arg the word or phrase to capitalize :)\n" +
      "         declare function functx:capitalize-first ( $arg as xs:string? ) as xs:string? { concat(upper-case(substring($arg,1,1)), substring($arg,2)) } ;\n" +
      "                    (functx:capitalize-first('hello world'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Hello world")
    );
  }

  /**
   * ~ : Capitalizes the first character of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_capitalize-first.html : @param $arg the word or phrase to capitalize .
   */
  @org.junit.Test
  public void functxFunctxCapitalizeFirst3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Capitalizes the first character of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_capitalize-first.html : @param $arg the word or phrase to capitalize :)\n" +
      "         declare function functx:capitalize-first ( $arg as xs:string? ) as xs:string? { concat(upper-case(substring($arg,1,1)), substring($arg,2)) } ;\n" +
      "                    (functx:capitalize-first('Hello world'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Hello world")
    );
  }

  /**
   * ~ : Capitalizes the first character of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_capitalize-first.html : @param $arg the word or phrase to capitalize .
   */
  @org.junit.Test
  public void functxFunctxCapitalizeFirstAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Capitalizes the first character of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_capitalize-first.html : @param $arg the word or phrase to capitalize :)\n" +
      "         declare function functx:capitalize-first ( $arg as xs:string? ) as xs:string? { concat(upper-case(substring($arg,1,1)), substring($arg,2)) } ;\n" +
      "                    (functx:capitalize-first('hello'), functx:capitalize-first('hello world'), functx:capitalize-first('Hello world'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Hello Hello world Hello world")
    );
  }

  /**
   * ~ : Changes the names of elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-names-deep.html : @param $nodes the element(s) to change : @param $oldNames the sequence of names to change from : @param $newNames the sequence of names to change to ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNamesDeep1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace dty = \"http://datypic.com\";\n" +
      "                    (:~ : Changes the names of elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-names-deep.html : @param $nodes the element(s) to change : @param $oldNames the sequence of names to change from : @param $newNames the sequence of names to change to :)\n" +
      "         declare function functx:change-element-names-deep ( $nodes as node()* , $oldNames as xs:QName* , $newNames as xs:QName* ) as node()* { if (count($oldNames) != count($newNames)) then error(xs:QName('functx:Different_number_of_names')) else for $node in $nodes return if ($node instance of element()) then element {functx:if-empty ($newNames[index-of($oldNames, node-name($node))], node-name($node)) } {$node/@*, functx:change-element-names-deep($node/node(), $oldNames, $newNames)} else if ($node instance of document-node()) then functx:change-element-names-deep($node/node(), $oldNames, $newNames) else $node } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b</b> <c>c</c> </a> </in-xml> return let $in-xml-2 := <in-xml xmlns:dty=\"http://datypic.com\"> <a> <dty:b>b</dty:b> <c>c</c> </a> </in-xml> return (functx:change-element-names-deep( $in-xml-1, xs:QName('b'), xs:QName('y')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a><y>b</y><c>c</c></a></in-xml>", false)
    );
  }

  /**
   * ~ : Changes the names of elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-names-deep.html : @param $nodes the element(s) to change : @param $oldNames the sequence of names to change from : @param $newNames the sequence of names to change to ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNamesDeep2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace dty = \"http://datypic.com\";\n" +
      "                    (:~ : Changes the names of elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-names-deep.html : @param $nodes the element(s) to change : @param $oldNames the sequence of names to change from : @param $newNames the sequence of names to change to :)\n" +
      "         declare function functx:change-element-names-deep ( $nodes as node()* , $oldNames as xs:QName* , $newNames as xs:QName* ) as node()* { if (count($oldNames) != count($newNames)) then error(xs:QName('functx:Different_number_of_names')) else for $node in $nodes return if ($node instance of element()) then element {functx:if-empty ($newNames[index-of($oldNames, node-name($node))], node-name($node)) } {$node/@*, functx:change-element-names-deep($node/node(), $oldNames, $newNames)} else if ($node instance of document-node()) then functx:change-element-names-deep($node/node(), $oldNames, $newNames) else $node } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b</b> <c>c</c> </a> </in-xml> return let $in-xml-2 := <in-xml xmlns:dty=\"http://datypic.com\"> <a> <dty:b>b</dty:b> <c>c</c> </a> </in-xml> return (functx:change-element-names-deep( $in-xml-1, (xs:QName('a'), xs:QName('b'),xs:QName('c')), (xs:QName('x'), xs:QName('y'),xs:QName('z'))))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><x><y>b</y><z>c</z></x></in-xml>", false)
    );
  }

  /**
   * ~ : Changes the names of elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-names-deep.html : @param $nodes the element(s) to change : @param $oldNames the sequence of names to change from : @param $newNames the sequence of names to change to ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNamesDeep3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace dty = \"http://datypic.com\";\n" +
      "                    (:~ : Changes the names of elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-names-deep.html : @param $nodes the element(s) to change : @param $oldNames the sequence of names to change from : @param $newNames the sequence of names to change to :)\n" +
      "         declare function functx:change-element-names-deep ( $nodes as node()* , $oldNames as xs:QName* , $newNames as xs:QName* ) as node()* { if (count($oldNames) != count($newNames)) then error(xs:QName('functx:Different_number_of_names')) else for $node in $nodes return if ($node instance of element()) then element {functx:if-empty ($newNames[index-of($oldNames, node-name($node))], node-name($node)) } {$node/@*, functx:change-element-names-deep($node/node(), $oldNames, $newNames)} else if ($node instance of document-node()) then functx:change-element-names-deep($node/node(), $oldNames, $newNames) else $node } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b</b> <c>c</c> </a> </in-xml> return let $in-xml-2 := <in-xml xmlns:dty=\"http://datypic.com\"> <a> <dty:b>b</dty:b> <c>c</c> </a> </in-xml> return (functx:change-element-names-deep( $in-xml-2, (xs:QName('dty:b'),xs:QName('c')), (xs:QName('q'), QName('http://new','new:c'))))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a><q>b</q><new:c xmlns:new=\"http://new\">c</new:c></a></in-xml>", false)
    );
  }

  /**
   * ~ : Changes the names of elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-names-deep.html : @param $nodes the element(s) to change : @param $oldNames the sequence of names to change from : @param $newNames the sequence of names to change to ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNamesDeepAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare namespace dty = \"http://datypic.com\";\n" +
      "                    (:~ : Changes the names of elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-names-deep.html : @param $nodes the element(s) to change : @param $oldNames the sequence of names to change from : @param $newNames the sequence of names to change to :)\n" +
      "         declare function functx:change-element-names-deep ( $nodes as node()* , $oldNames as xs:QName* , $newNames as xs:QName* ) as node()* { if (count($oldNames) != count($newNames)) then error(xs:QName('functx:Different_number_of_names')) else for $node in $nodes return if ($node instance of element()) then element {functx:if-empty ($newNames[index-of($oldNames, node-name($node))], node-name($node)) } {$node/@*, functx:change-element-names-deep($node/node(), $oldNames, $newNames)} else if ($node instance of document-node()) then functx:change-element-names-deep($node/node(), $oldNames, $newNames) else $node } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b</b> <c>c</c> </a> </in-xml> return let $in-xml-2 := <in-xml xmlns:dty=\"http://datypic.com\"> <a> <dty:b>b</dty:b> <c>c</c> </a> </in-xml> return (functx:change-element-names-deep( $in-xml-1, xs:QName('b'), xs:QName('y')), functx:change-element-names-deep( $in-xml-1, (xs:QName('a'), xs:QName('b'),xs:QName('c')), (xs:QName('x'), xs:QName('y'),xs:QName('z'))), functx:change-element-names-deep( $in-xml-2, (xs:QName('dty:b'),xs:QName('c')), (xs:QName('q'), QName('http://new','new:c'))))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a><y>b</y><c>c</c></a></in-xml><in-xml><x><y>b</y><z>c</z></x></in-xml><in-xml><a><q>b</q><new:c xmlns:new=\"http://new\">c</new:c></a></in-xml>", false)
    );
  }

  /**
   * ~ : Changes the namespace of XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns.html : @param $elements the elements to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNs1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Changes the namespace of XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns.html : @param $elements the elements to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace :)\n" +
      "         declare function functx:change-element-ns ( $elements as element()* , $newns as xs:string , $prefix as xs:string ) as element()? { for $element in $elements return element {QName ($newns, concat($prefix, if ($prefix = '') then '' else ':', local-name($element)))} {$element/@*, $element/node()} } ;\n" +
      "                    let $in-xml := <bar:a xmlns:bar=\"http://bar\"> <bar:b>557</bar:b> <bar:c>xyz</bar:c> </bar:a> return (functx:change-element-ns( $in-xml, 'http://foo',''))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a xmlns=\"http://foo\"><bar:b xmlns:bar=\"http://bar\">557</bar:b><bar:c xmlns:bar=\"http://bar\">xyz</bar:c></a>", false)
    );
  }

  /**
   * ~ : Changes the namespace of XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns.html : @param $elements the elements to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNs2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Changes the namespace of XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns.html : @param $elements the elements to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace :)\n" +
      "         declare function functx:change-element-ns ( $elements as element()* , $newns as xs:string , $prefix as xs:string ) as element()? { for $element in $elements return element {QName ($newns, concat($prefix, if ($prefix = '') then '' else ':', local-name($element)))} {$element/@*, $element/node()} } ;\n" +
      "                    let $in-xml := <bar:a xmlns:bar=\"http://bar\"> <bar:b>557</bar:b> <bar:c>xyz</bar:c> </bar:a> return (functx:change-element-ns( $in-xml, 'http://foo','foo'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<foo:a xmlns:foo=\"http://foo\"><bar:b xmlns:bar=\"http://bar\">557</bar:b><bar:c xmlns:bar=\"http://bar\">xyz</bar:c></foo:a>", false)
    );
  }

  /**
   * ~ : Changes the namespace of XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns.html : @param $elements the elements to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Changes the namespace of XML elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns.html : @param $elements the elements to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace :)\n" +
      "         declare function functx:change-element-ns ( $elements as element()* , $newns as xs:string , $prefix as xs:string ) as element()? { for $element in $elements return element {QName ($newns, concat($prefix, if ($prefix = '') then '' else ':', local-name($element)))} {$element/@*, $element/node()} } ;\n" +
      "                    let $in-xml := <bar:a xmlns:bar=\"http://bar\"> <bar:b>557</bar:b> <bar:c>xyz</bar:c> </bar:a> return (functx:change-element-ns( $in-xml, 'http://foo',''), functx:change-element-ns( $in-xml, 'http://foo','foo'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a xmlns=\"http://foo\"><bar:b xmlns:bar=\"http://bar\">557</bar:b><bar:c xmlns:bar=\"http://bar\">xyz</bar:c></a><foo:a xmlns:foo=\"http://foo\"><bar:b xmlns:bar=\"http://bar\">557</bar:b><bar:c xmlns:bar=\"http://bar\">xyz</bar:c></foo:a>", false)
    );
  }

  /**
   * ~ : Changes the namespace of XML elements and its descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns-deep.html : @param $nodes the nodes to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNsDeep1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Changes the namespace of XML elements and its descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns-deep.html : @param $nodes the nodes to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace :)\n" +
      "         declare function functx:change-element-ns-deep ( $nodes as node()* , $newns as xs:string , $prefix as xs:string ) as node()* { for $node in $nodes return if ($node instance of element()) then (element {QName ($newns, concat($prefix, if ($prefix = '') then '' else ':', local-name($node)))} {$node/@*, functx:change-element-ns-deep($node/node(), $newns, $prefix)}) else if ($node instance of document-node()) then functx:change-element-ns-deep($node/node(), $newns, $prefix) else $node } ;\n" +
      "                    let $in-xml := <bar:a xmlns:bar=\"http://bar\"> <bar:b>557</bar:b> <bar:c>xyz</bar:c> </bar:a> return (functx:change-element-ns-deep( $in-xml, 'http://foo',''))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a xmlns=\"http://foo\"><b>557</b><c>xyz</c></a>", false)
    );
  }

  /**
   * ~ : Changes the namespace of XML elements and its descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns-deep.html : @param $nodes the nodes to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNsDeep2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Changes the namespace of XML elements and its descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns-deep.html : @param $nodes the nodes to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace :)\n" +
      "         declare function functx:change-element-ns-deep ( $nodes as node()* , $newns as xs:string , $prefix as xs:string ) as node()* { for $node in $nodes return if ($node instance of element()) then (element {QName ($newns, concat($prefix, if ($prefix = '') then '' else ':', local-name($node)))} {$node/@*, functx:change-element-ns-deep($node/node(), $newns, $prefix)}) else if ($node instance of document-node()) then functx:change-element-ns-deep($node/node(), $newns, $prefix) else $node } ;\n" +
      "                    let $in-xml := <bar:a xmlns:bar=\"http://bar\"> <bar:b>557</bar:b> <bar:c>xyz</bar:c> </bar:a> return (functx:change-element-ns-deep( $in-xml, 'http://foo','foo'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<foo:a xmlns:foo=\"http://foo\"><foo:b>557</foo:b><foo:c>xyz</foo:c></foo:a>", false)
    );
  }

  /**
   * ~ : Changes the namespace of XML elements and its descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns-deep.html : @param $nodes the nodes to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace .
   */
  @org.junit.Test
  public void functxFunctxChangeElementNsDeepAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Changes the namespace of XML elements and its descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_change-element-ns-deep.html : @param $nodes the nodes to change : @param $newns the new namespace : @param $prefix the prefix to use for the new namespace :)\n" +
      "         declare function functx:change-element-ns-deep ( $nodes as node()* , $newns as xs:string , $prefix as xs:string ) as node()* { for $node in $nodes return if ($node instance of element()) then (element {QName ($newns, concat($prefix, if ($prefix = '') then '' else ':', local-name($node)))} {$node/@*, functx:change-element-ns-deep($node/node(), $newns, $prefix)}) else if ($node instance of document-node()) then functx:change-element-ns-deep($node/node(), $newns, $prefix) else $node } ;\n" +
      "                    let $in-xml := <bar:a xmlns:bar=\"http://bar\"> <bar:b>557</bar:b> <bar:c>xyz</bar:c> </bar:a> return (functx:change-element-ns-deep( $in-xml, 'http://foo',''), functx:change-element-ns-deep( $in-xml, 'http://foo','foo'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a xmlns=\"http://foo\"><b>557</b><c>xyz</c></a><foo:a xmlns:foo=\"http://foo\"><foo:b>557</foo:b><foo:c>xyz</foo:c></foo:a>", false)
    );
  }

  /**
   * ~ : Converts a string to a sequence of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_chars.html : @param $arg the string to split .
   */
  @org.junit.Test
  public void functxFunctxChars1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string to a sequence of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_chars.html : @param $arg the string to split :)\n" +
      "         declare function functx:chars ( $arg as xs:string? ) as xs:string* { for $ch in string-to-codepoints($arg) return codepoints-to-string($ch) } ;\n" +
      "                    (functx:chars('abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a b c")
    );
  }

  /**
   * ~ : Converts a string to a sequence of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_chars.html : @param $arg the string to split .
   */
  @org.junit.Test
  public void functxFunctxChars2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string to a sequence of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_chars.html : @param $arg the string to split :)\n" +
      "         declare function functx:chars ( $arg as xs:string? ) as xs:string* { for $ch in string-to-codepoints($arg) return codepoints-to-string($ch) } ;\n" +
      "                    (functx:chars('a b c'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a   b   c")
    );
  }

  /**
   * ~ : Converts a string to a sequence of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_chars.html : @param $arg the string to split .
   */
  @org.junit.Test
  public void functxFunctxCharsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string to a sequence of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_chars.html : @param $arg the string to split :)\n" +
      "         declare function functx:chars ( $arg as xs:string? ) as xs:string* { for $ch in string-to-codepoints($arg) return codepoints-to-string($ch) } ;\n" +
      "                    (functx:chars('abc'), functx:chars('a b c'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a b c a   b   c")
    );
  }

  /**
   * ~ : Whether a string contains any of a sequence of strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-any-of.html : @param $arg the string to test : @param $searchStrings the strings to look for .
   */
  @org.junit.Test
  public void functxFunctxContainsAnyOf1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a string contains any of a sequence of strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-any-of.html : @param $arg the string to test : @param $searchStrings the strings to look for :)\n" +
      "         declare function functx:contains-any-of ( $arg as xs:string? , $searchStrings as xs:string* ) as xs:boolean { some $searchString in $searchStrings satisfies contains($arg,$searchString) } ;\n" +
      "                    (functx:contains-any-of('abc',('bc','xy')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a string contains any of a sequence of strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-any-of.html : @param $arg the string to test : @param $searchStrings the strings to look for .
   */
  @org.junit.Test
  public void functxFunctxContainsAnyOf2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a string contains any of a sequence of strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-any-of.html : @param $arg the string to test : @param $searchStrings the strings to look for :)\n" +
      "         declare function functx:contains-any-of ( $arg as xs:string? , $searchStrings as xs:string* ) as xs:boolean { some $searchString in $searchStrings satisfies contains($arg,$searchString) } ;\n" +
      "                    (functx:contains-any-of('abc',('de','xy')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a string contains any of a sequence of strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-any-of.html : @param $arg the string to test : @param $searchStrings the strings to look for .
   */
  @org.junit.Test
  public void functxFunctxContainsAnyOfAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a string contains any of a sequence of strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-any-of.html : @param $arg the string to test : @param $searchStrings the strings to look for :)\n" +
      "         declare function functx:contains-any-of ( $arg as xs:string? , $searchStrings as xs:string* ) as xs:boolean { some $searchString in $searchStrings satisfies contains($arg,$searchString) } ;\n" +
      "                    (functx:contains-any-of('abc',('bc','xy')), functx:contains-any-of('abc',('de','xy')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false")
    );
  }

  /**
   * ~ : Whether one string contains another, without regard to case : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-case-insensitive.html : @param $arg the string to search : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxContainsCaseInsensitive1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one string contains another, without regard to case : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-case-insensitive.html : @param $arg the string to search : @param $substring the substring to find :)\n" +
      "         declare function functx:contains-case-insensitive ( $arg as xs:string? , $substring as xs:string ) as xs:boolean? { contains(upper-case($arg), upper-case($substring)) } ;\n" +
      "                    (functx:contains-case-insensitive( 'abcdef', 'def'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether one string contains another, without regard to case : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-case-insensitive.html : @param $arg the string to search : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxContainsCaseInsensitive2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one string contains another, without regard to case : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-case-insensitive.html : @param $arg the string to search : @param $substring the substring to find :)\n" +
      "         declare function functx:contains-case-insensitive ( $arg as xs:string? , $substring as xs:string ) as xs:boolean? { contains(upper-case($arg), upper-case($substring)) } ;\n" +
      "                    (functx:contains-case-insensitive( 'abcdEF', 'def'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether one string contains another, without regard to case : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-case-insensitive.html : @param $arg the string to search : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxContainsCaseInsensitiveAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one string contains another, without regard to case : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-case-insensitive.html : @param $arg the string to search : @param $substring the substring to find :)\n" +
      "         declare function functx:contains-case-insensitive ( $arg as xs:string? , $substring as xs:string ) as xs:boolean? { contains(upper-case($arg), upper-case($substring)) } ;\n" +
      "                    (functx:contains-case-insensitive( 'abcdef', 'def'), functx:contains-case-insensitive( 'abcdEF', 'def'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true")
    );
  }

  /**
   * ~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape .
   */
  @org.junit.Test
  public void functxFunctxContainsWord1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find :)\n" +
      "         declare function functx:contains-word ( $arg as xs:string? , $word as xs:string ) as xs:boolean { matches(upper-case($arg), concat('^(.*\\W)?', upper-case(functx:escape-for-regex($word)), '(\\W.*)?$')) } ;\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (functx:contains-word('abc def ghi', 'def'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape .
   */
  @org.junit.Test
  public void functxFunctxContainsWord2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find :)\n" +
      "         declare function functx:contains-word ( $arg as xs:string? , $word as xs:string ) as xs:boolean { matches(upper-case($arg), concat('^(.*\\W)?', upper-case(functx:escape-for-regex($word)), '(\\W.*)?$')) } ;\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (functx:contains-word('abc.def\\ghi', 'def'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape .
   */
  @org.junit.Test
  public void functxFunctxContainsWord3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find :)\n" +
      "         declare function functx:contains-word ( $arg as xs:string? , $word as xs:string ) as xs:boolean { matches(upper-case($arg), concat('^(.*\\W)?', upper-case(functx:escape-for-regex($word)), '(\\W.*)?$')) } ;\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (functx:contains-word('abc def ghi', 'abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape .
   */
  @org.junit.Test
  public void functxFunctxContainsWord4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find :)\n" +
      "         declare function functx:contains-word ( $arg as xs:string? , $word as xs:string ) as xs:boolean { matches(upper-case($arg), concat('^(.*\\W)?', upper-case(functx:escape-for-regex($word)), '(\\W.*)?$')) } ;\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (functx:contains-word('abc', 'abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape .
   */
  @org.junit.Test
  public void functxFunctxContainsWord5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find :)\n" +
      "         declare function functx:contains-word ( $arg as xs:string? , $word as xs:string ) as xs:boolean { matches(upper-case($arg), concat('^(.*\\W)?', upper-case(functx:escape-for-regex($word)), '(\\W.*)?$')) } ;\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (functx:contains-word('abcdef', 'abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape .
   */
  @org.junit.Test
  public void functxFunctxContainsWordAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one string contains another, as a separate word : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_contains-word.html : @param $arg the string to search : @param $word the word to find :)\n" +
      "         declare function functx:contains-word ( $arg as xs:string? , $word as xs:string ) as xs:boolean { matches(upper-case($arg), concat('^(.*\\W)?', upper-case(functx:escape-for-regex($word)), '(\\W.*)?$')) } ;\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (functx:contains-word('abc def ghi', 'def'), functx:contains-word('abc.def\\ghi', 'def'), functx:contains-word('abc def ghi', 'abc'), functx:contains-word('abc', 'abc'), functx:contains-word('abcdef', 'abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true true true false")
    );
  }

  /**
   * ~ : Copies attributes from one element to another : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_copy-attributes.html : @param $copyTo the element to copy attributes to : @param $copyFrom the element to copy attributes from .
   */
  @org.junit.Test
  public void functxFunctxCopyAttributes1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Copies attributes from one element to another : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_copy-attributes.html : @param $copyTo the element to copy attributes to : @param $copyFrom the element to copy attributes from :)\n" +
      "         declare function functx:copy-attributes ( $copyTo as element() , $copyFrom as element() ) as element() { element { node-name($copyTo)} { $copyTo/@*[not(node-name(.) = $copyFrom/@*/node-name(.))], $copyFrom/@*, $copyTo/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a>> <b x=\"1\" y=\"2\">456</b> <c x=\"9\">123</c> <d z=\"5\">123</d> </in-xml> return (functx:copy-attributes( $in-xml/a, $in-xml/b))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a y=\"2\" x=\"1\">123</a>", false)
    );
  }

  /**
   * ~ : Copies attributes from one element to another : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_copy-attributes.html : @param $copyTo the element to copy attributes to : @param $copyFrom the element to copy attributes from .
   */
  @org.junit.Test
  public void functxFunctxCopyAttributes2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Copies attributes from one element to another : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_copy-attributes.html : @param $copyTo the element to copy attributes to : @param $copyFrom the element to copy attributes from :)\n" +
      "         declare function functx:copy-attributes ( $copyTo as element() , $copyFrom as element() ) as element() { element { node-name($copyTo)} { $copyTo/@*[not(node-name(.) = $copyFrom/@*/node-name(.))], $copyFrom/@*, $copyTo/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a>> <b x=\"1\" y=\"2\">456</b> <c x=\"9\">123</c> <d z=\"5\">123</d> </in-xml> return (functx:copy-attributes( $in-xml/b, $in-xml/c))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<b y=\"2\" x=\"9\">456</b>", false)
    );
  }

  /**
   * ~ : Copies attributes from one element to another : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_copy-attributes.html : @param $copyTo the element to copy attributes to : @param $copyFrom the element to copy attributes from .
   */
  @org.junit.Test
  public void functxFunctxCopyAttributes3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Copies attributes from one element to another : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_copy-attributes.html : @param $copyTo the element to copy attributes to : @param $copyFrom the element to copy attributes from :)\n" +
      "         declare function functx:copy-attributes ( $copyTo as element() , $copyFrom as element() ) as element() { element { node-name($copyTo)} { $copyTo/@*[not(node-name(.) = $copyFrom/@*/node-name(.))], $copyFrom/@*, $copyTo/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a>> <b x=\"1\" y=\"2\">456</b> <c x=\"9\">123</c> <d z=\"5\">123</d> </in-xml> return (functx:copy-attributes( $in-xml/d, $in-xml/c))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<d z=\"5\" x=\"9\">123</d>", false)
    );
  }

  /**
   * ~ : Copies attributes from one element to another : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_copy-attributes.html : @param $copyTo the element to copy attributes to : @param $copyFrom the element to copy attributes from .
   */
  @org.junit.Test
  public void functxFunctxCopyAttributesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Copies attributes from one element to another : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_copy-attributes.html : @param $copyTo the element to copy attributes to : @param $copyFrom the element to copy attributes from :)\n" +
      "         declare function functx:copy-attributes ( $copyTo as element() , $copyFrom as element() ) as element() { element { node-name($copyTo)} { $copyTo/@*[not(node-name(.) = $copyFrom/@*/node-name(.))], $copyFrom/@*, $copyTo/node() } } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a>> <b x=\"1\" y=\"2\">456</b> <c x=\"9\">123</c> <d z=\"5\">123</d> </in-xml> return (functx:copy-attributes( $in-xml/a, $in-xml/b), functx:copy-attributes( $in-xml/b, $in-xml/c), functx:copy-attributes( $in-xml/d, $in-xml/c))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a y=\"2\" x=\"1\">123</a><b y=\"2\" x=\"9\">456</b><d z=\"5\" x=\"9\">123</d>", false)
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxDate1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:date(2006,6,12))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2006-06-12")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxDate2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:date('2006','06','12'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2006-06-12")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxDateAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:date(2006,6,12), functx:date('2006','06','12'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2006-06-12 2006-06-12")
    );
  }

  /**
   * ~ : Construct a date/time from individual components : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_datetime.html : @param $year the year : @param $month the month : @param $day the day : @param $hour the hour : @param $minute the minute : @param $second the second ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies ~ : Construct a time from an hour, minute and second : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_time.html : @param $hour the hour : @param $minute the minute : @param $second the second .
   */
  @org.junit.Test
  public void functxFunctxDateTime1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date/time from individual components : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_datetime.html : @param $year the year : @param $month the month : @param $day the day : @param $hour the hour : @param $minute the minute : @param $second the second :)\n" +
      "         declare function functx:dateTime ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType , $hour as xs:anyAtomicType , $minute as xs:anyAtomicType , $second as xs:anyAtomicType ) as xs:dateTime { xs:dateTime( concat(functx:date($year,$month,$day),'T', functx:time($hour,$minute,$second))) } ;\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (:~ : Construct a time from an hour, minute and second : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_time.html : @param $hour the hour : @param $minute the minute : @param $second the second :)\n" +
      "         declare function functx:time ( $hour as xs:anyAtomicType , $minute as xs:anyAtomicType , $second as xs:anyAtomicType ) as xs:time { xs:time( concat( functx:pad-integer-to-length(xs:integer($hour),2),':', functx:pad-integer-to-length(xs:integer($minute),2),':', functx:pad-integer-to-length(xs:integer($second),2))) } ;\n" +
      "                    (functx:dateTime(2006,6,12,20,6,12))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2006-06-12T20:06:12")
    );
  }

  /**
   * ~ : Construct a date/time from individual components : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_datetime.html : @param $year the year : @param $month the month : @param $day the day : @param $hour the hour : @param $minute the minute : @param $second the second ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies ~ : Construct a time from an hour, minute and second : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_time.html : @param $hour the hour : @param $minute the minute : @param $second the second .
   */
  @org.junit.Test
  public void functxFunctxDateTime2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date/time from individual components : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_datetime.html : @param $year the year : @param $month the month : @param $day the day : @param $hour the hour : @param $minute the minute : @param $second the second :)\n" +
      "         declare function functx:dateTime ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType , $hour as xs:anyAtomicType , $minute as xs:anyAtomicType , $second as xs:anyAtomicType ) as xs:dateTime { xs:dateTime( concat(functx:date($year,$month,$day),'T', functx:time($hour,$minute,$second))) } ;\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (:~ : Construct a time from an hour, minute and second : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_time.html : @param $hour the hour : @param $minute the minute : @param $second the second :)\n" +
      "         declare function functx:time ( $hour as xs:anyAtomicType , $minute as xs:anyAtomicType , $second as xs:anyAtomicType ) as xs:time { xs:time( concat( functx:pad-integer-to-length(xs:integer($hour),2),':', functx:pad-integer-to-length(xs:integer($minute),2),':', functx:pad-integer-to-length(xs:integer($second),2))) } ;\n" +
      "                    (functx:dateTime('2006','6','12','20','6','12'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2006-06-12T20:06:12")
    );
  }

  /**
   * ~ : Construct a date/time from individual components : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_datetime.html : @param $year the year : @param $month the month : @param $day the day : @param $hour the hour : @param $minute the minute : @param $second the second ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies ~ : Construct a time from an hour, minute and second : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_time.html : @param $hour the hour : @param $minute the minute : @param $second the second .
   */
  @org.junit.Test
  public void functxFunctxDateTimeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date/time from individual components : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_datetime.html : @param $year the year : @param $month the month : @param $day the day : @param $hour the hour : @param $minute the minute : @param $second the second :)\n" +
      "         declare function functx:dateTime ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType , $hour as xs:anyAtomicType , $minute as xs:anyAtomicType , $second as xs:anyAtomicType ) as xs:dateTime { xs:dateTime( concat(functx:date($year,$month,$day),'T', functx:time($hour,$minute,$second))) } ;\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (:~ : Construct a time from an hour, minute and second : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_time.html : @param $hour the hour : @param $minute the minute : @param $second the second :)\n" +
      "         declare function functx:time ( $hour as xs:anyAtomicType , $minute as xs:anyAtomicType , $second as xs:anyAtomicType ) as xs:time { xs:time( concat( functx:pad-integer-to-length(xs:integer($hour),2),':', functx:pad-integer-to-length(xs:integer($minute),2),':', functx:pad-integer-to-length(xs:integer($second),2))) } ;\n" +
      "                    (functx:dateTime(2006,6,12,20,6,12), functx:dateTime('2006','6','12','20','6','12'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2006-06-12T20:06:12 2006-06-12T20:06:12")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The day of the year (a number between 1 and 366) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-in-year.html : @param $date the date ~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxDayInYear1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The day of the year (a number between 1 and 366) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-in-year.html : @param $date the date :)\n" +
      "         declare function functx:day-in-year ( $date as xs:anyAtomicType? ) as xs:integer? { days-from-duration( xs:date($date) - functx:first-day-of-year($date)) + 1 } ;\n" +
      "                    (:~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 1, 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:day-in-year(xs:date('2004-01-01')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The day of the year (a number between 1 and 366) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-in-year.html : @param $date the date ~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxDayInYear2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The day of the year (a number between 1 and 366) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-in-year.html : @param $date the date :)\n" +
      "         declare function functx:day-in-year ( $date as xs:anyAtomicType? ) as xs:integer? { days-from-duration( xs:date($date) - functx:first-day-of-year($date)) + 1 } ;\n" +
      "                    (:~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 1, 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:day-in-year( xs:dateTime('2004-02-01T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("32")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The day of the year (a number between 1 and 366) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-in-year.html : @param $date the date ~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxDayInYear3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The day of the year (a number between 1 and 366) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-in-year.html : @param $date the date :)\n" +
      "         declare function functx:day-in-year ( $date as xs:anyAtomicType? ) as xs:integer? { days-from-duration( xs:date($date) - functx:first-day-of-year($date)) + 1 } ;\n" +
      "                    (:~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 1, 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:day-in-year('2004-02-05'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("36")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The day of the year (a number between 1 and 366) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-in-year.html : @param $date the date ~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxDayInYearAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The day of the year (a number between 1 and 366) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-in-year.html : @param $date the date :)\n" +
      "         declare function functx:day-in-year ( $date as xs:anyAtomicType? ) as xs:integer? { days-from-duration( xs:date($date) - functx:first-day-of-year($date)) + 1 } ;\n" +
      "                    (:~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 1, 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:day-in-year(xs:date('2004-01-01')), functx:day-in-year( xs:dateTime('2004-02-01T12:00:13')), functx:day-in-year('2004-02-05'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 32 36")
    );
  }

  /**
   * ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeek1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week( xs:date('2004-11-04')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("4")
    );
  }

  /**
   * ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeek2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week( xs:dateTime('2004-11-04T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("4")
    );
  }

  /**
   * ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeek3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week('2004-11-04'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("4")
    );
  }

  /**
   * ~ : The abbreviated day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-abbrev-en.html : @param $date the date ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeekAbbrevEn1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The abbreviated day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-abbrev-en.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week-abbrev-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Sun', 'Mon', 'Tues', 'Wed', 'Thurs', 'Fri', 'Sat') [functx:day-of-week($date) + 1] } ;\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week-abbrev-en( xs:date('2004-11-04')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Thurs")
    );
  }

  /**
   * ~ : The abbreviated day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-abbrev-en.html : @param $date the date ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeekAbbrevEn2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The abbreviated day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-abbrev-en.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week-abbrev-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Sun', 'Mon', 'Tues', 'Wed', 'Thurs', 'Fri', 'Sat') [functx:day-of-week($date) + 1] } ;\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week-abbrev-en('2004-11-04'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Thurs")
    );
  }

  /**
   * ~ : The abbreviated day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-abbrev-en.html : @param $date the date ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeekAbbrevEnAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The abbreviated day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-abbrev-en.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week-abbrev-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Sun', 'Mon', 'Tues', 'Wed', 'Thurs', 'Fri', 'Sat') [functx:day-of-week($date) + 1] } ;\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week-abbrev-en( xs:date('2004-11-04')), functx:day-of-week-abbrev-en('2004-11-04'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Thurs Thurs")
    );
  }

  /**
   * ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeekAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week( xs:date('2004-11-04')), functx:day-of-week( xs:dateTime('2004-11-04T12:00:13')), functx:day-of-week('2004-11-04'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "4 4 4")
    );
  }

  /**
   * ~ : The name of the day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-name-en.html : @param $date the date ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeekNameEn1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The name of the day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-name-en.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week-name-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday') [functx:day-of-week($date) + 1] } ;\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week-name-en( xs:date('2004-11-04')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Thursday")
    );
  }

  /**
   * ~ : The name of the day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-name-en.html : @param $date the date ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeekNameEn2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The name of the day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-name-en.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week-name-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday') [functx:day-of-week($date) + 1] } ;\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week-name-en('2004-11-04'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Thursday")
    );
  }

  /**
   * ~ : The name of the day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-name-en.html : @param $date the date ~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxDayOfWeekNameEnAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The name of the day of the week, from a date, in English : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week-name-en.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week-name-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday') [functx:day-of-week($date) + 1] } ;\n" +
      "                    (:~ : The day of the week, from a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_day-of-week.html : @param $date the date :)\n" +
      "         declare function functx:day-of-week ( $date as xs:anyAtomicType? ) as xs:integer? { if (empty($date)) then () else xs:integer((xs:date($date) - xs:date('1901-01-06')) div xs:dayTimeDuration('P1D')) mod 7 } ;\n" +
      "                    (functx:day-of-week-name-en( xs:date('2004-11-04')), functx:day-of-week-name-en('2004-11-04'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Thursday Thursday")
    );
  }

  /**
   * ~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxDayTimeDuration1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds :)\n" +
      "         declare function functx:dayTimeDuration ( $days as xs:decimal? , $hours as xs:decimal? , $minutes as xs:decimal? , $seconds as xs:decimal? ) as xs:dayTimeDuration { (xs:dayTimeDuration('P1D') * functx:if-empty($days,0)) + (xs:dayTimeDuration('PT1H') * functx:if-empty($hours,0)) + (xs:dayTimeDuration('PT1M') * functx:if-empty($minutes,0)) + (xs:dayTimeDuration('PT1S') * functx:if-empty($seconds,0)) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (functx:dayTimeDuration(1,6,0,0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "P1DT6H")
    );
  }

  /**
   * ~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxDayTimeDuration2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds :)\n" +
      "         declare function functx:dayTimeDuration ( $days as xs:decimal? , $hours as xs:decimal? , $minutes as xs:decimal? , $seconds as xs:decimal? ) as xs:dayTimeDuration { (xs:dayTimeDuration('P1D') * functx:if-empty($days,0)) + (xs:dayTimeDuration('PT1H') * functx:if-empty($hours,0)) + (xs:dayTimeDuration('PT1M') * functx:if-empty($minutes,0)) + (xs:dayTimeDuration('PT1S') * functx:if-empty($seconds,0)) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (functx:dayTimeDuration(2.5,0,0,0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "P2DT12H")
    );
  }

  /**
   * ~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxDayTimeDuration3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds :)\n" +
      "         declare function functx:dayTimeDuration ( $days as xs:decimal? , $hours as xs:decimal? , $minutes as xs:decimal? , $seconds as xs:decimal? ) as xs:dayTimeDuration { (xs:dayTimeDuration('P1D') * functx:if-empty($days,0)) + (xs:dayTimeDuration('PT1H') * functx:if-empty($hours,0)) + (xs:dayTimeDuration('PT1M') * functx:if-empty($minutes,0)) + (xs:dayTimeDuration('PT1S') * functx:if-empty($seconds,0)) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (functx:dayTimeDuration(1,(),3,5.6))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "P1DT3M5.6S")
    );
  }

  /**
   * ~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxDayTimeDuration4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds :)\n" +
      "         declare function functx:dayTimeDuration ( $days as xs:decimal? , $hours as xs:decimal? , $minutes as xs:decimal? , $seconds as xs:decimal? ) as xs:dayTimeDuration { (xs:dayTimeDuration('P1D') * functx:if-empty($days,0)) + (xs:dayTimeDuration('PT1H') * functx:if-empty($hours,0)) + (xs:dayTimeDuration('PT1M') * functx:if-empty($minutes,0)) + (xs:dayTimeDuration('PT1S') * functx:if-empty($seconds,0)) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (functx:dayTimeDuration(0,0,5,0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "PT5M")
    );
  }

  /**
   * ~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxDayTimeDuration5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds :)\n" +
      "         declare function functx:dayTimeDuration ( $days as xs:decimal? , $hours as xs:decimal? , $minutes as xs:decimal? , $seconds as xs:decimal? ) as xs:dayTimeDuration { (xs:dayTimeDuration('P1D') * functx:if-empty($days,0)) + (xs:dayTimeDuration('PT1H') * functx:if-empty($hours,0)) + (xs:dayTimeDuration('PT1M') * functx:if-empty($minutes,0)) + (xs:dayTimeDuration('PT1S') * functx:if-empty($seconds,0)) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (functx:dayTimeDuration(0,0,0,0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "PT0S")
    );
  }

  /**
   * ~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxDayTimeDurationAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a dayTimeDuration from a number of days, hours, etc. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_daytimeduration.html : @param $days the number of days : @param $hours the number of hours : @param $minutes the number of minutes : @param $seconds the number of seconds :)\n" +
      "         declare function functx:dayTimeDuration ( $days as xs:decimal? , $hours as xs:decimal? , $minutes as xs:decimal? , $seconds as xs:decimal? ) as xs:dayTimeDuration { (xs:dayTimeDuration('P1D') * functx:if-empty($days,0)) + (xs:dayTimeDuration('PT1H') * functx:if-empty($hours,0)) + (xs:dayTimeDuration('PT1M') * functx:if-empty($minutes,0)) + (xs:dayTimeDuration('PT1S') * functx:if-empty($seconds,0)) } ;\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    (functx:dayTimeDuration(1,6,0,0), functx:dayTimeDuration(2.5,0,0,0), functx:dayTimeDuration(1,(),3,5.6), functx:dayTimeDuration(0,0,5,0), functx:dayTimeDuration(0,0,0,0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "P1DT6H P2DT12H P1DT3M5.6S PT5M PT0S")
    );
  }

  /**
   * ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year .
   */
  @org.junit.Test
  public void functxFunctxDaysInMonth1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (functx:days-in-month(xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("31")
    );
  }

  /**
   * ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year .
   */
  @org.junit.Test
  public void functxFunctxDaysInMonth2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (functx:days-in-month( xs:dateTime('2004-02-15T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("29")
    );
  }

  /**
   * ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year .
   */
  @org.junit.Test
  public void functxFunctxDaysInMonth3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (functx:days-in-month('2005-02-15'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("28")
    );
  }

  /**
   * ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year .
   */
  @org.junit.Test
  public void functxFunctxDaysInMonthAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (functx:days-in-month(xs:date('2004-01-23')), functx:days-in-month( xs:dateTime('2004-02-15T12:00:13')), functx:days-in-month('2005-02-15'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "31 29 28")
    );
  }

  /**
   * ~ : Converts a string with format DDMMYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.1 : @see http://www.xqueryfunctions.com/xq/functx_ddmmyyyy-to-date.html : @param $dateString the DDMMYYYY string .
   */
  @org.junit.Test
  public void functxFunctxDdmmyyyyToDate1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string with format DDMMYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.1 : @see http://www.xqueryfunctions.com/xq/functx_ddmmyyyy-to-date.html : @param $dateString the DDMMYYYY string :)\n" +
      "         declare function functx:ddmmyyyy-to-date ( $dateString as xs:string? ) as xs:date? { if (empty($dateString)) then () else if (not(matches($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$'))) then error(xs:QName('functx:Invalid_Date_Format')) else xs:date(replace($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$', '$3-$2-$1')) } ;\n" +
      "                    (functx:ddmmyyyy-to-date('15-12-2004'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-15")
    );
  }

  /**
   * ~ : Converts a string with format DDMMYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.1 : @see http://www.xqueryfunctions.com/xq/functx_ddmmyyyy-to-date.html : @param $dateString the DDMMYYYY string .
   */
  @org.junit.Test
  public void functxFunctxDdmmyyyyToDate2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string with format DDMMYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.1 : @see http://www.xqueryfunctions.com/xq/functx_ddmmyyyy-to-date.html : @param $dateString the DDMMYYYY string :)\n" +
      "         declare function functx:ddmmyyyy-to-date ( $dateString as xs:string? ) as xs:date? { if (empty($dateString)) then () else if (not(matches($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$'))) then error(xs:QName('functx:Invalid_Date_Format')) else xs:date(replace($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$', '$3-$2-$1')) } ;\n" +
      "                    (functx:ddmmyyyy-to-date('15122004'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-15")
    );
  }

  /**
   * ~ : Converts a string with format DDMMYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.1 : @see http://www.xqueryfunctions.com/xq/functx_ddmmyyyy-to-date.html : @param $dateString the DDMMYYYY string .
   */
  @org.junit.Test
  public void functxFunctxDdmmyyyyToDate3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string with format DDMMYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.1 : @see http://www.xqueryfunctions.com/xq/functx_ddmmyyyy-to-date.html : @param $dateString the DDMMYYYY string :)\n" +
      "         declare function functx:ddmmyyyy-to-date ( $dateString as xs:string? ) as xs:date? { if (empty($dateString)) then () else if (not(matches($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$'))) then error(xs:QName('functx:Invalid_Date_Format')) else xs:date(replace($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$', '$3-$2-$1')) } ;\n" +
      "                    (functx:ddmmyyyy-to-date('15/12/2004'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-15")
    );
  }

  /**
   * ~ : Converts a string with format DDMMYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.1 : @see http://www.xqueryfunctions.com/xq/functx_ddmmyyyy-to-date.html : @param $dateString the DDMMYYYY string .
   */
  @org.junit.Test
  public void functxFunctxDdmmyyyyToDateAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string with format DDMMYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.1 : @see http://www.xqueryfunctions.com/xq/functx_ddmmyyyy-to-date.html : @param $dateString the DDMMYYYY string :)\n" +
      "         declare function functx:ddmmyyyy-to-date ( $dateString as xs:string? ) as xs:date? { if (empty($dateString)) then () else if (not(matches($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$'))) then error(xs:QName('functx:Invalid_Date_Format')) else xs:date(replace($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$', '$3-$2-$1')) } ;\n" +
      "                    (functx:ddmmyyyy-to-date('15-12-2004'), functx:ddmmyyyy-to-date('15122004'), functx:ddmmyyyy-to-date('15/12/2004'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-15 2004-12-15 2004-12-15")
    );
  }

  /**
   * ~ : The depth (level) of a node in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_depth-of-node.html : @param $node the node to check .
   */
  @org.junit.Test
  public void functxFunctxDepthOfNode1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The depth (level) of a node in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_depth-of-node.html : @param $node the node to check :)\n" +
      "         declare function functx:depth-of-node ( $node as node()? ) as xs:integer { count($node/ancestor-or-self::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:depth-of-node($in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : The depth (level) of a node in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_depth-of-node.html : @param $node the node to check .
   */
  @org.junit.Test
  public void functxFunctxDepthOfNode2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The depth (level) of a node in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_depth-of-node.html : @param $node the node to check :)\n" +
      "         declare function functx:depth-of-node ( $node as node()? ) as xs:integer { count($node/ancestor-or-self::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:depth-of-node($in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The depth (level) of a node in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_depth-of-node.html : @param $node the node to check .
   */
  @org.junit.Test
  public void functxFunctxDepthOfNode3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The depth (level) of a node in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_depth-of-node.html : @param $node the node to check :)\n" +
      "         declare function functx:depth-of-node ( $node as node()? ) as xs:integer { count($node/ancestor-or-self::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:depth-of-node( $in-xml/author[1]/fName/text()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("4")
    );
  }

  /**
   * ~ : The depth (level) of a node in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_depth-of-node.html : @param $node the node to check .
   */
  @org.junit.Test
  public void functxFunctxDepthOfNodeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The depth (level) of a node in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_depth-of-node.html : @param $node the node to check :)\n" +
      "         declare function functx:depth-of-node ( $node as node()? ) as xs:integer { count($node/ancestor-or-self::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:depth-of-node($in-xml), functx:depth-of-node($in-xml/author[1]), functx:depth-of-node( $in-xml/author[1]/fName/text()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 2 4")
    );
  }

  /**
   * ~ : The distinct names of all attributes in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-attribute-names.html : @param $nodes the root to start from .
   */
  @org.junit.Test
  public void functxFunctxDistinctAttributeNames1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct names of all attributes in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-attribute-names.html : @param $nodes the root to start from :)\n" +
      "         declare function functx:distinct-attribute-names ( $nodes as node()* ) as xs:string* { distinct-values($nodes//@*/name(.)) } ;\n" +
      "                    let $in-xml := <authors a1=\"xyz\"> <author a2=\"abc\"> <fName a3=\"def\">Kate</fName> <lName>Jones</lName> </author> <author> <fName a3=\"def\">John</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-attribute-names($in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a1 a2 a3")
    );
  }

  /**
   * ~ : The XML nodes with distinct values, taking into account attributes and descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-deep.html : @param $nodes the sequence of nodes to test ~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxDistinctDeep1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML nodes with distinct values, taking into account attributes and descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-deep.html : @param $nodes the sequence of nodes to test :)\n" +
      "         declare function functx:distinct-deep ( $nodes as node()* ) as node()* { for $seq in (1 to count($nodes)) return $nodes[$seq][not(functx:is-node-in-sequence-deep-equal( .,$nodes[position() < $seq]))] } ;\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>Kate</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-deep($in-xml//author))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<author><fName>Kate</fName><lName>Jones</lName></author><author><fName>Kate</fName><lName>Doe</lName></author>", false)
    );
  }

  /**
   * ~ : The XML nodes with distinct values, taking into account attributes and descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-deep.html : @param $nodes the sequence of nodes to test ~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxDistinctDeep2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML nodes with distinct values, taking into account attributes and descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-deep.html : @param $nodes the sequence of nodes to test :)\n" +
      "         declare function functx:distinct-deep ( $nodes as node()* ) as node()* { for $seq in (1 to count($nodes)) return $nodes[$seq][not(functx:is-node-in-sequence-deep-equal( .,$nodes[position() < $seq]))] } ;\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>Kate</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-deep($in-xml//lName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<lName>Jones</lName><lName>Doe</lName>", false)
    );
  }

  /**
   * ~ : The XML nodes with distinct values, taking into account attributes and descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-deep.html : @param $nodes the sequence of nodes to test ~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxDistinctDeep3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML nodes with distinct values, taking into account attributes and descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-deep.html : @param $nodes the sequence of nodes to test :)\n" +
      "         declare function functx:distinct-deep ( $nodes as node()* ) as node()* { for $seq in (1 to count($nodes)) return $nodes[$seq][not(functx:is-node-in-sequence-deep-equal( .,$nodes[position() < $seq]))] } ;\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>Kate</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-deep($in-xml//fName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>Kate</fName>", false)
    );
  }

  /**
   * ~ : The XML nodes with distinct values, taking into account attributes and descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-deep.html : @param $nodes the sequence of nodes to test ~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxDistinctDeepAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML nodes with distinct values, taking into account attributes and descendants : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-deep.html : @param $nodes the sequence of nodes to test :)\n" +
      "         declare function functx:distinct-deep ( $nodes as node()* ) as node()* { for $seq in (1 to count($nodes)) return $nodes[$seq][not(functx:is-node-in-sequence-deep-equal( .,$nodes[position() < $seq]))] } ;\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>Kate</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-deep($in-xml//author), functx:distinct-deep($in-xml//lName), functx:distinct-deep($in-xml//fName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<author><fName>Kate</fName><lName>Jones</lName></author><author><fName>Kate</fName><lName>Doe</lName></author><lName>Jones</lName><lName>Doe</lName><fName>Kate</fName>", false)
    );
  }

  /**
   * ~ : The distinct names of all elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-names.html : @param $nodes the root(s) to start from ~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence .
   */
  @org.junit.Test
  public void functxFunctxDistinctElementNames1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct names of all elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-names.html : @param $nodes the root(s) to start from :)\n" +
      "         declare function functx:distinct-element-names ( $nodes as node()* ) as xs:string* { distinct-values($nodes/descendant-or-self::*/name(.)) } ;\n" +
      "                    (:~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:path-to-node ( $nodes as node()* ) as xs:string* { $nodes/string-join(ancestor-or-self::*/name(.), '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-element-names($in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors author fName lName")
    );
  }

  /**
   * ~ : The distinct names of all elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-names.html : @param $nodes the root(s) to start from ~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence .
   */
  @org.junit.Test
  public void functxFunctxDistinctElementNames2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct names of all elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-names.html : @param $nodes the root(s) to start from :)\n" +
      "         declare function functx:distinct-element-names ( $nodes as node()* ) as xs:string* { distinct-values($nodes/descendant-or-self::*/name(.)) } ;\n" +
      "                    (:~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:path-to-node ( $nodes as node()* ) as xs:string* { $nodes/string-join(ancestor-or-self::*/name(.), '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-element-names( $in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "author fName lName")
    );
  }

  /**
   * ~ : The distinct names of all elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-names.html : @param $nodes the root(s) to start from ~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence .
   */
  @org.junit.Test
  public void functxFunctxDistinctElementNamesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct names of all elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-names.html : @param $nodes the root(s) to start from :)\n" +
      "         declare function functx:distinct-element-names ( $nodes as node()* ) as xs:string* { distinct-values($nodes/descendant-or-self::*/name(.)) } ;\n" +
      "                    (:~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:path-to-node ( $nodes as node()* ) as xs:string* { $nodes/string-join(ancestor-or-self::*/name(.), '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-element-names($in-xml), functx:distinct-element-names( $in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors author fName lName author fName lName")
    );
  }

  /**
   * ~ : The distinct paths of all descendant elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-paths.html : @param $nodes the root(s) to start from ~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence .
   */
  @org.junit.Test
  public void functxFunctxDistinctElementPaths1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct paths of all descendant elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-paths.html : @param $nodes the root(s) to start from :)\n" +
      "         declare function functx:distinct-element-paths ( $nodes as node()* ) as xs:string* { distinct-values(functx:path-to-node($nodes/descendant-or-self::*)) } ;\n" +
      "                    (:~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:path-to-node ( $nodes as node()* ) as xs:string* { $nodes/string-join(ancestor-or-self::*/name(.), '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-element-paths( $in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors authors/author authors/author/fName authors/author/lName")
    );
  }

  /**
   * ~ : The distinct paths of all descendant elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-paths.html : @param $nodes the root(s) to start from ~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence .
   */
  @org.junit.Test
  public void functxFunctxDistinctElementPaths2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct paths of all descendant elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-paths.html : @param $nodes the root(s) to start from :)\n" +
      "         declare function functx:distinct-element-paths ( $nodes as node()* ) as xs:string* { distinct-values(functx:path-to-node($nodes/descendant-or-self::*)) } ;\n" +
      "                    (:~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:path-to-node ( $nodes as node()* ) as xs:string* { $nodes/string-join(ancestor-or-self::*/name(.), '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-element-paths( $in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors/author authors/author/fName authors/author/lName")
    );
  }

  /**
   * ~ : The distinct paths of all descendant elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-paths.html : @param $nodes the root(s) to start from ~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence .
   */
  @org.junit.Test
  public void functxFunctxDistinctElementPathsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct paths of all descendant elements in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-element-paths.html : @param $nodes the root(s) to start from :)\n" +
      "         declare function functx:distinct-element-paths ( $nodes as node()* ) as xs:string* { distinct-values(functx:path-to-node($nodes/descendant-or-self::*)) } ;\n" +
      "                    (:~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:path-to-node ( $nodes as node()* ) as xs:string* { $nodes/string-join(ancestor-or-self::*/name(.), '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:distinct-element-paths( $in-xml), functx:distinct-element-paths( $in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors authors/author authors/author/fName authors/author/lName authors/author authors/author/fName authors/author/lName")
    );
  }

  /**
   * ~ : The distinct XML nodes in a sequence (by node identity) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-nodes.html : @param $nodes the node sequence ~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxDistinctNodes1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct XML nodes in a sequence (by node identity) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-nodes.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:distinct-nodes ( $nodes as node()* ) as node()* { for $seq in (1 to count($nodes)) return $nodes[$seq][not(functx:is-node-in-sequence( .,$nodes[position() < $seq]))] } ;\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml :=  <test> <child>1</child> <child>2</child> <child>3</child> <child>3</child> </test> return (functx:distinct-nodes( ($in-xml/child, $in-xml/*) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<child>1</child><child>2</child><child>3</child><child>3</child>", false)
    );
  }

  /**
   * ~ : The distinct XML nodes in a sequence (by node identity) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-nodes.html : @param $nodes the node sequence ~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxDistinctNodes2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct XML nodes in a sequence (by node identity) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-nodes.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:distinct-nodes ( $nodes as node()* ) as node()* { for $seq in (1 to count($nodes)) return $nodes[$seq][not(functx:is-node-in-sequence( .,$nodes[position() < $seq]))] } ;\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml :=  <test> <child>1</child> <child>2</child> <child>3</child> <child>3</child> </test> return (functx:distinct-nodes( ($in-xml/child[3], $in-xml/*) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<child>3</child><child>1</child><child>2</child><child>3</child>", false)
    );
  }

  /**
   * ~ : The distinct XML nodes in a sequence (by node identity) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-nodes.html : @param $nodes the node sequence ~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxDistinctNodesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The distinct XML nodes in a sequence (by node identity) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_distinct-nodes.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:distinct-nodes ( $nodes as node()* ) as node()* { for $seq in (1 to count($nodes)) return $nodes[$seq][not(functx:is-node-in-sequence( .,$nodes[position() < $seq]))] } ;\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml :=  <test> <child>1</child> <child>2</child> <child>3</child> <child>3</child> </test> return (functx:distinct-nodes( ($in-xml/child, $in-xml/*) ), functx:distinct-nodes( ($in-xml/child[3], $in-xml/*) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<child>1</child><child>2</child><child>3</child><child>3</child><child>3</child><child>1</child><child>2</child><child>3</child>", false)
    );
  }

  /**
   * ~ : Converts a timezone like "-05:00" or "Z" into xs:dayTimeDuration : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_duration-from-timezone.html : @param $timezone the time zone, in (+|-)HH:MM format .
   */
  @org.junit.Test
  public void functxFunctxDurationFromTimezone1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a timezone like \"-05:00\" or \"Z\" into xs:dayTimeDuration : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_duration-from-timezone.html : @param $timezone the time zone, in (+|-)HH:MM format :)\n" +
      "         declare function functx:duration-from-timezone ( $timezone as xs:string ) as xs:dayTimeDuration { xs:dayTimeDuration( if (not(matches($timezone,'Z|[\\+\\-]\\d{2}:\\d{2}'))) then error(xs:QName('functx:Invalid_Timezone_Value')) else if ($timezone = 'Z') then 'PT0S' else replace($timezone,'\\+?(\\d{2}):\\d{2}','PT$1H') ) } ;\n" +
      "                    (functx:duration-from-timezone('Z'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "PT0S")
    );
  }

  /**
   * ~ : Converts a timezone like "-05:00" or "Z" into xs:dayTimeDuration : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_duration-from-timezone.html : @param $timezone the time zone, in (+|-)HH:MM format .
   */
  @org.junit.Test
  public void functxFunctxDurationFromTimezone2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a timezone like \"-05:00\" or \"Z\" into xs:dayTimeDuration : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_duration-from-timezone.html : @param $timezone the time zone, in (+|-)HH:MM format :)\n" +
      "         declare function functx:duration-from-timezone ( $timezone as xs:string ) as xs:dayTimeDuration { xs:dayTimeDuration( if (not(matches($timezone,'Z|[\\+\\-]\\d{2}:\\d{2}'))) then error(xs:QName('functx:Invalid_Timezone_Value')) else if ($timezone = 'Z') then 'PT0S' else replace($timezone,'\\+?(\\d{2}):\\d{2}','PT$1H') ) } ;\n" +
      "                    (functx:duration-from-timezone('-05:00'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "-PT5H")
    );
  }

  /**
   * ~ : Converts a timezone like "-05:00" or "Z" into xs:dayTimeDuration : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_duration-from-timezone.html : @param $timezone the time zone, in (+|-)HH:MM format .
   */
  @org.junit.Test
  public void functxFunctxDurationFromTimezone3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a timezone like \"-05:00\" or \"Z\" into xs:dayTimeDuration : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_duration-from-timezone.html : @param $timezone the time zone, in (+|-)HH:MM format :)\n" +
      "         declare function functx:duration-from-timezone ( $timezone as xs:string ) as xs:dayTimeDuration { xs:dayTimeDuration( if (not(matches($timezone,'Z|[\\+\\-]\\d{2}:\\d{2}'))) then error(xs:QName('functx:Invalid_Timezone_Value')) else if ($timezone = 'Z') then 'PT0S' else replace($timezone,'\\+?(\\d{2}):\\d{2}','PT$1H') ) } ;\n" +
      "                    (functx:duration-from-timezone('+09:00'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "PT9H")
    );
  }

  /**
   * ~ : Converts a timezone like "-05:00" or "Z" into xs:dayTimeDuration : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_duration-from-timezone.html : @param $timezone the time zone, in (+|-)HH:MM format .
   */
  @org.junit.Test
  public void functxFunctxDurationFromTimezoneAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a timezone like \"-05:00\" or \"Z\" into xs:dayTimeDuration : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_duration-from-timezone.html : @param $timezone the time zone, in (+|-)HH:MM format :)\n" +
      "         declare function functx:duration-from-timezone ( $timezone as xs:string ) as xs:dayTimeDuration { xs:dayTimeDuration( if (not(matches($timezone,'Z|[\\+\\-]\\d{2}:\\d{2}'))) then error(xs:QName('functx:Invalid_Timezone_Value')) else if ($timezone = 'Z') then 'PT0S' else replace($timezone,'\\+?(\\d{2}):\\d{2}','PT$1H') ) } ;\n" +
      "                    (functx:duration-from-timezone('Z'), functx:duration-from-timezone('-05:00'), functx:duration-from-timezone('+09:00'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "PT0S -PT5H PT9H")
    );
  }

  /**
   * ~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter ~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxDynamicPath1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression :)\n" +
      "         declare function functx:dynamic-path ( $parent as node() , $path as xs:string ) as item()* { let $nextStep := functx:substring-before-if-contains($path,'/') let $restOfSteps := substring-after($path,'/') for $child in ($parent/*[functx:name-test(name(),$nextStep)], $parent/@*[functx:name-test(name(), substring-after($nextStep,'@'))]) return if ($restOfSteps) then functx:dynamic-path($child, $restOfSteps) else $child } ;\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    (:~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-before-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-before($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <authors> <author test=\"abc\"> <first>Kate</first> <last>Jones</last> </author> <author> <first>John</first> <a:last xmlns:a=\"http://a\">Doe</a:last> </author> </authors> return (functx:dynamic-path( $in-xml,'author/first'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<first>Kate</first><first>John</first>", false)
    );
  }

  /**
   * ~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter ~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxDynamicPath2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression :)\n" +
      "         declare function functx:dynamic-path ( $parent as node() , $path as xs:string ) as item()* { let $nextStep := functx:substring-before-if-contains($path,'/') let $restOfSteps := substring-after($path,'/') for $child in ($parent/*[functx:name-test(name(),$nextStep)], $parent/@*[functx:name-test(name(), substring-after($nextStep,'@'))]) return if ($restOfSteps) then functx:dynamic-path($child, $restOfSteps) else $child } ;\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    (:~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-before-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-before($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <authors> <author test=\"abc\"> <first>Kate</first> <last>Jones</last> </author> <author> <first>John</first> <a:last xmlns:a=\"http://a\">Doe</a:last> </author> </authors> return (name(functx:dynamic-path( $in-xml,'author/@test')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "test")
    );
  }

  /**
   * ~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter ~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxDynamicPath3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression :)\n" +
      "         declare function functx:dynamic-path ( $parent as node() , $path as xs:string ) as item()* { let $nextStep := functx:substring-before-if-contains($path,'/') let $restOfSteps := substring-after($path,'/') for $child in ($parent/*[functx:name-test(name(),$nextStep)], $parent/@*[functx:name-test(name(), substring-after($nextStep,'@'))]) return if ($restOfSteps) then functx:dynamic-path($child, $restOfSteps) else $child } ;\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    (:~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-before-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-before($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <authors> <author test=\"abc\"> <first>Kate</first> <last>Jones</last> </author> <author> <first>John</first> <a:last xmlns:a=\"http://a\">Doe</a:last> </author> </authors> return (functx:dynamic-path( $in-xml,'author'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<author test=\"abc\"><first>Kate</first><last>Jones</last></author><author><first>John</first><a:last xmlns:a=\"http://a\">Doe</a:last></author>", false)
    );
  }

  /**
   * ~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter ~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxDynamicPath4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression :)\n" +
      "         declare function functx:dynamic-path ( $parent as node() , $path as xs:string ) as item()* { let $nextStep := functx:substring-before-if-contains($path,'/') let $restOfSteps := substring-after($path,'/') for $child in ($parent/*[functx:name-test(name(),$nextStep)], $parent/@*[functx:name-test(name(), substring-after($nextStep,'@'))]) return if ($restOfSteps) then functx:dynamic-path($child, $restOfSteps) else $child } ;\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    (:~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-before-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-before($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <authors> <author test=\"abc\"> <first>Kate</first> <last>Jones</last> </author> <author> <first>John</first> <a:last xmlns:a=\"http://a\">Doe</a:last> </author> </authors> return (functx:dynamic-path( $in-xml,'author/a:last'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a:last xmlns:a=\"http://a\">Doe</a:last>", false)
    );
  }

  /**
   * ~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter ~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxDynamicPathAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Dynamically evaluates a simple XPath path : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_dynamic-path.html : @param $parent the root to start from : @param $path the path expression :)\n" +
      "         declare function functx:dynamic-path ( $parent as node() , $path as xs:string ) as item()* { let $nextStep := functx:substring-before-if-contains($path,'/') let $restOfSteps := substring-after($path,'/') for $child in ($parent/*[functx:name-test(name(),$nextStep)], $parent/@*[functx:name-test(name(), substring-after($nextStep,'@'))]) return if ($restOfSteps) then functx:dynamic-path($child, $restOfSteps) else $child } ;\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    (:~ : Performs substring-before, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-before-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-before($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <authors> <author test=\"abc\"> <first>Kate</first> <last>Jones</last> </author> <author> <first>John</first> <a:last xmlns:a=\"http://a\">Doe</a:last> </author> </authors> return (functx:dynamic-path( $in-xml,'author/first'), name(functx:dynamic-path( $in-xml,'author/@test')), functx:dynamic-path( $in-xml,'author'), functx:dynamic-path( $in-xml,'author/a:last'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<first>Kate</first><first>John</first>test<author test=\"abc\"><first>Kate</first><last>Jones</last></author><author><first>John</first><a:last xmlns:a=\"http://a\">Doe</a:last></author><a:last xmlns:a=\"http://a\">Doe</a:last>", false)
    );
  }

  /**
   * ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape .
   */
  @org.junit.Test
  public void functxFunctxEscapeForRegex1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (functx:escape-for-regex('5.55'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "5\\.55")
    );
  }

  /**
   * ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape .
   */
  @org.junit.Test
  public void functxFunctxEscapeForRegex2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (functx:escape-for-regex('[abc]'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "\\[abc\\]")
    );
  }

  /**
   * ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape .
   */
  @org.junit.Test
  public void functxFunctxEscapeForRegexAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (functx:escape-for-regex('5.55'), functx:escape-for-regex('[abc]'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "5\\.55 \\[abc\\]")
    );
  }

  /**
   * ~ : Whether one (and only one) of two boolean values is true : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_exclusive-or.html : @param $arg1 the first boolean value : @param $arg2 the second boolean value .
   */
  @org.junit.Test
  public void functxFunctxExclusiveOr1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one (and only one) of two boolean values is true : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_exclusive-or.html : @param $arg1 the first boolean value : @param $arg2 the second boolean value :)\n" +
      "         declare function functx:exclusive-or ( $arg1 as xs:boolean? , $arg2 as xs:boolean? ) as xs:boolean? { $arg1 != $arg2 } ;\n" +
      "                    (functx:exclusive-or(true(),false()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether one (and only one) of two boolean values is true : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_exclusive-or.html : @param $arg1 the first boolean value : @param $arg2 the second boolean value .
   */
  @org.junit.Test
  public void functxFunctxExclusiveOr2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one (and only one) of two boolean values is true : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_exclusive-or.html : @param $arg1 the first boolean value : @param $arg2 the second boolean value :)\n" +
      "         declare function functx:exclusive-or ( $arg1 as xs:boolean? , $arg2 as xs:boolean? ) as xs:boolean? { $arg1 != $arg2 } ;\n" +
      "                    (functx:exclusive-or(true(),true()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether one (and only one) of two boolean values is true : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_exclusive-or.html : @param $arg1 the first boolean value : @param $arg2 the second boolean value .
   */
  @org.junit.Test
  public void functxFunctxExclusiveOr3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one (and only one) of two boolean values is true : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_exclusive-or.html : @param $arg1 the first boolean value : @param $arg2 the second boolean value :)\n" +
      "         declare function functx:exclusive-or ( $arg1 as xs:boolean? , $arg2 as xs:boolean? ) as xs:boolean? { $arg1 != $arg2 } ;\n" +
      "                    (functx:exclusive-or(4 >\n" +
      "                    3,1 >\n" +
      "                    2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether one (and only one) of two boolean values is true : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_exclusive-or.html : @param $arg1 the first boolean value : @param $arg2 the second boolean value .
   */
  @org.junit.Test
  public void functxFunctxExclusiveOrAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether one (and only one) of two boolean values is true : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_exclusive-or.html : @param $arg1 the first boolean value : @param $arg2 the second boolean value :)\n" +
      "         declare function functx:exclusive-or ( $arg1 as xs:boolean? , $arg2 as xs:boolean? ) as xs:boolean? { $arg1 != $arg2 } ;\n" +
      "                    (functx:exclusive-or(true(),false()), functx:exclusive-or(true(),true()), functx:exclusive-or(4 >\n" +
      "                    3,1 >\n" +
      "                    2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false true")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The first day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-month.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxFirstDayOfMonth1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The first day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-month.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-month ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), month-from-date(xs:date($date)), 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:first-day-of-month( xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-01")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The first day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-month.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxFirstDayOfMonth2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The first day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-month.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-month ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), month-from-date(xs:date($date)), 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:first-day-of-month( xs:dateTime('2004-01-23T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-01")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The first day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-month.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxFirstDayOfMonth3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The first day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-month.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-month ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), month-from-date(xs:date($date)), 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:first-day-of-month('2004-03-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-03-01")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The first day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-month.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxFirstDayOfMonthAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The first day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-month.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-month ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), month-from-date(xs:date($date)), 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:first-day-of-month( xs:date('2004-01-23')), functx:first-day-of-month( xs:dateTime('2004-01-23T12:00:13')), functx:first-day-of-month('2004-03-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-01 2004-01-01 2004-03-01")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxFirstDayOfYear1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 1, 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:first-day-of-year(xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-01")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxFirstDayOfYear2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 1, 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:first-day-of-year( xs:dateTime('2004-01-23T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-01")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxFirstDayOfYear3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 1, 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:first-day-of-year('2004-03-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-01")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxFirstDayOfYearAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : The first day of the year of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:first-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 1, 1) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:first-day-of-year(xs:date('2004-01-23')), functx:first-day-of-year( xs:dateTime('2004-01-23T12:00:13')), functx:first-day-of-year('2004-03-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-01 2004-01-01 2004-01-01")
    );
  }

  /**
   * ~ : The XML node in a sequence that appears first in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-node.html : @param $nodes the sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxFirstNode1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node in a sequence that appears first in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-node.html : @param $nodes the sequence of nodes :)\n" +
      "         declare function functx:first-node ( $nodes as node()* ) as node()? { ($nodes/.)[1] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:first-node($in-xml//fName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>Kate</fName>", false)
    );
  }

  /**
   * ~ : The XML node in a sequence that appears first in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-node.html : @param $nodes the sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxFirstNode2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node in a sequence that appears first in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-node.html : @param $nodes the sequence of nodes :)\n" +
      "         declare function functx:first-node ( $nodes as node()* ) as node()? { ($nodes/.)[1] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:first-node( ($in-xml//lName, $in-xml//fName) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>Kate</fName>", false)
    );
  }

  /**
   * ~ : The XML node in a sequence that appears first in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-node.html : @param $nodes the sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxFirstNodeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node in a sequence that appears first in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_first-node.html : @param $nodes the sequence of nodes :)\n" +
      "         declare function functx:first-node ( $nodes as node()* ) as node()? { ($nodes/.)[1] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:first-node($in-xml//fName), functx:first-node( ($in-xml//lName, $in-xml//fName) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>Kate</fName><fName>Kate</fName>", false)
    );
  }

  /**
   * ~ : Whether an XML node follows another without being its descendant : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_follows-not-descendant.html : @param $a the first node : @param $b the second node .
   */
  @org.junit.Test
  public void functxFunctxFollowsNotDescendant1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node follows another without being its descendant : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_follows-not-descendant.html : @param $a the first node : @param $b the second node :)\n" +
      "         declare function functx:follows-not-descendant ( $a as node()? , $b as node()? ) as xs:boolean { $a >> $b and empty($b intersect $a/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:follows-not-descendant( $in-xml//author[2],$in-xml//author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node follows another without being its descendant : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_follows-not-descendant.html : @param $a the first node : @param $b the second node .
   */
  @org.junit.Test
  public void functxFunctxFollowsNotDescendant2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node follows another without being its descendant : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_follows-not-descendant.html : @param $a the first node : @param $b the second node :)\n" +
      "         declare function functx:follows-not-descendant ( $a as node()? , $b as node()? ) as xs:boolean { $a >> $b and empty($b intersect $a/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:follows-not-descendant( $in-xml//author[1]/fName, $in-xml//author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node follows another without being its descendant : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_follows-not-descendant.html : @param $a the first node : @param $b the second node .
   */
  @org.junit.Test
  public void functxFunctxFollowsNotDescendant3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node follows another without being its descendant : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_follows-not-descendant.html : @param $a the first node : @param $b the second node :)\n" +
      "         declare function functx:follows-not-descendant ( $a as node()? , $b as node()? ) as xs:boolean { $a >> $b and empty($b intersect $a/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:follows-not-descendant( $in-xml//author[1],$in-xml//author[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node follows another without being its descendant : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_follows-not-descendant.html : @param $a the first node : @param $b the second node .
   */
  @org.junit.Test
  public void functxFunctxFollowsNotDescendantAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node follows another without being its descendant : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_follows-not-descendant.html : @param $a the first node : @param $b the second node :)\n" +
      "         declare function functx:follows-not-descendant ( $a as node()? , $b as node()? ) as xs:boolean { $a >> $b and empty($b intersect $a/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:follows-not-descendant( $in-xml//author[2],$in-xml//author[1]), functx:follows-not-descendant( $in-xml//author[1]/fName, $in-xml//author[1]), functx:follows-not-descendant( $in-xml//author[1],$in-xml//author[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false false")
    );
  }

  /**
   * ~ : Moves title words like "the" and "a" to the end of strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_format-as-title-en.html : @param $titles the titles to format ~ : The substring before the first text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-match.html : @param $arg the string to substring : @param $regex the regular expression .
   */
  @org.junit.Test
  public void functxFunctxFormatAsTitleEn1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Moves title words like \"the\" and \"a\" to the end of strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_format-as-title-en.html : @param $titles the titles to format :)\n" +
      "         declare function functx:format-as-title-en ( $titles as xs:string* ) as xs:string* { let $wordsToMoveToEnd := ('A', 'An', 'The') for $title in $titles let $firstWord := functx:substring-before-match($title,'\\W') return if ($firstWord = $wordsToMoveToEnd) then replace($title,'(.*?)\\W(.*)', '$2, $1') else $title } ;\n" +
      "                    (:~ : The substring before the first text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-before-match.html : @param $arg the string to substring : @param $regex the regular expression :)\n" +
      "         declare function functx:substring-before-match ( $arg as xs:string? , $regex as xs:string ) as xs:string? { tokenize($arg,$regex)[1] } ;\n" +
      "                    (functx:format-as-title-en( ('A Midsummer Night''s Dream', 'The Merchant of Venice', 'Hamlet')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Midsummer Night's Dream, A Merchant of Venice, The Hamlet")
    );
  }

  /**
   * ~ : Returns the fragment from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_fragment-from-uri.html : @param $uri the URI .
   */
  @org.junit.Test
  public void functxFunctxFragmentFromUri1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns the fragment from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_fragment-from-uri.html : @param $uri the URI :)\n" +
      "         declare function functx:fragment-from-uri ( $uri as xs:string? ) as xs:string? { substring-after($uri,'#') } ;\n" +
      "                    (functx:fragment-from-uri( 'http://datypic.com/index.htm#abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abc")
    );
  }

  /**
   * ~ : Returns the fragment from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_fragment-from-uri.html : @param $uri the URI .
   */
  @org.junit.Test
  public void functxFunctxFragmentFromUri2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns the fragment from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_fragment-from-uri.html : @param $uri the URI :)\n" +
      "         declare function functx:fragment-from-uri ( $uri as xs:string? ) as xs:string? { substring-after($uri,'#') } ;\n" +
      "                    (functx:fragment-from-uri( 'http://datypic.com/index.htm'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : Returns the fragment from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_fragment-from-uri.html : @param $uri the URI .
   */
  @org.junit.Test
  public void functxFunctxFragmentFromUriAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns the fragment from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_fragment-from-uri.html : @param $uri the URI :)\n" +
      "         declare function functx:fragment-from-uri ( $uri as xs:string? ) as xs:string? { substring-after($uri,'#') } ;\n" +
      "                    (functx:fragment-from-uri( 'http://datypic.com/index.htm#abc'), functx:fragment-from-uri( 'http://datypic.com/index.htm'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abc ")
    );
  }

  /**
   * ~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern ~ : Return the matching regions of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches.html : @param $string the string to split : @param $regex the pattern ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxGetMatches1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches-and-non-matches ( $string as xs:string? , $regex as xs:string ) as element()* { let $iomf := functx:index-of-match-first($string, $regex) return if (empty($iomf)) then <non-match>{$string}</non-match> else if ($iomf > 1) then (<non-match>{substring($string,1,$iomf - 1)}</non-match>, functx:get-matches-and-non-matches( substring($string,$iomf),$regex)) else let $length := string-length($string) - string-length(functx:replace-first($string, $regex,'')) return (<match>{substring($string,1,$length)}</match>, if (string-length($string) > $length) then functx:get-matches-and-non-matches( substring($string,$length + 1),$regex) else ()) } ;\n" +
      "                    (:~ : Return the matching regions of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches ( $string as xs:string? , $regex as xs:string ) as xs:string* { functx:get-matches-and-non-matches($string,$regex)/ string(self::match) } ;\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:get-matches( 'abc123def', '\\d+'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, " 123 ")
    );
  }

  /**
   * ~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern ~ : Return the matching regions of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches.html : @param $string the string to split : @param $regex the pattern ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxGetMatches2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches-and-non-matches ( $string as xs:string? , $regex as xs:string ) as element()* { let $iomf := functx:index-of-match-first($string, $regex) return if (empty($iomf)) then <non-match>{$string}</non-match> else if ($iomf > 1) then (<non-match>{substring($string,1,$iomf - 1)}</non-match>, functx:get-matches-and-non-matches( substring($string,$iomf),$regex)) else let $length := string-length($string) - string-length(functx:replace-first($string, $regex,'')) return (<match>{substring($string,1,$length)}</match>, if (string-length($string) > $length) then functx:get-matches-and-non-matches( substring($string,$length + 1),$regex) else ()) } ;\n" +
      "                    (:~ : Return the matching regions of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches ( $string as xs:string? , $regex as xs:string ) as xs:string* { functx:get-matches-and-non-matches($string,$regex)/ string(self::match) } ;\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:get-matches( 'abc123def', '\\d'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, " 1 2 3 ")
    );
  }

  /**
   * ~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern ~ : Return the matching regions of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches.html : @param $string the string to split : @param $regex the pattern ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxGetMatches3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches-and-non-matches ( $string as xs:string? , $regex as xs:string ) as element()* { let $iomf := functx:index-of-match-first($string, $regex) return if (empty($iomf)) then <non-match>{$string}</non-match> else if ($iomf > 1) then (<non-match>{substring($string,1,$iomf - 1)}</non-match>, functx:get-matches-and-non-matches( substring($string,$iomf),$regex)) else let $length := string-length($string) - string-length(functx:replace-first($string, $regex,'')) return (<match>{substring($string,1,$length)}</match>, if (string-length($string) > $length) then functx:get-matches-and-non-matches( substring($string,$length + 1),$regex) else ()) } ;\n" +
      "                    (:~ : Return the matching regions of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches ( $string as xs:string? , $regex as xs:string ) as xs:string* { functx:get-matches-and-non-matches($string,$regex)/ string(self::match) } ;\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:get-matches( 'abc123def', '[a-z]{2}'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "ab  de ")
    );
  }

  /**
   * ~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern ~ : Return the matching regions of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches.html : @param $string the string to split : @param $regex the pattern ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxGetMatchesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches-and-non-matches ( $string as xs:string? , $regex as xs:string ) as element()* { let $iomf := functx:index-of-match-first($string, $regex) return if (empty($iomf)) then <non-match>{$string}</non-match> else if ($iomf > 1) then (<non-match>{substring($string,1,$iomf - 1)}</non-match>, functx:get-matches-and-non-matches( substring($string,$iomf),$regex)) else let $length := string-length($string) - string-length(functx:replace-first($string, $regex,'')) return (<match>{substring($string,1,$length)}</match>, if (string-length($string) > $length) then functx:get-matches-and-non-matches( substring($string,$length + 1),$regex) else ()) } ;\n" +
      "                    (:~ : Return the matching regions of a string : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches ( $string as xs:string? , $regex as xs:string ) as xs:string* { functx:get-matches-and-non-matches($string,$regex)/ string(self::match) } ;\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:get-matches( 'abc123def', '\\d+'), functx:get-matches( 'abc123def', '\\d'), functx:get-matches( 'abc123def', '[a-z]{2}'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, " 123   1 2 3  ab  de ")
    );
  }

  /**
   * ~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxGetMatchesAndNonMatches1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches-and-non-matches ( $string as xs:string? , $regex as xs:string ) as element()* { let $iomf := functx:index-of-match-first($string, $regex) return if (empty($iomf)) then <non-match>{$string}</non-match> else if ($iomf > 1) then (<non-match>{substring($string,1,$iomf - 1)}</non-match>, functx:get-matches-and-non-matches( substring($string,$iomf),$regex)) else let $length := string-length($string) - string-length(functx:replace-first($string, $regex,'')) return (<match>{substring($string,1,$length)}</match>, if (string-length($string) > $length) then functx:get-matches-and-non-matches( substring($string,$length + 1),$regex) else ()) } ;\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:get-matches-and-non-matches( 'abc123def', '\\d+'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<non-match>abc</non-match><match>123</match><non-match>def</non-match>", false)
    );
  }

  /**
   * ~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxGetMatchesAndNonMatches2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches-and-non-matches ( $string as xs:string? , $regex as xs:string ) as element()* { let $iomf := functx:index-of-match-first($string, $regex) return if (empty($iomf)) then <non-match>{$string}</non-match> else if ($iomf > 1) then (<non-match>{substring($string,1,$iomf - 1)}</non-match>, functx:get-matches-and-non-matches( substring($string,$iomf),$regex)) else let $length := string-length($string) - string-length(functx:replace-first($string, $regex,'')) return (<match>{substring($string,1,$length)}</match>, if (string-length($string) > $length) then functx:get-matches-and-non-matches( substring($string,$length + 1),$regex) else ()) } ;\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:get-matches-and-non-matches( 'abc123def', '\\d'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<non-match>abc</non-match><match>1</match><match>2</match><match>3</match><non-match>def</non-match>", false)
    );
  }

  /**
   * ~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxGetMatchesAndNonMatches3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches-and-non-matches ( $string as xs:string? , $regex as xs:string ) as element()* { let $iomf := functx:index-of-match-first($string, $regex) return if (empty($iomf)) then <non-match>{$string}</non-match> else if ($iomf > 1) then (<non-match>{substring($string,1,$iomf - 1)}</non-match>, functx:get-matches-and-non-matches( substring($string,$iomf),$regex)) else let $length := string-length($string) - string-length(functx:replace-first($string, $regex,'')) return (<match>{substring($string,1,$length)}</match>, if (string-length($string) > $length) then functx:get-matches-and-non-matches( substring($string,$length + 1),$regex) else ()) } ;\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:get-matches-and-non-matches( 'abc123def', '[a-z]{2}'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<match>ab</match><non-match>c123</non-match><match>de</match><non-match>f</non-match>", false)
    );
  }

  /**
   * ~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxGetMatchesAndNonMatchesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Splits a string into matching and non-matching regions : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_get-matches-and-non-matches.html : @param $string the string to split : @param $regex the pattern :)\n" +
      "         declare function functx:get-matches-and-non-matches ( $string as xs:string? , $regex as xs:string ) as element()* { let $iomf := functx:index-of-match-first($string, $regex) return if (empty($iomf)) then <non-match>{$string}</non-match> else if ($iomf > 1) then (<non-match>{substring($string,1,$iomf - 1)}</non-match>, functx:get-matches-and-non-matches( substring($string,$iomf),$regex)) else let $length := string-length($string) - string-length(functx:replace-first($string, $regex,'')) return (<match>{substring($string,1,$length)}</match>, if (string-length($string) > $length) then functx:get-matches-and-non-matches( substring($string,$length + 1),$regex) else ()) } ;\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:get-matches-and-non-matches( 'abc123def', '\\d+'), functx:get-matches-and-non-matches( 'abc123def', '\\d'), functx:get-matches-and-non-matches( 'abc123def', '[a-z]{2}'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<non-match>abc</non-match><match>123</match><non-match>def</non-match><non-match>abc</non-match><match>1</match><match>2</match><match>3</match><non-match>def</non-match><match>ab</match><non-match>c123</non-match><match>de</match><non-match>f</non-match>", false)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContent1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/a))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContent2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/b))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContent3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/c))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContent4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/d))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContent5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/e))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContent6() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/f))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContent7() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/g))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContent8() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/h))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContent9() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/i))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasElementOnlyContentAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has element-only content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-element-only-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-element-only-content ( $element as element() ) as xs:boolean { not($element/text()[normalize-space(.) != '']) and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> <h><x>xml</x><y>xml</y></h> <i> <x>xml</x> <y>xml</y> </i> </in-xml> return (functx:has-element-only-content($in-xml/a), functx:has-element-only-content($in-xml/b), functx:has-element-only-content($in-xml/c), functx:has-element-only-content($in-xml/d), functx:has-element-only-content($in-xml/e), functx:has-element-only-content($in-xml/f), functx:has-element-only-content($in-xml/g), functx:has-element-only-content($in-xml/h), functx:has-element-only-content($in-xml/i))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "false false false false true false true true true")
    );
  }

  /**
   * ~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasEmptyContent1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-empty-content ( $element as element() ) as xs:boolean { not($element/node()) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-empty-content($in-xml/a))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasEmptyContent2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-empty-content ( $element as element() ) as xs:boolean { not($element/node()) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-empty-content($in-xml/b))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasEmptyContent3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-empty-content ( $element as element() ) as xs:boolean { not($element/node()) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-empty-content($in-xml/c))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasEmptyContent4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-empty-content ( $element as element() ) as xs:boolean { not($element/node()) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-empty-content($in-xml/d))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasEmptyContent5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-empty-content ( $element as element() ) as xs:boolean { not($element/node()) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-empty-content($in-xml/e))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasEmptyContent6() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-empty-content ( $element as element() ) as xs:boolean { not($element/node()) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-empty-content($in-xml/f))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasEmptyContent7() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-empty-content ( $element as element() ) as xs:boolean { not($element/node()) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-empty-content($in-xml/g))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasEmptyContentAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has empty content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-empty-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-empty-content ( $element as element() ) as xs:boolean { not($element/node()) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-empty-content($in-xml/a), functx:has-empty-content($in-xml/b), functx:has-empty-content($in-xml/c), functx:has-empty-content($in-xml/d), functx:has-empty-content($in-xml/e), functx:has-empty-content($in-xml/f), functx:has-empty-content($in-xml/g))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true true false false false false")
    );
  }

  /**
   * ~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasMixedContent1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-mixed-content ( $element as element() ) as xs:boolean { $element/text()[normalize-space(.) != ''] and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-mixed-content($in-xml/a))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasMixedContent2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-mixed-content ( $element as element() ) as xs:boolean { $element/text()[normalize-space(.) != ''] and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-mixed-content($in-xml/b))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasMixedContent3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-mixed-content ( $element as element() ) as xs:boolean { $element/text()[normalize-space(.) != ''] and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-mixed-content($in-xml/c))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasMixedContent4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-mixed-content ( $element as element() ) as xs:boolean { $element/text()[normalize-space(.) != ''] and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-mixed-content($in-xml/d))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasMixedContent5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-mixed-content ( $element as element() ) as xs:boolean { $element/text()[normalize-space(.) != ''] and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-mixed-content($in-xml/e))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasMixedContent6() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-mixed-content ( $element as element() ) as xs:boolean { $element/text()[normalize-space(.) != ''] and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-mixed-content($in-xml/f))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasMixedContent7() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-mixed-content ( $element as element() ) as xs:boolean { $element/text()[normalize-space(.) != ''] and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-mixed-content($in-xml/g))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasMixedContentAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has mixed content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-mixed-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-mixed-content ( $element as element() ) as xs:boolean { $element/text()[normalize-space(.) != ''] and $element/* } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> <g> <x>xml</x> </g> </in-xml> return (functx:has-mixed-content($in-xml/a), functx:has-mixed-content($in-xml/b), functx:has-mixed-content($in-xml/c), functx:has-mixed-content($in-xml/d), functx:has-mixed-content($in-xml/e), functx:has-mixed-content($in-xml/f), functx:has-mixed-content($in-xml/g))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "false false false false false true false")
    );
  }

  /**
   * ~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasSimpleContent1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-simple-content ( $element as element() ) as xs:boolean { $element/text() and not($element/*) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> </in-xml> return (functx:has-simple-content($in-xml/a))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasSimpleContent2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-simple-content ( $element as element() ) as xs:boolean { $element/text() and not($element/*) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> </in-xml> return (functx:has-simple-content($in-xml/b))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasSimpleContent3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-simple-content ( $element as element() ) as xs:boolean { $element/text() and not($element/*) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> </in-xml> return (functx:has-simple-content($in-xml/c))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasSimpleContent4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-simple-content ( $element as element() ) as xs:boolean { $element/text() and not($element/*) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> </in-xml> return (functx:has-simple-content($in-xml/d))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasSimpleContent5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-simple-content ( $element as element() ) as xs:boolean { $element/text() and not($element/*) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> </in-xml> return (functx:has-simple-content($in-xml/e))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasSimpleContent6() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-simple-content ( $element as element() ) as xs:boolean { $element/text() and not($element/*) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> </in-xml> return (functx:has-simple-content($in-xml/f))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test .
   */
  @org.junit.Test
  public void functxFunctxHasSimpleContentAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an element has simple content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_has-simple-content.html : @param $element the XML element to test :)\n" +
      "         declare function functx:has-simple-content ( $element as element() ) as xs:boolean { $element/text() and not($element/*) } ;\n" +
      "                    let $in-xml := <in-xml> <a></a> <b/> <c> </c> <d>xml</d> <e><x>xml</x></e> <f>mixed <x>xml</x></f> </in-xml> return (functx:has-simple-content($in-xml/a), functx:has-simple-content($in-xml/b), functx:has-simple-content($in-xml/c), functx:has-simple-content($in-xml/d), functx:has-simple-content($in-xml/e), functx:has-simple-content($in-xml/f))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "false false false true false false")
    );
  }

  /**
   * ~ : Gets the ID of an XML element : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_id-from-element.html : @param $element the element .
   */
  @org.junit.Test
  public void functxFunctxIdFromElement1() {
    final XQuery query = new XQuery(
      "\n" +
      "         declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare function functx:id-from-element ( $element as element()? ) as xs:string? { data(($element/@*[id(.) is ..])[1]) } ;\n" +
      "         let $book := (/) return (functx:id-from-element($book/book/section[1]))",
      ctx);
    try {
      query.context(node(file("app/FunctxFn/functx_book.xml")));
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "preface")
    );
  }

  /**
   * ~ : Gets XML element(s) that have an attribute with a particular value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_id-untyped.html : @param $node the root node(s) to start from : @param $id the "id" to find .
   */
  @org.junit.Test
  public void functxFunctxIdUntyped1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Gets XML element(s) that have an attribute with a particular value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_id-untyped.html : @param $node the root node(s) to start from : @param $id the \"id\" to find :)\n" +
      "         declare function functx:id-untyped ( $node as node()* , $id as xs:anyAtomicType ) as element()* { $node//*[@* = $id] } ;\n" +
      "                    let $in-xml := <in-xml> <a id=\"A001\">abc</a> <b foo=\"A001\">def</b> <c id=\"B001\">ghi</c> </in-xml> return (functx:id-untyped($in-xml,'B001'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<c id=\"B001\">ghi</c>", false)
    );
  }

  /**
   * ~ : Gets XML element(s) that have an attribute with a particular value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_id-untyped.html : @param $node the root node(s) to start from : @param $id the "id" to find .
   */
  @org.junit.Test
  public void functxFunctxIdUntyped2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Gets XML element(s) that have an attribute with a particular value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_id-untyped.html : @param $node the root node(s) to start from : @param $id the \"id\" to find :)\n" +
      "         declare function functx:id-untyped ( $node as node()* , $id as xs:anyAtomicType ) as element()* { $node//*[@* = $id] } ;\n" +
      "                    let $in-xml := <in-xml> <a id=\"A001\">abc</a> <b foo=\"A001\">def</b> <c id=\"B001\">ghi</c> </in-xml> return (functx:id-untyped($in-xml,'A001'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a id=\"A001\">abc</a><b foo=\"A001\">def</b>", false)
    );
  }

  /**
   * ~ : Gets XML element(s) that have an attribute with a particular value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_id-untyped.html : @param $node the root node(s) to start from : @param $id the "id" to find .
   */
  @org.junit.Test
  public void functxFunctxIdUntyped3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Gets XML element(s) that have an attribute with a particular value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_id-untyped.html : @param $node the root node(s) to start from : @param $id the \"id\" to find :)\n" +
      "         declare function functx:id-untyped ( $node as node()* , $id as xs:anyAtomicType ) as element()* { $node//*[@* = $id] } ;\n" +
      "                    let $in-xml := <in-xml> <a id=\"A001\">abc</a> <b foo=\"A001\">def</b> <c id=\"B001\">ghi</c> </in-xml> return (functx:id-untyped($in-xml,'C001'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : Gets XML element(s) that have an attribute with a particular value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_id-untyped.html : @param $node the root node(s) to start from : @param $id the "id" to find .
   */
  @org.junit.Test
  public void functxFunctxIdUntypedAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Gets XML element(s) that have an attribute with a particular value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_id-untyped.html : @param $node the root node(s) to start from : @param $id the \"id\" to find :)\n" +
      "         declare function functx:id-untyped ( $node as node()* , $id as xs:anyAtomicType ) as element()* { $node//*[@* = $id] } ;\n" +
      "                    let $in-xml := <in-xml> <a id=\"A001\">abc</a> <b foo=\"A001\">def</b> <c id=\"B001\">ghi</c> </in-xml> return (functx:id-untyped($in-xml,'B001'), functx:id-untyped($in-xml,'A001'), functx:id-untyped($in-xml,'C001'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<c id=\"B001\">ghi</c><a id=\"A001\">abc</a><b foo=\"A001\">def</b>", false)
    );
  }

  /**
   * ~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent .
   */
  @org.junit.Test
  public void functxFunctxIfAbsent1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent :)\n" +
      "         declare function functx:if-absent ( $arg as item()* , $value as item()* ) as item()* { if (exists($arg)) then $arg else $value } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"69.99\"/> <price value=\"49.99\" discount=\"\"/> </prices> return (data(functx:if-absent( $in-xml//price[1]/@discount, 0)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "10.00")
    );
  }

  /**
   * ~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent .
   */
  @org.junit.Test
  public void functxFunctxIfAbsent2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent :)\n" +
      "         declare function functx:if-absent ( $arg as item()* , $value as item()* ) as item()* { if (exists($arg)) then $arg else $value } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"69.99\"/> <price value=\"49.99\" discount=\"\"/> </prices> return (data(functx:if-absent( $in-xml//price[3]/@discount, 0)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("0")
    );
  }

  /**
   * ~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent .
   */
  @org.junit.Test
  public void functxFunctxIfAbsent3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent :)\n" +
      "         declare function functx:if-absent ( $arg as item()* , $value as item()* ) as item()* { if (exists($arg)) then $arg else $value } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"69.99\"/> <price value=\"49.99\" discount=\"\"/> </prices> return (data(functx:if-absent( $in-xml//price[4]/@discount, 0)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent .
   */
  @org.junit.Test
  public void functxFunctxIfAbsentAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent :)\n" +
      "         declare function functx:if-absent ( $arg as item()* , $value as item()* ) as item()* { if (exists($arg)) then $arg else $value } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"69.99\"/> <price value=\"49.99\" discount=\"\"/> </prices> return (data(functx:if-absent( $in-xml//price[1]/@discount, 0)), data(functx:if-absent( $in-xml//price[3]/@discount, 0)), data(functx:if-absent( $in-xml//price[4]/@discount, 0)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "10.00 0 ")
    );
  }

  /**
   * ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxIfEmpty1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml := <prices> <price discount=\"10.00\">29.99</price> <price discount=\"6.00\">39.99</price> <price></price> <price discount=\"\">49.99</price> </prices> return (functx:if-empty($in-xml//price[1], 0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "29.99")
    );
  }

  /**
   * ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxIfEmpty2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml := <prices> <price discount=\"10.00\">29.99</price> <price discount=\"6.00\">39.99</price> <price></price> <price discount=\"\">49.99</price> </prices> return (functx:if-empty($in-xml//price[3], 0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("0")
    );
  }

  /**
   * ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxIfEmpty3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml := <prices> <price discount=\"10.00\">29.99</price> <price discount=\"6.00\">39.99</price> <price></price> <price discount=\"\">49.99</price> </prices> return (functx:if-empty($in-xml//price[99], 0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("0")
    );
  }

  /**
   * ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxIfEmpty4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml := <prices> <price discount=\"10.00\">29.99</price> <price discount=\"6.00\">39.99</price> <price></price> <price discount=\"\">49.99</price> </prices> return (functx:if-empty($in-xml//price[1]/@discount, 0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "10.00")
    );
  }

  /**
   * ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxIfEmpty5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml := <prices> <price discount=\"10.00\">29.99</price> <price discount=\"6.00\">39.99</price> <price></price> <price discount=\"\">49.99</price> </prices> return (functx:if-empty($in-xml//price[3]/@discount, 0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("0")
    );
  }

  /**
   * ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxIfEmpty6() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml := <prices> <price discount=\"10.00\">29.99</price> <price discount=\"6.00\">39.99</price> <price></price> <price discount=\"\">49.99</price> </prices> return (functx:if-empty($in-xml//price[4]/@discount, 0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("0")
    );
  }

  /**
   * ~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty .
   */
  @org.junit.Test
  public void functxFunctxIfEmptyAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not blank, otherwise the second argument : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-empty.html : @param $arg the node that may be empty : @param $value the item(s) to use if the node is empty :)\n" +
      "         declare function functx:if-empty ( $arg as item()? , $value as item()* ) as item()* { if (string($arg) != '') then data($arg) else $value } ;\n" +
      "                    let $in-xml := <prices> <price discount=\"10.00\">29.99</price> <price discount=\"6.00\">39.99</price> <price></price> <price discount=\"\">49.99</price> </prices> return (functx:if-empty($in-xml//price[1], 0), functx:if-empty($in-xml//price[3], 0), functx:if-empty($in-xml//price[99], 0), functx:if-empty($in-xml//price[1]/@discount, 0), functx:if-empty($in-xml//price[3]/@discount, 0), functx:if-empty($in-xml//price[4]/@discount, 0))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "29.99 0 0 10.00 0 0")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-deep-equal-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence .
   */
  @org.junit.Test
  public void functxFunctxIndexOfDeepEqualNode1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-deep-equal-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-deep-equal-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[deep-equal($nodes[$seq],$nodeToFind)] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName/> <lName>Smith</lName> </author> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return let $anotherAuthor := <author> <fName>John</fName> <lName>Smith</lName> </author> return (functx:index-of-deep-equal-node( $in-xml/author,$anAuthor))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-deep-equal-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence .
   */
  @org.junit.Test
  public void functxFunctxIndexOfDeepEqualNode2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-deep-equal-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-deep-equal-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[deep-equal($nodes[$seq],$nodeToFind)] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName/> <lName>Smith</lName> </author> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return let $anotherAuthor := <author> <fName>John</fName> <lName>Smith</lName> </author> return (functx:index-of-deep-equal-node( $in-xml/author,$anotherAuthor))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-deep-equal-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence .
   */
  @org.junit.Test
  public void functxFunctxIndexOfDeepEqualNode3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-deep-equal-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-deep-equal-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[deep-equal($nodes[$seq],$nodeToFind)] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName/> <lName>Smith</lName> </author> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return let $anotherAuthor := <author> <fName>John</fName> <lName>Smith</lName> </author> return (functx:index-of-deep-equal-node( $in-xml/author/lName,$anAuthor/lName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-deep-equal-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence .
   */
  @org.junit.Test
  public void functxFunctxIndexOfDeepEqualNodeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-deep-equal-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-deep-equal-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[deep-equal($nodes[$seq],$nodeToFind)] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName/> <lName>Smith</lName> </author> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return let $anotherAuthor := <author> <fName>John</fName> <lName>Smith</lName> </author> return (functx:index-of-deep-equal-node( $in-xml/author,$anAuthor), functx:index-of-deep-equal-node( $in-xml/author,$anotherAuthor), functx:index-of-deep-equal-node( $in-xml/author/lName,$anAuthor/lName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2 2")
    );
  }

  /**
   * ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match .
   */
  @org.junit.Test
  public void functxFunctxIndexOfMatchFirst1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (functx:index-of-match-first( 'abcdabcdabcd','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match .
   */
  @org.junit.Test
  public void functxFunctxIndexOfMatchFirst2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (functx:index-of-match-first( 'abcdabcdabcd','bcd'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match .
   */
  @org.junit.Test
  public void functxFunctxIndexOfMatchFirst3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (functx:index-of-match-first('a1234','\\d'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match .
   */
  @org.junit.Test
  public void functxFunctxIndexOfMatchFirst4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (functx:index-of-match-first('abc abc','\\s'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("4")
    );
  }

  /**
   * ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match .
   */
  @org.junit.Test
  public void functxFunctxIndexOfMatchFirst5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (functx:index-of-match-first('abc abc','z'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match .
   */
  @org.junit.Test
  public void functxFunctxIndexOfMatchFirstAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a matching substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-match-first.html : @param $arg the string : @param $pattern the pattern to match :)\n" +
      "         declare function functx:index-of-match-first ( $arg as xs:string? , $pattern as xs:string ) as xs:integer? { if (matches($arg,$pattern)) then string-length(tokenize($arg, $pattern)[1]) + 1 else () } ;\n" +
      "                    (functx:index-of-match-first( 'abcdabcdabcd','abc'), functx:index-of-match-first( 'abcdabcdabcd','bcd'), functx:index-of-match-first('a1234','\\d'), functx:index-of-match-first('abc abc','\\s'), functx:index-of-match-first('abc abc','z'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 2 2 4")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence .
   */
  @org.junit.Test
  public void functxFunctxIndexOfNode1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[$nodes[$seq] is $nodeToFind] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:index-of-node( $in-xml/author,$in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence .
   */
  @org.junit.Test
  public void functxFunctxIndexOfNode2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[$nodes[$seq] is $nodeToFind] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:index-of-node( $in-xml/author,$in-xml/author[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence .
   */
  @org.junit.Test
  public void functxFunctxIndexOfNode3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[$nodes[$seq] is $nodeToFind] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:index-of-node( $in-xml/author, $in-xml/author[lName='Doe']))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence .
   */
  @org.junit.Test
  public void functxFunctxIndexOfNodeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[$nodes[$seq] is $nodeToFind] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:index-of-node( $in-xml/author,$in-xml/author[1]), functx:index-of-node( $in-xml/author,$in-xml/author[2]), functx:index-of-node( $in-xml/author, $in-xml/author[lName='Doe']))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 2 2")
    );
  }

  /**
   * ~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfString1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string ( $arg as xs:string? , $substring as xs:string ) as xs:integer* { if (contains($arg, $substring)) then (string-length(substring-before($arg, $substring))+1, for $other in functx:index-of-string(substring-after($arg, $substring), $substring) return $other + string-length(substring-before($arg, $substring)) + string-length($substring)) else () } ;\n" +
      "                    (functx:index-of-string('abcdabcdabcd','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 5 9")
    );
  }

  /**
   * ~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfString2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string ( $arg as xs:string? , $substring as xs:string ) as xs:integer* { if (contains($arg, $substring)) then (string-length(substring-before($arg, $substring))+1, for $other in functx:index-of-string(substring-after($arg, $substring), $substring) return $other + string-length(substring-before($arg, $substring)) + string-length($substring)) else () } ;\n" +
      "                    (functx:index-of-string('abcd','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfString3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string ( $arg as xs:string? , $substring as xs:string ) as xs:integer* { if (contains($arg, $substring)) then (string-length(substring-before($arg, $substring))+1, for $other in functx:index-of-string(substring-after($arg, $substring), $substring) return $other + string-length(substring-before($arg, $substring)) + string-length($substring)) else () } ;\n" +
      "                    (functx:index-of-string('xxx','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfStringAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string ( $arg as xs:string? , $substring as xs:string ) as xs:integer* { if (contains($arg, $substring)) then (string-length(substring-before($arg, $substring))+1, for $other in functx:index-of-string(substring-after($arg, $substring), $substring) return $other + string-length(substring-before($arg, $substring)) + string-length($substring)) else () } ;\n" +
      "                    (functx:index-of-string('abcdabcdabcd','abc'), functx:index-of-string('abcd','abc'), functx:index-of-string('xxx','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 5 9 1")
    );
  }

  /**
   * ~ : The first position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-first.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfStringFirst1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-first.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string-first ( $arg as xs:string? , $substring as xs:string ) as xs:integer? { if (contains($arg, $substring)) then string-length(substring-before($arg, $substring))+1 else () } ;\n" +
      "                    (functx:index-of-string-first( 'abcdabcdabcd','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : The first position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-first.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfStringFirst2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-first.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string-first ( $arg as xs:string? , $substring as xs:string ) as xs:integer? { if (contains($arg, $substring)) then string-length(substring-before($arg, $substring))+1 else () } ;\n" +
      "                    (functx:index-of-string-first( 'abcd','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : The first position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-first.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfStringFirst3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-first.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string-first ( $arg as xs:string? , $substring as xs:string ) as xs:integer? { if (contains($arg, $substring)) then string-length(substring-before($arg, $substring))+1 else () } ;\n" +
      "                    (functx:index-of-string-first( 'xxx','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : The first position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-first.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfStringFirstAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-first.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string-first ( $arg as xs:string? , $substring as xs:string ) as xs:integer? { if (contains($arg, $substring)) then string-length(substring-before($arg, $substring))+1 else () } ;\n" +
      "                    (functx:index-of-string-first( 'abcdabcdabcd','abc'), functx:index-of-string-first( 'abcd','abc'), functx:index-of-string-first( 'xxx','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 1")
    );
  }

  /**
   * ~ : The last position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-last.html : @param $arg the string : @param $substring the substring to find ~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfStringLast1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The last position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-last.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string-last ( $arg as xs:string? , $substring as xs:string ) as xs:integer? { functx:index-of-string($arg, $substring)[last()] } ;\n" +
      "                    (:~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string ( $arg as xs:string? , $substring as xs:string ) as xs:integer* { if (contains($arg, $substring)) then (string-length(substring-before($arg, $substring))+1, for $other in functx:index-of-string(substring-after($arg, $substring), $substring) return $other + string-length(substring-before($arg, $substring)) + string-length($substring)) else () } ;\n" +
      "                    (functx:index-of-string-last( 'abcdabcdabcd','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("9")
    );
  }

  /**
   * ~ : The last position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-last.html : @param $arg the string : @param $substring the substring to find ~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfStringLast2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The last position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-last.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string-last ( $arg as xs:string? , $substring as xs:string ) as xs:integer? { functx:index-of-string($arg, $substring)[last()] } ;\n" +
      "                    (:~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string ( $arg as xs:string? , $substring as xs:string ) as xs:integer* { if (contains($arg, $substring)) then (string-length(substring-before($arg, $substring))+1, for $other in functx:index-of-string(substring-after($arg, $substring), $substring) return $other + string-length(substring-before($arg, $substring)) + string-length($substring)) else () } ;\n" +
      "                    (functx:index-of-string-last( 'abcd','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : The last position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-last.html : @param $arg the string : @param $substring the substring to find ~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfStringLast3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The last position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-last.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string-last ( $arg as xs:string? , $substring as xs:string ) as xs:integer? { functx:index-of-string($arg, $substring)[last()] } ;\n" +
      "                    (:~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string ( $arg as xs:string? , $substring as xs:string ) as xs:integer* { if (contains($arg, $substring)) then (string-length(substring-before($arg, $substring))+1, for $other in functx:index-of-string(substring-after($arg, $substring), $substring) return $other + string-length(substring-before($arg, $substring)) + string-length($substring)) else () } ;\n" +
      "                    (functx:index-of-string-last( 'xxx','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : The last position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-last.html : @param $arg the string : @param $substring the substring to find ~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find .
   */
  @org.junit.Test
  public void functxFunctxIndexOfStringLastAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The last position of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string-last.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string-last ( $arg as xs:string? , $substring as xs:string ) as xs:integer? { functx:index-of-string($arg, $substring)[last()] } ;\n" +
      "                    (:~ : The position(s) of a substring : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-string.html : @param $arg the string : @param $substring the substring to find :)\n" +
      "         declare function functx:index-of-string ( $arg as xs:string? , $substring as xs:string ) as xs:integer* { if (contains($arg, $substring)) then (string-length(substring-before($arg, $substring))+1, for $other in functx:index-of-string(substring-after($arg, $substring), $substring) return $other + string-length(substring-before($arg, $substring)) + string-length($substring)) else () } ;\n" +
      "                    (functx:index-of-string-last( 'abcdabcdabcd','abc'), functx:index-of-string-last( 'abcd','abc'), functx:index-of-string-last( 'xxx','abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "9 1")
    );
  }

  /**
   * ~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position .
   */
  @org.junit.Test
  public void functxFunctxInsertString1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position :)\n" +
      "         declare function functx:insert-string ( $originalString as xs:string? , $stringToInsert as xs:string? , $pos as xs:integer ) as xs:string { concat(substring($originalString,1,$pos - 1), $stringToInsert, substring($originalString,$pos)) } ;\n" +
      "                    (functx:insert-string('xyz','def',2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xdefyz")
    );
  }

  /**
   * ~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position .
   */
  @org.junit.Test
  public void functxFunctxInsertString2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position :)\n" +
      "         declare function functx:insert-string ( $originalString as xs:string? , $stringToInsert as xs:string? , $pos as xs:integer ) as xs:string { concat(substring($originalString,1,$pos - 1), $stringToInsert, substring($originalString,$pos)) } ;\n" +
      "                    (functx:insert-string('xyz','def',5))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xyzdef")
    );
  }

  /**
   * ~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position .
   */
  @org.junit.Test
  public void functxFunctxInsertString3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position :)\n" +
      "         declare function functx:insert-string ( $originalString as xs:string? , $stringToInsert as xs:string? , $pos as xs:integer ) as xs:string { concat(substring($originalString,1,$pos - 1), $stringToInsert, substring($originalString,$pos)) } ;\n" +
      "                    (functx:insert-string('xyz','',2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xyz")
    );
  }

  /**
   * ~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position .
   */
  @org.junit.Test
  public void functxFunctxInsertString4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position :)\n" +
      "         declare function functx:insert-string ( $originalString as xs:string? , $stringToInsert as xs:string? , $pos as xs:integer ) as xs:string { concat(substring($originalString,1,$pos - 1), $stringToInsert, substring($originalString,$pos)) } ;\n" +
      "                    (functx:insert-string('','def',2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "def")
    );
  }

  /**
   * ~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position .
   */
  @org.junit.Test
  public void functxFunctxInsertStringAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Inserts a string at a specified position : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_insert-string.html : @param $originalString the original string to insert into : @param $stringToInsert the string to insert : @param $pos the position :)\n" +
      "         declare function functx:insert-string ( $originalString as xs:string? , $stringToInsert as xs:string? , $pos as xs:integer ) as xs:string { concat(substring($originalString,1,$pos - 1), $stringToInsert, substring($originalString,$pos)) } ;\n" +
      "                    (functx:insert-string('xyz','def',2), functx:insert-string('xyz','def',5), functx:insert-string('xyz','',2), functx:insert-string('','def',2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xdefyz xyzdef xyz def")
    );
  }

  /**
   * ~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test .
   */
  @org.junit.Test
  public void functxFunctxIsANumber1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test :)\n" +
      "         declare function functx:is-a-number ( $value as xs:anyAtomicType? ) as xs:boolean { string(number($value)) != 'NaN' } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>abc</b> </in-xml> return (functx:is-a-number('123'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test .
   */
  @org.junit.Test
  public void functxFunctxIsANumber2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test :)\n" +
      "         declare function functx:is-a-number ( $value as xs:anyAtomicType? ) as xs:boolean { string(number($value)) != 'NaN' } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>abc</b> </in-xml> return (functx:is-a-number(123))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test .
   */
  @org.junit.Test
  public void functxFunctxIsANumber3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test :)\n" +
      "         declare function functx:is-a-number ( $value as xs:anyAtomicType? ) as xs:boolean { string(number($value)) != 'NaN' } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>abc</b> </in-xml> return (functx:is-a-number(' 123 '))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test .
   */
  @org.junit.Test
  public void functxFunctxIsANumber4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test :)\n" +
      "         declare function functx:is-a-number ( $value as xs:anyAtomicType? ) as xs:boolean { string(number($value)) != 'NaN' } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>abc</b> </in-xml> return (functx:is-a-number(''))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test .
   */
  @org.junit.Test
  public void functxFunctxIsANumber5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test :)\n" +
      "         declare function functx:is-a-number ( $value as xs:anyAtomicType? ) as xs:boolean { string(number($value)) != 'NaN' } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>abc</b> </in-xml> return (functx:is-a-number('123abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test .
   */
  @org.junit.Test
  public void functxFunctxIsANumber6() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test :)\n" +
      "         declare function functx:is-a-number ( $value as xs:anyAtomicType? ) as xs:boolean { string(number($value)) != 'NaN' } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>abc</b> </in-xml> return (functx:is-a-number('NaN'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test .
   */
  @org.junit.Test
  public void functxFunctxIsANumber7() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test :)\n" +
      "         declare function functx:is-a-number ( $value as xs:anyAtomicType? ) as xs:boolean { string(number($value)) != 'NaN' } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>abc</b> </in-xml> return (functx:is-a-number($in-xml/a))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test .
   */
  @org.junit.Test
  public void functxFunctxIsANumber8() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test :)\n" +
      "         declare function functx:is-a-number ( $value as xs:anyAtomicType? ) as xs:boolean { string(number($value)) != 'NaN' } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>abc</b> </in-xml> return (functx:is-a-number($in-xml/b))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test .
   */
  @org.junit.Test
  public void functxFunctxIsANumberAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a value is numeric : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-a-number.html : @param $value the value to test :)\n" +
      "         declare function functx:is-a-number ( $value as xs:anyAtomicType? ) as xs:boolean { string(number($value)) != 'NaN' } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>abc</b> </in-xml> return (functx:is-a-number('123'), functx:is-a-number(123), functx:is-a-number(' 123 '), functx:is-a-number(''), functx:is-a-number('123abc'), functx:is-a-number('NaN'), functx:is-a-number($in-xml/a), functx:is-a-number($in-xml/b))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true true false false false true false")
    );
  }

  /**
   * ~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test .
   */
  @org.junit.Test
  public void functxFunctxIsAbsoluteUri1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test :)\n" +
      "         declare function functx:is-absolute-uri ( $uri as xs:string? ) as xs:boolean { matches($uri,'^[a-z]+:') } ;\n" +
      "                    (functx:is-absolute-uri( 'http://www.datypic.com'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test .
   */
  @org.junit.Test
  public void functxFunctxIsAbsoluteUri2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test :)\n" +
      "         declare function functx:is-absolute-uri ( $uri as xs:string? ) as xs:boolean { matches($uri,'^[a-z]+:') } ;\n" +
      "                    (functx:is-absolute-uri( 'ftp://ftp.datypic.com'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test .
   */
  @org.junit.Test
  public void functxFunctxIsAbsoluteUri3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test :)\n" +
      "         declare function functx:is-absolute-uri ( $uri as xs:string? ) as xs:boolean { matches($uri,'^[a-z]+:') } ;\n" +
      "                    (functx:is-absolute-uri('ftp.datypic.com'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test .
   */
  @org.junit.Test
  public void functxFunctxIsAbsoluteUri4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test :)\n" +
      "         declare function functx:is-absolute-uri ( $uri as xs:string? ) as xs:boolean { matches($uri,'^[a-z]+:') } ;\n" +
      "                    (functx:is-absolute-uri('www.datypic.com'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test .
   */
  @org.junit.Test
  public void functxFunctxIsAbsoluteUri5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test :)\n" +
      "         declare function functx:is-absolute-uri ( $uri as xs:string? ) as xs:boolean { matches($uri,'^[a-z]+:') } ;\n" +
      "                    (functx:is-absolute-uri('prod.html'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test .
   */
  @org.junit.Test
  public void functxFunctxIsAbsoluteUriAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a URI is absolute : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-absolute-uri.html : @param $uri the URI to test :)\n" +
      "         declare function functx:is-absolute-uri ( $uri as xs:string? ) as xs:boolean { matches($uri,'^[a-z]+:') } ;\n" +
      "                    (functx:is-absolute-uri( 'http://www.datypic.com'), functx:is-absolute-uri( 'ftp://ftp.datypic.com'), functx:is-absolute-uri('ftp.datypic.com'), functx:is-absolute-uri('www.datypic.com'), functx:is-absolute-uri('prod.html'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true false false false")
    );
  }

  /**
   * ~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsAncestor1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-ancestor ( $node1 as node() , $node2 as node() ) as xs:boolean { exists($node1 intersect $node2/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-ancestor( $in-xml//author[1], $in-xml//author[1]/fName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsAncestor2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-ancestor ( $node1 as node() , $node2 as node() ) as xs:boolean { exists($node1 intersect $node2/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-ancestor( $in-xml//author[1]/fName, $in-xml//author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsAncestor3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-ancestor ( $node1 as node() , $node2 as node() ) as xs:boolean { exists($node1 intersect $node2/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-ancestor( $in-xml//author[1]/fName, $in-xml//author[1]/fName/text()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsAncestor4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-ancestor ( $node1 as node() , $node2 as node() ) as xs:boolean { exists($node1 intersect $node2/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-ancestor( $in-xml//author[1], $in-xml//author[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsAncestorAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is an ancestor of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-ancestor.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-ancestor ( $node1 as node() , $node2 as node() ) as xs:boolean { exists($node1 intersect $node2/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-ancestor( $in-xml//author[1], $in-xml//author[1]/fName), functx:is-ancestor( $in-xml//author[1]/fName, $in-xml//author[1]), functx:is-ancestor( $in-xml//author[1]/fName, $in-xml//author[1]/fName/text()), functx:is-ancestor( $in-xml//author[1], $in-xml//author[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false true false")
    );
  }

  /**
   * ~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsDescendant1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-descendant ( $node1 as node() , $node2 as node() ) as xs:boolean { boolean($node2 intersect $node1/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-descendant( $in-xml//author[1]/fName, $in-xml//author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsDescendant2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-descendant ( $node1 as node() , $node2 as node() ) as xs:boolean { boolean($node2 intersect $node1/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-descendant( $in-xml//author[1], $in-xml//author[1]/fName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsDescendant3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-descendant ( $node1 as node() , $node2 as node() ) as xs:boolean { boolean($node2 intersect $node1/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-descendant( $in-xml//author[1]/fName/text(), $in-xml//author[1]/fName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsDescendant4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-descendant ( $node1 as node() , $node2 as node() ) as xs:boolean { boolean($node2 intersect $node1/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-descendant( $in-xml//author[1], $in-xml//author[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node .
   */
  @org.junit.Test
  public void functxFunctxIsDescendantAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is a descendant of another node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-descendant.html : @param $node1 the first node : @param $node2 the second node :)\n" +
      "         declare function functx:is-descendant ( $node1 as node() , $node2 as node() ) as xs:boolean { boolean($node2 intersect $node1/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:is-descendant( $in-xml//author[1]/fName, $in-xml//author[1]), functx:is-descendant( $in-xml//author[1], $in-xml//author[1]/fName), functx:is-descendant( $in-xml//author[1]/fName/text(), $in-xml//author[1]/fName), functx:is-descendant( $in-xml//author[1], $in-xml//author[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false true false")
    );
  }

  /**
   * ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year .
   */
  @org.junit.Test
  public void functxFunctxIsLeapYear1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (functx:is-leap-year(xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year .
   */
  @org.junit.Test
  public void functxFunctxIsLeapYear2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (functx:is-leap-year(2004))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year .
   */
  @org.junit.Test
  public void functxFunctxIsLeapYear3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (functx:is-leap-year('2005-02-15'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year .
   */
  @org.junit.Test
  public void functxFunctxIsLeapYearAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (functx:is-leap-year(xs:date('2004-01-23')), functx:is-leap-year(2004), functx:is-leap-year('2005-02-15'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true false")
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendants1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"49.99\" discount=\"\"/> </prices> return let $aPrice := <price value=\"49.99\" discount=\"\"/> return (functx:is-node-among-descendants( $in-xml/price[1],$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendants2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"49.99\" discount=\"\"/> </prices> return let $aPrice := <price value=\"49.99\" discount=\"\"/> return (functx:is-node-among-descendants( $in-xml,$in-xml/price[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendants3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"49.99\" discount=\"\"/> </prices> return let $aPrice := <price value=\"49.99\" discount=\"\"/> return (functx:is-node-among-descendants( $in-xml,$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendants4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"49.99\" discount=\"\"/> </prices> return let $aPrice := <price value=\"49.99\" discount=\"\"/> return (functx:is-node-among-descendants( $aPrice,$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendantsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"49.99\" discount=\"\"/> </prices> return let $aPrice := <price value=\"49.99\" discount=\"\"/> return (functx:is-node-among-descendants( $in-xml/price[1],$in-xml), functx:is-node-among-descendants( $in-xml,$in-xml/price[1]), functx:is-node-among-descendants( $in-xml,$in-xml), functx:is-node-among-descendants( $aPrice,$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false true false")
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendantsDeepEqual1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>John</fName> <lName>Doe</lName> </author> return let $anotherAuthor := <author> <lName>Doe</lName> <fName>John</fName> </author> return (functx:is-node-among-descendants-deep-equal( $in-xml/author[1],$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendantsDeepEqual2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>John</fName> <lName>Doe</lName> </author> return let $anotherAuthor := <author> <lName>Doe</lName> <fName>John</fName> </author> return (functx:is-node-among-descendants-deep-equal( $anAuthor,$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendantsDeepEqual3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>John</fName> <lName>Doe</lName> </author> return let $anotherAuthor := <author> <lName>Doe</lName> <fName>John</fName> </author> return (functx:is-node-among-descendants-deep-equal( $anotherAuthor,$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendantsDeepEqual4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>John</fName> <lName>Doe</lName> </author> return let $anotherAuthor := <author> <lName>Doe</lName> <fName>John</fName> </author> return (functx:is-node-among-descendants-deep-equal( $anAuthor,$in-xml/author))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeAmongDescendantsDeepEqualAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is among the descendants of a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-among-descendants-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-among-descendants-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq/descendant-or-self::*/(.|@*) satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>John</fName> <lName>Doe</lName> </author> return let $anotherAuthor := <author> <lName>Doe</lName> <fName>John</fName> </author> return (functx:is-node-among-descendants-deep-equal( $in-xml/author[1],$in-xml), functx:is-node-among-descendants-deep-equal( $anAuthor,$in-xml), functx:is-node-among-descendants-deep-equal( $anotherAuthor,$in-xml), functx:is-node-among-descendants-deep-equal( $anAuthor,$in-xml/author))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true false true")
    );
  }

  /**
   * ~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeInSequence1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"49.99\" discount=\"\"/> </prices> return let $aPrice := <price value=\"49.99\" discount=\"\"/> return (functx:is-node-in-sequence( $in-xml/price[1],$in-xml/price))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeInSequence2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"49.99\" discount=\"\"/> </prices> return let $aPrice := <price value=\"49.99\" discount=\"\"/> return (functx:is-node-in-sequence( $in-xml/price[1],$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeInSequence3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"49.99\" discount=\"\"/> </prices> return let $aPrice := <price value=\"49.99\" discount=\"\"/> return (functx:is-node-in-sequence( $aPrice,$in-xml/price))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeInSequenceAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on node identity : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies $nodeInSeq is $node } ;\n" +
      "                    let $in-xml := <prices> <price value=\"29.99\" discount=\"10.00\"/> <price value=\"39.99\" discount=\"6.00\"/> <price value=\"49.99\" discount=\"\"/> </prices> return let $aPrice := <price value=\"49.99\" discount=\"\"/> return (functx:is-node-in-sequence( $in-xml/price[1],$in-xml/price), functx:is-node-in-sequence( $in-xml/price[1],$in-xml), functx:is-node-in-sequence( $aPrice,$in-xml/price))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false false")
    );
  }

  /**
   * ~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeInSequenceDeepEqual1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>John</fName> <lName>Doe</lName> </author> return (functx:is-node-in-sequence-deep-equal( $in-xml/author[1],$in-xml/author))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeInSequenceDeepEqual2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>John</fName> <lName>Doe</lName> </author> return (functx:is-node-in-sequence-deep-equal( $anAuthor,$in-xml/author))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeInSequenceDeepEqual3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>John</fName> <lName>Doe</lName> </author> return (functx:is-node-in-sequence-deep-equal( $in-xml/author[1],$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search .
   */
  @org.junit.Test
  public void functxFunctxIsNodeInSequenceDeepEqualAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node is in a sequence, based on contents and attributes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-node-in-sequence-deep-equal.html : @param $node the node to test : @param $seq the sequence of nodes to search :)\n" +
      "         declare function functx:is-node-in-sequence-deep-equal ( $node as node()? , $seq as node()* ) as xs:boolean { some $nodeInSeq in $seq satisfies deep-equal($nodeInSeq,$node) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>John</fName> <lName>Doe</lName> </author> return (functx:is-node-in-sequence-deep-equal( $in-xml/author[1],$in-xml/author), functx:is-node-in-sequence-deep-equal( $anAuthor,$in-xml/author), functx:is-node-in-sequence-deep-equal( $in-xml/author[1],$in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true false")
    );
  }

  /**
   * ~ : Whether an atomic value appears in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-value-in-sequence.html : @param $value the atomic value to test : @param $seq the sequence of values to search .
   */
  @org.junit.Test
  public void functxFunctxIsValueInSequence1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an atomic value appears in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-value-in-sequence.html : @param $value the atomic value to test : @param $seq the sequence of values to search :)\n" +
      "         declare function functx:is-value-in-sequence ( $value as xs:anyAtomicType? , $seq as xs:anyAtomicType* ) as xs:boolean { $value = $seq } ;\n" +
      "                    (functx:is-value-in-sequence(1,(1,2,3)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an atomic value appears in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-value-in-sequence.html : @param $value the atomic value to test : @param $seq the sequence of values to search .
   */
  @org.junit.Test
  public void functxFunctxIsValueInSequence2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an atomic value appears in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-value-in-sequence.html : @param $value the atomic value to test : @param $seq the sequence of values to search :)\n" +
      "         declare function functx:is-value-in-sequence ( $value as xs:anyAtomicType? , $seq as xs:anyAtomicType* ) as xs:boolean { $value = $seq } ;\n" +
      "                    (functx:is-value-in-sequence(5,(1,2,3)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an atomic value appears in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-value-in-sequence.html : @param $value the atomic value to test : @param $seq the sequence of values to search .
   */
  @org.junit.Test
  public void functxFunctxIsValueInSequence3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an atomic value appears in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-value-in-sequence.html : @param $value the atomic value to test : @param $seq the sequence of values to search :)\n" +
      "         declare function functx:is-value-in-sequence ( $value as xs:anyAtomicType? , $seq as xs:anyAtomicType* ) as xs:boolean { $value = $seq } ;\n" +
      "                    (functx:is-value-in-sequence(1.0,(1,2,3)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an atomic value appears in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-value-in-sequence.html : @param $value the atomic value to test : @param $seq the sequence of values to search .
   */
  @org.junit.Test
  public void functxFunctxIsValueInSequenceAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an atomic value appears in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-value-in-sequence.html : @param $value the atomic value to test : @param $seq the sequence of values to search :)\n" +
      "         declare function functx:is-value-in-sequence ( $value as xs:anyAtomicType? , $seq as xs:anyAtomicType* ) as xs:boolean { $value = $seq } ;\n" +
      "                    (functx:is-value-in-sequence(1,(1,2,3)), functx:is-value-in-sequence(5,(1,2,3)), functx:is-value-in-sequence(1.0,(1,2,3)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false true")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year ~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-month.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxLastDayOfMonth1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (:~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-month.html : @param $date the date :)\n" +
      "         declare function functx:last-day-of-month ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), month-from-date(xs:date($date)), functx:days-in-month($date)) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:last-day-of-month(xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-31")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year ~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-month.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxLastDayOfMonth2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (:~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-month.html : @param $date the date :)\n" +
      "         declare function functx:last-day-of-month ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), month-from-date(xs:date($date)), functx:days-in-month($date)) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:last-day-of-month( xs:dateTime('2004-09-23T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-09-30")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year ~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-month.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxLastDayOfMonth3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (:~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-month.html : @param $date the date :)\n" +
      "         declare function functx:last-day-of-month ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), month-from-date(xs:date($date)), functx:days-in-month($date)) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:last-day-of-month('2004-03-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-03-31")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year ~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-month.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxLastDayOfMonthAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (:~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-month.html : @param $date the date :)\n" +
      "         declare function functx:last-day-of-month ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), month-from-date(xs:date($date)), functx:days-in-month($date)) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:last-day-of-month(xs:date('2004-01-23')), functx:last-day-of-month( xs:dateTime('2004-09-23T12:00:13')), functx:last-day-of-month('2004-03-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-31 2004-09-30 2004-03-31")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year ~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxLastDayOfYear1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (:~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:last-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 12, 31) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:last-day-of-year(xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-31")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year ~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxLastDayOfYear2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (:~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:last-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 12, 31) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:last-day-of-year( xs:dateTime('2004-12-23T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-31")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year ~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxLastDayOfYear3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (:~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:last-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 12, 31) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:last-day-of-year('2004-03-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-31")
    );
  }

  /**
   * ~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day ~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date ~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year ~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-year.html : @param $date the date ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxLastDayOfYearAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Construct a date from a year, month and day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_date.html : @param $year the year : @param $month the month : @param $day the day :)\n" +
      "         declare function functx:date ( $year as xs:anyAtomicType , $month as xs:anyAtomicType , $day as xs:anyAtomicType ) as xs:date { xs:date( concat( functx:pad-integer-to-length(xs:integer($year),4),'-', functx:pad-integer-to-length(xs:integer($month),2),'-', functx:pad-integer-to-length(xs:integer($day),2))) } ;\n" +
      "                    (:~ : Number of days in the month : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_days-in-month.html : @param $date the date :)\n" +
      "         declare function functx:days-in-month ( $date as xs:anyAtomicType? ) as xs:integer? { if (month-from-date(xs:date($date)) = 2 and functx:is-leap-year($date)) then 29 else (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [month-from-date(xs:date($date))] } ;\n" +
      "                    (:~ : Whether a date falls in a leap year : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_is-leap-year.html : @param $date the date or year :)\n" +
      "         declare function functx:is-leap-year ( $date as xs:anyAtomicType? ) as xs:boolean { for $year in xs:integer(substring(string($date),1,4)) return ($year mod 4 = 0 and $year mod 100 != 0) or $year mod 400 = 0 } ;\n" +
      "                    (:~ : The last day of the month of a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-day-of-year.html : @param $date the date :)\n" +
      "         declare function functx:last-day-of-year ( $date as xs:anyAtomicType? ) as xs:date? { functx:date(year-from-date(xs:date($date)), 12, 31) } ;\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:last-day-of-year(xs:date('2004-01-23')), functx:last-day-of-year( xs:dateTime('2004-12-23T12:00:13')), functx:last-day-of-year('2004-03-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-31 2004-12-31 2004-12-31")
    );
  }

  /**
   * ~ : The XML node in a sequence that is last in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-node.html : @param $nodes the sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxLastNode1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node in a sequence that is last in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-node.html : @param $nodes the sequence of nodes :)\n" +
      "         declare function functx:last-node ( $nodes as node()* ) as node()? { ($nodes/.)[last()] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:last-node($in-xml//fName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>John</fName>", false)
    );
  }

  /**
   * ~ : The XML node in a sequence that is last in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-node.html : @param $nodes the sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxLastNode2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node in a sequence that is last in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-node.html : @param $nodes the sequence of nodes :)\n" +
      "         declare function functx:last-node ( $nodes as node()* ) as node()? { ($nodes/.)[last()] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:last-node( ($in-xml//lName, $in-xml//fName) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<lName>Doe</lName>", false)
    );
  }

  /**
   * ~ : The XML node in a sequence that is last in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-node.html : @param $nodes the sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxLastNodeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node in a sequence that is last in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_last-node.html : @param $nodes the sequence of nodes :)\n" +
      "         declare function functx:last-node ( $nodes as node()* ) as node()? { ($nodes/.)[last()] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:last-node($in-xml//fName), functx:last-node( ($in-xml//lName, $in-xml//fName) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>John</fName><lName>Doe</lName>", false)
    );
  }

  /**
   * 
   *       	All XML elements that don't have any child elements
   *       	@author Priscilla Walmsley, Datypic
   *       	@version 1.0
   *       	@see http://www.xqueryfunctions.com/xq/functx_leaf-elements.html
   *       	@param $root the root 
   *       .
   */
  @org.junit.Test
  public void functxFunctxLeafElements1() {
    final XQuery query = new XQuery(
      "\n" +
      "      \tdeclare namespace functx = \"http://www.example.com/\";\n" +
      "      \tdeclare function functx:leaf-elements ( $root as node()? ) as element()* { $root/descendant-or-self::*[not(*)] } ;\n" +
      "        let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> \n" +
      "                                 <author> <fName>John</fName> <lName>Doe</lName> </author> \n" +
      "                       </authors> \n" +
      "        return (functx:leaf-elements($in-xml))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>Kate</fName><lName>Jones</lName><fName>John</fName><lName>Doe</lName>", false)
    );
  }

  /**
   * 
   *       	All XML elements that don't have any child elements
   *       	@author Priscilla Walmsley, Datypic
   *       	@version 1.0
   *       	@see http://www.xqueryfunctions.com/xq/functx_leaf-elements.html
   *       	@param $root the root 
   *       .
   */
  @org.junit.Test
  public void functxFunctxLeafElements2() {
    final XQuery query = new XQuery(
      "\n" +
      "      \tdeclare namespace functx = \"http://www.example.com/\";\n" +
      "        declare function functx:leaf-elements ( $root as node()? ) as element()* { $root/descendant-or-self::*[not(*)] } ;\n" +
      "        let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> \n" +
      "                                 <author> <fName>John</fName> <lName>Doe</lName> </author> \n" +
      "                       </authors> \n" +
      "        return (functx:leaf-elements($in-xml/author[1]))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>Kate</fName><lName>Jones</lName>", false)
    );
  }

  /**
   * 
   *       	All XML elements that don't have any child elements
   *       	@author Priscilla Walmsley, Datypic
   *       	@version 1.0
   *       	@see http://www.xqueryfunctions.com/xq/functx_leaf-elements.html
   *       	@param $root the root 
   *       .
   */
  @org.junit.Test
  public void functxFunctxLeafElementsAll() {
    final XQuery query = new XQuery(
      "\n" +
      "      \tdeclare namespace functx = \"http://www.example.com/\";\n" +
      "        declare function functx:leaf-elements ( $root as node()? ) as element()* { $root/descendant-or-self::*[not(*)] } ;\n" +
      "        let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> \n" +
      "                                 <author> <fName>John</fName> <lName>Doe</lName> </author> \n" +
      "                       </authors> \n" +
      "        return (functx:leaf-elements($in-xml), functx:leaf-elements($in-xml/author[1]))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>Kate</fName><lName>Jones</lName><fName>John</fName><lName>Doe</lName><fName>Kate</fName><lName>Jones</lName>", false)
    );
  }

  /**
   * ~ : Trims leading whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_left-trim.html : @param $arg the string to trim .
   */
  @org.junit.Test
  public void functxFunctxLeftTrim1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Trims leading whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_left-trim.html : @param $arg the string to trim :)\n" +
      "         declare function functx:left-trim ( $arg as xs:string? ) as xs:string { replace($arg,'^\\s+','') } ;\n" +
      "                    (functx:left-trim(' xyz'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xyz")
    );
  }

  /**
   * ~ : Trims leading whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_left-trim.html : @param $arg the string to trim .
   */
  @org.junit.Test
  public void functxFunctxLeftTrim2() {
    final XQuery query = new XQuery(
      "\n" +
      "         declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare function functx:left-trim ( $arg as xs:string? ) as xs:string { replace($arg,'^\\s+','') } ;\n" +
      "         (functx:left-trim(' xyz    x'))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xyz    x")
    );
  }

  /**
   * ~ : Trims leading whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_left-trim.html : @param $arg the string to trim .
   */
  @org.junit.Test
  public void functxFunctxLeftTrim3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Trims leading whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_left-trim.html : @param $arg the string to trim :)\n" +
      "         declare function functx:left-trim ( $arg as xs:string? ) as xs:string { replace($arg,'^\\s+','') } ;\n" +
      "                    (functx:left-trim('xyz'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xyz")
    );
  }

  /**
   * ~ : Trims leading whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_left-trim.html : @param $arg the string to trim .
   */
  @org.junit.Test
  public void functxFunctxLeftTrimAll() {
    final XQuery query = new XQuery(
      "\n" +
      "         declare namespace functx = \"http://www.example.com/\";\n" +
      "         declare function functx:left-trim ( $arg as xs:string? ) as xs:string { replace($arg,'^\\s+','') } ;\n" +
      "                    (functx:left-trim(' xyz'), functx:left-trim(' xyz    x'), functx:left-trim('xyz'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xyz xyz    x xyz")
    );
  }

  /**
   * ~ : The number of lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_line-count.html : @param $arg the string to test ~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split .
   */
  @org.junit.Test
  public void functxFunctxLineCount1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The number of lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_line-count.html : @param $arg the string to test :)\n" +
      "         declare function functx:line-count ( $arg as xs:string? ) as xs:integer { count(functx:lines($arg)) } ;\n" +
      "                    (:~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split :)\n" +
      "         declare function functx:lines ( $arg as xs:string? ) as xs:string* { tokenize($arg, '(\\r\\n?|\\n\\r?)') } ;\n" +
      "                    let $lines := 'a value on many lines' return (functx:line-count('a value'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : The number of lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_line-count.html : @param $arg the string to test ~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split .
   */
  @org.junit.Test
  public void functxFunctxLineCount2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The number of lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_line-count.html : @param $arg the string to test :)\n" +
      "         declare function functx:line-count ( $arg as xs:string? ) as xs:integer { count(functx:lines($arg)) } ;\n" +
      "                    (:~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split :)\n" +
      "         declare function functx:lines ( $arg as xs:string? ) as xs:string* { tokenize($arg, '(\\r\\n?|\\n\\r?)') } ;\n" +
      "         let $lines := 'a \n" +
      "            value \n" +
      "            on \n" +
      "            many \n" +
      "            lines' return (functx:line-count($lines))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("5")
    );
  }

  /**
   * ~ : The number of lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_line-count.html : @param $arg the string to test ~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split .
   */
  @org.junit.Test
  public void functxFunctxLineCountAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The number of lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_line-count.html : @param $arg the string to test :)\n" +
      "         declare function functx:line-count ( $arg as xs:string? ) as xs:integer { count(functx:lines($arg)) } ;\n" +
      "                    (:~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split :)\n" +
      "         declare function functx:lines ( $arg as xs:string? ) as xs:string* { tokenize($arg, '(\\r\\n?|\\n\\r?)') } ;\n" +
      "         let $lines := 'a \n" +
      "                    value \n" +
      "                    on \n" +
      "                    many \n" +
      "                    lines' \n" +
      "         return (functx:line-count('a value'), functx:line-count($lines))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 5")
    );
  }

  /**
   * ~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split .
   */
  @org.junit.Test
  public void functxFunctxLines1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split :)\n" +
      "         declare function functx:lines ( $arg as xs:string? ) as xs:string* { tokenize($arg, '(\\r\\n?|\\n\\r?)') } ;\n" +
      "                    let $in-xml := <in-xml>a value on many lines</in-xml> return (functx:lines('a value'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a value")
    );
  }

  /**
   * ~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split .
   */
  @org.junit.Test
  public void functxFunctxLines2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split :)\n" +
      "         declare function functx:lines ( $arg as xs:string? ) as xs:string* { tokenize($arg, '(\\r\\n?|\\n\\r?)') } ;\n" +
      "                    let $in-xml := <in-xml>a value on many lines</in-xml> return (functx:lines($in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a value on many lines")
    );
  }

  /**
   * ~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split .
   */
  @org.junit.Test
  public void functxFunctxLinesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split :)\n" +
      "         declare function functx:lines ( $arg as xs:string? ) as xs:string* { tokenize($arg, '(\\r\\n?|\\n\\r?)') } ;\n" +
      "                    let $in-xml := <in-xml>a value on many lines</in-xml> return (functx:lines('a value'), functx:lines($in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a value a value on many lines")
    );
  }

  /**
   * ~ : The maximum depth of elements in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-depth.html : @param $root the root to start from .
   */
  @org.junit.Test
  public void functxFunctxMaxDepth1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum depth of elements in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-depth.html : @param $root the root to start from :)\n" +
      "         declare function functx:max-depth ( $root as node()? ) as xs:integer? { if ($root/*) then max($root/*/functx:max-depth(.)) + 1 else 1 } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:max-depth($in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("3")
    );
  }

  /**
   * ~ : The maximum depth of elements in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-depth.html : @param $root the root to start from .
   */
  @org.junit.Test
  public void functxFunctxMaxDepth2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum depth of elements in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-depth.html : @param $root the root to start from :)\n" +
      "         declare function functx:max-depth ( $root as node()? ) as xs:integer? { if ($root/*) then max($root/*/functx:max-depth(.)) + 1 else 1 } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:max-depth($in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The maximum depth of elements in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-depth.html : @param $root the root to start from .
   */
  @org.junit.Test
  public void functxFunctxMaxDepthAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum depth of elements in an XML tree : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-depth.html : @param $root the root to start from :)\n" +
      "         declare function functx:max-depth ( $root as node()? ) as xs:integer? { if ($root/*) then max($root/*/functx:max-depth(.)) + 1 else 1 } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:max-depth($in-xml), functx:max-depth($in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "3 2")
    );
  }

  /**
   * ~ : The maximum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-determine-type.html : @param $seq the sequence of values to test .
   */
  @org.junit.Test
  public void functxFunctxMaxDetermineType1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-determine-type.html : @param $seq the sequence of values to test :)\n" +
      "         declare function functx:max-determine-type ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType? { if (every $value in $seq satisfies ($value castable as xs:double)) then max(for $value in $seq return xs:double($value)) else max(for $value in $seq return xs:string($value)) } ;\n" +
      "                    let $in-xml := <values> <nums> <num>12</num> <num>23</num> <num>115</num> <num>12.5</num> </nums> <strings> <string>def</string> <string>abc</string> </strings> </values> return (functx:max-determine-type($in-xml//num))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("115")
    );
  }

  /**
   * ~ : The maximum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-determine-type.html : @param $seq the sequence of values to test .
   */
  @org.junit.Test
  public void functxFunctxMaxDetermineType2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-determine-type.html : @param $seq the sequence of values to test :)\n" +
      "         declare function functx:max-determine-type ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType? { if (every $value in $seq satisfies ($value castable as xs:double)) then max(for $value in $seq return xs:double($value)) else max(for $value in $seq return xs:string($value)) } ;\n" +
      "                    let $in-xml := <values> <nums> <num>12</num> <num>23</num> <num>115</num> <num>12.5</num> </nums> <strings> <string>def</string> <string>abc</string> </strings> </values> return (functx:max-determine-type($in-xml//string))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "def")
    );
  }

  /**
   * ~ : The maximum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-determine-type.html : @param $seq the sequence of values to test .
   */
  @org.junit.Test
  public void functxFunctxMaxDetermineType3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-determine-type.html : @param $seq the sequence of values to test :)\n" +
      "         declare function functx:max-determine-type ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType? { if (every $value in $seq satisfies ($value castable as xs:double)) then max(for $value in $seq return xs:double($value)) else max(for $value in $seq return xs:string($value)) } ;\n" +
      "                    let $in-xml := <values> <nums> <num>12</num> <num>23</num> <num>115</num> <num>12.5</num> </nums> <strings> <string>def</string> <string>abc</string> </strings> </values> return (functx:max-determine-type( $in-xml//(num|string)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "def")
    );
  }

  /**
   * ~ : The maximum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-determine-type.html : @param $seq the sequence of values to test .
   */
  @org.junit.Test
  public void functxFunctxMaxDetermineTypeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-determine-type.html : @param $seq the sequence of values to test :)\n" +
      "         declare function functx:max-determine-type ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType? { if (every $value in $seq satisfies ($value castable as xs:double)) then max(for $value in $seq return xs:double($value)) else max(for $value in $seq return xs:string($value)) } ;\n" +
      "                    let $in-xml := <values> <nums> <num>12</num> <num>23</num> <num>115</num> <num>12.5</num> </nums> <strings> <string>def</string> <string>abc</string> </strings> </values> return (functx:max-determine-type($in-xml//num), functx:max-determine-type($in-xml//string), functx:max-determine-type( $in-xml//(num|string)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "115 def def")
    );
  }

  /**
   * ~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split ~ : The maximum line length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-line-length.html : @param $arg the string to test .
   */
  @org.junit.Test
  public void functxFunctxMaxLineLength1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split :)\n" +
      "         declare function functx:lines ( $arg as xs:string? ) as xs:string* { tokenize($arg, '(\\r\\n?|\\n\\r?)') } ;\n" +
      "                    (:~ : The maximum line length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-line-length.html : @param $arg the string to test :)\n" +
      "         declare function functx:max-line-length ( $arg as xs:string? ) as xs:integer? { max( for $line in functx:lines($arg) return string-length($line)) } ;\n" +
      "                    let $lines := 'a value on several lines' return (functx:max-line-length('a value'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("7")
    );
  }

  /**
   * ~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split ~ : The maximum line length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-line-length.html : @param $arg the string to test .
   */
  @org.junit.Test
  public void functxFunctxMaxLineLength2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split :)\n" +
      "         declare function functx:lines ( $arg as xs:string? ) as xs:string* { tokenize($arg, '(\\r\\n?|\\n\\r?)') } ;\n" +
      "                    (:~ : The maximum line length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-line-length.html : @param $arg the string to test :)\n" +
      "         declare function functx:max-line-length ( $arg as xs:string? ) as xs:integer? { max( for $line in functx:lines($arg) return string-length($line)) } ;\n" +
      " let $lines := 'a \n" +
      "     value \n" +
      "     on \n" +
      "     several\n" +
      "     lines' \n" +
      "         return (functx:max-line-length($lines))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("12")
    );
  }

  /**
   * ~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split ~ : The maximum line length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-line-length.html : @param $arg the string to test .
   */
  @org.junit.Test
  public void functxFunctxMaxLineLengthAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Split a string into separate lines : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_lines.html : @param $arg the string to split :)\n" +
      "         declare function functx:lines ( $arg as xs:string? ) as xs:string* { tokenize($arg, '(\\r\\n?|\\n\\r?)') } ;\n" +
      "                    (:~ : The maximum line length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-line-length.html : @param $arg the string to test :)\n" +
      "         declare function functx:max-line-length ( $arg as xs:string? ) as xs:integer? { max( for $line in functx:lines($arg) return string-length($line)) } ;\n" +
      "let $lines := 'a \n" +
      "     value \n" +
      "     on \n" +
      "     several\n" +
      "     lines' \n" +
      "         return (functx:max-line-length('a value'), functx:max-line-length($lines))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "7 12")
    );
  }

  /**
   * ~ : The XML node whose typed value is the maximum : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-node.html : @param $nodes the sequence of nodes to test .
   */
  @org.junit.Test
  public void functxFunctxMaxNode1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node whose typed value is the maximum : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-node.html : @param $nodes the sequence of nodes to test :)\n" +
      "         declare function functx:max-node ( $nodes as node()* ) as node()* { $nodes[. = max($nodes)] } ;\n" +
      "                    let $in-xml := <values> <int>1</int> <int>23</int> <int>115</int> </values> return (functx:max-node($in-xml//int))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<int>115</int>", false)
    );
  }

  /**
   * ~ : The maximum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-string.html : @param $strings the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxMaxString1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-string.html : @param $strings the sequence of values :)\n" +
      "         declare function functx:max-string ( $strings as xs:anyAtomicType* ) as xs:string? { max(for $string in $strings return string($string)) } ;\n" +
      "                    let $in-xml := <in-xml> <x>a</x> <y>c</y> <z>b</z> </in-xml> return (functx:max-string( $in-xml/* ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "c")
    );
  }

  /**
   * ~ : The maximum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-string.html : @param $strings the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxMaxString2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-string.html : @param $strings the sequence of values :)\n" +
      "         declare function functx:max-string ( $strings as xs:anyAtomicType* ) as xs:string? { max(for $string in $strings return string($string)) } ;\n" +
      "                    let $in-xml := <in-xml> <x>a</x> <y>c</y> <z>b</z> </in-xml> return (functx:max-string( (100,25,3) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "3")
    );
  }

  /**
   * ~ : The maximum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-string.html : @param $strings the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxMaxStringAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The maximum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_max-string.html : @param $strings the sequence of values :)\n" +
      "         declare function functx:max-string ( $strings as xs:anyAtomicType* ) as xs:string? { max(for $string in $strings return string($string)) } ;\n" +
      "                    let $in-xml := <in-xml> <x>a</x> <y>c</y> <z>b</z> </in-xml> return (functx:max-string( $in-xml/* ), functx:max-string( (100,25,3) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "c 3")
    );
  }

  /**
   * ~ : The minimum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-determine-type.html : @param $seq the sequence of values to test .
   */
  @org.junit.Test
  public void functxFunctxMinDetermineType1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The minimum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-determine-type.html : @param $seq the sequence of values to test :)\n" +
      "         declare function functx:min-determine-type ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType? { if (every $value in $seq satisfies ($value castable as xs:double)) then min(for $value in $seq return xs:double($value)) else min(for $value in $seq return xs:string($value)) } ;\n" +
      "                    let $in-xml := <values> <nums> <num>12</num> <num>23</num> <num>115</num> <num>12.5</num> </nums> <strings> <str>def</str> <str>abc</str> </strings> </values> return (functx:min-determine-type($in-xml//num))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("12")
    );
  }

  /**
   * ~ : The minimum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-determine-type.html : @param $seq the sequence of values to test .
   */
  @org.junit.Test
  public void functxFunctxMinDetermineType2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The minimum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-determine-type.html : @param $seq the sequence of values to test :)\n" +
      "         declare function functx:min-determine-type ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType? { if (every $value in $seq satisfies ($value castable as xs:double)) then min(for $value in $seq return xs:double($value)) else min(for $value in $seq return xs:string($value)) } ;\n" +
      "                    let $in-xml := <values> <nums> <num>12</num> <num>23</num> <num>115</num> <num>12.5</num> </nums> <strings> <str>def</str> <str>abc</str> </strings> </values> return (functx:min-determine-type($in-xml//str))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abc")
    );
  }

  /**
   * ~ : The minimum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-determine-type.html : @param $seq the sequence of values to test .
   */
  @org.junit.Test
  public void functxFunctxMinDetermineType3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The minimum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-determine-type.html : @param $seq the sequence of values to test :)\n" +
      "         declare function functx:min-determine-type ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType? { if (every $value in $seq satisfies ($value castable as xs:double)) then min(for $value in $seq return xs:double($value)) else min(for $value in $seq return xs:string($value)) } ;\n" +
      "                    let $in-xml := <values> <nums> <num>12</num> <num>23</num> <num>115</num> <num>12.5</num> </nums> <strings> <str>def</str> <str>abc</str> </strings> </values> return (functx:min-determine-type($in-xml//(num|str)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "115")
    );
  }

  /**
   * ~ : The minimum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-determine-type.html : @param $seq the sequence of values to test .
   */
  @org.junit.Test
  public void functxFunctxMinDetermineTypeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The minimum value in a sequence, figuring out its type (numeric or string) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-determine-type.html : @param $seq the sequence of values to test :)\n" +
      "         declare function functx:min-determine-type ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType? { if (every $value in $seq satisfies ($value castable as xs:double)) then min(for $value in $seq return xs:double($value)) else min(for $value in $seq return xs:string($value)) } ;\n" +
      "                    let $in-xml := <values> <nums> <num>12</num> <num>23</num> <num>115</num> <num>12.5</num> </nums> <strings> <str>def</str> <str>abc</str> </strings> </values> return (functx:min-determine-type($in-xml//num), functx:min-determine-type($in-xml//str), functx:min-determine-type($in-xml//(num|str)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "12 abc 115")
    );
  }

  /**
   * ~ : The XML node whose typed value is the minimum : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-node.html : @param $nodes the sequence of nodes to test .
   */
  @org.junit.Test
  public void functxFunctxMinNode1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node whose typed value is the minimum : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-node.html : @param $nodes the sequence of nodes to test :)\n" +
      "         declare function functx:min-node ( $nodes as node()* ) as node()* { $nodes[. = min($nodes)] } ;\n" +
      "                    let $in-xml := <values> <int>1</int> <int>23</int> <int>115</int> </values> return (functx:min-node($in-xml//int))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<int>1</int>", false)
    );
  }

  /**
   * ~ : The minimum of a sequence of strings, ignoring "empty" values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-non-empty-string.html : @param $strings the sequence of strings to search .
   */
  @org.junit.Test
  public void functxFunctxMinNonEmptyString1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The minimum of a sequence of strings, ignoring \"empty\" values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-non-empty-string.html : @param $strings the sequence of strings to search :)\n" +
      "         declare function functx:min-non-empty-string ( $strings as xs:string* ) as xs:string? { min($strings[. != '']) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName/> <lName>Smith</lName> </author> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:min-non-empty-string( $in-xml//fName ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "John")
    );
  }

  /**
   * ~ : The minimum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-string.html : @param $strings the sequence of strings .
   */
  @org.junit.Test
  public void functxFunctxMinString1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The minimum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-string.html : @param $strings the sequence of strings :)\n" +
      "         declare function functx:min-string ( $strings as xs:anyAtomicType* ) as xs:string? { min(for $string in $strings return string($string)) } ;\n" +
      "                    let $in-xml := <in-xml> <x>a</x> <y>c</y> <z>b</z> </in-xml> return (functx:min-string( $in-xml/* ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a")
    );
  }

  /**
   * ~ : The minimum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-string.html : @param $strings the sequence of strings .
   */
  @org.junit.Test
  public void functxFunctxMinString2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The minimum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-string.html : @param $strings the sequence of strings :)\n" +
      "         declare function functx:min-string ( $strings as xs:anyAtomicType* ) as xs:string? { min(for $string in $strings return string($string)) } ;\n" +
      "                    let $in-xml := <in-xml> <x>a</x> <y>c</y> <z>b</z> </in-xml> return (functx:min-string( (100,25,3) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "100")
    );
  }

  /**
   * ~ : The minimum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-string.html : @param $strings the sequence of strings .
   */
  @org.junit.Test
  public void functxFunctxMinStringAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The minimum of a sequence of values, treating them like strings : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_min-string.html : @param $strings the sequence of strings :)\n" +
      "         declare function functx:min-string ( $strings as xs:anyAtomicType* ) as xs:string? { min(for $string in $strings return string($string)) } ;\n" +
      "                    let $in-xml := <in-xml> <x>a</x> <y>c</y> <z>b</z> </in-xml> return (functx:min-string( $in-xml/* ), functx:min-string( (100,25,3) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a 100")
    );
  }

  /**
   * ~ : Converts a string with format MMDDYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_mmddyyyy-to-date.html : @param $dateString the MMDDYYYY string .
   */
  @org.junit.Test
  public void functxFunctxMmddyyyyToDate1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string with format MMDDYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_mmddyyyy-to-date.html : @param $dateString the MMDDYYYY string :)\n" +
      "         declare function functx:mmddyyyy-to-date ( $dateString as xs:string? ) as xs:date? { if (empty($dateString)) then () else if (not(matches($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$'))) then error(xs:QName('functx:Invalid_Date_Format')) else xs:date(replace($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$', '$3-$1-$2')) } ;\n" +
      "                    (functx:mmddyyyy-to-date('12-15-2004'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-15")
    );
  }

  /**
   * ~ : Converts a string with format MMDDYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_mmddyyyy-to-date.html : @param $dateString the MMDDYYYY string .
   */
  @org.junit.Test
  public void functxFunctxMmddyyyyToDate2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string with format MMDDYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_mmddyyyy-to-date.html : @param $dateString the MMDDYYYY string :)\n" +
      "         declare function functx:mmddyyyy-to-date ( $dateString as xs:string? ) as xs:date? { if (empty($dateString)) then () else if (not(matches($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$'))) then error(xs:QName('functx:Invalid_Date_Format')) else xs:date(replace($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$', '$3-$1-$2')) } ;\n" +
      "                    (functx:mmddyyyy-to-date('12152004'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-15")
    );
  }

  /**
   * ~ : Converts a string with format MMDDYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_mmddyyyy-to-date.html : @param $dateString the MMDDYYYY string .
   */
  @org.junit.Test
  public void functxFunctxMmddyyyyToDate3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string with format MMDDYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_mmddyyyy-to-date.html : @param $dateString the MMDDYYYY string :)\n" +
      "         declare function functx:mmddyyyy-to-date ( $dateString as xs:string? ) as xs:date? { if (empty($dateString)) then () else if (not(matches($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$'))) then error(xs:QName('functx:Invalid_Date_Format')) else xs:date(replace($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$', '$3-$1-$2')) } ;\n" +
      "                    (functx:mmddyyyy-to-date('12/15/2004'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-15")
    );
  }

  /**
   * ~ : Converts a string with format MMDDYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_mmddyyyy-to-date.html : @param $dateString the MMDDYYYY string .
   */
  @org.junit.Test
  public void functxFunctxMmddyyyyToDateAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Converts a string with format MMDDYYYY (with any delimiters) to a date : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_mmddyyyy-to-date.html : @param $dateString the MMDDYYYY string :)\n" +
      "         declare function functx:mmddyyyy-to-date ( $dateString as xs:string? ) as xs:date? { if (empty($dateString)) then () else if (not(matches($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$'))) then error(xs:QName('functx:Invalid_Date_Format')) else xs:date(replace($dateString, '^\\D*(\\d{2})\\D*(\\d{2})\\D*(\\d{4})\\D*$', '$3-$1-$2')) } ;\n" +
      "                    (functx:mmddyyyy-to-date('12-15-2004'), functx:mmddyyyy-to-date('12152004'), functx:mmddyyyy-to-date('12/15/2004'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-15 2004-12-15 2004-12-15")
    );
  }

  /**
   * ~ : The month of a date as an abbreviated word (Jan, Feb, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-abbrev-en.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxMonthAbbrevEn1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The month of a date as an abbreviated word (Jan, Feb, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-abbrev-en.html : @param $date the date :)\n" +
      "         declare function functx:month-abbrev-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec') [month-from-date(xs:date($date))] } ;\n" +
      "                    (functx:month-abbrev-en(xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Jan")
    );
  }

  /**
   * ~ : The month of a date as an abbreviated word (Jan, Feb, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-abbrev-en.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxMonthAbbrevEn2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The month of a date as an abbreviated word (Jan, Feb, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-abbrev-en.html : @param $date the date :)\n" +
      "         declare function functx:month-abbrev-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec') [month-from-date(xs:date($date))] } ;\n" +
      "                    (functx:month-abbrev-en( xs:dateTime('2004-01-23T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Jan")
    );
  }

  /**
   * ~ : The month of a date as an abbreviated word (Jan, Feb, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-abbrev-en.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxMonthAbbrevEn3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The month of a date as an abbreviated word (Jan, Feb, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-abbrev-en.html : @param $date the date :)\n" +
      "         declare function functx:month-abbrev-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec') [month-from-date(xs:date($date))] } ;\n" +
      "                    (functx:month-abbrev-en('2004-01-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Jan")
    );
  }

  /**
   * ~ : The month of a date as an abbreviated word (Jan, Feb, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-abbrev-en.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxMonthAbbrevEnAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The month of a date as an abbreviated word (Jan, Feb, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-abbrev-en.html : @param $date the date :)\n" +
      "         declare function functx:month-abbrev-en ( $date as xs:anyAtomicType? ) as xs:string? { ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec') [month-from-date(xs:date($date))] } ;\n" +
      "                    (functx:month-abbrev-en(xs:date('2004-01-23')), functx:month-abbrev-en( xs:dateTime('2004-01-23T12:00:13')), functx:month-abbrev-en('2004-01-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "Jan Jan Jan")
    );
  }

  /**
   * ~ : The month of a date as a word (January, February, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-name-en.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxMonthNameEn1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The month of a date as a word (January, February, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-name-en.html : @param $date the date :)\n" +
      "         declare function functx:month-name-en ( $date as xs:anyAtomicType? ) as xs:string? { ('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December') [month-from-date(xs:date($date))] } ;\n" +
      "                    (functx:month-name-en(xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "January")
    );
  }

  /**
   * ~ : The month of a date as a word (January, February, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-name-en.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxMonthNameEn2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The month of a date as a word (January, February, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-name-en.html : @param $date the date :)\n" +
      "         declare function functx:month-name-en ( $date as xs:anyAtomicType? ) as xs:string? { ('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December') [month-from-date(xs:date($date))] } ;\n" +
      "                    (functx:month-name-en( xs:dateTime('2004-01-23T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "January")
    );
  }

  /**
   * ~ : The month of a date as a word (January, February, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-name-en.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxMonthNameEn3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The month of a date as a word (January, February, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-name-en.html : @param $date the date :)\n" +
      "         declare function functx:month-name-en ( $date as xs:anyAtomicType? ) as xs:string? { ('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December') [month-from-date(xs:date($date))] } ;\n" +
      "                    (functx:month-name-en('2004-01-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "January")
    );
  }

  /**
   * ~ : The month of a date as a word (January, February, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-name-en.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxMonthNameEnAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The month of a date as a word (January, February, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_month-name-en.html : @param $date the date :)\n" +
      "         declare function functx:month-name-en ( $date as xs:anyAtomicType? ) as xs:string? { ('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December') [month-from-date(xs:date($date))] } ;\n" +
      "                    (functx:month-name-en(xs:date('2004-01-23')), functx:month-name-en( xs:dateTime('2004-01-23T12:00:13')), functx:month-name-en('2004-01-23'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "January January January")
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxNameTest1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <pre:a xmlns:pre=\"http://ns.example.com/ns1\">abc</pre:a> return (functx:name-test(name($in-xml),('*')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxNameTest2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <pre:a xmlns:pre=\"http://ns.example.com/ns1\">abc</pre:a> return (functx:name-test(name($in-xml),('pre:*')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxNameTest3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <pre:a xmlns:pre=\"http://ns.example.com/ns1\">abc</pre:a> return (functx:name-test(name($in-xml),('*:a')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxNameTest4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <pre:a xmlns:pre=\"http://ns.example.com/ns1\">abc</pre:a> return (functx:name-test( name($in-xml),('pre:a','pre:b')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxNameTest5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <pre:a xmlns:pre=\"http://ns.example.com/ns1\">abc</pre:a> return (functx:name-test( name($in-xml),('a','b','c')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxNameTestAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml := <pre:a xmlns:pre=\"http://ns/example.com/ns1\">abc</pre:a> return (functx:name-test(name($in-xml),('*')), functx:name-test(name($in-xml),('pre:*')), functx:name-test(name($in-xml),('*:a')), functx:name-test( name($in-xml),('pre:a','pre:b')), functx:name-test( name($in-xml),('a','b','c')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true true true false")
    );
  }

  /**
   * ~ : A list of namespaces used in element/attribute names in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_namespaces-in-use.html : @param $root the root node to start from .
   */
  @org.junit.Test
  public void functxFunctxNamespacesInUse1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : A list of namespaces used in element/attribute names in an XML fragment : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_namespaces-in-use.html : @param $root the root node to start from :)\n" +
      "         declare function functx:namespaces-in-use ( $root as node()? ) as xs:anyURI* { distinct-values( $root/descendant-or-self::*/(.|@*)/namespace-uri(.)) } ;\n" +
      "                    let $in-xml := <authors xmlns=\"http://ns.example.com/abc\" xmlns:d=\"http://ns.example.com/def\"> <author xmlns=\"http://ns.example.com/ghi\"> <fName xmlns:x=\"http://ns.example.com/xyz\" x:attr=\"123\">Kate</fName> <lName>Jones</lName> </author> </authors> return (functx:namespaces-in-use($in-xml))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "http://ns.example.com/abc http://ns.example.com/ghi http://ns.example.com/xyz")
    );
  }

  /**
   * ~ : The next day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_next-day.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxNextDay1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The next day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_next-day.html : @param $date the date :)\n" +
      "         declare function functx:next-day ( $date as xs:anyAtomicType? ) as xs:date? { xs:date($date) + xs:dayTimeDuration('P1D') } ;\n" +
      "                    (functx:next-day(xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-24")
    );
  }

  /**
   * ~ : The next day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_next-day.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxNextDay2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The next day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_next-day.html : @param $date the date :)\n" +
      "         declare function functx:next-day ( $date as xs:anyAtomicType? ) as xs:date? { xs:date($date) + xs:dayTimeDuration('P1D') } ;\n" +
      "                    (functx:next-day( xs:dateTime('2005-15-31T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2006-01-01")
    );
  }

  /**
   * ~ : The next day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_next-day.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxNextDayAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The next day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_next-day.html : @param $date the date :)\n" +
      "         declare function functx:next-day ( $date as xs:anyAtomicType? ) as xs:date? { xs:date($date) + xs:dayTimeDuration('P1D') } ;\n" +
      "                    (functx:next-day(xs:date('2004-01-23')), functx:next-day( xs:dateTime('2005-15-31T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-24 2006-01-01")
    );
  }

  /**
   * ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine .
   */
  @org.junit.Test
  public void functxFunctxNodeKind1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    let $in-xml := <in-xml> <!-- this is in-xml --> <?test see?> <a z=\"2\">xyz</a> </in-xml> return (functx:node-kind($in-xml/a))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "element")
    );
  }

  /**
   * ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine .
   */
  @org.junit.Test
  public void functxFunctxNodeKind2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    let $in-xml := <in-xml> <!-- this is in-xml --> <?test see?> <a z=\"2\">xyz</a> </in-xml> return (functx:node-kind($in-xml/a/@z))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "attribute")
    );
  }

  /**
   * ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine .
   */
  @org.junit.Test
  public void functxFunctxNodeKind3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    let $in-xml := <in-xml> <!-- this is in-xml --> <?test see?> <a z=\"2\">xyz</a> </in-xml> return (functx:node-kind($in-xml/comment()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "comment")
    );
  }

  /**
   * ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine .
   */
  @org.junit.Test
  public void functxFunctxNodeKind4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    let $in-xml := <in-xml> <!-- this is in-xml --> <?test see?> <a z=\"2\">xyz</a> </in-xml> return (functx:node-kind( $in-xml/processing-instruction()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "processing-instruction")
    );
  }

  /**
   * ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine .
   */
  @org.junit.Test
  public void functxFunctxNodeKind5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    let $in-xml := <in-xml> <!-- this is in-xml --> <?test see?> <a z=\"2\">xyz</a> </in-xml> return (functx:node-kind($in-xml/a/text()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "text")
    );
  }

  /**
   * ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine .
   */
  @org.junit.Test
  public void functxFunctxNodeKind6() {
    final XQuery query = new XQuery(
      "\n" +
      "         declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "         let $in-xml := <in-xml> <!-- this is in-xml --> <?test see?> <a z=\"2\">xyz</a> </in-xml> \n" +
      "         return (functx:node-kind(/))\n" +
      "      ",
      ctx);
    try {
      query.context(node(file("app/FunctxFn/functx_book.xml")));
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "document-node")
    );
  }

  /**
   * ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine .
   */
  @org.junit.Test
  public void functxFunctxNodeKindAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    declare variable $input-context1 external;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "         let $in-xml := <in-xml> <!-- this is in-xml --> <?test see?> <a z=\"2\">xyz</a> </in-xml> \n" +
      "         return (functx:node-kind($in-xml/a), \n" +
      "                    functx:node-kind($in-xml/a/@z), \n" +
      "                    functx:node-kind($in-xml/comment()), \n" +
      "                    functx:node-kind( $in-xml/processing-instruction()), \n" +
      "                    functx:node-kind($in-xml/a/text()), \n" +
      "                    functx:node-kind(/))",
      ctx);
    try {
      query.context(node(file("app/FunctxFn/functx_book.xml")));
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "element attribute comment processing-instruction text document-node")
    );
  }

  /**
   * ~ : Returns any values that appear more than once in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_non-distinct-values.html : @param $seq the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxNonDistinctValues1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns any values that appear more than once in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_non-distinct-values.html : @param $seq the sequence of values :)\n" +
      "         declare function functx:non-distinct-values ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType* { for $val in distinct-values($seq) return $val[count($seq[. = $val]) >\n" +
      "                    1] } ;\n" +
      "                    (functx:non-distinct-values( (1,2,1,3)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("1")
    );
  }

  /**
   * ~ : Returns any values that appear more than once in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_non-distinct-values.html : @param $seq the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxNonDistinctValues2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns any values that appear more than once in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_non-distinct-values.html : @param $seq the sequence of values :)\n" +
      "         declare function functx:non-distinct-values ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType* { for $val in distinct-values($seq) return $val[count($seq[. = $val]) >\n" +
      "                    1] } ;\n" +
      "                    (functx:non-distinct-values( (1,2,1,3,2.0)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 2")
    );
  }

  /**
   * ~ : Returns any values that appear more than once in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_non-distinct-values.html : @param $seq the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxNonDistinctValues3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns any values that appear more than once in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_non-distinct-values.html : @param $seq the sequence of values :)\n" +
      "         declare function functx:non-distinct-values ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType* { for $val in distinct-values($seq) return $val[count($seq[. = $val]) >\n" +
      "                    1] } ;\n" +
      "                    (functx:non-distinct-values( (1,2,3) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : Returns any values that appear more than once in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_non-distinct-values.html : @param $seq the sequence of values .
   */
  @org.junit.Test
  public void functxFunctxNonDistinctValuesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns any values that appear more than once in a sequence : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_non-distinct-values.html : @param $seq the sequence of values :)\n" +
      "         declare function functx:non-distinct-values ( $seq as xs:anyAtomicType* ) as xs:anyAtomicType* { for $val in distinct-values($seq) return $val[count($seq[. = $val]) >\n" +
      "                    1] } ;\n" +
      "                    (functx:non-distinct-values( (1,2,1,3)), functx:non-distinct-values( (1,2,1,3,2.0)), functx:non-distinct-values( (1,2,3) ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 1 2")
    );
  }

  /**
   * ~ : The number of regions that match a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_number-of-matches.html : @param $arg the string to test : @param $pattern the regular expression .
   */
  @org.junit.Test
  public void functxFunctxNumberOfMatches1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The number of regions that match a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_number-of-matches.html : @param $arg the string to test : @param $pattern the regular expression :)\n" +
      "         declare function functx:number-of-matches ( $arg as xs:string? , $pattern as xs:string ) as xs:integer { count(tokenize($arg,$pattern)) - 1 } ;\n" +
      "                    (functx:number-of-matches('abcabc','ab'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The number of regions that match a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_number-of-matches.html : @param $arg the string to test : @param $pattern the regular expression .
   */
  @org.junit.Test
  public void functxFunctxNumberOfMatches2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The number of regions that match a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_number-of-matches.html : @param $arg the string to test : @param $pattern the regular expression :)\n" +
      "         declare function functx:number-of-matches ( $arg as xs:string? , $pattern as xs:string ) as xs:integer { count(tokenize($arg,$pattern)) - 1 } ;\n" +
      "                    (functx:number-of-matches('12345','\\d'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("5")
    );
  }

  /**
   * ~ : The number of regions that match a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_number-of-matches.html : @param $arg the string to test : @param $pattern the regular expression .
   */
  @org.junit.Test
  public void functxFunctxNumberOfMatches3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The number of regions that match a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_number-of-matches.html : @param $arg the string to test : @param $pattern the regular expression :)\n" +
      "         declare function functx:number-of-matches ( $arg as xs:string? , $pattern as xs:string ) as xs:integer { count(tokenize($arg,$pattern)) - 1 } ;\n" +
      "                    (functx:number-of-matches('aaaaaa','aaa'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertEq("2")
    );
  }

  /**
   * ~ : The number of regions that match a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_number-of-matches.html : @param $arg the string to test : @param $pattern the regular expression .
   */
  @org.junit.Test
  public void functxFunctxNumberOfMatchesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The number of regions that match a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_number-of-matches.html : @param $arg the string to test : @param $pattern the regular expression :)\n" +
      "         declare function functx:number-of-matches ( $arg as xs:string? , $pattern as xs:string ) as xs:integer { count(tokenize($arg,$pattern)) - 1 } ;\n" +
      "                    (functx:number-of-matches('abcabc','ab'), functx:number-of-matches('12345','\\d'), functx:number-of-matches('aaaaaa','aaa'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2 5 2")
    );
  }

  /**
   * ~ : Reformats a number as an ordinal number, e.g. 1st, 2nd, 3rd. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_ordinal-number-en.html : @param $num the number .
   */
  @org.junit.Test
  public void functxFunctxOrdinalNumberEn1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Reformats a number as an ordinal number, e.g. 1st, 2nd, 3rd. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_ordinal-number-en.html : @param $num the number :)\n" +
      "         declare function functx:ordinal-number-en ( $num as xs:integer? ) as xs:string { concat(xs:string($num), if (matches(xs:string($num),'[04-9]$|1[1-3]$')) then 'th' else if (ends-with(xs:string($num),'1')) then 'st' else if (ends-with(xs:string($num),'2')) then 'nd' else if (ends-with(xs:string($num),'3')) then 'rd' else '') } ;\n" +
      "                    (functx:ordinal-number-en(1))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1st")
    );
  }

  /**
   * ~ : Reformats a number as an ordinal number, e.g. 1st, 2nd, 3rd. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_ordinal-number-en.html : @param $num the number .
   */
  @org.junit.Test
  public void functxFunctxOrdinalNumberEn2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Reformats a number as an ordinal number, e.g. 1st, 2nd, 3rd. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_ordinal-number-en.html : @param $num the number :)\n" +
      "         declare function functx:ordinal-number-en ( $num as xs:integer? ) as xs:string { concat(xs:string($num), if (matches(xs:string($num),'[04-9]$|1[1-3]$')) then 'th' else if (ends-with(xs:string($num),'1')) then 'st' else if (ends-with(xs:string($num),'2')) then 'nd' else if (ends-with(xs:string($num),'3')) then 'rd' else '') } ;\n" +
      "                    (functx:ordinal-number-en(12))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "12th")
    );
  }

  /**
   * ~ : Reformats a number as an ordinal number, e.g. 1st, 2nd, 3rd. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_ordinal-number-en.html : @param $num the number .
   */
  @org.junit.Test
  public void functxFunctxOrdinalNumberEnAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Reformats a number as an ordinal number, e.g. 1st, 2nd, 3rd. : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_ordinal-number-en.html : @param $num the number :)\n" +
      "         declare function functx:ordinal-number-en ( $num as xs:integer? ) as xs:string { concat(xs:string($num), if (matches(xs:string($num),'[04-9]$|1[1-3]$')) then 'th' else if (ends-with(xs:string($num),'1')) then 'st' else if (ends-with(xs:string($num),'2')) then 'nd' else if (ends-with(xs:string($num),'3')) then 'rd' else '') } ;\n" +
      "                    (functx:ordinal-number-en(1), functx:ordinal-number-en(12))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1st 12th")
    );
  }

  /**
   * ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxPadIntegerToLength1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:pad-integer-to-length(12, 6))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "000012")
    );
  }

  /**
   * ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxPadIntegerToLength2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:pad-integer-to-length(1, 6))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "000001")
    );
  }

  /**
   * ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxPadIntegerToLength3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:pad-integer-to-length(12, 2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "12")
    );
  }

  /**
   * ~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxPadIntegerToLengthAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Pads an integer to a desired length by adding leading zeros : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-integer-to-length.html : @param $integerToPad the integer to pad : @param $length the desired length :)\n" +
      "         declare function functx:pad-integer-to-length ( $integerToPad as xs:anyAtomicType? , $length as xs:integer ) as xs:string { if ($length < string-length(string($integerToPad))) then error(xs:QName('functx:Integer_Longer_Than_Length')) else concat (functx:repeat-string( '0',$length - string-length(string($integerToPad))), string($integerToPad)) } ;\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:pad-integer-to-length(12, 6), functx:pad-integer-to-length(1, 6), functx:pad-integer-to-length(12, 2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "000012 000001 12")
    );
  }

  /**
   * ~ : Pads a string to a desired length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-string-to-length.html : @param $stringToPad the string to pad : @param $padChar the character(s) to use as padding : @param $length the desired length .
   */
  @org.junit.Test
  public void functxFunctxPadStringToLength1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Pads a string to a desired length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-string-to-length.html : @param $stringToPad the string to pad : @param $padChar the character(s) to use as padding : @param $length the desired length :)\n" +
      "         declare function functx:pad-string-to-length ( $stringToPad as xs:string? , $padChar as xs:string , $length as xs:integer ) as xs:string { substring( string-join ( ($stringToPad, for $i in (1 to $length) return $padChar) ,'') ,1,$length) } ;\n" +
      "                    (functx:pad-string-to-length('abc', '*', 6))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abc***")
    );
  }

  /**
   * ~ : Pads a string to a desired length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-string-to-length.html : @param $stringToPad the string to pad : @param $padChar the character(s) to use as padding : @param $length the desired length .
   */
  @org.junit.Test
  public void functxFunctxPadStringToLength2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Pads a string to a desired length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-string-to-length.html : @param $stringToPad the string to pad : @param $padChar the character(s) to use as padding : @param $length the desired length :)\n" +
      "         declare function functx:pad-string-to-length ( $stringToPad as xs:string? , $padChar as xs:string , $length as xs:integer ) as xs:string { substring( string-join ( ($stringToPad, for $i in (1 to $length) return $padChar) ,'') ,1,$length) } ;\n" +
      "                    (functx:pad-string-to-length('abcdef', '*', 4))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abcd")
    );
  }

  /**
   * ~ : Pads a string to a desired length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-string-to-length.html : @param $stringToPad the string to pad : @param $padChar the character(s) to use as padding : @param $length the desired length .
   */
  @org.junit.Test
  public void functxFunctxPadStringToLength3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Pads a string to a desired length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-string-to-length.html : @param $stringToPad the string to pad : @param $padChar the character(s) to use as padding : @param $length the desired length :)\n" +
      "         declare function functx:pad-string-to-length ( $stringToPad as xs:string? , $padChar as xs:string , $length as xs:integer ) as xs:string { substring( string-join ( ($stringToPad, for $i in (1 to $length) return $padChar) ,'') ,1,$length) } ;\n" +
      "                    (functx:pad-string-to-length('', '*', 4))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "****")
    );
  }

  /**
   * ~ : Pads a string to a desired length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-string-to-length.html : @param $stringToPad the string to pad : @param $padChar the character(s) to use as padding : @param $length the desired length .
   */
  @org.junit.Test
  public void functxFunctxPadStringToLengthAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Pads a string to a desired length : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_pad-string-to-length.html : @param $stringToPad the string to pad : @param $padChar the character(s) to use as padding : @param $length the desired length :)\n" +
      "         declare function functx:pad-string-to-length ( $stringToPad as xs:string? , $padChar as xs:string , $length as xs:integer ) as xs:string { substring( string-join ( ($stringToPad, for $i in (1 to $length) return $padChar) ,'') ,1,$length) } ;\n" +
      "                    (functx:pad-string-to-length('abc', '*', 6), functx:pad-string-to-length('abcdef', '*', 4), functx:pad-string-to-length('', '*', 4))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abc*** abcd ****")
    );
  }

  /**
   * ~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence .
   */
  @org.junit.Test
  public void functxFunctxPathToNode1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:path-to-node ( $nodes as node()* ) as xs:string* { $nodes/string-join(ancestor-or-self::*/name(.), '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:path-to-node($in-xml//lName[. = 'Doe']))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors/author/lName")
    );
  }

  /**
   * ~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence .
   */
  @org.junit.Test
  public void functxFunctxPathToNode2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:path-to-node ( $nodes as node()* ) as xs:string* { $nodes/string-join(ancestor-or-self::*/name(.), '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:path-to-node($in-xml/*[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors/author")
    );
  }

  /**
   * ~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence .
   */
  @org.junit.Test
  public void functxFunctxPathToNodeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : A path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node.html : @param $nodes the node sequence :)\n" +
      "         declare function functx:path-to-node ( $nodes as node()* ) as xs:string* { $nodes/string-join(ancestor-or-self::*/name(.), '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:path-to-node($in-xml//lName[. = 'Doe']), functx:path-to-node($in-xml/*[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors/author/lName authors/author")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence ~ : A unique path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node-with-pos.html : @param $node the node sequence .
   */
  @org.junit.Test
  public void functxFunctxPathToNodeWithPos1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[$nodes[$seq] is $nodeToFind] } ;\n" +
      "                    (:~ : A unique path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node-with-pos.html : @param $node the node sequence :)\n" +
      "         declare function functx:path-to-node-with-pos ( $node as node()? ) as xs:string { string-join( for $ancestor in $node/ancestor-or-self::* let $sibsOfSameName := $ancestor/../*[name() = name($ancestor)] return concat(name($ancestor), if (count($sibsOfSameName) <= 1) then '' else concat( '[',functx:index-of-node($sibsOfSameName,$ancestor),']')) , '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:path-to-node-with-pos( $in-xml//lName[. = 'Doe']))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors/author[2]/lName")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence ~ : A unique path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node-with-pos.html : @param $node the node sequence .
   */
  @org.junit.Test
  public void functxFunctxPathToNodeWithPos2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[$nodes[$seq] is $nodeToFind] } ;\n" +
      "                    (:~ : A unique path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node-with-pos.html : @param $node the node sequence :)\n" +
      "         declare function functx:path-to-node-with-pos ( $node as node()? ) as xs:string { string-join( for $ancestor in $node/ancestor-or-self::* let $sibsOfSameName := $ancestor/../*[name() = name($ancestor)] return concat(name($ancestor), if (count($sibsOfSameName) <= 1) then '' else concat( '[',functx:index-of-node($sibsOfSameName,$ancestor),']')) , '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:path-to-node-with-pos($in-xml/*[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors/author[1]")
    );
  }

  /**
   * ~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence ~ : A unique path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node-with-pos.html : @param $node the node sequence .
   */
  @org.junit.Test
  public void functxFunctxPathToNodeWithPosAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The position of a node in a sequence, based on node identity : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_index-of-node.html : @param $nodes the node sequence : @param $nodeToFind the node to find in the sequence :)\n" +
      "         declare function functx:index-of-node ( $nodes as node()* , $nodeToFind as node() ) as xs:integer* { for $seq in (1 to count($nodes)) return $seq[$nodes[$seq] is $nodeToFind] } ;\n" +
      "                    (:~ : A unique path to an XML node (or sequence of nodes) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_path-to-node-with-pos.html : @param $node the node sequence :)\n" +
      "         declare function functx:path-to-node-with-pos ( $node as node()? ) as xs:string { string-join( for $ancestor in $node/ancestor-or-self::* let $sibsOfSameName := $ancestor/../*[name() = name($ancestor)] return concat(name($ancestor), if (count($sibsOfSameName) <= 1) then '' else concat( '[',functx:index-of-node($sibsOfSameName,$ancestor),']')) , '/') } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:path-to-node-with-pos( $in-xml//lName[. = 'Doe']), functx:path-to-node-with-pos($in-xml/*[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "authors/author[2]/lName authors/author[1]")
    );
  }

  /**
   * ~ : Whether an XML node precedes another without being its ancestor : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_precedes-not-ancestor.html : @param $a the first node : @param $b the second node .
   */
  @org.junit.Test
  public void functxFunctxPrecedesNotAncestor1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node precedes another without being its ancestor : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_precedes-not-ancestor.html : @param $a the first node : @param $b the second node :)\n" +
      "         declare function functx:precedes-not-ancestor ( $a as node()? , $b as node()? ) as xs:boolean { $a << $b and empty($a intersect $b/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:precedes-not-ancestor( $in-xml//author[1],$in-xml//author[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether an XML node precedes another without being its ancestor : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_precedes-not-ancestor.html : @param $a the first node : @param $b the second node .
   */
  @org.junit.Test
  public void functxFunctxPrecedesNotAncestor2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node precedes another without being its ancestor : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_precedes-not-ancestor.html : @param $a the first node : @param $b the second node :)\n" +
      "         declare function functx:precedes-not-ancestor ( $a as node()? , $b as node()? ) as xs:boolean { $a << $b and empty($a intersect $b/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:precedes-not-ancestor( $in-xml//author[1], $in-xml//author[1]/fName))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node precedes another without being its ancestor : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_precedes-not-ancestor.html : @param $a the first node : @param $b the second node .
   */
  @org.junit.Test
  public void functxFunctxPrecedesNotAncestor3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node precedes another without being its ancestor : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_precedes-not-ancestor.html : @param $a the first node : @param $b the second node :)\n" +
      "         declare function functx:precedes-not-ancestor ( $a as node()? , $b as node()? ) as xs:boolean { $a << $b and empty($a intersect $b/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:precedes-not-ancestor( $in-xml//author[2],$in-xml//author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether an XML node precedes another without being its ancestor : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_precedes-not-ancestor.html : @param $a the first node : @param $b the second node .
   */
  @org.junit.Test
  public void functxFunctxPrecedesNotAncestorAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether an XML node precedes another without being its ancestor : : @author W3C XML Query Working Group : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_precedes-not-ancestor.html : @param $a the first node : @param $b the second node :)\n" +
      "         declare function functx:precedes-not-ancestor ( $a as node()? , $b as node()? ) as xs:boolean { $a << $b and empty($a intersect $b/ancestor::node()) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:precedes-not-ancestor( $in-xml//author[1],$in-xml//author[2]), functx:precedes-not-ancestor( $in-xml//author[1], $in-xml//author[1]/fName), functx:precedes-not-ancestor( $in-xml//author[2],$in-xml//author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false false")
    );
  }

  /**
   * ~ : The previous day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_previous-day.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxPreviousDay1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The previous day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_previous-day.html : @param $date the date :)\n" +
      "         declare function functx:previous-day ( $date as xs:anyAtomicType? ) as xs:date? { xs:date($date) - xs:dayTimeDuration('P1D') } ;\n" +
      "                    (functx:previous-day(xs:date('2004-01-23')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-22")
    );
  }

  /**
   * ~ : The previous day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_previous-day.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxPreviousDay2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The previous day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_previous-day.html : @param $date the date :)\n" +
      "         declare function functx:previous-day ( $date as xs:anyAtomicType? ) as xs:date? { xs:date($date) - xs:dayTimeDuration('P1D') } ;\n" +
      "                    (functx:previous-day( xs:dateTime('2005-01-01T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-12-31")
    );
  }

  /**
   * ~ : The previous day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_previous-day.html : @param $date the date .
   */
  @org.junit.Test
  public void functxFunctxPreviousDayAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The previous day : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_previous-day.html : @param $date the date :)\n" +
      "         declare function functx:previous-day ( $date as xs:anyAtomicType? ) as xs:date? { xs:date($date) - xs:dayTimeDuration('P1D') } ;\n" +
      "                    (functx:previous-day(xs:date('2004-01-23')), functx:previous-day( xs:dateTime('2005-01-01T12:00:13')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2004-01-22 2004-12-31")
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveAttributes1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes :)\n" +
      "         declare function functx:remove-attributes ( $elements as element()* , $names as xs:string* ) as element() { for $element in $elements return element {node-name($element)} {$element/@*[not(functx:name-test(name(),$names))], $element/node() } } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <a attr1=\"123\" attr2=\"456\">abc</a> return let $in-xml-2 := <a xmlns:a=\"http://a\" a:attr1=\"123\" attr1=\"456\">abc</a> return (functx:remove-attributes( $in-xml-1, ('attr1','attr2')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a>abc</a>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveAttributes2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes :)\n" +
      "         declare function functx:remove-attributes ( $elements as element()* , $names as xs:string* ) as element() { for $element in $elements return element {node-name($element)} {$element/@*[not(functx:name-test(name(),$names))], $element/node() } } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <a attr1=\"123\" attr2=\"456\">abc</a> return let $in-xml-2 := <a xmlns:a=\"http://a\" a:attr1=\"123\" attr1=\"456\">abc</a> return (functx:remove-attributes( $in-xml-1, ('attr1','attr3')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a attr2=\"456\">abc</a>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveAttributes3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes :)\n" +
      "         declare function functx:remove-attributes ( $elements as element()* , $names as xs:string* ) as element() { for $element in $elements return element {node-name($element)} {$element/@*[not(functx:name-test(name(),$names))], $element/node() } } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <a attr1=\"123\" attr2=\"456\">abc</a> return let $in-xml-2 := <a xmlns:a=\"http://a\" a:attr1=\"123\" attr1=\"456\">abc</a> return (functx:remove-attributes($in-xml-1, '*'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a>abc</a>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveAttributes4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes :)\n" +
      "         declare function functx:remove-attributes ( $elements as element()* , $names as xs:string* ) as element() { for $element in $elements return element {node-name($element)} {$element/@*[not(functx:name-test(name(),$names))], $element/node() } } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <a attr1=\"123\" attr2=\"456\">abc</a> return let $in-xml-2 := <a xmlns:a=\"http://a\" a:attr1=\"123\" attr1=\"456\">abc</a> return (functx:remove-attributes( $in-xml-2, ('a:attr1')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a attr1=\"456\">abc</a>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveAttributesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes attributes from an XML element, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes.html : @param $elements the element(s) from which to remove the attributes : @param $names the names of the attributes to remove, or * for all attributes :)\n" +
      "         declare function functx:remove-attributes ( $elements as element()* , $names as xs:string* ) as element() { for $element in $elements return element {node-name($element)} {$element/@*[not(functx:name-test(name(),$names))], $element/node() } } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <a attr1=\"123\" attr2=\"456\">abc</a> return let $in-xml-2 := <a xmlns:a=\"http://a\" a:attr1=\"123\" attr1=\"456\">abc</a> return (functx:remove-attributes( $in-xml-1, ('attr1','attr2')), functx:remove-attributes( $in-xml-1, ('attr1','attr3')), functx:remove-attributes($in-xml-1, '*'), functx:remove-attributes( $in-xml-2, ('a:attr1')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a>abc</a><a attr2=\"456\">abc</a><a>abc</a><a attr1=\"456\">abc</a>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes attributes from an XML fragment, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes-deep.html : @param $nodes the root(s) to start from : @param $names the names of the attributes to remove, or * for all attributes ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveAttributesDeep1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes attributes from an XML fragment, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes-deep.html : @param $nodes the root(s) to start from : @param $names the names of the attributes to remove, or * for all attributes :)\n" +
      "         declare function functx:remove-attributes-deep ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then element { node-name($node)} { $node/@*[not(functx:name-test(name(),$names))], functx:remove-attributes-deep($node/node(), $names)} else if ($node instance of document-node()) then functx:remove-attributes-deep($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <a attr1=\"123\" attr2=\"456\"> <b attr1=\"xzy\">abc</b> </a> return let $in-xml-2 := <a xmlns:a=\"http://a\" a:attr1=\"123\" attr1=\"456\"> <b a:attr1=\"ghi\" attr1=\"xzy\">abc</b> </a> return (functx:remove-attributes-deep( $in-xml-1, ('attr1','attr2')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a><b>abc</b></a>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes attributes from an XML fragment, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes-deep.html : @param $nodes the root(s) to start from : @param $names the names of the attributes to remove, or * for all attributes ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveAttributesDeep2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes attributes from an XML fragment, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes-deep.html : @param $nodes the root(s) to start from : @param $names the names of the attributes to remove, or * for all attributes :)\n" +
      "         declare function functx:remove-attributes-deep ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then element { node-name($node)} { $node/@*[not(functx:name-test(name(),$names))], functx:remove-attributes-deep($node/node(), $names)} else if ($node instance of document-node()) then functx:remove-attributes-deep($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <a attr1=\"123\" attr2=\"456\"> <b attr1=\"xzy\">abc</b> </a> return let $in-xml-2 := <a xmlns:a=\"http://a\" a:attr1=\"123\" attr1=\"456\"> <b a:attr1=\"ghi\" attr1=\"xzy\">abc</b> </a> return (functx:remove-attributes-deep( $in-xml-1, ('attr1','attr3')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a attr2=\"456\"><b>abc</b></a>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes attributes from an XML fragment, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes-deep.html : @param $nodes the root(s) to start from : @param $names the names of the attributes to remove, or * for all attributes ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveAttributesDeep3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes attributes from an XML fragment, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes-deep.html : @param $nodes the root(s) to start from : @param $names the names of the attributes to remove, or * for all attributes :)\n" +
      "         declare function functx:remove-attributes-deep ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then element { node-name($node)} { $node/@*[not(functx:name-test(name(),$names))], functx:remove-attributes-deep($node/node(), $names)} else if ($node instance of document-node()) then functx:remove-attributes-deep($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <a attr1=\"123\" attr2=\"456\"> <b attr1=\"xzy\">abc</b> </a> return let $in-xml-2 := <a xmlns:a=\"http://a\" a:attr1=\"123\" attr1=\"456\"> <b a:attr1=\"ghi\" attr1=\"xzy\">abc</b> </a> return (functx:remove-attributes-deep( $in-xml-2, 'a:attr1'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a attr1=\"456\"><b attr1=\"xzy\">abc</b></a>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes attributes from an XML fragment, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes-deep.html : @param $nodes the root(s) to start from : @param $names the names of the attributes to remove, or * for all attributes ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveAttributesDeepAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes attributes from an XML fragment, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-attributes-deep.html : @param $nodes the root(s) to start from : @param $names the names of the attributes to remove, or * for all attributes :)\n" +
      "         declare function functx:remove-attributes-deep ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then element { node-name($node)} { $node/@*[not(functx:name-test(name(),$names))], functx:remove-attributes-deep($node/node(), $names)} else if ($node instance of document-node()) then functx:remove-attributes-deep($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <a attr1=\"123\" attr2=\"456\"> <b attr1=\"xzy\">abc</b> </a> return let $in-xml-2 := <a xmlns:a=\"http://a\" a:attr1=\"123\" attr1=\"456\"> <b a:attr1=\"ghi\" attr1=\"xzy\">abc</b> </a> return (functx:remove-attributes-deep( $in-xml-1, ('attr1','attr2')), functx:remove-attributes-deep( $in-xml-1, ('attr1','attr3')), functx:remove-attributes-deep( $in-xml-2, 'a:attr1'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a><b>abc</b></a><a attr2=\"456\"><b>abc</b></a><a attr1=\"456\"><b attr1=\"xzy\">abc</b></a>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes child elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements.html : @param $elements the element(s) from which you wish to remove the children : @param $names the names of the child elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElements1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes child elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements.html : @param $elements the element(s) from which you wish to remove the children : @param $names the names of the child elements to remove :)\n" +
      "         declare function functx:remove-elements ( $elements as element()* , $names as xs:string* ) as element()* { for $element in $elements return element {node-name($element)} {$element/@*, $element/node()[not(functx:name-test(name(),$names))] } } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a>123</a> <a>456</a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a>123</a> <x:a>456</x:a> <c>Mixed <x:a>content</x:a></c> </in-xml> return (functx:remove-elements( $in-xml-1, 'c'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a>123</a><a>456</a></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes child elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements.html : @param $elements the element(s) from which you wish to remove the children : @param $names the names of the child elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElements2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes child elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements.html : @param $elements the element(s) from which you wish to remove the children : @param $names the names of the child elements to remove :)\n" +
      "         declare function functx:remove-elements ( $elements as element()* , $names as xs:string* ) as element()* { for $element in $elements return element {node-name($element)} {$element/@*, $element/node()[not(functx:name-test(name(),$names))] } } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a>123</a> <a>456</a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a>123</a> <x:a>456</x:a> <c>Mixed <x:a>content</x:a></c> </in-xml> return (functx:remove-elements( $in-xml-1, ('a','b')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><c>Mixed <b>content</b></c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes child elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements.html : @param $elements the element(s) from which you wish to remove the children : @param $names the names of the child elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElements3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes child elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements.html : @param $elements the element(s) from which you wish to remove the children : @param $names the names of the child elements to remove :)\n" +
      "         declare function functx:remove-elements ( $elements as element()* , $names as xs:string* ) as element()* { for $element in $elements return element {node-name($element)} {$element/@*, $element/node()[not(functx:name-test(name(),$names))] } } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a>123</a> <a>456</a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a>123</a> <x:a>456</x:a> <c>Mixed <x:a>content</x:a></c> </in-xml> return (functx:remove-elements( $in-xml-2, 'x:a'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a xmlns:x=\"http://x\">123</a><c xmlns:x=\"http://x\">Mixed <x:a>content</x:a></c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes child elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements.html : @param $elements the element(s) from which you wish to remove the children : @param $names the names of the child elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes child elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements.html : @param $elements the element(s) from which you wish to remove the children : @param $names the names of the child elements to remove :)\n" +
      "         declare function functx:remove-elements ( $elements as element()* , $names as xs:string* ) as element()* { for $element in $elements return element {node-name($element)} {$element/@*, $element/node()[not(functx:name-test(name(),$names))] } } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a>123</a> <a>456</a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a>123</a> <x:a>456</x:a> <c>Mixed <x:a>content</x:a></c> </in-xml> return (functx:remove-elements( $in-xml-1, 'c'), functx:remove-elements( $in-xml-1, ('a','b')), functx:remove-elements( $in-xml-2, 'x:a'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a>123</a><a>456</a></in-xml><in-xml><c>Mixed <b>content</b></c></in-xml><in-xml><a xmlns:x=\"http://x\">123</a><c xmlns:x=\"http://x\">Mixed <x:a>content</x:a></c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsDeep1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-deep ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then () else element { node-name($node)} { $node/@*, functx:remove-elements-deep($node/node(), $names)} else if ($node instance of document-node()) then functx:remove-elements-deep($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <x:b>b1</x:b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return (functx:remove-elements-deep( $in-xml-1, 'b'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a><c>c1</c></a><c>Mixed </c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsDeep2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-deep ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then () else element { node-name($node)} { $node/@*, functx:remove-elements-deep($node/node(), $names)} else if ($node instance of document-node()) then functx:remove-elements-deep($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <x:b>b1</x:b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return (functx:remove-elements-deep( $in-xml-1, 'a'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><c>Mixed <b>content</b></c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsDeep3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-deep ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then () else element { node-name($node)} { $node/@*, functx:remove-elements-deep($node/node(), $names)} else if ($node instance of document-node()) then functx:remove-elements-deep($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <x:b>b1</x:b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return (functx:remove-elements-deep( $in-xml-1, ('b','c')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a/></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsDeep4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-deep ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then () else element { node-name($node)} { $node/@*, functx:remove-elements-deep($node/node(), $names)} else if ($node instance of document-node()) then functx:remove-elements-deep($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <x:b>b1</x:b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return (functx:remove-elements-deep( $in-xml-2, 'x:b'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a><c>c1</c></a><c>Mixed <b>content</b></c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsDeepAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant elements from an XML node, based on name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-deep.html : @param $nodes root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-deep ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then () else element { node-name($node)} { $node/@*, functx:remove-elements-deep($node/node(), $names)} else if ($node instance of document-node()) then functx:remove-elements-deep($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <x:b>b1</x:b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return (functx:remove-elements-deep( $in-xml-1, 'b'), functx:remove-elements-deep( $in-xml-1, 'a'), functx:remove-elements-deep( $in-xml-1, ('b','c')), functx:remove-elements-deep( $in-xml-2, 'x:b'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a><c>c1</c></a><c>Mixed </c></in-xml><in-xml><c>Mixed <b>content</b></c></in-xml><in-xml><a/></in-xml><in-xml><a><c>c1</c></a><c>Mixed <b>content</b></c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsNotContents1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-not-contents ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then functx:remove-elements-not-contents($node/node(), $names) else element {node-name($node)} {$node/@*, functx:remove-elements-not-contents($node/node(),$names)} else if ($node instance of document-node()) then functx:remove-elements-not-contents($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <x:b>content</x:b></c> </in-xml> return (functx:remove-elements-not-contents( $in-xml-1, 'b'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a>b1<c>c1</c></a><c>Mixed content</c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsNotContents2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-not-contents ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then functx:remove-elements-not-contents($node/node(), $names) else element {node-name($node)} {$node/@*, functx:remove-elements-not-contents($node/node(),$names)} else if ($node instance of document-node()) then functx:remove-elements-not-contents($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <x:b>content</x:b></c> </in-xml> return (functx:remove-elements-not-contents( $in-xml-1, ('b','c')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a>b1c1</a>Mixed content</in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsNotContents3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-not-contents ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then functx:remove-elements-not-contents($node/node(), $names) else element {node-name($node)} {$node/@*, functx:remove-elements-not-contents($node/node(),$names)} else if ($node instance of document-node()) then functx:remove-elements-not-contents($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <x:b>content</x:b></c> </in-xml> return (functx:remove-elements-not-contents( $in-xml-1, 'a'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><b>b1</b><c>c1</c><c>Mixed <b>content</b></c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsNotContents4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-not-contents ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then functx:remove-elements-not-contents($node/node(), $names) else element {node-name($node)} {$node/@*, functx:remove-elements-not-contents($node/node(),$names)} else if ($node instance of document-node()) then functx:remove-elements-not-contents($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <x:b>content</x:b></c> </in-xml> return (functx:remove-elements-not-contents( $in-xml-2, 'x:b'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a><b>b1</b><c>c1</c></a><c>Mixed content</c></in-xml>", false)
    );
  }

  /**
   * ~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards ~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxRemoveElementsNotContentsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether a name matches a list of names or name wildcards : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_name-test.html : @param $testname the name to test : @param $names the list of names or name wildcards :)\n" +
      "         declare function functx:name-test ( $testname as xs:string? , $names as xs:string* ) as xs:boolean { $testname = $names or $names = '*' or functx:substring-after-if-contains($testname,':') = (for $name in $names return substring-after($name,'*:')) or substring-before($testname,':') = (for $name in $names[contains(.,':*')] return substring-before($name,':*')) } ;\n" +
      "                    (:~ : Removes descendant XML elements but keeps their content : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_remove-elements-not-contents.html : @param $nodes the root(s) to start from : @param $names the names of the elements to remove :)\n" +
      "         declare function functx:remove-elements-not-contents ( $nodes as node()* , $names as xs:string* ) as node()* { for $node in $nodes return if ($node instance of element()) then if (functx:name-test(name($node),$names)) then functx:remove-elements-not-contents($node/node(), $names) else element {node-name($node)} {$node/@*, functx:remove-elements-not-contents($node/node(),$names)} else if ($node instance of document-node()) then functx:remove-elements-not-contents($node/node(), $names) else $node } ;\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    let $in-xml-1 := <in-xml> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <b>content</b></c> </in-xml> return let $in-xml-2 := <in-xml xmlns:x=\"http://x\"> <a> <b>b1</b> <c>c1</c> </a> <c>Mixed <x:b>content</x:b></c> </in-xml> return (functx:remove-elements-not-contents( $in-xml-1, 'b'), functx:remove-elements-not-contents( $in-xml-1, ('b','c')), functx:remove-elements-not-contents( $in-xml-1, 'a'), functx:remove-elements-not-contents( $in-xml-2, 'x:b'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<in-xml><a>b1<c>c1</c></a><c>Mixed content</c></in-xml><in-xml><a>b1c1</a>Mixed content</in-xml><in-xml><b>b1</b><c>c1</c><c>Mixed <b>content</b></c></in-xml><in-xml><a><b>b1</b><c>c1</c></a><c>Mixed content</c></in-xml>", false)
    );
  }

  /**
   * ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxRepeatString1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:repeat-string('*', 6))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "******")
    );
  }

  /**
   * ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxRepeatString2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:repeat-string('abc', 3))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abcabcabc")
    );
  }

  /**
   * ~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies .
   */
  @org.junit.Test
  public void functxFunctxRepeatStringAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Repeats a string a given number of times : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_repeat-string.html : @param $stringToRepeat the string to repeat : @param $count the desired number of copies :)\n" +
      "         declare function functx:repeat-string ( $stringToRepeat as xs:string? , $count as xs:integer ) as xs:string { string-join((for $i in 1 to $count return $stringToRepeat), '') } ;\n" +
      "                    (functx:repeat-string('*', 6), functx:repeat-string('abc', 3))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "****** abcabcabc")
    );
  }

  /**
   * ~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceBeginning1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-beginning ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('^.*?', $pattern), $replacement) } ;\n" +
      "                    (functx:replace-beginning('abc-def', '-', 'xxx'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xxxdef")
    );
  }

  /**
   * ~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceBeginning2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-beginning ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('^.*?', $pattern), $replacement) } ;\n" +
      "                    (functx:replace-beginning('abc-def', '-', ''))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "def")
    );
  }

  /**
   * ~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceBeginning3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-beginning ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('^.*?', $pattern), $replacement) } ;\n" +
      "                    (functx:replace-beginning( '---abc', '[a-z]', 'x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xbc")
    );
  }

  /**
   * ~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceBeginning4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-beginning ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('^.*?', $pattern), $replacement) } ;\n" +
      "                    (functx:replace-beginning( '2004-12-05', '-', '2005-'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "2005-15-05")
    );
  }

  /**
   * ~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceBeginningAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the beginning of a string, up to a matched pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-beginning.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace up to : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-beginning ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('^.*?', $pattern), $replacement) } ;\n" +
      "                    (functx:replace-beginning('abc-def', '-', 'xxx'), functx:replace-beginning('abc-def', '-', ''), functx:replace-beginning( '---abc', '[a-z]', 'x'), functx:replace-beginning( '2004-12-05', '-', '2005-'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xxxdef def xbc 2005-15-05")
    );
  }

  /**
   * ~ : Updates the content of one or more elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-element-values.html : @param $elements the elements whose content you wish to replace : @param $values the replacement values .
   */
  @org.junit.Test
  public void functxFunctxReplaceElementValues1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Updates the content of one or more elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-element-values.html : @param $elements the elements whose content you wish to replace : @param $values the replacement values :)\n" +
      "         declare function functx:replace-element-values ( $elements as element()* , $values as xs:anyAtomicType* ) as element()* { for $element at $seq in $elements return element { node-name($element)} { $element/@*, $values[$seq] } } ;\n" +
      "                    let $in-xml := <in-xml> <price num=\"1\">12</price> <price num=\"2\">20</price> <price num=\"3\">5</price> </in-xml> return (functx:replace-element-values( $in-xml/price, for $p in $in-xml/price return $p * 2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<price num=\"1\">24</price><price num=\"2\">40</price><price num=\"3\">10</price>", false)
    );
  }

  /**
   * ~ : Updates the content of one or more elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-element-values.html : @param $elements the elements whose content you wish to replace : @param $values the replacement values .
   */
  @org.junit.Test
  public void functxFunctxReplaceElementValues2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Updates the content of one or more elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-element-values.html : @param $elements the elements whose content you wish to replace : @param $values the replacement values :)\n" +
      "         declare function functx:replace-element-values ( $elements as element()* , $values as xs:anyAtomicType* ) as element()* { for $element at $seq in $elements return element { node-name($element)} { $element/@*, $values[$seq] } } ;\n" +
      "                    let $in-xml := <in-xml> <price num=\"1\">12</price> <price num=\"2\">20</price> <price num=\"3\">5</price> </in-xml> return (for $p in $in-xml/price return functx:replace-element-values( $p,concat($p,'.0')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<price num=\"1\">12.0</price><price num=\"2\">20.0</price><price num=\"3\">5.0</price>", false)
    );
  }

  /**
   * ~ : Updates the content of one or more elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-element-values.html : @param $elements the elements whose content you wish to replace : @param $values the replacement values .
   */
  @org.junit.Test
  public void functxFunctxReplaceElementValuesAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Updates the content of one or more elements : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-element-values.html : @param $elements the elements whose content you wish to replace : @param $values the replacement values :)\n" +
      "         declare function functx:replace-element-values ( $elements as element()* , $values as xs:anyAtomicType* ) as element()* { for $element at $seq in $elements return element { node-name($element)} { $element/@*, $values[$seq] } } ;\n" +
      "                    let $in-xml := <in-xml> <price num=\"1\">12</price> <price num=\"2\">20</price> <price num=\"3\">5</price> </in-xml> return (functx:replace-element-values( $in-xml/price, for $p in $in-xml/price return $p * 2), for $p in $in-xml/price return functx:replace-element-values( $p,concat($p,'.0')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<price num=\"1\">24</price><price num=\"2\">40</price><price num=\"3\">10</price><price num=\"1\">12.0</price><price num=\"2\">20.0</price><price num=\"3\">5.0</price>", false)
    );
  }

  /**
   * ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceFirst1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:replace-first('abcabcabc', 'ab', 'x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xcabcabc")
    );
  }

  /**
   * ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceFirst2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:replace-first('elementary', 'e.*e', 'x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xntary")
    );
  }

  /**
   * ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceFirst3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:replace-first( 'elementary', 'e.*?e', 'x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xmentary")
    );
  }

  /**
   * ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceFirst4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:replace-first('9999-9999', '\\d+', 'X'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "X-9999")
    );
  }

  /**
   * ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceFirst5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:replace-first('9999-9999', '\\d{3}', 'X'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "X9-9999")
    );
  }

  /**
   * ~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string .
   */
  @org.junit.Test
  public void functxFunctxReplaceFirstAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Replaces the first match of a pattern : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-first.html : @param $arg the entire string to change : @param $pattern the pattern of characters to replace : @param $replacement the replacement string :)\n" +
      "         declare function functx:replace-first ( $arg as xs:string? , $pattern as xs:string , $replacement as xs:string ) as xs:string { replace($arg, concat('(^.*?)', $pattern), concat('$1',$replacement)) } ;\n" +
      "                    (functx:replace-first('abcabcabc', 'ab', 'x'), functx:replace-first('elementary', 'e.*e', 'x'), functx:replace-first( 'elementary', 'e.*?e', 'x'), functx:replace-first('9999-9999', '\\d+', 'X'), functx:replace-first('9999-9999', '\\d{3}', 'X'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xcabcabc xntary xmentary X-9999 X9-9999")
    );
  }

  /**
   * ~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent ~ : Performs multiple replacements, using pairs of replace parameters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-multi.html : @param $arg the string to manipulate : @param $changeFrom the sequence of strings or patterns to change from : @param $changeTo the sequence of strings to change to .
   */
  @org.junit.Test
  public void functxFunctxReplaceMulti1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The first argument if it is not empty, otherwise the second argument : : @author W3C XML Query WG : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_if-absent.html : @param $arg the item(s) that may be absent : @param $value the item(s) to use if the item is absent :)\n" +
      "         declare function functx:if-absent\n" +
      "           ( $arg as item()* , $value as item()* ) as item()* {\n" +
      "           if (exists($arg)) then $arg else $value } ;\n" +
      "                    (:~ : Performs multiple replacements, using pairs of replace parameters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_replace-multi.html : @param $arg the string to manipulate : @param $changeFrom the sequence of strings or patterns to change from : @param $changeTo the sequence of strings to change to :)\n" +
      "         declare function functx:replace-multi ( $arg as xs:string? , $changeFrom as xs:string* , $changeTo as xs:string* ) as xs:string? {\n" +
      "           if (count($changeFrom) > 0)\n" +
      "           then functx:replace-multi( replace($arg, $changeFrom[1], functx:if-absent($changeTo[1],'')), $changeFrom[position() > 1], $changeTo[position() > 1])\n" +
      "           else $arg\n" +
      "         } ;\n" +
      "         let $fr := ('[a-c]', 'def', '\\d+')\n" +
      "         return let $to := ('x', 'y', '0')\n" +
      "         return (functx:replace-multi('abcdef123',$fr,$to))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xxxy0")
    );
  }

  /**
   * ~ : Reverses the order of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_reverse-string.html : @param $arg the string to reverse .
   */
  @org.junit.Test
  public void functxFunctxReverseString1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Reverses the order of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_reverse-string.html : @param $arg the string to reverse :)\n" +
      "         declare function functx:reverse-string ( $arg as xs:string? ) as xs:string { codepoints-to-string(reverse(string-to-codepoints($arg))) } ;\n" +
      "                    (functx:reverse-string('abc'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "cba")
    );
  }

  /**
   * ~ : Reverses the order of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_reverse-string.html : @param $arg the string to reverse .
   */
  @org.junit.Test
  public void functxFunctxReverseString2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Reverses the order of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_reverse-string.html : @param $arg the string to reverse :)\n" +
      "         declare function functx:reverse-string ( $arg as xs:string? ) as xs:string { codepoints-to-string(reverse(string-to-codepoints($arg))) } ;\n" +
      "                    (functx:reverse-string('a'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a")
    );
  }

  /**
   * ~ : Reverses the order of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_reverse-string.html : @param $arg the string to reverse .
   */
  @org.junit.Test
  public void functxFunctxReverseStringAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Reverses the order of characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_reverse-string.html : @param $arg the string to reverse :)\n" +
      "         declare function functx:reverse-string ( $arg as xs:string? ) as xs:string { codepoints-to-string(reverse(string-to-codepoints($arg))) } ;\n" +
      "                    (functx:reverse-string('abc'), functx:reverse-string('a'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "cba a")
    );
  }

  /**
   * ~ : Trims trailing whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_right-trim.html : @param $arg the string to trim .
   */
  @org.junit.Test
  public void functxFunctxRightTrim1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Trims trailing whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_right-trim.html : @param $arg the string to trim :)\n" +
      "         declare function functx:right-trim ( $arg as xs:string? ) as xs:string { replace($arg,'\\s+$','') } ;\n" +
      "                    (functx:right-trim('xyz '))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xyz")
    );
  }

  /**
   * ~ : Trims trailing whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_right-trim.html : @param $arg the string to trim .
   */
  @org.junit.Test
  public void functxFunctxRightTrim2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Trims trailing whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_right-trim.html : @param $arg the string to trim :)\n" +
      "         declare function functx:right-trim ( $arg as xs:string? ) as xs:string { replace($arg,'\\s+$','') } ;\n" +
      "         (functx:right-trim(' x   xyz '))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, " x   xyz")
    );
  }

  /**
   * ~ : Trims trailing whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_right-trim.html : @param $arg the string to trim .
   */
  @org.junit.Test
  public void functxFunctxRightTrim3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Trims trailing whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_right-trim.html : @param $arg the string to trim :)\n" +
      "         declare function functx:right-trim ( $arg as xs:string? ) as xs:string { replace($arg,'\\s+$','') } ;\n" +
      "                    (functx:right-trim('xyz'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xyz")
    );
  }

  /**
   * ~ : Trims trailing whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_right-trim.html : @param $arg the string to trim .
   */
  @org.junit.Test
  public void functxFunctxRightTrimAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Trims trailing whitespace : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_right-trim.html : @param $arg the string to trim :)\n" +
      "         declare function functx:right-trim ( $arg as xs:string? ) as xs:string { replace($arg,'\\s+$','') } ;\n" +
      "                    (functx:right-trim('xyz '), functx:right-trim(' x   xyz '), functx:right-trim('xyz'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertDeepEq("\"xyz\", \" x   xyz\", \"xyz\"")
    );
  }

  /**
   * ~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI .
   */
  @org.junit.Test
  public void functxFunctxSchemeFromUri1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI :)\n" +
      "         declare function functx:scheme-from-uri ( $uri as xs:string? ) as xs:string? { substring-before($uri,':') } ;\n" +
      "                    (functx:scheme-from-uri( 'http://www.datypic.com'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "http")
    );
  }

  /**
   * ~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI .
   */
  @org.junit.Test
  public void functxFunctxSchemeFromUri2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI :)\n" +
      "         declare function functx:scheme-from-uri ( $uri as xs:string? ) as xs:string? { substring-before($uri,':') } ;\n" +
      "                    (functx:scheme-from-uri( 'ftp://ftp.datypic.com'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "ftp")
    );
  }

  /**
   * ~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI .
   */
  @org.junit.Test
  public void functxFunctxSchemeFromUri3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI :)\n" +
      "         declare function functx:scheme-from-uri ( $uri as xs:string? ) as xs:string? { substring-before($uri,':') } ;\n" +
      "                    (functx:scheme-from-uri('ftp.datypic.com'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI .
   */
  @org.junit.Test
  public void functxFunctxSchemeFromUri4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI :)\n" +
      "         declare function functx:scheme-from-uri ( $uri as xs:string? ) as xs:string? { substring-before($uri,':') } ;\n" +
      "                    (functx:scheme-from-uri('www.datypic.com'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI .
   */
  @org.junit.Test
  public void functxFunctxSchemeFromUri5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI :)\n" +
      "         declare function functx:scheme-from-uri ( $uri as xs:string? ) as xs:string? { substring-before($uri,':') } ;\n" +
      "                    (functx:scheme-from-uri('prod.html'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "")
    );
  }

  /**
   * ~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI .
   */
  @org.junit.Test
  public void functxFunctxSchemeFromUriAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Returns the scheme from a URI : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_scheme-from-uri.html : @param $uri the URI :)\n" +
      "         declare function functx:scheme-from-uri ( $uri as xs:string? ) as xs:string? { substring-before($uri,':') } ;\n" +
      "                    (functx:scheme-from-uri( 'http://www.datypic.com'), functx:scheme-from-uri( 'ftp://ftp.datypic.com'), functx:scheme-from-uri('ftp.datypic.com'), functx:scheme-from-uri('www.datypic.com'), functx:scheme-from-uri('prod.html'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "http ftp   ")
    );
  }

  /**
   * ~ : Whether two sequences have the same XML node content and/or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-deep-equal.html : @param $seq1 the first sequence : @param $seq2 the second sequence .
   */
  @org.junit.Test
  public void functxFunctxSequenceDeepEqual1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences have the same XML node content and/or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-deep-equal.html : @param $seq1 the first sequence : @param $seq2 the second sequence :)\n" +
      "         declare function functx:sequence-deep-equal ( $seq1 as item()* , $seq2 as item()* ) as xs:boolean { every $i in 1 to max((count($seq1),count($seq2))) satisfies deep-equal($seq1[$i],$seq2[$i]) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-deep-equal( $in-xml/author/*, $in-xml/*/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether two sequences have the same XML node content and/or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-deep-equal.html : @param $seq1 the first sequence : @param $seq2 the second sequence .
   */
  @org.junit.Test
  public void functxFunctxSequenceDeepEqual2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences have the same XML node content and/or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-deep-equal.html : @param $seq1 the first sequence : @param $seq2 the second sequence :)\n" +
      "         declare function functx:sequence-deep-equal ( $seq1 as item()* , $seq2 as item()* ) as xs:boolean { every $i in 1 to max((count($seq1),count($seq2))) satisfies deep-equal($seq1[$i],$seq2[$i]) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-deep-equal( $in-xml/author[1], $anAuthor))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether two sequences have the same XML node content and/or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-deep-equal.html : @param $seq1 the first sequence : @param $seq2 the second sequence .
   */
  @org.junit.Test
  public void functxFunctxSequenceDeepEqual3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences have the same XML node content and/or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-deep-equal.html : @param $seq1 the first sequence : @param $seq2 the second sequence :)\n" +
      "         declare function functx:sequence-deep-equal ( $seq1 as item()* , $seq2 as item()* ) as xs:boolean { every $i in 1 to max((count($seq1),count($seq2))) satisfies deep-equal($seq1[$i],$seq2[$i]) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-deep-equal( (1,2,3), (1.0,2.0,3.0)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether two sequences have the same XML node content and/or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-deep-equal.html : @param $seq1 the first sequence : @param $seq2 the second sequence .
   */
  @org.junit.Test
  public void functxFunctxSequenceDeepEqualAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences have the same XML node content and/or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-deep-equal.html : @param $seq1 the first sequence : @param $seq2 the second sequence :)\n" +
      "         declare function functx:sequence-deep-equal ( $seq1 as item()* , $seq2 as item()* ) as xs:boolean { every $i in 1 to max((count($seq1),count($seq2))) satisfies deep-equal($seq1[$i],$seq2[$i]) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-deep-equal( $in-xml/author/*, $in-xml/*/*), functx:sequence-deep-equal( $in-xml/author[1], $anAuthor), functx:sequence-deep-equal( (1,2,3), (1.0,2.0,3.0)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true true")
    );
  }

  /**
   * ~ : Whether two sequences contain the same XML nodes, in the same order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxSequenceNodeEqual1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences contain the same XML nodes, in the same order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes :)\n" +
      "         declare function functx:sequence-node-equal ( $seq1 as node()* , $seq2 as node()* ) as xs:boolean { every $i in 1 to max((count($seq1),count($seq2))) satisfies $seq1[$i] is $seq2[$i] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-node-equal( $in-xml/author/*, $in-xml/*/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether two sequences contain the same XML nodes, in the same order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxSequenceNodeEqual2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences contain the same XML nodes, in the same order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes :)\n" +
      "         declare function functx:sequence-node-equal ( $seq1 as node()* , $seq2 as node()* ) as xs:boolean { every $i in 1 to max((count($seq1),count($seq2))) satisfies $seq1[$i] is $seq2[$i] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-node-equal( $in-xml/author, ($in-xml/author[2],$in-xml/author[1])))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether two sequences contain the same XML nodes, in the same order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxSequenceNodeEqual3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences contain the same XML nodes, in the same order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes :)\n" +
      "         declare function functx:sequence-node-equal ( $seq1 as node()* , $seq2 as node()* ) as xs:boolean { every $i in 1 to max((count($seq1),count($seq2))) satisfies $seq1[$i] is $seq2[$i] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-node-equal( $in-xml/author[1],$anAuthor))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether two sequences contain the same XML nodes, in the same order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxSequenceNodeEqualAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences contain the same XML nodes, in the same order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes :)\n" +
      "         declare function functx:sequence-node-equal ( $seq1 as node()* , $seq2 as node()* ) as xs:boolean { every $i in 1 to max((count($seq1),count($seq2))) satisfies $seq1[$i] is $seq2[$i] } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-node-equal( $in-xml/author/*, $in-xml/*/*), functx:sequence-node-equal( $in-xml/author, ($in-xml/author[2],$in-xml/author[1])), functx:sequence-node-equal( $in-xml/author[1],$anAuthor))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true false false")
    );
  }

  /**
   * ~ : Whether two sequences contain the same XML nodes, regardless of order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal-any-order.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxSequenceNodeEqualAnyOrder1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences contain the same XML nodes, regardless of order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal-any-order.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes :)\n" +
      "         declare function functx:sequence-node-equal-any-order ( $seq1 as node()* , $seq2 as node()* ) as xs:boolean { not( ($seq1 except $seq2, $seq2 except $seq1)) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-node-equal-any-order( $in-xml/author, $in-xml/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether two sequences contain the same XML nodes, regardless of order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal-any-order.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxSequenceNodeEqualAnyOrder2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences contain the same XML nodes, regardless of order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal-any-order.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes :)\n" +
      "         declare function functx:sequence-node-equal-any-order ( $seq1 as node()* , $seq2 as node()* ) as xs:boolean { not( ($seq1 except $seq2, $seq2 except $seq1)) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-node-equal-any-order( $in-xml/author, ($in-xml/author[2],$in-xml/author[1])))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(true)
    );
  }

  /**
   * ~ : Whether two sequences contain the same XML nodes, regardless of order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal-any-order.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxSequenceNodeEqualAnyOrder3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences contain the same XML nodes, regardless of order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal-any-order.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes :)\n" +
      "         declare function functx:sequence-node-equal-any-order ( $seq1 as node()* , $seq2 as node()* ) as xs:boolean { not( ($seq1 except $seq2, $seq2 except $seq1)) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-node-equal-any-order( $in-xml/author[1],$anAuthor))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertBoolean(false)
    );
  }

  /**
   * ~ : Whether two sequences contain the same XML nodes, regardless of order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal-any-order.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes .
   */
  @org.junit.Test
  public void functxFunctxSequenceNodeEqualAnyOrderAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Whether two sequences contain the same XML nodes, regardless of order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-node-equal-any-order.html : @param $seq1 the first sequence of nodes : @param $seq2 the second sequence of nodes :)\n" +
      "         declare function functx:sequence-node-equal-any-order ( $seq1 as node()* , $seq2 as node()* ) as xs:boolean { not( ($seq1 except $seq2, $seq2 except $seq1)) } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return let $anAuthor := <author> <fName>Kate</fName> <lName>Jones</lName> </author> return (functx:sequence-node-equal-any-order( $in-xml/author, $in-xml/*), functx:sequence-node-equal-any-order( $in-xml/author, ($in-xml/author[2],$in-xml/author[1])), functx:sequence-node-equal-any-order( $in-xml/author[1],$anAuthor))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "true true false")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type(2))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xs:integer")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType10() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type($in-xml/node()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "node()+")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType11() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type(($in-xml/*,'2')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "item()+")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type(('abc','def')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xs:string+")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type(('abc',2)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xs:anyAtomicType+")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType4() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type( () ))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "empty-sequence()")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType5() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type($in-xml/*[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "element()")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType6() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type($in-xml/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "element()+")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType7() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type($in-xml/*/@*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "attribute()+")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType8() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type($in-xml/*/text()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "text()+")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceType9() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type($in-xml/comment()))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "comment()")
    );
  }

  /**
   * ~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine ~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine ~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine .
   */
  @org.junit.Test
  public void functxFunctxSequenceTypeAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The built-in type of an atomic value : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_atomic-type.html : @param $values the value(s) whose type you want to determine :)\n" +
      "         declare function functx:atomic-type ( $values as xs:anyAtomicType* ) as xs:string* { for $val in $values return (if ($val instance of xs:untypedAtomic) then 'xs:untypedAtomic' else if ($val instance of xs:anyURI) then 'xs:anyURI' else if ($val instance of xs:ENTITY) then 'xs:ENTITY' else if ($val instance of xs:ID) then 'xs:ID' else if ($val instance of xs:NMTOKEN) then 'xs:NMTOKEN' else if ($val instance of xs:language) then 'xs:language' else if ($val instance of xs:NCName) then 'xs:NCName' else if ($val instance of xs:Name) then 'xs:Name' else if ($val instance of xs:token) then 'xs:token' else if ($val instance of xs:normalizedString) then 'xs:normalizedString' else if ($val instance of xs:string) then 'xs:string' else if ($val instance of xs:QName) then 'xs:QName' else if ($val instance of xs:boolean) then 'xs:boolean' else if ($val instance of xs:base64Binary) then 'xs:base64Binary' else if ($val instance of xs:hexBinary) then 'xs:hexBinary' else if ($val instance of xs:byte) then 'xs:byte' else if ($val instance of xs:short) then 'xs:short' else if ($val instance of xs:int) then 'xs:int' else if ($val instance of xs:long) then 'xs:long' else if ($val instance of xs:unsignedByte) then 'xs:unsignedByte' else if ($val instance of xs:unsignedShort) then 'xs:unsignedShort' else if ($val instance of xs:unsignedInt) then 'xs:unsignedInt' else if ($val instance of xs:unsignedLong) then 'xs:unsignedLong' else if ($val instance of xs:positiveInteger) then 'xs:positiveInteger' else if ($val instance of xs:nonNegativeInteger) then 'xs:nonNegativeInteger' else if ($val instance of xs:negativeInteger) then 'xs:negativeInteger' else if ($val instance of xs:nonPositiveInteger) then 'xs:nonPositiveInteger' else if ($val instance of xs:integer) then 'xs:integer' else if ($val instance of xs:decimal) then 'xs:decimal' else if ($val instance of xs:float) then 'xs:float' else if ($val instance of xs:double) then 'xs:double' else if ($val instance of xs:date) then 'xs:date' else if ($val instance of xs:time) then 'xs:time' else if ($val instance of xs:dateTime) then 'xs:dateTime' else if ($val instance of xs:dayTimeDuration) then 'xs:dayTimeDuration' else if ($val instance of xs:yearMonthDuration) then 'xs:yearMonthDuration' else if ($val instance of xs:duration) then 'xs:duration' else if ($val instance of xs:gMonth) then 'xs:gMonth' else if ($val instance of xs:gYear) then 'xs:gYear' else if ($val instance of xs:gYearMonth) then 'xs:gYearMonth' else if ($val instance of xs:gDay) then 'xs:gDay' else if ($val instance of xs:gMonthDay) then 'xs:gMonthDay' else 'unknown') } ;\n" +
      "                    (:~ : The XML node kind (element, attribute, text, etc.) : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_node-kind.html : @param $nodes the node(s) whose kind you want to determine :)\n" +
      "         declare function functx:node-kind ( $nodes as node()* ) as xs:string* { for $node in $nodes return if ($node instance of element()) then 'element' else if ($node instance of attribute()) then 'attribute' else if ($node instance of text()) then 'text' else if ($node instance of document-node()) then 'document-node' else if ($node instance of comment()) then 'comment' else if ($node instance of processing-instruction()) then 'processing-instruction' else 'unknown' } ;\n" +
      "                    (:~ : The sequence type that represents a sequence of nodes or values : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sequence-type.html : @param $items the items whose sequence type you want to determine :)\n" +
      "         declare function functx:sequence-type ( $items as item()* ) as xs:string { concat( if (empty($items)) then 'empty-sequence()' else if (every $val in $items satisfies $val instance of xs:anyAtomicType) then if (count(distinct-values(functx:atomic-type($items))) > 1) then 'xs:anyAtomicType' else functx:atomic-type($items[1]) else if (some $val in $items satisfies $val instance of xs:anyAtomicType) then 'item()' else if (count(distinct-values(functx:node-kind($items))) > 1) then 'node()' else concat(functx:node-kind($items[1]),'()') , if (count($items) > 1) then '+' else '') } ;\n" +
      "                    let $in-xml := <in-xml> <a att1=\"y\">x</a> <b att1=\"x\">x</b> <!-- comment --> </in-xml> return (functx:sequence-type(2), functx:sequence-type(('abc','def')), functx:sequence-type(('abc',2)), functx:sequence-type( () ), functx:sequence-type($in-xml/*[1]), functx:sequence-type($in-xml/*), functx:sequence-type($in-xml/*/@*), functx:sequence-type($in-xml/*/text()), functx:sequence-type($in-xml/comment()), functx:sequence-type($in-xml/node()), functx:sequence-type(($in-xml/*,'2')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "xs:integer xs:string+ xs:anyAtomicType+ empty-sequence() element() element()+ attribute()+ text()+ comment() node()+ item()+")
    );
  }

  /**
   * ~ : The siblings of an XML node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings.html : @param $node the node .
   */
  @org.junit.Test
  public void functxFunctxSiblings1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The siblings of an XML node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings.html : @param $node the node :)\n" +
      "         declare function functx:siblings ( $node as node()? ) as node()* { $node/../node() except $node } ;\n" +
      "                    let $in-xml := <authors a1='xyz'> <author a2='abc'> <fName a3='def'>Kate</fName> <fName a3='def'>Jane</fName> <lName>Jones</lName> </author> <author> <fName a3='def'>John</fName> <lName>Doe</lName> </author> </authors> return (functx:siblings( $in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<author><fName a3=\"def\">John</fName><lName>Doe</lName></author>", false)
    );
  }

  /**
   * ~ : The siblings of an XML node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings.html : @param $node the node .
   */
  @org.junit.Test
  public void functxFunctxSiblings2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The siblings of an XML node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings.html : @param $node the node :)\n" +
      "         declare function functx:siblings ( $node as node()? ) as node()* { $node/../node() except $node } ;\n" +
      "                    let $in-xml := <authors a1='xyz'> <author a2='abc'> <fName a3='def'>Kate</fName> <fName a3='def'>Jane</fName> <lName>Jones</lName> </author> <author> <fName a3='def'>John</fName> <lName>Doe</lName> </author> </authors> return (functx:siblings( $in-xml/author[1]/fName[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName a3=\"def\">Kate</fName><lName>Jones</lName>", false)
    );
  }

  /**
   * ~ : The siblings of an XML node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings.html : @param $node the node .
   */
  @org.junit.Test
  public void functxFunctxSiblingsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The siblings of an XML node : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings.html : @param $node the node :)\n" +
      "         declare function functx:siblings ( $node as node()? ) as node()* { $node/../node() except $node } ;\n" +
      "                    let $in-xml := <authors a1='xyz'> <author a2='abc'> <fName a3='def'>Kate</fName> <fName a3='def'>Jane</fName> <lName>Jones</lName> </author> <author> <fName a3='def'>John</fName> <lName>Doe</lName> </author> </authors> return (functx:siblings( $in-xml/author[1]), functx:siblings( $in-xml/author[1]/fName[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<author><fName a3=\"def\">John</fName><lName>Doe</lName></author><fName a3=\"def\">Kate</fName><lName>Jones</lName>", false)
    );
  }

  /**
   * ~ : The siblings of an XML element that have the same name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings-same-name.html : @param $element the node .
   */
  @org.junit.Test
  public void functxFunctxSiblingsSameName1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The siblings of an XML element that have the same name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings-same-name.html : @param $element the node :)\n" +
      "         declare function functx:siblings-same-name ( $element as element()? ) as element()* { $element/../*[node-name(.) = node-name($element)] except $element } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <fName>Jane</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:siblings-same-name( $in-xml/author[1]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<author><fName>John</fName><lName>Doe</lName></author>", false)
    );
  }

  /**
   * ~ : The siblings of an XML element that have the same name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings-same-name.html : @param $element the node .
   */
  @org.junit.Test
  public void functxFunctxSiblingsSameName2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The siblings of an XML element that have the same name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings-same-name.html : @param $element the node :)\n" +
      "         declare function functx:siblings-same-name ( $element as element()? ) as element()* { $element/../*[node-name(.) = node-name($element)] except $element } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <fName>Jane</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:siblings-same-name( $in-xml/author[1]/fName[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<fName>Kate</fName>", false)
    );
  }

  /**
   * ~ : The siblings of an XML element that have the same name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings-same-name.html : @param $element the node .
   */
  @org.junit.Test
  public void functxFunctxSiblingsSameNameAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The siblings of an XML element that have the same name : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_siblings-same-name.html : @param $element the node :)\n" +
      "         declare function functx:siblings-same-name ( $element as element()? ) as element()* { $element/../*[node-name(.) = node-name($element)] except $element } ;\n" +
      "                    let $in-xml := <authors> <author> <fName>Kate</fName> <fName>Jane</fName> <lName>Jones</lName> </author> <author> <fName>John</fName> <lName>Doe</lName> </author> </authors> return (functx:siblings-same-name( $in-xml/author[1]), functx:siblings-same-name( $in-xml/author[1]/fName[2]))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<author><fName>John</fName><lName>Doe</lName></author><fName>Kate</fName>", false)
    );
  }

  /**
   * ~ : Sorts a sequence of values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSort1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort ( $seq as item()* ) as item()* { for $item in $seq order by $item return $item } ;\n" +
      "                    let $in-xml := <in-xml> <f>c</f> <f>a</f> <e>b</e> </in-xml> return (functx:sort(('c','a','b')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a b c")
    );
  }

  /**
   * ~ : Sorts a sequence of values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSort2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort ( $seq as item()* ) as item()* { for $item in $seq order by $item return $item } ;\n" +
      "                    let $in-xml := <in-xml> <f>c</f> <f>a</f> <e>b</e> </in-xml> return (functx:sort($in-xml/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<f>a</f><e>b</e><f>c</f>", false)
    );
  }

  /**
   * ~ : Sorts a sequence of values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSortAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort ( $seq as item()* ) as item()* { for $item in $seq order by $item return $item } ;\n" +
      "                    let $in-xml := <in-xml> <f>c</f> <f>a</f> <e>b</e> </in-xml> return (functx:sort(('c','a','b')), functx:sort($in-xml/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("a b c<f>a</f><e>b</e><f>c</f>", false)
    );
  }

  /**
   * ~ : Sorts a sequence of numeric values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-as-numeric.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSortAsNumeric1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of numeric values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-as-numeric.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort-as-numeric ( $seq as item()* ) as item()* { for $item in $seq order by number($item) return $item } ;\n" +
      "                    let $in-xml := <in-xml> <f>1</f> <f>35</f> <e>4</e> </in-xml> return (functx:sort-as-numeric(('1','100','99')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "1 99 100")
    );
  }

  /**
   * ~ : Sorts a sequence of numeric values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-as-numeric.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSortAsNumeric2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of numeric values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-as-numeric.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort-as-numeric ( $seq as item()* ) as item()* { for $item in $seq order by number($item) return $item } ;\n" +
      "                    let $in-xml := <in-xml> <f>1</f> <f>35</f> <e>4</e> </in-xml> return (functx:sort-as-numeric($in-xml/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<f>1</f><e>4</e><f>35</f>", false)
    );
  }

  /**
   * ~ : Sorts a sequence of numeric values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-as-numeric.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSortAsNumericAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of numeric values or nodes : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-as-numeric.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort-as-numeric ( $seq as item()* ) as item()* { for $item in $seq order by number($item) return $item } ;\n" +
      "                    let $in-xml := <in-xml> <f>1</f> <f>35</f> <e>4</e> </in-xml> return (functx:sort-as-numeric(('1','100','99')), functx:sort-as-numeric($in-xml/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("1 99 100<f>1</f><e>4</e><f>35</f>", false)
    );
  }

  /**
   * ~ : Sorts a sequence of values or nodes regardless of capitalization : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-case-insensitive.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSortCaseInsensitive1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of values or nodes regardless of capitalization : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-case-insensitive.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort-case-insensitive ( $seq as item()* ) as item()* { for $item in $seq order by upper-case(string($item)) return $item } ;\n" +
      "                    let $in-xml := <in-xml> <f>a</f> <f>c</f> <e>B</e> </in-xml> return (functx:sort-case-insensitive(('a','c','B')))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "a B c")
    );
  }

  /**
   * ~ : Sorts a sequence of values or nodes regardless of capitalization : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-case-insensitive.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSortCaseInsensitive2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of values or nodes regardless of capitalization : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-case-insensitive.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort-case-insensitive ( $seq as item()* ) as item()* { for $item in $seq order by upper-case(string($item)) return $item } ;\n" +
      "                    let $in-xml := <in-xml> <f>a</f> <f>c</f> <e>B</e> </in-xml> return (functx:sort-case-insensitive($in-xml/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<f>a</f><e>B</e><f>c</f>", false)
    );
  }

  /**
   * ~ : Sorts a sequence of values or nodes regardless of capitalization : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-case-insensitive.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSortCaseInsensitiveAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of values or nodes regardless of capitalization : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-case-insensitive.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort-case-insensitive ( $seq as item()* ) as item()* { for $item in $seq order by upper-case(string($item)) return $item } ;\n" +
      "                    let $in-xml := <in-xml> <f>a</f> <f>c</f> <e>B</e> </in-xml> return (functx:sort-case-insensitive(('a','c','B')), functx:sort-case-insensitive($in-xml/*))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("a B c<f>a</f><e>B</e><f>c</f>", false)
    );
  }

  /**
   * ~ : Sorts a sequence of nodes in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-document-order.html : @param $seq the sequence to sort .
   */
  @org.junit.Test
  public void functxFunctxSortDocumentOrder1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Sorts a sequence of nodes in document order : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_sort-document-order.html : @param $seq the sequence to sort :)\n" +
      "         declare function functx:sort-document-order ( $seq as node()* ) as node()* { $seq/. } ;\n" +
      "                    let $in-xml := <in-xml> <a>123</a> <b>456</b> <c>789</c> </in-xml> return (functx:sort-document-order( ($in-xml/c,$in-xml/a)))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<a>123</a><c>789</c>", false)
    );
  }

  /**
   * ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterIfContains1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    (functx:substring-after-if-contains('abcd','b'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "cd")
    );
  }

  /**
   * ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterIfContains2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    (functx:substring-after-if-contains('abcd','x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abcd")
    );
  }

  /**
   * ~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterIfContainsAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Performs substring-after, returning the entire string if it does not contain the delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-if-contains.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-if-contains ( $arg as xs:string? , $delim as xs:string ) as xs:string? { if (contains($arg,$delim)) then substring-after($arg,$delim) else $arg } ;\n" +
      "                    (functx:substring-after-if-contains('abcd','b'), functx:substring-after-if-contains('abcd','x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "cd abcd")
    );
  }

  /**
   * ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape ~ : The substring after the last occurrence of a delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterLast1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (:~ : The substring after the last occurrence of a delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-last ( $arg as xs:string? , $delim as xs:string ) as xs:string { replace ($arg,concat('^.*',functx:escape-for-regex($delim)),'') } ;\n" +
      "                    (functx:substring-after-last('abc-def-ghi', '-'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "ghi")
    );
  }

  /**
   * ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape ~ : The substring after the last occurrence of a delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterLast2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (:~ : The substring after the last occurrence of a delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-last ( $arg as xs:string? , $delim as xs:string ) as xs:string { replace ($arg,concat('^.*',functx:escape-for-regex($delim)),'') } ;\n" +
      "                    (functx:substring-after-last('abcd-abcd', 'ab'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "cd")
    );
  }

  /**
   * ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape ~ : The substring after the last occurrence of a delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterLast3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (:~ : The substring after the last occurrence of a delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-last ( $arg as xs:string? , $delim as xs:string ) as xs:string { replace ($arg,concat('^.*',functx:escape-for-regex($delim)),'') } ;\n" +
      "                    (functx:substring-after-last('abcd-abcd', 'x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abcd-abcd")
    );
  }

  /**
   * ~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape ~ : The substring after the last occurrence of a delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last.html : @param $arg the string to substring : @param $delim the delimiter .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterLastAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : Escapes regex special characters : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_escape-for-regex.html : @param $arg the string to escape :)\n" +
      "         declare function functx:escape-for-regex ( $arg as xs:string? ) as xs:string { replace($arg, '(\\.|\\[|\\]|\\\\|\\||\\-|\\^|\\$|\\?|\\*|\\+|\\{|\\}|\\(|\\))','\\\\$1') } ;\n" +
      "                    (:~ : The substring after the last occurrence of a delimiter : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last.html : @param $arg the string to substring : @param $delim the delimiter :)\n" +
      "         declare function functx:substring-after-last ( $arg as xs:string? , $delim as xs:string ) as xs:string { replace ($arg,concat('^.*',functx:escape-for-regex($delim)),'') } ;\n" +
      "                    (functx:substring-after-last('abc-def-ghi', '-'), functx:substring-after-last('abcd-abcd', 'ab'), functx:substring-after-last('abcd-abcd', 'x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "ghi cd abcd-abcd")
    );
  }

  /**
   * ~ : The substring after the last text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last-match.html : @param $arg the string to substring : @param $regex the regular expression .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterLastMatch1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The substring after the last text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last-match.html : @param $arg the string to substring : @param $regex the regular expression :)\n" +
      "         declare function functx:substring-after-last-match ( $arg as xs:string? , $regex as xs:string ) as xs:string { replace($arg,concat('^.*',$regex),'') } ;\n" +
      "                    (functx:substring-after-last-match( 'abc-def-ghi', '[ad]'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "ef-ghi")
    );
  }

  /**
   * ~ : The substring after the last text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last-match.html : @param $arg the string to substring : @param $regex the regular expression .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterLastMatch2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The substring after the last text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last-match.html : @param $arg the string to substring : @param $regex the regular expression :)\n" +
      "         declare function functx:substring-after-last-match ( $arg as xs:string? , $regex as xs:string ) as xs:string { replace($arg,concat('^.*',$regex),'') } ;\n" +
      "                    (functx:substring-after-last-match( 'abcd-abcd', 'bc?'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "d")
    );
  }

  /**
   * ~ : The substring after the last text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last-match.html : @param $arg the string to substring : @param $regex the regular expression .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterLastMatch3() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The substring after the last text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last-match.html : @param $arg the string to substring : @param $regex the regular expression :)\n" +
      "         declare function functx:substring-after-last-match ( $arg as xs:string? , $regex as xs:string ) as xs:string { replace($arg,concat('^.*',$regex),'') } ;\n" +
      "                    (functx:substring-after-last-match( 'abcd-abcd', 'x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "abcd-abcd")
    );
  }

  /**
   * ~ : The substring after the last text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last-match.html : @param $arg the string to substring : @param $regex the regular expression .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterLastMatchAll() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The substring after the last text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-last-match.html : @param $arg the string to substring : @param $regex the regular expression :)\n" +
      "         declare function functx:substring-after-last-match ( $arg as xs:string? , $regex as xs:string ) as xs:string { replace($arg,concat('^.*',$regex),'') } ;\n" +
      "                    (functx:substring-after-last-match( 'abc-def-ghi', '[ad]'), functx:substring-after-last-match( 'abcd-abcd', 'bc?'), functx:substring-after-last-match( 'abcd-abcd', 'x'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "ef-ghi d abcd-abcd")
    );
  }

  /**
   * ~ : The substring after the first text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-match.html : @param $arg the string to substring : @param $regex the regular expression .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterMatch1() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The substring after the first text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-match.html : @param $arg the string to substring : @param $regex the regular expression :)\n" +
      "         declare function functx:substring-after-match ( $arg as xs:string? , $regex as xs:string ) as xs:string? { replace($arg,concat('^.*?',$regex),'') } ;\n" +
      "                    (functx:substring-after-match( 'abc-def-ghi', '[ce]'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertStringValue(false, "-def-ghi")
    );
  }

  /**
   * ~ : The substring after the first text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-match.html : @param $arg the string to substring : @param $regex the regular expression .
   */
  @org.junit.Test
  public void functxFunctxSubstringAfterMatch2() {
    final XQuery query = new XQuery(
      "declare namespace functx = \"http://www.example.com/\";\n" +
      "                    (:~ : The substring after the first text that matches a regex : : @author Priscilla Walmsley, Datypic : @version 1.0 : @see http://www.xqueryfunctions.com/xq/functx_substring-after-match.html : @param $arg the string to substring : @param $regex the regular expression :)\n" +
      "         declare function functx:substring-after-match ( $arg as xs:string? , $regex as xs:string ) as xs:string? { replace($arg,concat('^.*?',$regex),'') } ;\n" +
      "                    (functx:substring-after-match( 'abcd-abcd', 'ab?'))",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } fina