/******************************************************************************
*
* Copyright (C) 2016-2020 Allegro DVT2.  All rights reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* Use of the Software is limited solely to applications:
* (a) running on a Xilinx device, or
* (b) that interact with a Xilinx device through a bus or interconnect.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* XILINX OR ALLEGRO DVT2 BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
* OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Except as contained in this notice, the name of  Xilinx shall not be used
* in advertising or otherwise to promote the sale, use or other dealings in
* this Software without prior written authorization from Xilinx.
*
*
* Except as contained in this notice, the name of Allegro DVT2 shall not be used
* in advertising or otherwise to promote the sale, use or other dealings in
* this Software without prior written authorization from Allegro DVT2.
*
******************************************************************************/

#include "convert_module_soft_hevc.h"

HEVCProfileType ConvertSoftToModuleHEVCHighTierProfile(AL_EProfile const& profile)
{
  if(!AL_IS_HEVC(profile))
    return HEVCProfileType::HEVC_PROFILE_MAX_ENUM;
  switch(profile)
  {
  case AL_PROFILE_HEVC_MAIN: return HEVCProfileType::HEVC_PROFILE_MAIN_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN10: return HEVCProfileType::HEVC_PROFILE_MAIN_10_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_STILL: return HEVCProfileType::HEVC_PROFILE_MAIN_STILL_HIGH_TIER;
  case AL_PROFILE_HEVC_MONO: return HEVCProfileType::HEVC_PROFILE_MONOCHROME_HIGH_TIER;
  case AL_PROFILE_HEVC_MONO10: return HEVCProfileType::HEVC_PROFILE_MONOCHROME_10_HIGH_TIER;
  case AL_PROFILE_HEVC_MONO12: return HEVCProfileType::HEVC_PROFILE_MONOCHROME_12_HIGH_TIER;
  case AL_PROFILE_HEVC_MONO16: return HEVCProfileType::HEVC_PROFILE_MONOCHROME_16_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN12: return HEVCProfileType::HEVC_PROFILE_MAIN_12_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_422: return HEVCProfileType::HEVC_PROFILE_MAIN_422_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_422_10: return HEVCProfileType::HEVC_PROFILE_MAIN_422_10_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_422_12: return HEVCProfileType::HEVC_PROFILE_MAIN_422_12_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_444: return HEVCProfileType::HEVC_PROFILE_MAIN_444_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_444_10: return HEVCProfileType::HEVC_PROFILE_MAIN_444_10_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_444_12: return HEVCProfileType::HEVC_PROFILE_MAIN_444_12_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN10_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_10_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN12_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_12_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_422_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_422_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_422_10_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_422_10_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_422_12_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_422_12_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_444_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_444_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_444_10_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_444_10_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_444_12_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_444_12_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_444_16_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_444_16_INTRA_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_444_STILL: return HEVCProfileType::HEVC_PROFILE_MAIN_444_STILL_HIGH_TIER;
  case AL_PROFILE_HEVC_MAIN_444_16_STILL: return HEVCProfileType::HEVC_PROFILE_MAIN_444_16_STILL_HIGH_TIER;
  default: return HEVCProfileType::HEVC_PROFILE_MAX_ENUM;
  }

  return HEVCProfileType::HEVC_PROFILE_MAX_ENUM;
}

HEVCProfileType ConvertSoftToModuleHEVCMainTierProfile(AL_EProfile const& profile)
{
  if(!AL_IS_HEVC(profile))
    return HEVCProfileType::HEVC_PROFILE_MAX_ENUM;
  switch(profile)
  {
  case AL_PROFILE_HEVC_MAIN: return HEVCProfileType::HEVC_PROFILE_MAIN;
  case AL_PROFILE_HEVC_MAIN10: return HEVCProfileType::HEVC_PROFILE_MAIN_10;
  case AL_PROFILE_HEVC_MAIN_STILL: return HEVCProfileType::HEVC_PROFILE_MAIN_STILL;
  case AL_PROFILE_HEVC_MONO: return HEVCProfileType::HEVC_PROFILE_MONOCHROME;
  case AL_PROFILE_HEVC_MONO10: return HEVCProfileType::HEVC_PROFILE_MONOCHROME_10;
  case AL_PROFILE_HEVC_MONO12: return HEVCProfileType::HEVC_PROFILE_MONOCHROME_12;
  case AL_PROFILE_HEVC_MONO16: return HEVCProfileType::HEVC_PROFILE_MONOCHROME_16;
  case AL_PROFILE_HEVC_MAIN12: return HEVCProfileType::HEVC_PROFILE_MAIN_12;
  case AL_PROFILE_HEVC_MAIN_422: return HEVCProfileType::HEVC_PROFILE_MAIN_422;
  case AL_PROFILE_HEVC_MAIN_422_10: return HEVCProfileType::HEVC_PROFILE_MAIN_422_10;
  case AL_PROFILE_HEVC_MAIN_422_12: return HEVCProfileType::HEVC_PROFILE_MAIN_422_12;
  case AL_PROFILE_HEVC_MAIN_444: return HEVCProfileType::HEVC_PROFILE_MAIN_444;
  case AL_PROFILE_HEVC_MAIN_444_10: return HEVCProfileType::HEVC_PROFILE_MAIN_444_10;
  case AL_PROFILE_HEVC_MAIN_444_12: return HEVCProfileType::HEVC_PROFILE_MAIN_444_12;
  case AL_PROFILE_HEVC_MAIN_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_INTRA;
  case AL_PROFILE_HEVC_MAIN10_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_10_INTRA;
  case AL_PROFILE_HEVC_MAIN12_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_12_INTRA;
  case AL_PROFILE_HEVC_MAIN_422_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_422_INTRA;
  case AL_PROFILE_HEVC_MAIN_422_10_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_422_10_INTRA;
  case AL_PROFILE_HEVC_MAIN_422_12_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_422_12_INTRA;
  case AL_PROFILE_HEVC_MAIN_444_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_444_INTRA;
  case AL_PROFILE_HEVC_MAIN_444_10_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_444_10_INTRA;
  case AL_PROFILE_HEVC_MAIN_444_12_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_444_12_INTRA;
  case AL_PROFILE_HEVC_MAIN_444_16_INTRA: return HEVCProfileType::HEVC_PROFILE_MAIN_444_16_INTRA;
  case AL_PROFILE_HEVC_MAIN_444_STILL: return HEVCProfileType::HEVC_PROFILE_MAIN_444_STILL;
  case AL_PROFILE_HEVC_MAIN_444_16_STILL: return HEVCProfileType::HEVC_PROFILE_MAIN_444_16_STILL;
  default: return HEVCProfileType::HEVC_PROFILE_MAX_ENUM;
  }

  return HEVCProfileType::HEVC_PROFILE_MAX_ENUM;
}

AL_EProfile ConvertModuleToSoftHEVCProfile(HEVCProfileType const& profile)
{
  switch(profile)
  {
  case HEVCProfileType::HEVC_PROFILE_MAIN:
  case HEVCProfileType::HEVC_PROFILE_MAIN_HIGH_TIER: return AL_PROFILE_HEVC_MAIN;
  case HEVCProfileType::HEVC_PROFILE_MAIN_10:
  case HEVCProfileType::HEVC_PROFILE_MAIN_10_HIGH_TIER: return AL_PROFILE_HEVC_MAIN10;
  case HEVCProfileType::HEVC_PROFILE_MAIN_STILL:
  case HEVCProfileType::HEVC_PROFILE_MAIN_STILL_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_STILL;
  case HEVCProfileType::HEVC_PROFILE_MONOCHROME:
  case HEVCProfileType::HEVC_PROFILE_MONOCHROME_HIGH_TIER: return AL_PROFILE_HEVC_MONO;
  case HEVCProfileType::HEVC_PROFILE_MONOCHROME_10:
  case HEVCProfileType::HEVC_PROFILE_MONOCHROME_10_HIGH_TIER: return AL_PROFILE_HEVC_MONO10;
  case HEVCProfileType::HEVC_PROFILE_MONOCHROME_12:
  case HEVCProfileType::HEVC_PROFILE_MONOCHROME_12_HIGH_TIER: return AL_PROFILE_HEVC_MONO12;
  case HEVCProfileType::HEVC_PROFILE_MONOCHROME_16:
  case HEVCProfileType::HEVC_PROFILE_MONOCHROME_16_HIGH_TIER: return AL_PROFILE_HEVC_MONO16;
  case HEVCProfileType::HEVC_PROFILE_MAIN_12:
  case HEVCProfileType::HEVC_PROFILE_MAIN_12_HIGH_TIER: return AL_PROFILE_HEVC_MAIN12;
  case HEVCProfileType::HEVC_PROFILE_MAIN_422:
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_422;
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_10:
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_10_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_422_10;
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_12:
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_12_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_422_12;
  case HEVCProfileType::HEVC_PROFILE_MAIN_444:
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_444;
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_10:
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_10_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_444_10;
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_12:
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_12_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_444_12;
  case HEVCProfileType::HEVC_PROFILE_MAIN_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_10_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_10_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN10_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_12_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_12_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN12_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_422_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_10_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_10_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_422_10_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_12_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_422_12_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_422_12_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_444_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_10_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_10_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_444_10_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_12_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_12_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_444_12_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_16_INTRA:
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_16_INTRA_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_444_16_INTRA;
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_STILL:
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_STILL_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_444_STILL;
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_16_STILL:
  case HEVCProfileType::HEVC_PROFILE_MAIN_444_16_STILL_HIGH_TIER: return AL_PROFILE_HEVC_MAIN_444_16_STILL;
  default: return AL_PROFILE_HEVC;
  }

  return AL_PROFILE_HEVC;
}
