// ================================================================ //
//                                                                  //
//   File      : GDE_global.cxx                                     //
//   Purpose   : Global data for GDE interface                      //
//                                                                  //
//   Institute of Microbiology (Technical University Munich)        //
//   http://www.arb-home.de/                                        //
//                                                                  //
// ================================================================ //

#include "GDE_extglob.h"

int  DataType;
int  FileFormat;
char FileName[80];

// Months of the year
const char *GDEmonth[] = {
    "-JAN-", "-FEB-", "-MAR-", "-APR-", "-MAY-", "-JUN-",
    "-JUL-", "-AUG-", "-SEP-", "-OCT-", "-NOV-", "-DEC-"
};

// Tables for DNA/RNA <--> ASCII translation
int Default_RNA_Trans[128] = {
    '-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'U', 'W', 'Y', 'H', 'K', 'D', 'B', 'N', // Upper
    '.', 'a', 'c', 'm', 'g', 'r', 's', 'v', 'u', 'w', 'y', 'h', 'k', 'd', 'b', 'n', // lower
    '-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'U', 'W', 'Y', 'H', 'K', 'D', 'B', 'N', // Upper select
    '.', 'a', 'c', 'm', 'g', 'r', 's', 'v', 'u', 'w', 'y', 'h', 'k', 'd', 'b', 'n', // lwr select
    '-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'U', 'W', 'Y', 'H', 'K', 'D', 'B', 'N', // extended
    '~', 'a', 'c', 'm', 'g', 'r', 's', 'v', 'u', 'w', 'y', 'h', 'k', 'd', 'b', 'n', // extended
    '-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'U', 'W', 'Y', 'H', 'K', 'D', 'B', 'N', // extended
    '~', 'a', 'c', 'm', 'g', 'r', 's', 'v', 'u', 'w', 'y', 'h', 'k', 'd', 'b', 'n', // extended
};

int Default_DNA_Trans[128] = {
    '-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'T', 'W', 'Y', 'H', 'K', 'D', 'B', 'N', // Upper
    '.', 'a', 'c', 'm', 'g', 'r', 's', 'v', 't', 'w', 'y', 'h', 'k', 'd', 'b', 'n', // lower
    '-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'T', 'W', 'Y', 'H', 'K', 'D', 'B', 'N', // Upper select
    '.', 'a', 'c', 'm', 'g', 'r', 's', 'v', 't', 'w', 'y', 'h', 'k', 'd', 'b', 'n', // lwr select
    '-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'T', 'W', 'Y', 'H', 'K', 'D', 'B', 'N', // extended
    '~', 'a', 'c', 'm', 'g', 'r', 's', 'v', 't', 'w', 'y', 'h', 'k', 'd', 'b', 'n', // extended
    '-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'T', 'W', 'Y', 'H', 'K', 'D', 'B', 'N', // extended
    '~', 'a', 'c', 'm', 'g', 'r', 's', 'v', 't', 'w', 'y', 'h', 'k', 'd', 'b', 'n', // extended
};

int Default_NA_RTrans[128] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    // Upper case alpha
    0x01, 0xe, 0x02, 0x0d, 0, 0, 0x04, 0x0b, 0, 0, 0x0c, 0, 0x03, 0x0f, 0, 0, 0, 0x05, 0x06, 0x08,
    0x08, 0x07, 0x09, 0x0f, 0xa, 0, 0, 0, 0, 0, 0, 0,
    // Lower case alpha
    0x11, 0x1e, 0x12, 0x1d, 0, 0, 0x14, 0x1b, 0, 0, 0x1c, 0, 0x13, 0x1f, 0, 0, 0, 0x15, 0x16, 0x18,
    0x18, 0x17, 0x19, 0x1f, 0x1a, 0, 0, 0, 0, 0x10, 0
};


// Character->color lookup table

int Default_NAColor_LKUP[128] = {
    13, 3, 6, 13, 8, 13, 13, 13, 5, 13, 13, 13, 13, 13, 13, 13,
    13, 3, 6, 13, 8, 13, 13, 13, 5, 13, 13, 13, 13, 13, 13, 13,
    13, 3, 6, 13, 8, 13, 13, 13, 5, 13, 13, 13, 13, 13, 13, 13,
    13, 3, 6, 13, 8, 13, 13, 13, 5, 13, 13, 13, 13, 13, 13, 13,
    13, 3, 6, 13, 8, 13, 13, 13, 5, 13, 13, 13, 13, 13, 13, 13,
    13, 3, 6, 13, 8, 13, 13, 13, 5, 13, 13, 13, 13, 13, 13, 13,
    13, 3, 6, 13, 8, 13, 13, 13, 5, 13, 13, 13, 13, 13, 13, 13,
    13, 3, 6, 13, 8, 13, 13, 13, 5, 13, 13, 13, 13, 13, 13, 13
};

int Default_PROColor_LKUP[128] = {
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 2, 8, 3, 8, 8, 6, 2, 4, 5, 12, 4, 5, 5, 8, 12, 2,
    8, 4, 2, 2, 12, 5, 6, 12, 6, 8, 12, 12, 12, 12, 12, 12,
    2, 8, 3, 8, 8, 6, 2, 4, 5, 12, 4, 5, 5, 8, 12, 2,
    8, 4, 2, 2, 12, 5, 6, 12, 6, 8, 12, 12, 12, 12, 12
};

