# -*- coding: utf-8 -*-

import system_tests

class AdditionOverflowInLoaderExifJpeg(metaclass=system_tests.CaseMeta):
    """
    Regression test for bug #365:
    https://github.com/Exiv2/exiv2/issues/365
    aka CVE 2018-12265:
    https://cve.mitre.org/cgi-bin/cvename.cgi?name=2018-12265
    """
    filename = system_tests.path("$data_path/1-out-of-read-Poc")
    commands = ["$exiv2 -ep $filename"]
    stdout = [""]
    stderr = [
        """Error: Upper boundary of data for directory Image, entry 0x00fe is out of bounds: Offset = 0x0000002a, size = 64, exceeds buffer size by 22 Bytes; truncating the entry
Warning: Directory Image, entry 0x0201: Strip 0 is outside of the data area; ignored.
Warning: Directory Image, entry 0x0201: Strip 7 is outside of the data area; ignored.
""" +
        ("" if system_tests.BT.Config.is_64bit else "Uncaught exception: Overflow in addition\n")
    ]
    retval = [0 if system_tests.BT.Config.is_64bit else 1]
